/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.List;
import java.util.PriorityQueue;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.coverage.Corner;
import org.locationtech.jts.coverage.CornerArea;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.VertexSequencePackedRtree;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.simplify.LinkedLine;

class TPVWSimplifier {
    private CornerArea cornerArea;
    private double removableSizeFactor = 1.0;
    private Edge[] edges;

    public static void simplify(Edge[] edges, CornerArea cornerArea, double removableSizeFactor) {
        TPVWSimplifier simp = new TPVWSimplifier(edges);
        simp.setCornerArea(cornerArea);
        simp.setRemovableRingSizeFactor(removableSizeFactor);
        simp.simplify();
    }

    public TPVWSimplifier(Edge[] edges) {
        this.edges = edges;
    }

    public void setRemovableRingSizeFactor(double removableSizeFactor) {
        this.removableSizeFactor = removableSizeFactor;
    }

    public void setCornerArea(CornerArea cornerArea) {
        this.cornerArea = cornerArea;
    }

    private void simplify() {
        EdgeIndex edgeIndex = new EdgeIndex();
        this.add(this.edges, edgeIndex);
        for (int i2 = 0; i2 < this.edges.length; ++i2) {
            Edge edge = this.edges[i2];
            edge.simplify(this.cornerArea, edgeIndex);
        }
    }

    private void add(Edge[] edges, EdgeIndex edgeIndex) {
        for (Edge edge : edges) {
            edge.updateRemoved(this.removableSizeFactor);
            if (edge.isRemoved()) continue;
            edge.init();
            edgeIndex.add(edge);
        }
    }

    private static class EdgeIndex {
        STRtree index = new STRtree();

        private EdgeIndex() {
        }

        public void add(Edge edge) {
            this.index.insert(edge.getEnvelope(), (Object)edge);
        }

        public List<Edge> query(Envelope queryEnv) {
            return this.index.query(queryEnv);
        }
    }

    public static class Edge {
        private static final int MIN_EDGE_SIZE = 2;
        private static final int MIN_RING_SIZE = 4;
        private LinkedLine linkedLine;
        private boolean isFreeRing;
        private int nPts;
        private Coordinate[] pts;
        private VertexSequencePackedRtree vertexIndex;
        private Envelope envelope;
        private boolean isRemoved = false;
        private boolean isRemovable;
        private double distanceTolerance = 0.0;

        Edge(Coordinate[] pts, double distanceTolerance, boolean isFreeRing, boolean isRemovable) {
            this.envelope = CoordinateArrays.envelope(pts);
            this.pts = pts;
            this.nPts = pts.length;
            this.isFreeRing = isFreeRing;
            this.isRemovable = isRemovable;
            this.distanceTolerance = distanceTolerance;
        }

        public void updateRemoved(double removableSizeFactor) {
            if (!this.isRemovable) {
                return;
            }
            double areaTolerance = this.distanceTolerance * this.distanceTolerance;
            this.isRemoved = CoordinateArrays.isRing(this.pts) && Area.ofRing(this.pts) < removableSizeFactor * areaTolerance;
        }

        public void init() {
            this.linkedLine = new LinkedLine(this.pts);
        }

        public double getTolerance() {
            return this.distanceTolerance;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        private Coordinate getCoordinate(int index) {
            return this.pts[index];
        }

        public Coordinate[] getCoordinates() {
            if (this.isRemoved) {
                return new Coordinate[0];
            }
            return this.linkedLine.getCoordinates();
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public int size() {
            return this.linkedLine.size();
        }

        public void simplify(CornerArea cornerArea, EdgeIndex edgeIndex) {
            if (this.isRemoved) {
                return;
            }
            if (this.distanceTolerance <= 0.0) {
                return;
            }
            double areaTolerance = this.distanceTolerance * this.distanceTolerance;
            int minEdgeSize = this.linkedLine.isRing() ? 4 : 2;
            PriorityQueue<Corner> cornerQueue = this.createQueue(areaTolerance, cornerArea);
            while (!cornerQueue.isEmpty() && this.size() > minEdgeSize) {
                Corner corner = cornerQueue.poll();
                if (corner.isRemoved()) continue;
                if (corner.getArea() > areaTolerance) break;
                if (!this.isRemovable(corner, edgeIndex)) continue;
                this.removeCorner(corner, areaTolerance, cornerArea, cornerQueue);
            }
        }

        private PriorityQueue<Corner> createQueue(double areaTolerance, CornerArea cornerArea) {
            PriorityQueue<Corner> cornerQueue = new PriorityQueue<Corner>();
            int minIndex = this.linkedLine.isRing() && this.isFreeRing ? 0 : 1;
            int maxIndex = this.nPts - 1;
            for (int i2 = minIndex; i2 < maxIndex; ++i2) {
                this.addCorner(i2, areaTolerance, cornerArea, cornerQueue);
            }
            return cornerQueue;
        }

        private void addCorner(int i2, double areaTolerance, CornerArea cornerArea, PriorityQueue<Corner> cornerQueue) {
            double area;
            if ((this.isFreeRing || i2 != 0 && i2 != this.nPts - 1) && (area = this.area(i2, cornerArea)) <= areaTolerance) {
                Corner corner = new Corner(this.linkedLine, i2, area);
                cornerQueue.add(corner);
            }
        }

        private double area(int index, CornerArea cornerArea) {
            Coordinate pp = this.linkedLine.prevCoordinate(index);
            Coordinate p = this.linkedLine.getCoordinate(index);
            Coordinate pn = this.linkedLine.nextCoordinate(index);
            return cornerArea.area(pp, p, pn);
        }

        private boolean isRemovable(Corner corner, EdgeIndex edgeIndex) {
            Envelope cornerEnv = corner.envelope();
            for (Edge edge : edgeIndex.query(cornerEnv)) {
                Coordinate[] linePts;
                if (this.hasIntersectingVertex(corner, cornerEnv, edge)) {
                    return false;
                }
                if (edge == this || edge.size() != 2 || !corner.isBaseline((linePts = edge.linkedLine.getCoordinates())[0], linePts[1])) continue;
                return false;
            }
            return true;
        }

        private boolean hasIntersectingVertex(Corner corner, Envelope cornerEnv, Edge edge) {
            int[] result;
            for (int index : result = edge.query(cornerEnv)) {
                Coordinate v = edge.getCoordinate(index);
                if (corner.isVertex(v) || !corner.intersects(v)) continue;
                return true;
            }
            return false;
        }

        private void initIndex() {
            this.vertexIndex = new VertexSequencePackedRtree(this.pts);
            if (CoordinateArrays.isRing(this.pts)) {
                this.vertexIndex.remove(this.pts.length - 1);
            }
        }

        private int[] query(Envelope cornerEnv) {
            if (this.vertexIndex == null) {
                this.initIndex();
            }
            return this.vertexIndex.query(cornerEnv);
        }

        private void removeCorner(Corner corner, double areaTolerance, CornerArea cornerArea, PriorityQueue<Corner> cornerQueue) {
            int index = corner.getIndex();
            int prev = this.linkedLine.prev(index);
            int next = this.linkedLine.next(index);
            this.linkedLine.remove(index);
            this.vertexIndex.remove(index);
            this.addCorner(prev, areaTolerance, cornerArea, cornerQueue);
            this.addCorner(next, areaTolerance, cornerArea, cornerQueue);
        }

        public String toString() {
            return this.linkedLine.toString();
        }
    }
}

