/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.operation.relate.RelateOp;
import org.locationtech.jts.operation.relateng.RelateNG;
import org.locationtech.jts.operation.relateng.RelatePredicate;

class GeometryRelate {
    public static String RELATE_PROPERTY_NAME = "jts.relate";
    public static String RELATE_PROPERTY_VALUE_NG = "ng";
    public static String RELATE_PROPERTY_VALUE_OLD = "old";
    public static boolean RELATE_NG_DEFAULT;
    private static boolean isRelateNG;

    GeometryRelate() {
    }

    static void setRelateImpl(String relateImplCode) {
        if (relateImplCode == null) {
            return;
        }
        isRelateNG = RELATE_NG_DEFAULT;
        if (RELATE_PROPERTY_VALUE_NG.equalsIgnoreCase(relateImplCode)) {
            isRelateNG = true;
        }
    }

    static boolean intersects(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.intersects());
        }
        if (a.isGeometryCollection() || b.isGeometryCollection()) {
            for (int i2 = 0; i2 < a.getNumGeometries(); ++i2) {
                for (int j = 0; j < b.getNumGeometries(); ++j) {
                    if (!a.getGeometryN(i2).intersects(b.getGeometryN(j))) continue;
                    return true;
                }
            }
            return false;
        }
        return RelateOp.relate(a, b).isIntersects();
    }

    static boolean contains(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.contains());
        }
        if (b.getDimension() == 2 && a.getDimension() < 2) {
            return false;
        }
        if (b.getDimension() == 1 && a.getDimension() < 1 && b.getLength() > 0.0) {
            return false;
        }
        if (!a.getEnvelopeInternal().contains(b.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(a, b).isContains();
    }

    static boolean covers(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.covers());
        }
        if (b.getDimension() == 2 && a.getDimension() < 2) {
            return false;
        }
        if (b.getDimension() == 1 && a.getDimension() < 1 && b.getLength() > 0.0) {
            return false;
        }
        if (!a.getEnvelopeInternal().covers(b.getEnvelopeInternal())) {
            return false;
        }
        if (a.isRectangle()) {
            return true;
        }
        return RelateOp.relate(a, b).isCovers();
    }

    static boolean coveredBy(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.coveredBy());
        }
        return GeometryRelate.covers(b, a);
    }

    static boolean crosses(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.crosses());
        }
        if (!a.getEnvelopeInternal().intersects(b.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(a, b).isCrosses(a.getDimension(), b.getDimension());
    }

    static boolean disjoint(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.disjoint());
        }
        return !GeometryRelate.intersects(a, b);
    }

    static boolean equalsTopo(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.equalsTopo());
        }
        if (!a.getEnvelopeInternal().equals(b.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(a, b).isEquals(a.getDimension(), b.getDimension());
    }

    static boolean overlaps(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.overlaps());
        }
        if (!a.getEnvelopeInternal().intersects(b.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(a, b).isOverlaps(a.getDimension(), b.getDimension());
    }

    static boolean touches(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.touches());
        }
        if (!a.getEnvelopeInternal().intersects(b.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(a, b).isTouches(a.getDimension(), b.getDimension());
    }

    static boolean within(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, RelatePredicate.within());
        }
        return GeometryRelate.contains(b, a);
    }

    static IntersectionMatrix relate(Geometry a, Geometry b) {
        if (isRelateNG) {
            return RelateNG.relate(a, b);
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b);
        return RelateOp.relate(a, b);
    }

    static boolean relate(Geometry a, Geometry b, String intersectionPattern) {
        if (isRelateNG) {
            return RelateNG.relate(a, b, intersectionPattern);
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b);
        return RelateOp.relate(a, b).matches(intersectionPattern);
    }

    static {
        isRelateNG = RELATE_NG_DEFAULT = false;
        GeometryRelate.setRelateImpl(System.getProperty(RELATE_PROPERTY_NAME));
    }
}

