/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.BoundaryOp;

public class MultiLineString
extends GeometryCollection
implements Lineal {
    private static final long serialVersionUID = 8166665132445433741L;

    public MultiLineString(LineString[] lineStrings, PrecisionModel precisionModel, int SRID) {
        super(lineStrings, new GeometryFactory(precisionModel, SRID));
    }

    public MultiLineString(LineString[] lineStrings, GeometryFactory factory) {
        super(lineStrings, factory);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean hasDimension(int dim) {
        return dim == 1;
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            if (((LineString)this.geometries[i2]).isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public MultiLineString reverse() {
        return (MultiLineString)super.reverse();
    }

    @Override
    protected MultiLineString reverseInternal() {
        LineString[] lineStrings = new LineString[this.geometries.length];
        for (int i2 = 0; i2 < lineStrings.length; ++i2) {
            lineStrings[i2] = (LineString)this.geometries[i2].reverse();
        }
        return new MultiLineString(lineStrings, this.factory);
    }

    @Override
    protected MultiLineString copyInternal() {
        LineString[] lineStrings = new LineString[this.geometries.length];
        for (int i2 = 0; i2 < lineStrings.length; ++i2) {
            lineStrings[i2] = (LineString)this.geometries[i2].copy();
        }
        return new MultiLineString(lineStrings, this.factory);
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }

    @Override
    protected int getTypeCode() {
        return 4;
    }
}

