/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.GraphComponent;
import org.locationtech.jts.geomgraph.Label;

public class Node
extends GraphComponent {
    protected Coordinate coord;
    protected EdgeEndStar edges;

    public Node(Coordinate coord, EdgeEndStar edges) {
        this.coord = coord;
        this.edges = edges;
        this.label = new Label(0, -1);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coord;
    }

    public EdgeEndStar getEdges() {
        return this.edges;
    }

    public boolean isIncidentEdgeInResult() {
        for (DirectedEdge de : this.getEdges().getEdges()) {
            if (!de.getEdge().isInResult()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    @Override
    protected void computeIM(IntersectionMatrix im) {
    }

    public void add(EdgeEnd e) {
        this.edges.insert(e);
        e.setNode(this);
    }

    public void mergeLabel(Node n) {
        this.mergeLabel(n.label);
    }

    public void mergeLabel(Label label2) {
        for (int i2 = 0; i2 < 2; ++i2) {
            int loc = this.computeMergedLocation(label2, i2);
            int thisLoc = this.label.getLocation(i2);
            if (thisLoc != -1) continue;
            this.label.setLocation(i2, loc);
        }
    }

    public void setLabel(int argIndex, int onLocation) {
        if (this.label == null) {
            this.label = new Label(argIndex, onLocation);
        } else {
            this.label.setLocation(argIndex, onLocation);
        }
    }

    public void setLabelBoundary(int argIndex) {
        int newLoc;
        if (this.label == null) {
            return;
        }
        int loc = -1;
        if (this.label != null) {
            loc = this.label.getLocation(argIndex);
        }
        switch (loc) {
            case 1: {
                newLoc = 0;
                break;
            }
            case 0: {
                newLoc = 1;
                break;
            }
            default: {
                newLoc = 1;
            }
        }
        this.label.setLocation(argIndex, newLoc);
    }

    int computeMergedLocation(Label label2, int eltIndex) {
        int loc = -1;
        loc = this.label.getLocation(eltIndex);
        if (!label2.isNull(eltIndex)) {
            int nLoc = label2.getLocation(eltIndex);
            if (loc != 1) {
                loc = nLoc;
            }
        }
        return loc;
    }

    public void print(PrintStream out) {
        out.println("node " + this.coord + " lbl: " + this.label);
    }

    public String toString() {
        return "Node(" + this.coord.x + ", " + this.coord.y + ")";
    }
}

