/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import org.locationtech.jts.geom.Coordinate;

public class Vector3D {
    private double x;
    private double y;
    private double z;

    public static double dot(Coordinate A2, Coordinate B, Coordinate C, Coordinate D) {
        double ABx = B.x - A2.x;
        double ABy = B.y - A2.y;
        double ABz = B.getZ() - A2.getZ();
        double CDx = D.x - C.x;
        double CDy = D.y - C.y;
        double CDz = D.getZ() - C.getZ();
        return ABx * CDx + ABy * CDy + ABz * CDz;
    }

    public static Vector3D create(double x, double y, double z) {
        return new Vector3D(x, y, z);
    }

    public static Vector3D create(Coordinate coord) {
        return new Vector3D(coord);
    }

    public static double dot(Coordinate v1, Coordinate v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.getZ() * v2.getZ();
    }

    public Vector3D(Coordinate v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.getZ();
    }

    public Vector3D(Coordinate from, Coordinate to) {
        this.x = to.x - from.x;
        this.y = to.y - from.y;
        this.z = to.getZ() - from.getZ();
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3D add(Vector3D v) {
        return Vector3D.create(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3D subtract(Vector3D v) {
        return Vector3D.create(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3D divide(double d) {
        return Vector3D.create(this.x / d, this.y / d, this.z / d);
    }

    public double dot(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(Coordinate v) {
        return Math.sqrt(v.x * v.x + v.y * v.y + v.getZ() * v.getZ());
    }

    public Vector3D normalize() {
        double length = this.length();
        if (length > 0.0) {
            return this.divide(this.length());
        }
        return Vector3D.create(0.0, 0.0, 0.0);
    }

    public static Coordinate normalize(Coordinate v) {
        double len = Vector3D.length(v);
        return new Coordinate(v.x / len, v.y / len, v.getZ() / len);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector3D)) {
            return false;
        }
        Vector3D v = (Vector3D)o;
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + Coordinate.hashCode(this.x);
        result = 37 * result + Coordinate.hashCode(this.y);
        result = 37 * result + Coordinate.hashCode(this.z);
        return result;
    }
}

