/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.LineSegment;

class DouglasPeuckerLineSimplifier {
    private Coordinate[] pts;
    private boolean[] usePt;
    private double distanceTolerance;
    private boolean isPreserveEndpoint = false;
    private LineSegment seg = new LineSegment();

    public static Coordinate[] simplify(Coordinate[] pts, double distanceTolerance, boolean isPreserveEndpoint) {
        DouglasPeuckerLineSimplifier simp = new DouglasPeuckerLineSimplifier(pts);
        simp.setDistanceTolerance(distanceTolerance);
        simp.setPreserveEndpoint(isPreserveEndpoint);
        return simp.simplify();
    }

    public DouglasPeuckerLineSimplifier(Coordinate[] pts) {
        this.pts = pts;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    private void setPreserveEndpoint(boolean isPreserveEndpoint) {
        this.isPreserveEndpoint = isPreserveEndpoint;
    }

    public Coordinate[] simplify() {
        this.usePt = new boolean[this.pts.length];
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            this.usePt[i2] = true;
        }
        this.simplifySection(0, this.pts.length - 1);
        CoordinateList coordList = new CoordinateList();
        for (int i3 = 0; i3 < this.pts.length; ++i3) {
            if (!this.usePt[i3]) continue;
            coordList.add(new Coordinate(this.pts[i3]));
        }
        if (!this.isPreserveEndpoint && CoordinateArrays.isRing(this.pts)) {
            this.simplifyRingEndpoint(coordList);
        }
        return coordList.toCoordinateArray();
    }

    private void simplifyRingEndpoint(CoordinateList pts) {
        if (pts.size() < 4) {
            return;
        }
        this.seg.p0 = (Coordinate)pts.get(1);
        this.seg.p1 = (Coordinate)pts.get(pts.size() - 2);
        double distance = this.seg.distance((Coordinate)pts.get(0));
        if (distance <= this.distanceTolerance) {
            pts.remove(0);
            pts.remove(pts.size() - 1);
            pts.closeRing();
        }
    }

    private void simplifySection(int i2, int j) {
        int k;
        if (i2 + 1 == j) {
            return;
        }
        this.seg.p0 = this.pts[i2];
        this.seg.p1 = this.pts[j];
        double maxDistance = -1.0;
        int maxIndex = i2;
        for (k = i2 + 1; k < j; ++k) {
            double distance = this.seg.distance(this.pts[k]);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxIndex = k;
        }
        if (maxDistance <= this.distanceTolerance) {
            for (k = i2 + 1; k < j; ++k) {
                this.usePt[k] = false;
            }
        } else {
            this.simplifySection(i2, maxIndex);
            this.simplifySection(maxIndex, j);
        }
    }
}

