/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PolygonNodeTopology;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.MCIndexSegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.triangulate.polygon.PolygonNoder;

public class PolygonHoleJoiner {
    private Polygon inputPolygon;
    private Coordinate[] shellRing;
    private Coordinate[][] holeRings;
    private boolean[] isHoleTouchingHint;
    private List<Coordinate> joinedRing;
    private TreeSet<Coordinate> joinedPts;
    private SegmentSetMutualIntersector boundaryIntersector;

    public static Polygon joinAsPolygon(Polygon polygon) {
        return polygon.getFactory().createPolygon(PolygonHoleJoiner.join(polygon));
    }

    public static Coordinate[] join(Polygon polygon) {
        PolygonHoleJoiner joiner = new PolygonHoleJoiner(polygon);
        return joiner.compute();
    }

    public PolygonHoleJoiner(Polygon polygon) {
        this.inputPolygon = polygon;
    }

    public Coordinate[] compute() {
        this.extractOrientedRings(this.inputPolygon);
        if (this.holeRings.length > 0) {
            this.nodeRings();
        }
        this.joinedRing = PolygonHoleJoiner.copyToList(this.shellRing);
        if (this.holeRings.length > 0) {
            this.joinHoles();
        }
        return CoordinateArrays.toCoordinateArray(this.joinedRing);
    }

    private void extractOrientedRings(Polygon polygon) {
        this.shellRing = PolygonHoleJoiner.extractOrientedRing(polygon.getExteriorRing(), true);
        List<LinearRing> holes = PolygonHoleJoiner.sortHoles(polygon);
        this.holeRings = new Coordinate[holes.size()][];
        for (int i2 = 0; i2 < holes.size(); ++i2) {
            this.holeRings[i2] = PolygonHoleJoiner.extractOrientedRing(holes.get(i2), false);
        }
    }

    private static Coordinate[] extractOrientedRing(LinearRing ring, boolean isCW) {
        boolean isRingCW;
        Coordinate[] pts = ring.getCoordinates();
        boolean bl = isRingCW = !Orientation.isCCW(pts);
        if (isCW == isRingCW) {
            return pts;
        }
        Coordinate[] ptsRev = (Coordinate[])pts.clone();
        CoordinateArrays.reverse(ptsRev);
        return ptsRev;
    }

    private void nodeRings() {
        PolygonNoder noder = new PolygonNoder(this.shellRing, this.holeRings);
        noder.node();
        if (noder.isShellNoded()) {
            this.shellRing = noder.getNodedShell();
        }
        for (int i2 = 0; i2 < this.holeRings.length; ++i2) {
            if (!noder.isHoleNoded(i2)) continue;
            this.holeRings[i2] = noder.getNodedHole(i2);
        }
        this.isHoleTouchingHint = noder.getHolesTouching();
    }

    private static List<Coordinate> copyToList(Coordinate[] coords) {
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        for (Coordinate p : coords) {
            coordList.add(p.copy());
        }
        return coordList;
    }

    private void joinHoles() {
        this.boundaryIntersector = PolygonHoleJoiner.createBoundaryIntersector(this.shellRing, this.holeRings);
        this.joinedPts = new TreeSet();
        this.joinedPts.addAll(this.joinedRing);
        for (int i2 = 0; i2 < this.holeRings.length; ++i2) {
            this.joinHole(i2, this.holeRings[i2]);
        }
    }

    private void joinHole(int index, Coordinate[] holeCoords) {
        boolean isTouching;
        if (this.isHoleTouchingHint[index] && (isTouching = this.joinTouchingHole(holeCoords))) {
            return;
        }
        this.joinNonTouchingHole(holeCoords);
    }

    private boolean joinTouchingHole(Coordinate[] holeCoords) {
        int holeTouchIndex = this.findHoleTouchIndex(holeCoords);
        if (holeTouchIndex < 0) {
            return false;
        }
        Coordinate joinPt = holeCoords[holeTouchIndex];
        Coordinate holeSegPt = holeCoords[PolygonHoleJoiner.prev(holeTouchIndex, holeCoords.length)];
        int joinIndex = this.findJoinIndex(joinPt, holeSegPt);
        this.addJoinedHole(joinIndex, holeCoords, holeTouchIndex);
        return true;
    }

    private int findHoleTouchIndex(Coordinate[] holeCoords) {
        for (int i2 = 0; i2 < holeCoords.length; ++i2) {
            if (!this.joinedPts.contains(holeCoords[i2])) continue;
            return i2;
        }
        return -1;
    }

    private void joinNonTouchingHole(Coordinate[] holeCoords) {
        int holeJoinIndex = PolygonHoleJoiner.findLowestLeftVertexIndex(holeCoords);
        Coordinate holeJoinCoord = holeCoords[holeJoinIndex];
        Coordinate joinCoord = this.findJoinableVertex(holeJoinCoord);
        int joinIndex = this.findJoinIndex(joinCoord, holeJoinCoord);
        this.addJoinedHole(joinIndex, holeCoords, holeJoinIndex);
    }

    private Coordinate findJoinableVertex(Coordinate holeJoinCoord) {
        Coordinate candidate = this.joinedPts.higher(holeJoinCoord);
        while (candidate.x == holeJoinCoord.x) {
            candidate = this.joinedPts.higher(candidate);
        }
        candidate = this.joinedPts.lower(candidate);
        while (this.intersectsBoundary(holeJoinCoord, candidate)) {
            if ((candidate = this.joinedPts.lower(candidate)) != null) continue;
            throw new IllegalStateException("Unable to find joinable vertex");
        }
        return candidate;
    }

    private int findJoinIndex(Coordinate joinCoord, Coordinate holeJoinCoord) {
        for (int i2 = 0; i2 < this.joinedRing.size() - 1; ++i2) {
            if (!joinCoord.equals2D(this.joinedRing.get(i2)) || !this.isLineInterior(this.joinedRing, i2, holeJoinCoord)) continue;
            return i2;
        }
        throw new IllegalStateException("Unable to find shell join index with interior join line");
    }

    private boolean isLineInterior(List<Coordinate> ring, int ringIndex, Coordinate linePt) {
        Coordinate nodePt = ring.get(ringIndex);
        Coordinate shell0 = ring.get(PolygonHoleJoiner.prev(ringIndex, ring.size()));
        Coordinate shell1 = ring.get(PolygonHoleJoiner.next(ringIndex, ring.size()));
        return PolygonNodeTopology.isInteriorSegment(nodePt, shell0, shell1, linePt);
    }

    private static int prev(int i2, int size) {
        int prev = i2 - 1;
        if (prev < 0) {
            return size - 2;
        }
        return prev;
    }

    private static int next(int i2, int size) {
        int next = i2 + 1;
        if (next > size - 2) {
            return 0;
        }
        return next;
    }

    private void addJoinedHole(int joinIndex, Coordinate[] holeCoords, int holeJoinIndex) {
        Coordinate holeJoinPt;
        Coordinate joinPt = this.joinedRing.get(joinIndex);
        boolean isVertexTouch = joinPt.equals2D(holeJoinPt = holeCoords[holeJoinIndex]);
        Coordinate addJoinPt = isVertexTouch ? null : joinPt;
        List<Coordinate> newSection = this.createHoleSection(holeCoords, holeJoinIndex, addJoinPt);
        int addIndex = joinIndex + 1;
        this.joinedRing.addAll(addIndex, newSection);
        this.joinedPts.addAll(newSection);
    }

    private List<Coordinate> createHoleSection(Coordinate[] holeCoords, int holeJoinIndex, Coordinate joinPt) {
        boolean isNonTouchingHole;
        ArrayList<Coordinate> section = new ArrayList<Coordinate>();
        boolean bl = isNonTouchingHole = joinPt != null;
        if (isNonTouchingHole) {
            section.add(holeCoords[holeJoinIndex].copy());
        }
        int holeSize = holeCoords.length - 1;
        int index = holeJoinIndex;
        for (int i2 = 0; i2 < holeSize; ++i2) {
            index = (index + 1) % holeSize;
            section.add(holeCoords[index].copy());
        }
        if (isNonTouchingHole) {
            section.add(joinPt.copy());
        }
        return section;
    }

    private static List<LinearRing> sortHoles(Polygon poly) {
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            holes.add(poly.getInteriorRingN(i2));
        }
        Collections.sort(holes, new EnvelopeComparator());
        return holes;
    }

    private static int findLowestLeftVertexIndex(Coordinate[] coords) {
        Coordinate lowestLeftCoord = null;
        int lowestLeftIndex = -1;
        for (int i2 = 0; i2 < coords.length - 1; ++i2) {
            if (lowestLeftCoord != null && coords[i2].compareTo(lowestLeftCoord) >= 0) continue;
            lowestLeftCoord = coords[i2];
            lowestLeftIndex = i2;
        }
        return lowestLeftIndex;
    }

    private boolean intersectsBoundary(Coordinate p0, Coordinate p1) {
        BasicSegmentString segString = new BasicSegmentString(new Coordinate[]{p0, p1}, null);
        ArrayList<BasicSegmentString> segStrings = new ArrayList<BasicSegmentString>();
        segStrings.add(segString);
        InteriorIntersectionDetector segInt = new InteriorIntersectionDetector();
        this.boundaryIntersector.process(segStrings, segInt);
        return segInt.hasIntersection();
    }

    private static SegmentSetMutualIntersector createBoundaryIntersector(Coordinate[] shellRing, Coordinate[][] holeRings) {
        ArrayList<BasicSegmentString> polySegStrings = new ArrayList<BasicSegmentString>();
        polySegStrings.add(new BasicSegmentString(shellRing, null));
        for (Coordinate[] hole : holeRings) {
            polySegStrings.add(new BasicSegmentString(hole, null));
        }
        return new MCIndexSegmentSetMutualIntersector(polySegStrings);
    }

    private static class InteriorIntersectionDetector
    implements SegmentIntersector {
        private LineIntersector li = new RobustLineIntersector();
        private boolean hasIntersection = false;

        private InteriorIntersectionDetector() {
        }

        public boolean hasIntersection() {
            return this.hasIntersection;
        }

        @Override
        public void processIntersections(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
            Coordinate p00 = ss0.getCoordinate(segIndex0);
            Coordinate p01 = ss0.getCoordinate(segIndex0 + 1);
            Coordinate p10 = ss1.getCoordinate(segIndex1);
            Coordinate p11 = ss1.getCoordinate(segIndex1 + 1);
            this.li.computeIntersection(p00, p01, p10, p11);
            if (this.li.getIntersectionNum() == 0) {
                return;
            }
            if (this.li.getIntersectionNum() == 1) {
                if (this.li.isInteriorIntersection()) {
                    this.hasIntersection = true;
                }
            } else {
                this.hasIntersection = true;
            }
        }

        @Override
        public boolean isDone() {
            return this.hasIntersection;
        }
    }

    private static class EnvelopeComparator
    implements Comparator<Geometry> {
        private EnvelopeComparator() {
        }

        @Override
        public int compare(Geometry g1, Geometry g2) {
            Envelope e1 = g1.getEnvelopeInternal();
            Envelope e2 = g2.getEnvelopeInternal();
            return e1.compareTo(e2);
        }
    }
}

