/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.tri;

import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.Assert;

public class Tri {
    private static final String INVALID_TRI_INDEX = "Invalid Tri index";
    protected Coordinate p0;
    protected Coordinate p1;
    protected Coordinate p2;
    protected Tri tri0;
    protected Tri tri1;
    protected Tri tri2;

    public static Geometry toGeometry(Collection<Tri> tris, GeometryFactory geomFact) {
        Geometry[] geoms = new Geometry[tris.size()];
        int i2 = 0;
        for (Tri tri : tris) {
            geoms[i2++] = tri.toPolygon(geomFact);
        }
        return geomFact.createGeometryCollection(geoms);
    }

    public static double area(List<? extends Tri> triList) {
        double area = 0.0;
        for (Tri tri : triList) {
            area += tri.getArea();
        }
        return area;
    }

    public static void validate(List<Tri> triList) {
        for (Tri tri : triList) {
            tri.validate();
        }
    }

    public static Tri create(Coordinate p0, Coordinate p1, Coordinate p2) {
        return new Tri(p0, p1, p2);
    }

    public static Tri create(Coordinate[] pts) {
        return new Tri(pts[0], pts[1], pts[2]);
    }

    public Tri(Coordinate p0, Coordinate p1, Coordinate p2) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    public void setAdjacent(Tri tri0, Tri tri1, Tri tri2) {
        this.tri0 = tri0;
        this.tri1 = tri1;
        this.tri2 = tri2;
    }

    public void setAdjacent(Coordinate pt, Tri tri) {
        int index = this.getIndex(pt);
        this.setTri(index, tri);
    }

    public void setTri(int edgeIndex, Tri tri) {
        switch (edgeIndex) {
            case 0: {
                this.tri0 = tri;
                return;
            }
            case 1: {
                this.tri1 = tri;
                return;
            }
            case 2: {
                this.tri2 = tri;
                return;
            }
        }
        throw new IllegalArgumentException(INVALID_TRI_INDEX);
    }

    private void setCoordinates(Coordinate p0, Coordinate p1, Coordinate p2) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    public Tri split(Coordinate p) {
        Tri tt0 = new Tri(p, this.p0, this.p1);
        Tri tt1 = new Tri(p, this.p1, this.p2);
        Tri tt2 = new Tri(p, this.p2, this.p0);
        tt0.setAdjacent(tt2, this.tri0, tt1);
        tt1.setAdjacent(tt0, this.tri1, tt2);
        tt2.setAdjacent(tt1, this.tri2, tt0);
        return tt0;
    }

    public void flip(int index) {
        Tri tri = this.getAdjacent(index);
        int index1 = tri.getIndex(this);
        Coordinate adj0 = this.getCoordinate(index);
        Coordinate adj1 = this.getCoordinate(Tri.next(index));
        Coordinate opp0 = this.getCoordinate(Tri.oppVertex(index));
        Coordinate opp1 = tri.getCoordinate(Tri.oppVertex(index1));
        this.flip(tri, index, index1, adj0, adj1, opp0, opp1);
    }

    private void flip(Tri tri, int index0, int index1, Coordinate adj0, Coordinate adj1, Coordinate opp0, Coordinate opp1) {
        this.setCoordinates(opp1, opp0, adj0);
        tri.setCoordinates(opp0, opp1, adj1);
        Tri[] adjacent = this.getAdjacentTris(tri, index0, index1);
        this.setAdjacent(tri, adjacent[0], adjacent[2]);
        if (adjacent[2] != null) {
            adjacent[2].replace(tri, this);
        }
        tri.setAdjacent(this, adjacent[3], adjacent[1]);
        if (adjacent[1] != null) {
            adjacent[1].replace(this, tri);
        }
    }

    private void replace(Tri triOld, Tri triNew) {
        if (this.tri0 != null && this.tri0 == triOld) {
            this.tri0 = triNew;
        } else if (this.tri1 != null && this.tri1 == triOld) {
            this.tri1 = triNew;
        } else if (this.tri2 != null && this.tri2 == triOld) {
            this.tri2 = triNew;
        }
    }

    public int degree(int index, List<? extends Tri> triList) {
        Coordinate v = this.getCoordinate(index);
        int degree = 0;
        for (Tri tri : triList) {
            for (int i2 = 0; i2 < 3; ++i2) {
                if (!v.equals2D(tri.getCoordinate(i2))) continue;
                ++degree;
            }
        }
        return degree;
    }

    public void remove(List<? extends Tri> triList) {
        this.remove();
        triList.remove(this);
    }

    public void remove() {
        this.remove(0);
        this.remove(1);
        this.remove(2);
    }

    private void remove(int index) {
        Tri adj = this.getAdjacent(index);
        if (adj == null) {
            return;
        }
        adj.setTri(adj.getIndex(this), null);
        this.setTri(index, null);
    }

    private Tri[] getAdjacentTris(Tri triAdj, int index, int indexAdj) {
        Tri[] adj = new Tri[]{this.getAdjacent(Tri.prev(index)), this.getAdjacent(Tri.next(index)), triAdj.getAdjacent(Tri.next(indexAdj)), triAdj.getAdjacent(Tri.prev(indexAdj))};
        return adj;
    }

    public void validate() {
        if (-1 != Orientation.index(this.p0, this.p1, this.p2)) {
            throw new IllegalArgumentException("Tri is not oriented correctly");
        }
        this.validateAdjacent(0);
        this.validateAdjacent(1);
        this.validateAdjacent(2);
    }

    public void validateAdjacent(int index) {
        Tri tri = this.getAdjacent(index);
        if (tri == null) {
            return;
        }
        assert (this.isAdjacent(tri));
        assert (tri.isAdjacent(this));
        Coordinate e0 = this.getCoordinate(index);
        Coordinate e1 = this.getCoordinate(Tri.next(index));
        int indexNeighbor = tri.getIndex(this);
        Coordinate n0 = tri.getCoordinate(indexNeighbor);
        Coordinate n1 = tri.getCoordinate(Tri.next(indexNeighbor));
        Assert.isTrue(e0.equals2D(n1), "Edge coord not equal");
        Assert.isTrue(e1.equals2D(n0), "Edge coord not equal");
        RobustLineIntersector li = new RobustLineIntersector();
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                Coordinate p00 = this.getCoordinate(i2);
                Coordinate p01 = this.getCoordinate(Tri.next(i2));
                Coordinate p10 = tri.getCoordinate(j);
                Coordinate p11 = tri.getCoordinate(Tri.next(j));
                li.computeIntersection(p00, p01, p10, p11);
                assert (!li.isProper());
            }
        }
    }

    public Coordinate getCoordinate(int index) {
        switch (index) {
            case 0: {
                return this.p0;
            }
            case 1: {
                return this.p1;
            }
            case 2: {
                return this.p2;
            }
        }
        throw new IllegalArgumentException(INVALID_TRI_INDEX);
    }

    public int getIndex(Coordinate p) {
        if (this.p0.equals2D(p)) {
            return 0;
        }
        if (this.p1.equals2D(p)) {
            return 1;
        }
        if (this.p2.equals2D(p)) {
            return 2;
        }
        return -1;
    }

    public int getIndex(Tri tri) {
        if (this.tri0 == tri) {
            return 0;
        }
        if (this.tri1 == tri) {
            return 1;
        }
        if (this.tri2 == tri) {
            return 2;
        }
        return -1;
    }

    public Tri getAdjacent(int index) {
        switch (index) {
            case 0: {
                return this.tri0;
            }
            case 1: {
                return this.tri1;
            }
            case 2: {
                return this.tri2;
            }
        }
        throw new IllegalArgumentException(INVALID_TRI_INDEX);
    }

    public boolean hasAdjacent() {
        return this.hasAdjacent(0) || this.hasAdjacent(1) || this.hasAdjacent(2);
    }

    public boolean hasAdjacent(int index) {
        return null != this.getAdjacent(index);
    }

    public boolean isAdjacent(Tri tri) {
        return this.getIndex(tri) >= 0;
    }

    public int numAdjacent() {
        int num = 0;
        if (this.tri0 != null) {
            ++num;
        }
        if (this.tri1 != null) {
            ++num;
        }
        if (this.tri2 != null) {
            ++num;
        }
        return num;
    }

    public boolean isInteriorVertex(int index) {
        Tri curr = this;
        int currIndex = index;
        do {
            Tri adj;
            if ((adj = curr.getAdjacent(currIndex)) == null) {
                return false;
            }
            int adjIndex = adj.getIndex(curr);
            if (adjIndex < 0) {
                throw new IllegalStateException("Inconsistent adjacency - invalid triangulation");
            }
            curr = adj;
            currIndex = Tri.next(adjIndex);
        } while (curr != this);
        return true;
    }

    public boolean isBorder() {
        return this.isBoundary(0) || this.isBoundary(1) || this.isBoundary(2);
    }

    public boolean isBoundary(int index) {
        return !this.hasAdjacent(index);
    }

    public static int next(int index) {
        switch (index) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    public static int prev(int index) {
        switch (index) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return -1;
    }

    public static int oppVertex(int edgeIndex) {
        return Tri.prev(edgeIndex);
    }

    public static int oppEdge(int vertexIndex) {
        return Tri.next(vertexIndex);
    }

    public Coordinate midpoint(int edgeIndex) {
        Coordinate p0 = this.getCoordinate(edgeIndex);
        Coordinate p1 = this.getCoordinate(Tri.next(edgeIndex));
        double midX = (p0.getX() + p1.getX()) / 2.0;
        double midY = (p0.getY() + p1.getY()) / 2.0;
        return new Coordinate(midX, midY);
    }

    public double getArea() {
        return Triangle.area(this.p0, this.p1, this.p2);
    }

    public double getLength() {
        return Triangle.length(this.p0, this.p1, this.p2);
    }

    public double getLength(int edgeIndex) {
        return this.getCoordinate(edgeIndex).distance(this.getCoordinate(Tri.next(edgeIndex)));
    }

    public Polygon toPolygon(GeometryFactory geomFact) {
        return geomFact.createPolygon(geomFact.createLinearRing(new Coordinate[]{this.p0.copy(), this.p1.copy(), this.p2.copy(), this.p0.copy()}), null);
    }

    public String toString() {
        return String.format("POLYGON ((%s, %s, %s, %s))", WKTWriter.format(this.p0), WKTWriter.format(this.p1), WKTWriter.format(this.p2), WKTWriter.format(this.p0));
    }
}

