/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.api.dataset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;

public interface IStreamResultSet
extends ResultSet {
    public ResultSet getResultSet();

    public Logger getLogger();

    @Override
    default public boolean next() {
        try {
            return this.getResultSet().next();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call next() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public void close() {
        try {
            this.getResultSet().close();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call close() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public boolean wasNull() {
        try {
            return this.getResultSet().wasNull();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call wasNull() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public String getString(int i2) {
        try {
            return this.getResultSet().getString(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getString(int) method on wrapped ResultSet.", e);
            return "";
        }
    }

    @Override
    default public boolean getBoolean(int i2) {
        try {
            return this.getResultSet().getBoolean(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBoolean(int) method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public byte getByte(int i2) {
        try {
            return this.getResultSet().getByte(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getByte(int) method on wrapped ResultSet.", e);
            return 0;
        }
    }

    @Override
    default public short getShort(int i2) {
        try {
            return this.getResultSet().getShort(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getShort(int) method on wrapped ResultSet.", e);
            return 0;
        }
    }

    @Override
    default public int getInt(int i2) {
        try {
            return this.getResultSet().getInt(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getInt(int) method on wrapped ResultSet.", e);
            return 0;
        }
    }

    @Override
    default public long getLong(int i2) {
        try {
            return this.getResultSet().getLong(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getLong(int) method on wrapped ResultSet.", e);
            return 0L;
        }
    }

    @Override
    default public float getFloat(int i2) {
        try {
            return this.getResultSet().getFloat(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getFloat(int) method on wrapped ResultSet.", e);
            return 0.0f;
        }
    }

    @Override
    default public double getDouble(int i2) {
        try {
            return this.getResultSet().getDouble(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getDouble(int) method on wrapped ResultSet.", e);
            return 0.0;
        }
    }

    @Override
    default public BigDecimal getBigDecimal(int i2, int i1) {
        try {
            return this.getResultSet().getBigDecimal(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBigDecimal(int, int) method on wrapped ResultSet.", e);
            return new BigDecimal("0");
        }
    }

    @Override
    default public byte[] getBytes(int i2) {
        try {
            return this.getResultSet().getBytes(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBytes(int) method on wrapped ResultSet.", e);
            return new byte[0];
        }
    }

    @Override
    default public Date getDate(int i2) {
        try {
            return this.getResultSet().getDate(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getDate(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Time getTime(int i2) {
        try {
            return this.getResultSet().getTime(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTime(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Timestamp getTimestamp(int i2) {
        try {
            return this.getResultSet().getTimestamp(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTimestamp(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public InputStream getAsciiStream(int i2) {
        try {
            return this.getResultSet().getAsciiStream(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getAsciiStream(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    @Deprecated
    default public InputStream getUnicodeStream(int i2) {
        try {
            return this.getResultSet().getUnicodeStream(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getUnicodeStream(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public InputStream getBinaryStream(int i2) {
        try {
            return this.getResultSet().getBinaryStream(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBinaryStream(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public String getString(String s) {
        try {
            return this.getResultSet().getString(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getString(String) method on wrapped ResultSet.", e);
            return "";
        }
    }

    @Override
    default public boolean getBoolean(String s) {
        try {
            return this.getResultSet().getBoolean(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBoolean(String) method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public byte getByte(String s) {
        try {
            return this.getResultSet().getByte(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getByte(String) method on wrapped ResultSet.", e);
            return 0;
        }
    }

    @Override
    default public short getShort(String s) {
        try {
            return this.getResultSet().getShort(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getShort(String) method on wrapped ResultSet.", e);
            return 0;
        }
    }

    @Override
    default public int getInt(String s) {
        try {
            return this.getResultSet().getInt(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getInt(String) method on wrapped ResultSet.", e);
            return 0;
        }
    }

    @Override
    default public long getLong(String s) {
        try {
            return this.getResultSet().getLong(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getLong(String) method on wrapped ResultSet.", e);
            return 0L;
        }
    }

    @Override
    default public float getFloat(String s) {
        try {
            return this.getResultSet().getFloat(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getFloat(String) method on wrapped ResultSet.", e);
            return 0.0f;
        }
    }

    @Override
    default public double getDouble(String s) {
        try {
            return this.getResultSet().getDouble(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getDouble(String) method on wrapped ResultSet.", e);
            return 0.0;
        }
    }

    @Override
    default public BigDecimal getBigDecimal(String s, int i2) {
        try {
            return this.getResultSet().getBigDecimal(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBigDecimal(String) method on wrapped ResultSet.", e);
            return new BigDecimal("0");
        }
    }

    @Override
    default public byte[] getBytes(String s) {
        try {
            return this.getResultSet().getBytes(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBytes(String) method on wrapped ResultSet.", e);
            return new byte[0];
        }
    }

    @Override
    default public Date getDate(String s) {
        try {
            return this.getResultSet().getDate(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getDate(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Time getTime(String s) {
        try {
            return this.getResultSet().getTime(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTime(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Timestamp getTimestamp(String s) {
        try {
            return this.getResultSet().getTimestamp(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTimestamp(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public InputStream getAsciiStream(String s) {
        try {
            return this.getResultSet().getAsciiStream(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getAsciiStream(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    @Deprecated
    default public InputStream getUnicodeStream(String s) {
        try {
            return this.getResultSet().getUnicodeStream(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getUnicodeStream(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public InputStream getBinaryStream(String s) {
        try {
            return this.getResultSet().getBinaryStream(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBinaryStream(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public SQLWarning getWarnings() {
        try {
            return this.getResultSet().getWarnings();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getWarnings() method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public void clearWarnings() {
        try {
            this.getResultSet().clearWarnings();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call clearWarnings() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public String getCursorName() {
        try {
            return this.getResultSet().getCursorName();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getCursorName() method on wrapped ResultSet.", e);
            return "";
        }
    }

    @Override
    default public ResultSetMetaData getMetaData() {
        try {
            return this.getResultSet().getMetaData();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getMetaData() method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Object getObject(int i2) {
        try {
            return this.getResultSet().getObject(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getObject(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Object getObject(String s) {
        try {
            return this.getResultSet().getObject(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getObject(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public int findColumn(String s) {
        try {
            return this.getResultSet().findColumn(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call findColumn(String) method on wrapped ResultSet.", e);
            return 0;
        }
    }

    @Override
    default public Reader getCharacterStream(int i2) {
        try {
            return this.getResultSet().getCharacterStream(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getObject(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Reader getCharacterStream(String s) {
        try {
            return this.getResultSet().getCharacterStream(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getCharacterStream(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public BigDecimal getBigDecimal(int i2) {
        try {
            return this.getResultSet().getBigDecimal(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBigDecimal(int) method on wrapped ResultSet.", e);
            return new BigDecimal("0");
        }
    }

    @Override
    default public BigDecimal getBigDecimal(String s) {
        try {
            return this.getResultSet().getBigDecimal(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBigDecimal(String) method on wrapped ResultSet.", e);
            return new BigDecimal("0");
        }
    }

    @Override
    default public boolean isBeforeFirst() {
        try {
            return this.getResultSet().isBeforeFirst();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call isBeforeFirst() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean isAfterLast() {
        try {
            return this.getResultSet().isAfterLast();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call isAfterLast() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean isFirst() {
        try {
            return this.getResultSet().isFirst();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call isFirst() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean isLast() {
        try {
            return this.getResultSet().isLast();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call isLast() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public void beforeFirst() {
        try {
            this.getResultSet().beforeFirst();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call beforeFirst() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void afterLast() {
        try {
            this.getResultSet().afterLast();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call afterLast() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public boolean first() {
        try {
            return this.getResultSet().first();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call first() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean last() {
        try {
            return this.getResultSet().isAfterLast();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call isAfterLast() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public int getRow() {
        try {
            return this.getResultSet().getRow();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getRow() method on wrapped ResultSet.", e);
            return -2;
        }
    }

    @Override
    default public boolean absolute(int i2) {
        try {
            return this.getResultSet().absolute(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call absolute(i) method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean relative(int i2) {
        try {
            return this.getResultSet().relative(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call relative(i) method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean previous() {
        try {
            return this.getResultSet().previous();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call previous() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public void setFetchDirection(int i2) {
        try {
            this.getResultSet().setFetchDirection(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call setFetchDirection(int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public int getFetchDirection() {
        try {
            return this.getResultSet().getFetchDirection();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getFetchDirection() method on wrapped ResultSet.", e);
            return 1002;
        }
    }

    @Override
    default public void setFetchSize(int i2) {
        try {
            this.getResultSet().setFetchSize(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call setFetchSize(int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public int getFetchSize() {
        try {
            return this.getResultSet().getFetchSize();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getFetchSize() method on wrapped ResultSet.", e);
            return -1;
        }
    }

    @Override
    default public int getType() {
        try {
            return this.getResultSet().getType();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getType() method on wrapped ResultSet.", e);
            return 1003;
        }
    }

    @Override
    default public int getConcurrency() {
        try {
            return this.getResultSet().getConcurrency();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getConcurrency() method on wrapped ResultSet.", e);
            return 1007;
        }
    }

    @Override
    default public boolean rowUpdated() {
        try {
            return this.getResultSet().rowUpdated();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call rowUpdated() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean rowInserted() {
        try {
            return this.getResultSet().rowInserted();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call rowInserted() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public boolean rowDeleted() {
        try {
            return this.getResultSet().rowDeleted();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call rowDeleted() method on wrapped ResultSet.", e);
            return false;
        }
    }

    @Override
    default public void updateNull(int i2) {
        try {
            this.getResultSet().updateNull(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNull(int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBoolean(int i2, boolean b) {
        try {
            this.getResultSet().updateBoolean(i2, b);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBoolean(int, boolean) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateByte(int i2, byte b) {
        try {
            this.getResultSet().updateByte(i2, b);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateByte(int, byte) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateShort(int i2, short i1) {
        try {
            this.getResultSet().updateShort(i2, i1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateShort(int, short) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateInt(int i2, int i1) {
        try {
            this.getResultSet().updateInt(i2, i1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateInt(int, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateLong(int i2, long l) {
        try {
            this.getResultSet().updateLong(i2, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateLong(int, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateFloat(int i2, float v) {
        try {
            this.getResultSet().updateFloat(i2, v);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateFloat(int, float) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateDouble(int i2, double v) {
        try {
            this.getResultSet().updateDouble(i2, v);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateDouble(int, double) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBigDecimal(int i2, BigDecimal bigDecimal) {
        try {
            this.getResultSet().updateBigDecimal(i2, bigDecimal);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBigDecimal(int, BigDecimal) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateString(int i2, String s) {
        try {
            this.getResultSet().updateString(i2, s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateString(int, String) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBytes(int i2, byte[] bytes) {
        try {
            this.getResultSet().updateBytes(i2, bytes);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBytes(int, byte[]) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateDate(int i2, Date date) {
        try {
            this.getResultSet().updateDate(i2, date);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateDate(int, Date) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateTime(int i2, Time time) {
        try {
            this.getResultSet().updateTime(i2, time);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateTime(int, Time) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateTimestamp(int i2, Timestamp timestamp) {
        try {
            this.getResultSet().updateTimestamp(i2, timestamp);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateTimestamp(int, Timestamp) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateAsciiStream(int i2, InputStream inputStream, int i1) {
        try {
            this.getResultSet().updateAsciiStream(i2, inputStream, i1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateAsciiStream(int, InputStream, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBinaryStream(int i2, InputStream inputStream, int i1) {
        try {
            this.getResultSet().updateBinaryStream(i2, inputStream, i1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBinaryStream(int, InputStream, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateCharacterStream(int i2, Reader reader, int i1) {
        try {
            this.getResultSet().updateCharacterStream(i2, reader, i1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateCharacterStream(int, Reader, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateObject(int i2, Object o, int i1) {
        try {
            this.getResultSet().updateObject(i2, o, i1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateObject(int, Object, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateObject(int i2, Object o) {
        try {
            this.getResultSet().updateObject(i2, o);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateObject(int, Object) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNull(String s) {
        try {
            this.getResultSet().updateNull(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNull(String) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBoolean(String s, boolean b) {
        try {
            this.getResultSet().updateBoolean(s, b);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBoolean(String, boolean) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateByte(String s, byte b) {
        try {
            this.getResultSet().updateByte(s, b);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateByte(String, byte) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateShort(String s, short i2) {
        try {
            this.getResultSet().updateShort(s, i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateShort(String, short) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateInt(String s, int i2) {
        try {
            this.getResultSet().updateInt(s, i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateInt(String, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateLong(String s, long l) {
        try {
            this.getResultSet().updateLong(s, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateLong(String, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateFloat(String s, float v) {
        try {
            this.getResultSet().updateFloat(s, v);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateFloat(String, float) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateDouble(String s, double v) {
        try {
            this.getResultSet().updateDouble(s, v);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateDouble(String, double) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBigDecimal(String s, BigDecimal bigDecimal) {
        try {
            this.getResultSet().updateBigDecimal(s, bigDecimal);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBigDecimal(String, BigDecimal) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateString(String s, String s1) {
        try {
            this.getResultSet().updateString(s, s1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateString(String, String) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBytes(String s, byte[] bytes) {
        try {
            this.getResultSet().updateBytes(s, bytes);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBytes(String, byte[]) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateDate(String s, Date date) {
        try {
            this.getResultSet().updateDate(s, date);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateDate(String, Date) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateTime(String s, Time time) {
        try {
            this.getResultSet().updateTime(s, time);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateTime(String, Time) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateTimestamp(String s, Timestamp timestamp) {
        try {
            this.getResultSet().updateTimestamp(s, timestamp);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateTimestamp(String, Timestamp) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateAsciiStream(String s, InputStream inputStream, int i2) {
        try {
            this.getResultSet().updateAsciiStream(s, inputStream, i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateAsciiStream(String, InputStream, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBinaryStream(String s, InputStream inputStream, int i2) {
        try {
            this.getResultSet().updateBinaryStream(s, inputStream, i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBinaryStream(String, InputStream, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateCharacterStream(String s, Reader reader, int i2) {
        try {
            this.getResultSet().updateCharacterStream(s, reader, i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateCharacterStream(String, Reader, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateObject(String s, Object o, int i2) {
        try {
            this.getResultSet().updateObject(s, o, i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateObject(String, Object, int) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateObject(String s, Object o) {
        try {
            this.getResultSet().updateObject(s, o);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateObject(String, Object) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void insertRow() {
        try {
            this.getResultSet().insertRow();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call insertRow() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateRow() {
        try {
            this.getResultSet().updateRow();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateRow() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void deleteRow() {
        try {
            this.getResultSet().deleteRow();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call deleteRow() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void refreshRow() {
        try {
            this.getResultSet().refreshRow();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call refreshRow() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void cancelRowUpdates() {
        try {
            this.getResultSet().cancelRowUpdates();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call cancelRowUpdates() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void moveToInsertRow() {
        try {
            this.getResultSet().moveToInsertRow();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call moveToInsertRow() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void moveToCurrentRow() {
        try {
            this.getResultSet().moveToCurrentRow();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call moveToCurrentRow() method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public Statement getStatement() {
        try {
            return this.getResultSet().getStatement();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getStatement() method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Object getObject(int i2, Map<String, Class<?>> map) {
        try {
            return this.getResultSet().getObject(i2, map);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getObject(int, Map<String, CLass<?>>) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Ref getRef(int i2) {
        try {
            return this.getResultSet().getRef(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getRef(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Blob getBlob(int i2) {
        try {
            return this.getResultSet().getBlob(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBlob(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Clob getClob(int i2) {
        try {
            return this.getResultSet().getClob(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getClob(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Array getArray(int i2) {
        try {
            return this.getResultSet().getArray(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getArray(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Object getObject(String s, Map<String, Class<?>> map) {
        try {
            return this.getResultSet().getObject(s, map);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getObject(String, Map<String, Class<?>>) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Ref getRef(String s) {
        try {
            return this.getResultSet().getRef(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getRef(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Blob getBlob(String s) {
        try {
            return this.getResultSet().getBlob(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getBlob(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Clob getClob(String s) {
        try {
            return this.getResultSet().getClob(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getClob(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Array getArray(String s) {
        try {
            return this.getResultSet().getArray(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getArray(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Date getDate(int i2, Calendar calendar) {
        try {
            return this.getResultSet().getDate(i2, calendar);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getDate(int, Calendar) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Date getDate(String s, Calendar calendar) {
        try {
            return this.getResultSet().getDate(s, calendar);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getDate(String, Calendar) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Time getTime(int i2, Calendar calendar) {
        try {
            return this.getResultSet().getTime(i2, calendar);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTime(int, Calendar) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Time getTime(String s, Calendar calendar) {
        try {
            return this.getResultSet().getTime(s, calendar);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTime(String, Calendar) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Timestamp getTimestamp(int i2, Calendar calendar) {
        try {
            return this.getResultSet().getTimestamp(i2, calendar);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTimestamp(int, Calendar) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Timestamp getTimestamp(String s, Calendar calendar) {
        try {
            return this.getResultSet().getTimestamp(s, calendar);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getTimestamp(String, Calendar) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public URL getURL(int i2) {
        try {
            return this.getResultSet().getURL(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getURL(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public URL getURL(String s) {
        try {
            return this.getResultSet().getURL(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getURL(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public void updateRef(int i2, Ref ref) {
        try {
            this.getResultSet().updateRef(i2, ref);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateRef(int, Ref) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateRef(String s, Ref ref) {
        try {
            this.getResultSet().updateRef(s, ref);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateRef(String, Ref) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBlob(int i2, Blob blob) {
        try {
            this.getResultSet().updateBlob(i2, blob);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBlob(int, Blob) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBlob(String s, Blob blob) {
        try {
            this.getResultSet().updateBlob(s, blob);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateRef(int, Blob) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateClob(int i2, Clob clob) {
        try {
            this.getResultSet().updateClob(i2, clob);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateRef(int, Clob) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateClob(String s, Clob clob) {
        try {
            this.getResultSet().updateClob(s, clob);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateClob(String, Clob) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateArray(int i2, Array array) {
        try {
            this.getResultSet().updateArray(i2, array);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateArray(int, Array) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateArray(String s, Array array) {
        try {
            this.getResultSet().updateArray(s, array);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateArray(int, Array) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public RowId getRowId(int i2) {
        try {
            return this.getResultSet().getRowId(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getRowId(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public RowId getRowId(String s) {
        try {
            return this.getResultSet().getRowId(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getRowId(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public void updateRowId(int i2, RowId rowId) {
        try {
            this.getResultSet().updateRowId(i2, rowId);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateRowId(int, RowId) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateRowId(String s, RowId rowId) {
        try {
            this.getResultSet().updateRowId(s, rowId);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateRowId(String, RowId) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public int getHoldability() {
        try {
            return this.getResultSet().getHoldability();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getHoldability() method on wrapped ResultSet.", e);
            return 1;
        }
    }

    @Override
    default public boolean isClosed() {
        try {
            return this.getResultSet().isClosed();
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call isClosed() method on wrapped ResultSet.", e);
            return true;
        }
    }

    @Override
    default public void updateNString(int i2, String s) {
        try {
            this.getResultSet().updateNString(i2, s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNString(int, String) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNString(String s, String s1) {
        try {
            this.getResultSet().updateNString(s, s1);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNString(String, String) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNClob(int i2, NClob nClob) {
        try {
            this.getResultSet().updateNClob(i2, nClob);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNClob(int, NClob) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNClob(String s, NClob nClob) {
        try {
            this.getResultSet().updateNClob(s, nClob);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNClob(String, NClob) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public NClob getNClob(int i2) {
        try {
            return this.getResultSet().getNClob(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getNClob(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public NClob getNClob(String s) {
        try {
            return this.getResultSet().getNClob(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getNClob(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public SQLXML getSQLXML(int i2) {
        try {
            return this.getResultSet().getSQLXML(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getSQLXML(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public SQLXML getSQLXML(String s) {
        try {
            return this.getResultSet().getSQLXML(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getSQLXML(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public void updateSQLXML(int i2, SQLXML sqlxml) {
        try {
            this.getResultSet().updateSQLXML(i2, sqlxml);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateSQLXML(int, SQLXML) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateSQLXML(String s, SQLXML sqlxml) {
        try {
            this.getResultSet().updateSQLXML(s, sqlxml);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateSQLXML(String, SQLXML) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public String getNString(int i2) {
        try {
            return this.getResultSet().getNString(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getNString(int) method on wrapped ResultSet.", e);
            return "";
        }
    }

    @Override
    default public String getNString(String s) {
        try {
            return this.getResultSet().getNString(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getNString(String) method on wrapped ResultSet.", e);
            return "";
        }
    }

    @Override
    default public Reader getNCharacterStream(int i2) {
        try {
            return this.getResultSet().getNCharacterStream(i2);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getNCharacterStream(int) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public Reader getNCharacterStream(String s) {
        try {
            return this.getResultSet().getNCharacterStream(s);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getNCharacterStream(String) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public void updateNCharacterStream(int i2, Reader reader, long l) {
        try {
            this.getResultSet().updateNCharacterStream(i2, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNCharacterStream(int, Reader, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNCharacterStream(String s, Reader reader, long l) {
        try {
            this.getResultSet().updateNCharacterStream(s, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNCharacterStream(String, Reader, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateAsciiStream(int i2, InputStream inputStream, long l) {
        try {
            this.getResultSet().updateAsciiStream(i2, inputStream, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateAsciiStream(int, InputStream, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBinaryStream(int i2, InputStream inputStream, long l) {
        try {
            this.getResultSet().updateBinaryStream(i2, inputStream, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBinaryStream(int, InputStream, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateCharacterStream(int i2, Reader reader, long l) {
        try {
            this.getResultSet().updateCharacterStream(i2, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateCharacterStream(int, Reader, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateAsciiStream(String s, InputStream inputStream, long l) {
        try {
            this.getResultSet().updateAsciiStream(s, inputStream, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateAsciiStream(String, InputStream, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBinaryStream(String s, InputStream inputStream, long l) {
        try {
            this.getResultSet().updateBinaryStream(s, inputStream, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBinaryStream(String, InputStream, l) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateCharacterStream(String s, Reader reader, long l) {
        try {
            this.getResultSet().updateCharacterStream(s, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateCharacterStream(String, Reader, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBlob(int i2, InputStream inputStream, long l) {
        try {
            this.getResultSet().updateBlob(i2, inputStream, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBlob(int, InputStream, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBlob(String s, InputStream inputStream, long l) {
        try {
            this.getResultSet().updateBlob(s, inputStream, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBlob(int, InputStream, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateClob(int i2, Reader reader, long l) {
        try {
            this.getResultSet().updateClob(i2, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateClob(int, Reader, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateClob(String s, Reader reader, long l) {
        try {
            this.getResultSet().updateClob(s, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateClob(String, Reader, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNClob(int i2, Reader reader, long l) {
        try {
            this.getResultSet().updateNClob(i2, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNClob(int, Reader, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNClob(String s, Reader reader, long l) {
        try {
            this.getResultSet().updateNClob(s, reader, l);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNClob(String, InputStream, long) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNCharacterStream(int i2, Reader reader) {
        try {
            this.getResultSet().updateNCharacterStream(i2, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNCharacterStream(int, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNCharacterStream(String s, Reader reader) {
        try {
            this.getResultSet().updateNCharacterStream(s, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateCharacterStream(String, Reader) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateAsciiStream(int i2, InputStream inputStream) {
        try {
            this.getResultSet().updateAsciiStream(i2, inputStream);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateAsciiStream(int, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBinaryStream(int i2, InputStream inputStream) {
        try {
            this.getResultSet().updateBinaryStream(i2, inputStream);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBinaryStream(int, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateCharacterStream(int i2, Reader reader) {
        try {
            this.getResultSet().updateCharacterStream(i2, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateCharacterStream(int, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateAsciiStream(String s, InputStream inputStream) {
        try {
            this.getResultSet().updateAsciiStream(s, inputStream);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateAsciiStream(String, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBinaryStream(String s, InputStream inputStream) {
        try {
            this.getResultSet().updateBinaryStream(s, inputStream);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBinaryStream(String, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateCharacterStream(String s, Reader reader) {
        try {
            this.getResultSet().updateCharacterStream(s, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateCharacterStream(int, Reader) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBlob(int i2, InputStream inputStream) {
        try {
            this.getResultSet().updateBlob(i2, inputStream);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBlob(int, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateBlob(String s, InputStream inputStream) {
        try {
            this.getResultSet().updateBlob(s, inputStream);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateBlob(String, InputStream) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateClob(int i2, Reader reader) {
        try {
            this.getResultSet().updateClob(i2, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateClob(int, Reader) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateClob(String s, Reader reader) {
        try {
            this.getResultSet().updateClob(s, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateClob(String, Reader) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNClob(int i2, Reader reader) {
        try {
            this.getResultSet().updateNClob(i2, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNClob(int, Reader) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public void updateNClob(String s, Reader reader) {
        try {
            this.getResultSet().updateNClob(s, reader);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call updateNClob(String, Reader) method on wrapped ResultSet.", e);
        }
    }

    @Override
    default public <T> T getObject(int i2, Class<T> aClass) {
        try {
            return this.getResultSet().getObject(i2, aClass);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getObject(int, Class<T>) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public <T> T getObject(String s, Class<T> aClass) {
        try {
            return this.getResultSet().getObject(s, aClass);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call getObject(String, Class<T>) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public <T> T unwrap(Class<T> aClass) {
        try {
            return this.getResultSet().unwrap(aClass);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call unwrap(Class<T>) method on wrapped ResultSet.", e);
            return null;
        }
    }

    @Override
    default public boolean isWrapperFor(Class<?> aClass) {
        try {
            return this.getResultSet().isWrapperFor(aClass);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to call isWrapperFor(Class<?>) method on wrapped ResultSet.", e);
            return false;
        }
    }
}

