/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.SimpleMap;
import java.util.Objects;

public final class V8Locker
implements IJavetClosable {
    private final long threadId;
    private final IV8Native v8Native;
    private final V8Runtime v8Runtime;
    private volatile boolean locked;

    V8Locker(V8Runtime v8Runtime, IV8Native v8Native) throws JavetException {
        Objects.requireNonNull(v8Runtime);
        this.threadId = Thread.currentThread().getId();
        this.v8Native = v8Native;
        this.v8Runtime = v8Runtime;
        if (!v8Native.lockV8Runtime(v8Runtime.getHandle())) {
            throw new JavetException(JavetError.LockAcquisitionFailure);
        }
        this.locked = true;
    }

    @Override
    public void close() throws JavetException {
        long currentThreadId = Thread.currentThread().getId();
        if (this.threadId != currentThreadId) {
            throw new JavetException(JavetError.LockConflictThreadIdMismatch, SimpleMap.of("lockedThreadId", Long.toString(this.threadId), "currentThreadId", Long.toString(currentThreadId)));
        }
        if (!this.v8Native.unlockV8Runtime(this.v8Runtime.getHandle())) {
            throw new JavetException(JavetError.LockReleaseFailure);
        }
        this.locked = false;
    }

    @Override
    public boolean isClosed() {
        return !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

