/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.enums.JSFunctionType;
import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.enums.JSScopeType;
import com.caoccao.javet.enums.JavetPromiseRejectEvent;
import com.caoccao.javet.enums.V8AllocationSpace;
import com.caoccao.javet.enums.V8AwaitMode;
import com.caoccao.javet.enums.V8GCCallbackFlags;
import com.caoccao.javet.enums.V8GCType;
import com.caoccao.javet.enums.V8ValueErrorType;
import com.caoccao.javet.enums.V8ValueInternalType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.exceptions.JavetExecutionException;
import com.caoccao.javet.exceptions.JavetScriptingError;
import com.caoccao.javet.exceptions.V8ErrorTemplate;
import com.caoccao.javet.interfaces.IEnumBitset;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.IV8Convertible;
import com.caoccao.javet.interop.IV8Creatable;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.V8Guard;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Inspector;
import com.caoccao.javet.interop.V8Internal;
import com.caoccao.javet.interop.V8Locker;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.V8ScriptOrigin;
import com.caoccao.javet.interop.callback.IJavetGCCallback;
import com.caoccao.javet.interop.callback.IJavetPromiseRejectCallback;
import com.caoccao.javet.interop.callback.IV8ModuleResolver;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetPromiseRejectCallback;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.interop.executors.IV8Executor;
import com.caoccao.javet.interop.executors.V8FileExecutor;
import com.caoccao.javet.interop.executors.V8PathExecutor;
import com.caoccao.javet.interop.executors.V8StringExecutor;
import com.caoccao.javet.interop.monitoring.V8HeapSpaceStatistics;
import com.caoccao.javet.interop.monitoring.V8HeapStatistics;
import com.caoccao.javet.interop.monitoring.V8SharedMemoryStatistics;
import com.caoccao.javet.interop.monitoring.V8StatisticsFuture;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.values.IV8ValueNonProxyable;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBigInteger;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueDouble;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueLong;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValueNumber;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.primitive.V8ValueZonedDateTime;
import com.caoccao.javet.values.reference.IV8Context;
import com.caoccao.javet.values.reference.IV8Module;
import com.caoccao.javet.values.reference.IV8Script;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueFunction;
import com.caoccao.javet.values.reference.IV8ValueMap;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.IV8ValuePromise;
import com.caoccao.javet.values.reference.IV8ValueProxy;
import com.caoccao.javet.values.reference.IV8ValueReference;
import com.caoccao.javet.values.reference.IV8ValueSet;
import com.caoccao.javet.values.reference.IV8ValueTypedArray;
import com.caoccao.javet.values.reference.V8Context;
import com.caoccao.javet.values.reference.V8Module;
import com.caoccao.javet.values.reference.V8Script;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArrayBuffer;
import com.caoccao.javet.values.reference.V8ValueBooleanObject;
import com.caoccao.javet.values.reference.V8ValueDataView;
import com.caoccao.javet.values.reference.V8ValueDoubleObject;
import com.caoccao.javet.values.reference.V8ValueError;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueGlobalObject;
import com.caoccao.javet.values.reference.V8ValueIntegerObject;
import com.caoccao.javet.values.reference.V8ValueLongObject;
import com.caoccao.javet.values.reference.V8ValueMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValuePromise;
import com.caoccao.javet.values.reference.V8ValueProxy;
import com.caoccao.javet.values.reference.V8ValueSet;
import com.caoccao.javet.values.reference.V8ValueStringObject;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import com.caoccao.javet.values.reference.V8ValueSymbolObject;
import com.caoccao.javet.values.reference.V8ValueTypedArray;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInSymbol;
import com.caoccao.javet.values.virtual.V8VirtualValue;
import java.io.File;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;

public class V8Runtime
implements IJavetClosable,
IV8Creatable,
IV8Convertible {
    protected static final String ERROR_BYTE_BUFFER_MUST_BE_DIRECT = "Byte buffer must be direct.";
    protected static final String ERROR_HANDLE_MUST_BE_VALID = "Handle must be valid.";
    protected static final String ERROR_SYMBOL_DESCRIPTION_CANNOT_BE_EMPTY = "Symbol description cannot be empty.";
    protected static final String ERROR_THE_KEY_VALUE_PAIR_MUST_MATCH = "The key value pair must match.";
    protected static final String ERROR_THE_PROPERTY_NAME_MUST_BE_EITHER_STRING_OR_SYMBOL = "The property name must be either string or symbol.";
    protected static final String ERROR_VALUE_CANNOT_BE_A_V_8_CONTEXT = "Value cannot be a V8 context.";
    protected static final String ERROR_VALUE_CANNOT_BE_A_V_8_MODULE = "Value cannot be a V8 module.";
    protected static final String ERROR_VALUE_CANNOT_BE_A_V_8_SCRIPT = "Value cannot be a V8 script.";
    static final IJavetConverter DEFAULT_CONVERTER = new JavetObjectConverter();
    static final String DEFAULT_MESSAGE_FORMAT_JAVET_INSPECTOR = "Javet Inspector {0}";
    static final long INVALID_HANDLE = 0L;
    static final String PROPERTY_DATA_VIEW = "DataView";
    static final int V8_VALUE_BOOLEAN_FALSE_INDEX = 0;
    static final int V8_VALUE_BOOLEAN_TRUE_INDEX = 1;
    static final int V8_VALUE_NUMBER_LOWER_BOUND = -128;
    static final int V8_VALUE_NUMBER_UPPER_BOUND = 128;
    final Object callbackContextLock;
    final Map<Long, JavetCallbackContext> callbackContextMap;
    final List<IJavetGCCallback> gcEpilogueCallbacks;
    final List<IJavetGCCallback> gcPrologueCallbacks;
    final boolean[] primitiveFlags;
    final Object referenceLock;
    final Map<Long, IV8ValueReference> referenceMap;
    final RuntimeOptions<?> runtimeOptions;
    final V8Host v8Host;
    final V8Internal v8Internal;
    final Object v8ModuleLock;
    final Map<String, IV8Module> v8ModuleMap;
    V8ValueBoolean[] cachedV8ValueBooleans;
    V8ValueInteger[] cachedV8ValueIntegers;
    V8ValueLong[] cachedV8ValueLongs;
    V8ValueNull cachedV8ValueNull;
    V8ValueUndefined cachedV8ValueUndefined;
    Object closeLock;
    IJavetConverter converter;
    boolean gcScheduled;
    long handle;
    IJavetLogger logger;
    boolean pooled;
    IJavetPromiseRejectCallback promiseRejectCallback;
    V8Inspector v8Inspector;
    IV8ModuleResolver v8ModuleResolver;
    IV8Native v8Native;

    V8Runtime(V8Host v8Host, long handle, boolean pooled, IV8Native v8Native, RuntimeOptions<?> runtimeOptions) {
        assert (handle != 0L) : "Handle must be valid.";
        this.callbackContextLock = new Object();
        this.callbackContextMap = new HashMap<Long, JavetCallbackContext>();
        this.closeLock = new Object();
        this.converter = DEFAULT_CONVERTER;
        this.gcEpilogueCallbacks = new CopyOnWriteArrayList<IJavetGCCallback>();
        this.gcPrologueCallbacks = new CopyOnWriteArrayList<IJavetGCCallback>();
        this.gcScheduled = false;
        this.runtimeOptions = Objects.requireNonNull(runtimeOptions);
        this.handle = handle;
        this.logger = new JavetDefaultLogger(this.getClass().getName());
        this.pooled = pooled;
        this.primitiveFlags = new boolean[1];
        this.promiseRejectCallback = new JavetPromiseRejectCallback(this.logger);
        this.referenceLock = new Object();
        this.referenceMap = new HashMap<Long, IV8ValueReference>();
        this.v8Host = Objects.requireNonNull(v8Host);
        this.v8Inspector = null;
        this.v8Native = Objects.requireNonNull(v8Native);
        this.v8ModuleLock = new Object();
        this.v8ModuleMap = new HashMap<String, IV8Module>();
        this.v8ModuleResolver = null;
        this.v8Internal = new V8Internal(this);
        this.initializeV8ValueCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGCEpilogueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcEpilogueCallbacks;
        synchronized (list) {
            boolean registered = !this.gcEpilogueCallbacks.isEmpty();
            this.gcEpilogueCallbacks.add(Objects.requireNonNull(iJavetGCCallback));
            if (!registered) {
                this.v8Native.registerGCEpilogueCallback(this.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGCPrologueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcPrologueCallbacks;
        synchronized (list) {
            boolean registered = !this.gcPrologueCallbacks.isEmpty();
            this.gcPrologueCallbacks.add(Objects.requireNonNull(iJavetGCCallback));
            if (!registered) {
                this.v8Native.registerGCPrologueCallback(this.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReference(IV8ValueReference iV8ValueReference) {
        Object object = this.referenceLock;
        synchronized (object) {
            this.referenceMap.put(iV8ValueReference.getHandle(), iV8ValueReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addV8Module(IV8Module iV8Module) throws JavetException {
        String resourceName = Objects.requireNonNull(iV8Module.getResourceName());
        if (StringUtils.isNotEmpty(resourceName)) {
            Object object = this.v8ModuleLock;
            synchronized (object) {
                if (this.containsV8Module(resourceName)) {
                    this.removeV8Module(resourceName, true);
                }
                this.v8ModuleMap.put(resourceName, iV8Module);
            }
        }
    }

    public void allowEval(boolean allow) {
        this.v8Native.allowCodeGenerationFromStrings(this.handle, allow);
    }

    int arrayGetLength(IV8ValueArray iV8ValueArray) throws JavetException {
        return this.v8Native.arrayGetLength(this.handle, iV8ValueArray.getHandle(), iV8ValueArray.getType().getId());
    }

    int arrayGetLength(IV8ValueTypedArray iV8ValueTypedArray) throws JavetException {
        return this.v8Native.arrayGetLength(this.handle, iV8ValueTypedArray.getHandle(), iV8ValueTypedArray.getType().getId());
    }

    public boolean await() {
        return this.await(V8AwaitMode.RunTillNoMoreTasks);
    }

    public boolean await(V8AwaitMode v8AwaitMode) {
        return this.v8Native.await(this.handle, Objects.requireNonNull(v8AwaitMode).getId());
    }

    int batchArrayGet(IV8ValueArray iV8ValueArray, V8Value[] v8Values, int startIndex, int endIndex) throws JavetException {
        return this.v8Native.batchArrayGet(this.handle, iV8ValueArray.getHandle(), iV8ValueArray.getType().getId(), v8Values, startIndex, endIndex);
    }

    int batchObjectGet(IV8ValueObject iV8ValueObject, V8Value[] v8ValueKeys, V8Value[] v8ValueValues, int length) throws JavetException {
        return this.v8Native.batchObjectGet(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), v8ValueKeys, v8ValueValues, length);
    }

    V8ValueBoolean booleanObjectValueOf(V8ValueBooleanObject v8ValueBooleanObject) {
        return (V8ValueBoolean)this.v8Native.booleanObjectValueOf(this.handle, Objects.requireNonNull(v8ValueBooleanObject).getHandle(), v8ValueBooleanObject.getType().getId());
    }

    void clearWeak(IV8ValueReference iV8ValueReference) throws JavetException {
        this.v8Native.clearWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    <T extends V8Value> T cloneV8Value(IV8ValueReference iV8ValueReference, boolean referenceCopy) throws JavetException {
        return (T)((V8Value)this.v8Native.cloneV8Value(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId(), referenceCopy));
    }

    @Override
    public void close() throws JavetException {
        this.close(!this.pooled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean forceClose) throws JavetException {
        if (!this.isClosed() && forceClose) {
            this.removeAllReferences();
            Object object = this.closeLock;
            synchronized (object) {
                this.v8Host.closeV8Runtime(this);
                this.handle = 0L;
                this.v8Native = null;
            }
        }
    }

    public V8Module compileV8Module(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        v8ScriptOrigin.setModule(true);
        if (StringUtils.isEmpty(v8ScriptOrigin.getResourceName())) {
            throw new JavetException(JavetError.ModuleNameEmpty);
        }
        Object result = this.v8Native.moduleCompile(this.handle, scriptString, cachedData, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule());
        V8Module v8Module = null;
        if (resultRequired && result instanceof V8Module) {
            v8Module = (V8Module)result;
            this.addV8Module(v8Module);
        }
        return v8Module;
    }

    public V8Script compileV8Script(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        v8ScriptOrigin.setModule(false);
        return (V8Script)this.v8Native.scriptCompile(this.handle, scriptString, cachedData, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule());
    }

    public V8ValueFunction compileV8ValueFunction(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, String[] arguments, V8ValueObject[] contextExtensions) throws JavetException {
        return (V8ValueFunction)this.v8Native.functionCompile(this.handle, scriptString, cachedData, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), arguments, contextExtensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsV8Module(String resourceName) {
        Object object = this.v8ModuleLock;
        synchronized (object) {
            return this.v8ModuleMap.containsKey(resourceName);
        }
    }

    <T extends V8Value> T contextGet(IV8Context iV8Context, int index) throws JavetException {
        return (T)((V8Value)this.v8Native.contextGet(this.handle, iV8Context.getHandle(), iV8Context.getType().getId(), index));
    }

    int contextGetLength(IV8Context iV8Context) throws JavetException {
        return this.v8Native.contextGetLength(this.handle, iV8Context.getHandle(), iV8Context.getType().getId());
    }

    boolean contextIsContextType(IV8Context iV8Context, int contextTypeId) throws JavetException {
        return this.v8Native.contextIsContextType(this.handle, iV8Context.getHandle(), iV8Context.getType().getId(), contextTypeId);
    }

    boolean contextSetLength(IV8Context iV8Context, int length) throws JavetException {
        return this.v8Native.contextSetLength(this.handle, iV8Context.getHandle(), iV8Context.getType().getId(), length);
    }

    public byte[] createSnapshot() throws JavetException {
        if (!this.runtimeOptions.isCreateSnapshotEnabled()) {
            throw new JavetException(JavetError.RuntimeCreateSnapshotDisabled);
        }
        int callbackContextCount = this.getCallbackContextCount();
        int referenceCount = this.getReferenceCount();
        int v8ModuleCount = this.getV8ModuleCount();
        if (callbackContextCount > 0 || referenceCount > 0 || v8ModuleCount > 0) {
            throw new JavetException(JavetError.RuntimeCreateSnapshotBlocked, SimpleMap.of("callbackContextCount", callbackContextCount, "referenceCount", referenceCount, "v8ModuleCount", v8ModuleCount));
        }
        return this.v8Native.snapshotCreate(this.handle);
    }

    @Override
    public V8Module createV8Module(String moduleName, IV8ValueObject iV8ValueObject) throws JavetException {
        if (StringUtils.isEmpty(moduleName)) {
            throw new JavetException(JavetError.ModuleNameEmpty);
        }
        Objects.requireNonNull(iV8ValueObject);
        V8Module v8Module = (V8Module)this.v8Native.moduleCreate(this.handle, moduleName, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId());
        if (v8Module != null) {
            this.addV8Module(v8Module);
        }
        return v8Module;
    }

    @Override
    public V8ValueArray createV8ValueArray() throws JavetException {
        return (V8ValueArray)this.v8Native.arrayCreate(this.handle);
    }

    @Override
    public V8ValueArrayBuffer createV8ValueArrayBuffer(int length) throws JavetException {
        return (V8ValueArrayBuffer)this.v8Native.arrayBufferCreate(this.handle, length);
    }

    @Override
    public V8ValueArrayBuffer createV8ValueArrayBuffer(ByteBuffer byteBuffer) throws JavetException {
        Objects.requireNonNull(byteBuffer);
        assert (byteBuffer.isDirect()) : "Byte buffer must be direct.";
        return (V8ValueArrayBuffer)this.v8Native.arrayBufferCreate(this.handle, byteBuffer);
    }

    @Override
    public V8ValueBigInteger createV8ValueBigInteger(BigInteger bigInteger) throws JavetException {
        return new V8ValueBigInteger(this, bigInteger);
    }

    @Override
    public V8ValueBigInteger createV8ValueBigInteger(String bigIntegerValue) throws JavetException {
        return new V8ValueBigInteger(this, bigIntegerValue);
    }

    @Override
    public V8ValueBoolean createV8ValueBoolean(boolean booleanValue) throws JavetException {
        return this.cachedV8ValueBooleans[booleanValue ? 1 : 0];
    }

    @Override
    public V8ValueBooleanObject createV8ValueBooleanObject(boolean booleanValue) throws JavetException {
        return (V8ValueBooleanObject)this.v8Native.booleanObjectCreate(this.handle, booleanValue);
    }

    @Override
    public V8ValueDataView createV8ValueDataView(V8ValueArrayBuffer v8ValueArrayBuffer) throws JavetException {
        Objects.requireNonNull(v8ValueArrayBuffer);
        try (Object v8Value = this.getExecutor(PROPERTY_DATA_VIEW).execute();){
            if (v8Value instanceof V8ValueFunction) {
                V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Value;
                V8ValueDataView v8ValueDataView = (V8ValueDataView)v8ValueFunction.callAsConstructor(v8ValueArrayBuffer);
                return v8ValueDataView;
            }
        }
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", PROPERTY_DATA_VIEW));
    }

    @Override
    public V8ValueDouble createV8ValueDouble(double doubleValue) throws JavetException {
        return new V8ValueDouble(this, doubleValue);
    }

    @Override
    public V8ValueDoubleObject createV8ValueDoubleObject(double doubleValue) throws JavetException {
        return (V8ValueDoubleObject)this.v8Native.doubleObjectCreate(this.handle, doubleValue);
    }

    @Override
    public V8ValueError createV8ValueError(V8ValueErrorType v8ValueErrorType, String message) throws JavetException {
        return (V8ValueError)this.v8Native.errorCreate(this.handle, Objects.requireNonNull(v8ValueErrorType).getId(), Objects.requireNonNull(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V8ValueFunction createV8ValueFunction(JavetCallbackContext javetCallbackContext) throws JavetException {
        V8ValueFunction v8ValueFunction = (V8ValueFunction)this.v8Native.functionCreate(this.handle, Objects.requireNonNull(javetCallbackContext));
        Object object = this.callbackContextLock;
        synchronized (object) {
            this.callbackContextMap.put(javetCallbackContext.getHandle(), javetCallbackContext);
        }
        return v8ValueFunction;
    }

    @Override
    public V8ValueFunction createV8ValueFunction(String codeString) throws JavetException {
        return (V8ValueFunction)this.getExecutor(codeString).execute();
    }

    @Override
    public V8ValueInteger createV8ValueInteger(int integerValue) throws JavetException {
        if (integerValue >= -128 && integerValue < 128) {
            return this.cachedV8ValueIntegers[integerValue - -128];
        }
        return new V8ValueInteger(this, integerValue);
    }

    @Override
    public V8ValueIntegerObject createV8ValueIntegerObject(int intValue) throws JavetException {
        return ((V8ValueDoubleObject)this.v8Native.integerObjectCreate(this.handle, intValue)).toIntegerObject();
    }

    @Override
    public V8ValueLong createV8ValueLong(long longValue) throws JavetException {
        if (longValue >= -128L && longValue < 128L) {
            return this.cachedV8ValueLongs[(int)longValue - -128];
        }
        return new V8ValueLong(this, longValue);
    }

    @Override
    public V8ValueLongObject createV8ValueLongObject(long longValue) throws JavetException {
        return (V8ValueLongObject)this.v8Native.longObjectCreate(this.handle, longValue);
    }

    @Override
    public V8ValueMap createV8ValueMap() throws JavetException {
        return (V8ValueMap)this.v8Native.mapCreate(this.handle);
    }

    @Override
    public V8ValueNull createV8ValueNull() {
        return this.cachedV8ValueNull;
    }

    @Override
    public V8ValueObject createV8ValueObject() throws JavetException {
        return (V8ValueObject)this.v8Native.objectCreate(this.handle);
    }

    @Override
    public V8ValuePromise createV8ValuePromise() throws JavetException {
        return (V8ValuePromise)this.v8Native.promiseCreate(this.handle);
    }

    @Override
    public V8ValueProxy createV8ValueProxy(V8Value v8Value) throws JavetException {
        if (v8Value instanceof IV8ValueNonProxyable) {
            throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", v8Value.toString()));
        }
        return (V8ValueProxy)this.v8Native.proxyCreate(this.handle, v8Value);
    }

    @Override
    public V8ValueSet createV8ValueSet() throws JavetException {
        return (V8ValueSet)this.v8Native.setCreate(this.handle);
    }

    @Override
    public V8ValueString createV8ValueString(String str) throws JavetException {
        return new V8ValueString(this, str);
    }

    @Override
    public V8ValueStringObject createV8ValueStringObject(String str) throws JavetException {
        return (V8ValueStringObject)this.v8Native.stringObjectCreate(this.handle, str);
    }

    @Override
    public V8ValueSymbol createV8ValueSymbol(String description, boolean global) throws JavetException {
        assert (!StringUtils.isEmpty(description)) : "Symbol description cannot be empty.";
        if (global) {
            try (V8ValueBuiltInSymbol v8ValueBuiltInSymbol = this.getGlobalObject().getBuiltInSymbol();){
                V8ValueSymbol v8ValueSymbol = v8ValueBuiltInSymbol._for(description);
                return v8ValueSymbol;
            }
        }
        return (V8ValueSymbol)this.v8Native.symbolCreate(this.handle, description);
    }

    @Override
    public V8ValueTypedArray createV8ValueTypedArray(V8ValueReferenceType type, int length) throws JavetException {
        try (Object v8Value = this.getGlobalObject().get(type.getName());){
            if (v8Value instanceof V8ValueFunction) {
                V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Value;
                V8ValueTypedArray v8ValueTypedArray = (V8ValueTypedArray)v8ValueFunction.callAsConstructor(this.createV8ValueInteger(length));
                return v8ValueTypedArray;
            }
        }
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", type.getName()));
    }

    @Override
    public V8ValueUndefined createV8ValueUndefined() {
        return this.cachedV8ValueUndefined;
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(long jsTimestamp) throws JavetException {
        return new V8ValueZonedDateTime(this, jsTimestamp);
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(ZonedDateTime zonedDateTime) throws JavetException {
        return new V8ValueZonedDateTime(this, zonedDateTime);
    }

    V8ValueNumber<?> doubleObjectValueOf(V8ValueDoubleObject v8ValueDoubleObject) {
        return (V8ValueNumber)this.v8Native.doubleObjectValueOf(this.handle, Objects.requireNonNull(v8ValueDoubleObject).getHandle(), v8ValueDoubleObject.getType().getId());
    }

    boolean equals(IV8ValueReference iV8ValueReference1, IV8ValueReference iV8ValueReference2) throws JavetException {
        return this.v8Native.equals(this.handle, iV8ValueReference1.getHandle(), iV8ValueReference2.getHandle());
    }

    public <T extends V8Value> T execute(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        if (v8ScriptOrigin.isModule()) {
            return (T)((V8Value)this.v8Native.moduleExecute(this.handle, scriptString, cachedData, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm()));
        }
        return (T)((V8Value)this.v8Native.scriptExecute(this.handle, scriptString, cachedData, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm()));
    }

    <T extends V8Value> T functionCall(IV8ValueObject iV8ValueObject, V8Value receiver, boolean returnResult, V8Value ... v8Values) throws JavetException {
        return (T)((V8Value)this.v8Native.functionCall(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), receiver, returnResult, v8Values));
    }

    <T extends V8Value> T functionCallAsConstructor(IV8ValueObject iV8ValueObject, V8Value ... v8Values) throws JavetException {
        return (T)((V8Value)this.v8Native.functionCallAsConstructor(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), v8Values));
    }

    boolean functionCanDiscardCompiled(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionCanDiscardCompiled(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionCopyScopeInfoFrom(IV8ValueFunction targetIV8ValueFunction, IV8ValueFunction sourceIV8ValueFunction) throws JavetException {
        return this.v8Native.functionCopyScopeInfoFrom(this.handle, targetIV8ValueFunction.getHandle(), targetIV8ValueFunction.getType().getId(), sourceIV8ValueFunction.getHandle(), sourceIV8ValueFunction.getType().getId());
    }

    boolean functionDiscardCompiled(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionDiscardCompiled(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    String[] functionGetArguments(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.v8Native.functionGetArguments(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    byte[] functionGetCachedData(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.v8Native.functionGetCachedData(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    V8Context functionGetContext(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return (V8Context)this.v8Native.functionGetContext(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    IV8ValueArray functionGetInternalProperties(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return (V8ValueArray)this.v8Native.functionGetInternalProperties(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    JSFunctionType functionGetJSFunctionType(IV8ValueFunction iV8ValueFunction) {
        return JSFunctionType.parse(this.v8Native.functionGetJSFunctionType(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId()));
    }

    JSScopeType functionGetJSScopeType(IV8ValueFunction iV8ValueFunction) {
        return JSScopeType.parse(this.v8Native.functionGetJSScopeType(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId()));
    }

    IV8ValueArray functionGetScopeInfos(IV8ValueFunction iV8ValueFunction, IV8ValueFunction.GetScopeInfosOptions options) throws JavetException {
        return (IV8ValueArray)this.v8Native.functionGetScopeInfos(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), options.isIncludeGlobalVariables(), options.isIncludeScopeTypeGlobal());
    }

    IV8ValueFunction.ScriptSource functionGetScriptSource(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return (IV8ValueFunction.ScriptSource)this.v8Native.functionGetScriptSource(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    String functionGetSourceCode(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.v8Native.functionGetSourceCode(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionIsCompiled(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionIsCompiled(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionIsWrapped(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionIsWrapped(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionSetContext(IV8ValueFunction iV8ValueFunction, V8Context v8Context) throws JavetException {
        return this.v8Native.functionSetContext(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), v8Context);
    }

    boolean functionSetScriptSource(IV8ValueFunction iV8ValueFunction, IV8ValueFunction.ScriptSource scriptSource, boolean cloneScript) throws JavetException {
        return this.v8Native.functionSetScriptSource(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), scriptSource, cloneScript);
    }

    boolean functionSetSourceCode(IV8ValueFunction iV8ValueFunction, String sourceCode, boolean cloneScript) throws JavetException {
        return this.v8Native.functionSetSourceCode(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), sourceCode, cloneScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavetCallbackContext getCallbackContext(long handle) {
        Object object = this.callbackContextLock;
        synchronized (object) {
            return this.callbackContextMap.get(handle);
        }
    }

    public int getCallbackContextCount() {
        return this.callbackContextMap.size();
    }

    Object getCloseLock() {
        return this.closeLock;
    }

    public IJavetConverter getConverter() {
        return this.converter;
    }

    public IV8Executor getExecutor(File scriptFile) throws JavetException {
        return new V8FileExecutor(this, scriptFile);
    }

    public IV8Executor getExecutor(Path scriptPath) throws JavetException {
        return new V8PathExecutor(this, scriptPath);
    }

    public IV8Executor getExecutor(String scriptString) {
        return new V8StringExecutor(this, scriptString);
    }

    public IV8Executor getExecutor(String scriptString, byte[] cachedData) {
        return new V8StringExecutor(this, scriptString, cachedData);
    }

    public V8ValueGlobalObject getGlobalObject() throws JavetException {
        return (V8ValueGlobalObject)this.v8Native.getGlobalObject(this.handle);
    }

    public V8Guard getGuard() {
        return new V8Guard(this);
    }

    public V8Guard getGuard(long timoutMillis) {
        return new V8Guard(this, timoutMillis);
    }

    public V8Guard getGuard(long timoutMillis, boolean debugModeEnabled) {
        return new V8Guard(this, timoutMillis, debugModeEnabled);
    }

    public long getHandle() {
        return this.handle;
    }

    public JSRuntimeType getJSRuntimeType() {
        return JSRuntimeType.V8;
    }

    public IJavetLogger getLogger() {
        return this.logger;
    }

    public IJavetPromiseRejectCallback getPromiseRejectCallback() {
        return this.promiseRejectCallback;
    }

    public int getReferenceCount() {
        return this.referenceMap.size();
    }

    public RuntimeOptions<?> getRuntimeOptions() {
        return this.runtimeOptions;
    }

    public CompletableFuture<V8HeapSpaceStatistics> getV8HeapSpaceStatistics(V8AllocationSpace v8AllocationSpace) {
        V8StatisticsFuture v8StatisticsFuture = (V8StatisticsFuture)this.v8Native.getV8HeapSpaceStatistics(this.handle, (Object)Objects.requireNonNull(v8AllocationSpace));
        if (!v8StatisticsFuture.isDone()) {
            this.v8Host.offerV8StatisticsFuture(v8StatisticsFuture);
        }
        return v8StatisticsFuture;
    }

    public CompletableFuture<V8HeapStatistics> getV8HeapStatistics() {
        V8StatisticsFuture v8StatisticsFuture = (V8StatisticsFuture)this.v8Native.getV8HeapStatistics(this.handle);
        if (!v8StatisticsFuture.isDone()) {
            this.v8Host.offerV8StatisticsFuture(v8StatisticsFuture);
        }
        return v8StatisticsFuture;
    }

    V8Host getV8Host() {
        return this.v8Host;
    }

    public V8Inspector getV8Inspector() {
        return this.getV8Inspector(MessageFormat.format(DEFAULT_MESSAGE_FORMAT_JAVET_INSPECTOR, Long.toString(this.handle)));
    }

    public V8Inspector getV8Inspector(String name) {
        if (this.v8Inspector == null) {
            this.v8Inspector = new V8Inspector(this, name, this.v8Native);
        }
        return this.v8Inspector;
    }

    public V8Internal getV8Internal() {
        return this.v8Internal;
    }

    public V8Locker getV8Locker() throws JavetException {
        return new V8Locker(this, this.v8Native);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IV8Module getV8Module(String resourceName, IV8Module v8ModuleReferrer) throws JavetException {
        IV8Module iV8Module = null;
        if (!StringUtils.isEmpty(resourceName)) {
            Object object = this.v8ModuleLock;
            synchronized (object) {
                iV8Module = this.v8ModuleMap.get(resourceName);
            }
            if (iV8Module == null && this.v8ModuleResolver != null) {
                iV8Module = this.v8ModuleResolver.resolve(this, resourceName, v8ModuleReferrer);
            }
        }
        return iV8Module;
    }

    public int getV8ModuleCount() {
        return this.v8ModuleMap.size();
    }

    public IV8ModuleResolver getV8ModuleResolver() {
        return this.v8ModuleResolver;
    }

    public V8Scope getV8Scope() {
        return new V8Scope(this);
    }

    public V8SharedMemoryStatistics getV8SharedMemoryStatistics() {
        return this.v8Host.getV8SharedMemoryStatistics();
    }

    public String getVersion() {
        return this.v8Native.getVersion();
    }

    boolean hasInternalType(IV8ValueObject iV8ValueObject, V8ValueInternalType internalType) {
        return this.v8Native.hasInternalType(this.handle, iV8ValueObject.getHandle(), Objects.requireNonNull(internalType).getId());
    }

    public boolean hasPendingException() throws JavetException {
        return this.v8Native.hasPendingException(this.handle);
    }

    public boolean hasPendingMessage() throws JavetException {
        return this.v8Native.hasPendingMessage(this.handle);
    }

    public boolean hasScheduledException() throws JavetException {
        return this.v8Native.hasScheduledException(this.handle);
    }

    void initializeV8ValueCache() {
        try {
            this.cachedV8ValueNull = new V8ValueNull(this);
            this.cachedV8ValueUndefined = new V8ValueUndefined(this);
            this.cachedV8ValueBooleans = new V8ValueBoolean[]{new V8ValueBoolean(this, false), new V8ValueBoolean(this, true)};
            this.cachedV8ValueIntegers = new V8ValueInteger[256];
            this.cachedV8ValueLongs = new V8ValueLong[256];
            for (int i2 = -128; i2 < 128; ++i2) {
                try {
                    this.cachedV8ValueIntegers[i2 - -128] = new V8ValueInteger(this, i2);
                    this.cachedV8ValueLongs[i2 - -128] = new V8ValueLong(this, i2);
                    continue;
                }
                catch (JavetException e) {
                    this.logger.logError(e, e.getMessage(), new Object[0]);
                }
            }
        }
        catch (JavetException e) {
            this.logger.logError(e, e.getMessage(), new Object[0]);
        }
    }

    V8ValueInteger integerObjectValueOf(V8ValueIntegerObject v8ValueIntegerObject) throws JavetException {
        return (V8ValueInteger)this.v8Native.integerObjectValueOf(this.handle, Objects.requireNonNull(v8ValueIntegerObject).getHandle(), v8ValueIntegerObject.getType().getId());
    }

    @Override
    public boolean isClosed() {
        return this.handle == 0L;
    }

    public boolean isDead() {
        return this.v8Native.isDead(this.handle);
    }

    public boolean isGCScheduled() {
        return this.gcScheduled;
    }

    public boolean isInUse() {
        return this.v8Native.isInUse(this.handle);
    }

    public boolean isPooled() {
        return this.pooled;
    }

    boolean isWeak(IV8ValueReference iV8ValueReference) {
        return this.v8Native.isWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    V8ValueLong longObjectValueOf(V8ValueLongObject v8ValueLongObject) throws JavetException {
        return (V8ValueLong)this.v8Native.longObjectValueOf(this.handle, Objects.requireNonNull(v8ValueLongObject).getHandle(), v8ValueLongObject.getType().getId());
    }

    public void lowMemoryNotification() {
        if (!this.isClosed()) {
            this.v8Native.lowMemoryNotification(this.handle);
        }
    }

    V8ValueArray mapAsArray(IV8ValueMap iV8ValueMap) throws JavetException {
        return (V8ValueArray)this.v8Native.mapAsArray(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId());
    }

    void mapClear(IV8ValueMap iV8ValueMap) {
        this.v8Native.mapClear(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId());
    }

    boolean mapDelete(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        return this.v8Native.mapDelete(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key);
    }

    <T extends V8Value> T mapGet(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        return (T)((V8Value)this.v8Native.mapGet(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key));
    }

    Boolean mapGetBoolean(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        boolean value = this.v8Native.mapGetBoolean(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Boolean.valueOf(value) : null;
    }

    Double mapGetDouble(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        double value = this.v8Native.mapGetDouble(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Double.valueOf(value) : null;
    }

    Integer mapGetInteger(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        int value = this.v8Native.mapGetInteger(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Integer.valueOf(value) : null;
    }

    Long mapGetLong(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        long value = this.v8Native.mapGetLong(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Long.valueOf(value) : null;
    }

    int mapGetSize(IV8ValueMap iV8ValueMap) throws JavetException {
        return this.v8Native.mapGetSize(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId());
    }

    String mapGetString(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        return this.v8Native.mapGetString(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key);
    }

    boolean mapHas(IV8ValueMap iV8ValueMap, V8Value value) throws JavetException {
        return this.v8Native.mapHas(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), value);
    }

    boolean mapSet(IV8ValueMap iV8ValueMap, V8Value ... v8Values) throws JavetException {
        assert (v8Values.length > 0 && v8Values.length % 2 == 0) : "The key value pair must match.";
        return this.v8Native.mapSet(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), v8Values);
    }

    boolean mapSetBoolean(IV8ValueMap iV8ValueMap, V8Value key, boolean value) throws JavetException {
        return this.v8Native.mapSetBoolean(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, value);
    }

    boolean mapSetDouble(IV8ValueMap iV8ValueMap, V8Value key, double value) throws JavetException {
        return this.v8Native.mapSetDouble(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, value);
    }

    boolean mapSetInteger(IV8ValueMap iV8ValueMap, V8Value key, int value) throws JavetException {
        return this.v8Native.mapSetInteger(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, value);
    }

    boolean mapSetLong(IV8ValueMap iV8ValueMap, V8Value key, long value) throws JavetException {
        return this.v8Native.mapSetLong(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, value);
    }

    boolean mapSetNull(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        return this.v8Native.mapSetNull(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key);
    }

    boolean mapSetString(IV8ValueMap iV8ValueMap, V8Value key, String value) throws JavetException {
        return this.v8Native.mapSetString(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key, value);
    }

    boolean mapSetUndefined(IV8ValueMap iV8ValueMap, V8Value key) throws JavetException {
        return this.v8Native.mapSetUndefined(this.handle, iV8ValueMap.getHandle(), iV8ValueMap.getType().getId(), key);
    }

    <T extends V8Value> T moduleEvaluate(IV8Module iV8Module, boolean resultRequired) throws JavetException {
        return (T)((V8Value)this.v8Native.moduleEvaluate(this.handle, iV8Module.getHandle(), iV8Module.getType().getId(), resultRequired));
    }

    byte[] moduleGetCachedData(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetCachedData(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    V8ValueError moduleGetException(IV8Module iV8Module) throws JavetException {
        return (V8ValueError)this.v8Native.moduleGetException(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    int moduleGetIdentityHash(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetIdentityHash(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    V8Value moduleGetNamespace(IV8Module iV8Module) throws JavetException {
        return (V8Value)this.v8Native.moduleGetNamespace(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    String moduleGetResourceName(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetResourceName(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    int moduleGetScriptId(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetScriptId(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    int moduleGetStatus(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetStatus(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    boolean moduleInstantiate(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleInstantiate(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    boolean moduleIsSourceTextModule(IV8Module iV8Module) {
        return this.v8Native.moduleIsSourceTextModule(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    boolean moduleIsSyntheticModule(IV8Module iV8Module) {
        return this.v8Native.moduleIsSyntheticModule(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    boolean objectDelete(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return this.v8Native.objectDelete(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    boolean objectDeletePrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return this.v8Native.objectDeletePrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName);
    }

    <T extends V8Value> T objectGet(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return (T)((V8Value)this.v8Native.objectGet(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key));
    }

    Boolean objectGetBoolean(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        boolean value = this.v8Native.objectGetBoolean(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Boolean.valueOf(value) : null;
    }

    Double objectGetDouble(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        double value = this.v8Native.objectGetDouble(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Double.valueOf(value) : null;
    }

    int objectGetIdentityHash(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.objectGetIdentityHash(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    Integer objectGetInteger(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        int value = this.v8Native.objectGetInteger(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Integer.valueOf(value) : null;
    }

    Long objectGetLong(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        this.primitiveFlags[0] = true;
        long value = this.v8Native.objectGetLong(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, this.primitiveFlags);
        return this.primitiveFlags[0] ? Long.valueOf(value) : null;
    }

    IV8ValueArray objectGetOwnPropertyNames(IV8ValueObject iV8ValueObject) throws JavetException {
        return (V8ValueArray)this.v8Native.objectGetOwnPropertyNames(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId());
    }

    <T extends V8Value> T objectGetPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return (T)((V8Value)this.v8Native.objectGetPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName));
    }

    <T extends V8Value> T objectGetProperty(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return (T)((V8Value)this.v8Native.objectGetProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key));
    }

    IV8ValueArray objectGetPropertyNames(IV8ValueObject iV8ValueObject) throws JavetException {
        return (V8ValueArray)this.v8Native.objectGetPropertyNames(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId());
    }

    <T extends IV8ValueObject> T objectGetPrototype(IV8ValueObject iV8ValueObject) throws JavetException {
        return (T)((IV8ValueObject)this.v8Native.objectGetPrototype(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId()));
    }

    String objectGetString(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return this.v8Native.objectGetString(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    boolean objectHas(IV8ValueObject iV8ValueObject, V8Value propertyKey) throws JavetException {
        return this.v8Native.objectHas(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyKey);
    }

    boolean objectHasOwnProperty(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return this.v8Native.objectHasOwnProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    boolean objectHasPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return this.v8Native.objectHasPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName);
    }

    <T extends V8Value> T objectInvoke(IV8ValueObject iV8ValueObject, String functionName, boolean returnResult, V8Value ... v8Values) throws JavetException {
        Object result = this.v8Native.objectInvoke(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), functionName, returnResult, v8Values);
        if (result == null) {
            String message = MessageFormat.format("{0}: {1}", V8ValueErrorType.TypeError.getName(), V8ErrorTemplate.typeErrorValueIsNotAFunction(functionName));
            throw new JavetExecutionException(new JavetScriptingError(message, message, null), null);
        }
        return (T)((V8Value)result);
    }

    public boolean objectIsFrozen(IV8ValueObject iV8ValueObject) {
        return this.v8Native.objectIsFrozen(this.handle, Objects.requireNonNull(iV8ValueObject).getHandle());
    }

    public boolean objectIsSealed(IV8ValueObject iV8ValueObject) {
        return this.v8Native.objectIsSealed(this.handle, Objects.requireNonNull(iV8ValueObject).getHandle());
    }

    boolean objectSet(IV8ValueObject iV8ValueObject, V8Value ... v8Values) throws JavetException {
        assert (v8Values.length > 0 && v8Values.length % 2 == 0) : "The key value pair must match.";
        return this.v8Native.objectSet(this.handle, Objects.requireNonNull(iV8ValueObject).getHandle(), iV8ValueObject.getType().getId(), v8Values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean objectSetAccessor(IV8ValueObject iV8ValueObject, V8Value propertyName, JavetCallbackContext javetCallbackContextGetter, JavetCallbackContext javetCallbackContextSetter) throws JavetException {
        assert (propertyName instanceof V8ValueString || propertyName instanceof V8ValueSymbol) : "The property name must be either string or symbol.";
        boolean isAccessorSet = this.v8Native.objectSetAccessor(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName, javetCallbackContextGetter, javetCallbackContextSetter);
        Object object = this.callbackContextLock;
        synchronized (object) {
            if (javetCallbackContextGetter != null && javetCallbackContextGetter.isValid()) {
                this.callbackContextMap.put(javetCallbackContextGetter.getHandle(), javetCallbackContextGetter);
            }
            if (javetCallbackContextSetter != null && javetCallbackContextSetter.isValid()) {
                this.callbackContextMap.put(javetCallbackContextSetter.getHandle(), javetCallbackContextSetter);
            }
        }
        return isAccessorSet;
    }

    boolean objectSetBoolean(IV8ValueObject iV8ValueObject, V8Value key, boolean value) throws JavetException {
        return this.v8Native.objectSetBoolean(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean objectSetDouble(IV8ValueObject iV8ValueObject, V8Value key, double value) throws JavetException {
        return this.v8Native.objectSetDouble(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean objectSetInteger(IV8ValueObject iV8ValueObject, V8Value key, int value) throws JavetException {
        return this.v8Native.objectSetInteger(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean objectSetLong(IV8ValueObject iV8ValueObject, V8Value key, long value) throws JavetException {
        return this.v8Native.objectSetLong(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean objectSetNull(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return this.v8Native.objectSetNull(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    boolean objectSetPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName, V8Value propertyValue) throws JavetException {
        return this.v8Native.objectSetPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName, propertyValue);
    }

    boolean objectSetProperty(IV8ValueObject iV8ValueObject, V8Value key, V8Value value) throws JavetException {
        return this.v8Native.objectSetProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean objectSetPrototype(IV8ValueObject iV8ValueObject, IV8ValueObject iV8ValueObjectPrototype) throws JavetException {
        return this.v8Native.objectSetPrototype(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), iV8ValueObjectPrototype.getHandle());
    }

    boolean objectSetString(IV8ValueObject iV8ValueObject, V8Value key, String value) throws JavetException {
        return this.v8Native.objectSetString(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean objectSetUndefined(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return this.v8Native.objectSetUndefined(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    String objectToProtoString(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.objectToProtoString(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    <T extends V8ValuePromise> T promiseCatch(IV8ValuePromise iV8ValuePromise, IV8ValueFunction functionHandle) throws JavetException {
        return (T)((V8ValuePromise)this.v8Native.promiseCatch(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId(), functionHandle.getHandle()));
    }

    V8ValuePromise promiseGetPromise(IV8ValuePromise iV8ValuePromise) throws JavetException {
        return (V8ValuePromise)this.v8Native.promiseGetPromise(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    <T extends V8Value> T promiseGetResult(IV8ValuePromise iV8ValuePromise) throws JavetException {
        return (T)((V8Value)this.v8Native.promiseGetResult(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId()));
    }

    int promiseGetState(IV8ValuePromise iV8ValuePromise) {
        return this.v8Native.promiseGetState(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    boolean promiseHasHandler(IV8ValuePromise iV8ValuePromise) {
        return this.v8Native.promiseHasHandler(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    void promiseMarkAsHandled(IV8ValuePromise iV8ValuePromise) {
        this.v8Native.promiseMarkAsHandled(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    boolean promiseReject(V8ValuePromise v8ValuePromise, V8Value v8Value) {
        return this.v8Native.promiseReject(this.handle, v8ValuePromise.getHandle(), v8ValuePromise.getType().getId(), v8Value);
    }

    boolean promiseResolve(V8ValuePromise v8ValuePromise, V8Value v8Value) {
        return this.v8Native.promiseResolve(this.handle, v8ValuePromise.getHandle(), v8ValuePromise.getType().getId(), v8Value);
    }

    <T extends V8ValuePromise> T promiseThen(IV8ValuePromise iV8ValuePromise, IV8ValueFunction functionFulfilledHandle, IV8ValueFunction functionRejectedHandle) throws JavetException {
        return (T)((V8ValuePromise)this.v8Native.promiseThen(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId(), functionFulfilledHandle.getHandle(), functionRejectedHandle == null ? 0L : functionRejectedHandle.getHandle()));
    }

    public boolean promoteScheduledException() throws JavetException {
        return this.v8Native.promoteScheduledException(this.handle);
    }

    V8ValueObject proxyGetHandler(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return (V8ValueObject)this.v8Native.proxyGetHandler(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    V8ValueObject proxyGetTarget(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return (V8ValueObject)this.v8Native.proxyGetTarget(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    boolean proxyIsRevoked(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return this.v8Native.proxyIsRevoked(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    void proxyRevoke(IV8ValueProxy iV8ValueProxy) throws JavetException {
        this.v8Native.proxyRevoke(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    void receiveGCEpilogueCallback(int v8GCTypeValue, int v8GCCallbackFlagsValue) {
        EnumSet<V8GCType> enumSetV8GCType = IEnumBitset.getEnumSet(v8GCTypeValue, V8GCType.class);
        EnumSet<V8GCCallbackFlags> enumSetV8GCCallbackFlags = IEnumBitset.getEnumSet(v8GCCallbackFlagsValue, V8GCCallbackFlags.class, V8GCCallbackFlags.NoGCCallbackFlags);
        for (IJavetGCCallback iJavetGCCallback : this.gcEpilogueCallbacks) {
            iJavetGCCallback.callback(enumSetV8GCType, enumSetV8GCCallbackFlags);
        }
    }

    void receiveGCPrologueCallback(int v8GCTypeValue, int v8GCCallbackFlagsValue) {
        EnumSet<V8GCType> enumSetV8GCType = IEnumBitset.getEnumSet(v8GCTypeValue, V8GCType.class);
        EnumSet<V8GCCallbackFlags> enumSetV8GCCallbackFlags = IEnumBitset.getEnumSet(v8GCCallbackFlagsValue, V8GCCallbackFlags.class, V8GCCallbackFlags.NoGCCallbackFlags);
        for (IJavetGCCallback iJavetGCCallback : this.gcPrologueCallbacks) {
            iJavetGCCallback.callback(enumSetV8GCType, enumSetV8GCCallbackFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivePromiseRejectCallback(int event, V8ValuePromise promise, V8Value value) {
        try {
            this.promiseRejectCallback.callback(JavetPromiseRejectEvent.parse(event), promise, value);
        }
        catch (Throwable t) {
            try {
                this.logger.logError(t, "Failed to process promise reject callback {0}.", event);
            }
            catch (Throwable throwable) {
                JavetResourceUtils.safeClose(promise, value);
                throw throwable;
            }
            JavetResourceUtils.safeClose(promise, value);
        }
        JavetResourceUtils.safeClose(promise, value);
    }

    void removeAllReferences() throws JavetException {
        this.removeReferences();
        this.removeCallbackContexts();
        this.removeV8Modules();
        this.v8Inspector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallbackContext(long handle) {
        Object object = this.callbackContextLock;
        synchronized (object) {
            this.callbackContextMap.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbackContexts() {
        Object object = this.callbackContextLock;
        synchronized (object) {
            if (!this.callbackContextMap.isEmpty()) {
                this.logger.logWarn("{0} V8 callback context object(s) not recycled.", Integer.toString(this.callbackContextMap.size()));
                this.callbackContextMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGCEpilogueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcEpilogueCallbacks;
        synchronized (list) {
            this.gcEpilogueCallbacks.remove(Objects.requireNonNull(iJavetGCCallback));
            if (this.gcEpilogueCallbacks.isEmpty()) {
                this.v8Native.unregisterGCEpilogueCallback(this.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGCPrologueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcPrologueCallbacks;
        synchronized (list) {
            this.gcPrologueCallbacks.remove(Objects.requireNonNull(iJavetGCCallback));
            if (this.gcPrologueCallbacks.isEmpty()) {
                this.v8Native.unregisterGCPrologueCallback(this.handle);
            }
        }
    }

    void removeJNIGlobalRef(long handle) {
        if (!this.isClosed()) {
            this.v8Native.removeJNIGlobalRef(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReference(IV8ValueReference iV8ValueReference) throws JavetException {
        long referenceHandle = iV8ValueReference.getHandle();
        Object object = this.referenceLock;
        synchronized (object) {
            if (this.referenceMap.remove(referenceHandle) != null) {
                int referenceType = iV8ValueReference.getType().getId();
                if (referenceType == V8ValueReferenceType.Module.getId()) {
                    this.removeV8Module((IV8Module)iV8ValueReference);
                }
                this.v8Native.removeReferenceHandle(this.handle, referenceHandle, referenceType);
            }
        }
        if (this.gcScheduled) {
            this.lowMemoryNotification();
            this.gcScheduled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReferences() throws JavetException {
        Object object = this.referenceLock;
        synchronized (object) {
            if (!this.referenceMap.isEmpty()) {
                int referenceCount = this.getReferenceCount();
                int v8ModuleCount = this.getV8ModuleCount();
                int weakReferenceCount = 0;
                for (IV8ValueReference iV8ValueReference : new ArrayList<IV8ValueReference>(this.referenceMap.values())) {
                    IV8ValueObject iV8ValueObject;
                    if (iV8ValueReference instanceof IV8ValueObject && (iV8ValueObject = (IV8ValueObject)iV8ValueReference).isWeak()) {
                        ++weakReferenceCount;
                    }
                    iV8ValueReference.close(true);
                }
                if (v8ModuleCount + weakReferenceCount < referenceCount) {
                    this.logger.logWarn("{0} V8 object(s) not recycled, {1} weak, {2} module(s).", Integer.toString(referenceCount), Integer.toString(weakReferenceCount), Integer.toString(v8ModuleCount));
                } else {
                    this.logger.logDebug("{0} V8 object(s) not recycled, {1} weak, {2} module(s).", Integer.toString(referenceCount), Integer.toString(weakReferenceCount), Integer.toString(v8ModuleCount));
                }
                this.referenceMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeV8Module(String resourceName, boolean forceClose) throws JavetException {
        IV8Module iV8Module;
        Object object = this.v8ModuleLock;
        synchronized (object) {
            iV8Module = this.v8ModuleMap.remove(resourceName);
        }
        if (forceClose && iV8Module != null) {
            iV8Module.close(true);
        }
    }

    public void removeV8Module(String resourceName) throws JavetException {
        this.removeV8Module(resourceName, false);
    }

    public void removeV8Module(IV8Module iV8Module) throws JavetException {
        this.removeV8Module(iV8Module, false);
    }

    public void removeV8Module(IV8Module iV8Module, boolean forceClose) throws JavetException {
        this.removeV8Module(iV8Module.getResourceName(), forceClose);
    }

    public void removeV8Modules() throws JavetException {
        this.removeV8Modules(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeV8Modules(boolean forceClose) throws JavetException {
        Object object = this.v8ModuleLock;
        synchronized (object) {
            if (!this.v8ModuleMap.isEmpty()) {
                this.logger.logWarn("{0} V8 module(s) not recycled.", Integer.toString(this.v8ModuleMap.size()));
                for (IV8Module iV8Module : this.v8ModuleMap.values()) {
                    this.logger.logWarn("  V8 module: {0}", iV8Module.getResourceName());
                    if (!forceClose) continue;
                    iV8Module.close(true);
                }
                this.v8ModuleMap.clear();
            }
        }
    }

    public boolean reportPendingMessages() throws JavetException {
        return this.v8Native.reportPendingMessages(this.handle);
    }

    public void requestGarbageCollectionForTesting(boolean fullGC) {
        this.v8Native.requestGarbageCollectionForTesting(this.handle, fullGC);
    }

    public void resetContext() throws JavetException {
        this.removeAllReferences();
        this.v8Native.resetV8Context(this.handle, this.runtimeOptions);
    }

    public void resetIsolate() throws JavetException {
        this.removeAllReferences();
        this.v8Native.resetV8Isolate(this.handle, this.runtimeOptions);
    }

    boolean sameValue(IV8ValueObject iV8ValueObject1, IV8ValueObject iV8ValueObject2) {
        return this.v8Native.sameValue(this.handle, iV8ValueObject1.getHandle(), iV8ValueObject2.getHandle());
    }

    byte[] scriptGetCachedData(IV8Script iV8Script) throws JavetException {
        return this.v8Native.scriptGetCachedData(this.handle, iV8Script.getHandle(), iV8Script.getType().getId());
    }

    String scriptGetResourceName(IV8Script iV8Script) throws JavetException {
        return this.v8Native.scriptGetResourceName(this.handle, iV8Script.getHandle(), iV8Script.getType().getId());
    }

    <T extends V8Value> T scriptRun(IV8Script iV8Script, boolean resultRequired) throws JavetException {
        return (T)((V8Value)this.v8Native.scriptRun(this.handle, iV8Script.getHandle(), iV8Script.getType().getId(), resultRequired));
    }

    void setAdd(IV8ValueSet iV8ValueSet, V8Value key) throws JavetException {
        this.v8Native.setAdd(this.handle, iV8ValueSet.getHandle(), iV8ValueSet.getType().getId(), key);
    }

    V8ValueArray setAsArray(IV8ValueSet iV8ValueSet) throws JavetException {
        return (V8ValueArray)this.v8Native.setAsArray(this.handle, iV8ValueSet.getHandle(), iV8ValueSet.getType().getId());
    }

    void setClear(IV8ValueSet iV8ValueSet) {
        this.v8Native.setClear(this.handle, iV8ValueSet.getHandle(), iV8ValueSet.getType().getId());
    }

    public void setConverter(IJavetConverter converter) {
        Objects.requireNonNull(converter);
        this.converter = converter;
    }

    boolean setDelete(IV8ValueSet iV8ValueSet, V8Value key) throws JavetException {
        return this.v8Native.setDelete(this.handle, iV8ValueSet.getHandle(), iV8ValueSet.getType().getId(), key);
    }

    public void setGCScheduled(boolean gcScheduled) {
        this.gcScheduled = gcScheduled;
    }

    int setGetSize(IV8ValueSet iV8ValueSet) throws JavetException {
        return this.v8Native.setGetSize(this.handle, iV8ValueSet.getHandle(), iV8ValueSet.getType().getId());
    }

    boolean setHas(IV8ValueSet iV8ValueSet, V8Value key) throws JavetException {
        return this.v8Native.setHas(this.handle, iV8ValueSet.getHandle(), iV8ValueSet.getType().getId(), key);
    }

    public void setLogger(IJavetLogger logger) {
        this.logger = logger;
    }

    public void setPromiseRejectCallback(IJavetPromiseRejectCallback promiseRejectCallback) {
        Objects.requireNonNull(promiseRejectCallback);
        this.promiseRejectCallback = promiseRejectCallback;
    }

    public void setV8ModuleResolver(IV8ModuleResolver v8ModuleResolver) {
        this.v8ModuleResolver = v8ModuleResolver;
    }

    void setWeak(IV8ValueReference iV8ValueReference) {
        this.v8Native.setWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId(), iV8ValueReference);
    }

    boolean strictEquals(IV8ValueObject iV8ValueObject1, IV8ValueObject iV8ValueObject2) {
        return this.v8Native.strictEquals(this.handle, iV8ValueObject1.getHandle(), iV8ValueObject2.getHandle());
    }

    V8ValueString stringObjectValueOf(V8ValueStringObject v8ValueStringObject) {
        return (V8ValueString)this.v8Native.stringObjectValueOf(this.handle, Objects.requireNonNull(v8ValueStringObject).getHandle(), v8ValueStringObject.getType().getId());
    }

    String symbolDescription(V8ValueSymbol v8ValueSymbol) {
        return this.v8Native.symbolDescription(this.handle, Objects.requireNonNull(v8ValueSymbol).getHandle(), v8ValueSymbol.getType().getId());
    }

    V8ValueSymbol symbolObjectValueOf(V8ValueSymbolObject v8ValueSymbolObject) {
        return (V8ValueSymbol)this.v8Native.symbolObjectValueOf(this.handle, Objects.requireNonNull(v8ValueSymbolObject).getHandle(), v8ValueSymbolObject.getType().getId());
    }

    V8ValueSymbolObject symbolToObject(V8ValueSymbol v8ValueSymbol) {
        return (V8ValueSymbolObject)this.v8Native.symbolToObject(this.handle, Objects.requireNonNull(v8ValueSymbol).getHandle(), v8ValueSymbol.getType().getId());
    }

    public void terminateExecution() {
        this.v8Native.terminateExecution(this.handle);
    }

    public boolean throwError(V8ValueErrorType v8ValueErrorType, String message) {
        return this.v8Native.throwError(this.handle, Objects.requireNonNull(v8ValueErrorType).getId(), Objects.requireNonNull(message));
    }

    public boolean throwError(Object errorObject) throws JavetException {
        try (V8VirtualValue v8VirtualValue = new V8VirtualValue(this, this.getConverter(), Objects.requireNonNull(errorObject));){
            boolean bl = this.throwError((V8Value)v8VirtualValue.get());
            return bl;
        }
    }

    public boolean throwError(V8Value errorV8Value) {
        assert (!(errorV8Value instanceof V8Context)) : "Value cannot be a V8 context.";
        assert (!(errorV8Value instanceof V8Module)) : "Value cannot be a V8 module.";
        assert (!(errorV8Value instanceof V8Script)) : "Value cannot be a V8 script.";
        return this.v8Native.throwError(this.handle, Objects.requireNonNull(errorV8Value));
    }

    @Override
    public <T, V extends V8Value> T toObject(V v8Value) throws JavetException {
        return this.converter.toObject(v8Value);
    }

    String toString(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.toString(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    @Override
    public <T, V extends V8Value> V toV8Value(T object) throws JavetException {
        return (V)this.converter.toV8Value(this, object);
    }
}

