/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import java.lang.reflect.Array;
import java.util.Objects;

public final class ArrayUtils {
    public static Object[] copyOf(Object object) {
        int length = Array.getLength(object);
        Object[] objects = new Object[length];
        for (int i2 = 0; i2 < length; ++i2) {
            objects[i2] = Array.get(object, i2);
        }
        return objects;
    }

    public static <T> boolean includes(Object object, T element, int fromIndex) {
        int length = Array.getLength(object);
        for (int index = fromIndex; index < length; ++index) {
            if (!Objects.equals(Array.get(object, index), element)) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(Object object, T element, int fromIndex) {
        int length = Array.getLength(object);
        for (int index = fromIndex; index < length; ++index) {
            if (!Objects.equals(Array.get(object, index), element)) continue;
            return index;
        }
        return -1;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(byte[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(long[] array) {
        return array != null && array.length > 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return array != null && array.length > 0;
    }

    public static <T> int lastIndexOf(Object object, T element, int fromIndex) {
        int length = Array.getLength(object);
        if (fromIndex >= 0 && fromIndex < length) {
            for (int i2 = fromIndex; i2 >= 0; --i2) {
                if (!Objects.equals(Array.get(object, i2), element)) continue;
                return i2;
            }
        }
        return -1;
    }

    public static void reverse(Object object) {
        int length = Array.getLength(object);
        if (length > 1) {
            int leftIndex = 0;
            for (int rightIndex = length - 1; leftIndex < rightIndex; ++leftIndex, --rightIndex) {
                Object temp = Array.get(object, leftIndex);
                Array.set(object, leftIndex, Array.get(object, rightIndex));
                Array.set(object, rightIndex, temp);
            }
        }
    }
}

