/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X2) {
        int m = X2.length;
        if (m <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X2);
        double s2 = 0.0;
        for (int i2 = 0; i2 < m; ++i2) {
            s2 += ((double)X2[i2] - xbar) * ((double)X2[i2] - xbar);
        }
        return Math.sqrt(s2 /= (double)(m - 1));
    }

    public static double avg(int[] X2) {
        double xbar = 0.0;
        int m = X2.length;
        if (m == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            xbar += (double)X2[i2];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m;
        }
        return 0.0;
    }

    public static int min(int[] X2) {
        int min = Integer.MAX_VALUE;
        int m = X2.length;
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X2[i2] >= min) continue;
            min = X2[i2];
        }
        return min;
    }

    public static int max(int[] X2) {
        int max = Integer.MIN_VALUE;
        int m = X2.length;
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X2[i2] <= max) continue;
            max = X2[i2];
        }
        return max;
    }

    public static double avg(List<Integer> X2) {
        double xbar = 0.0;
        int m = X2.size();
        if (m == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            xbar += (double)X2.get(i2).intValue();
        }
        if (xbar >= 0.0) {
            return xbar / (double)m;
        }
        return 0.0;
    }

    public static int min(List<Integer> X2) {
        int min = Integer.MAX_VALUE;
        int m = X2.size();
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X2.get(i2) >= min) continue;
            min = X2.get(i2);
        }
        return min;
    }

    public static int max(List<Integer> X2) {
        int max = Integer.MIN_VALUE;
        int m = X2.size();
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X2.get(i2) <= max) continue;
            max = X2.get(i2);
        }
        return max;
    }

    public static int sum(int[] X2) {
        int s = 0;
        int m = X2.length;
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            s += X2[i2];
        }
        return s;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

