/*
 * Decompiled with CFR 0.152.
 */
package org.cts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.cts.CRSHelper;
import org.cts.Identifier;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.parser.prj.PrjParser;
import org.cts.parser.proj4.Proj4Parser;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;
import org.cts.registry.RegistryManager;

public class CRSFactory {
    private RegistryManager registryManager = new RegistryManager();
    protected final CRSCache<String, CoordinateReferenceSystem> CRSPOOL = new CRSCache(10);

    public CoordinateReferenceSystem getCRS(String authorityAndSrid) throws CRSException {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.CRSPOOL.get(authorityAndSrid.toUpperCase());
        if (crs == null) {
            try {
                Registry registry;
                String[] registryNameWithCode = this.splitRegistryNameAndCode(authorityAndSrid);
                String authority = registryNameWithCode[0];
                String code = registryNameWithCode[1];
                if (this.isRegistrySupported(authority) && (crs = (registry = this.getRegistryManager().getRegistry(authority)).getCoordinateReferenceSystem(new Identifier(authority, code, ""))) != null) {
                    this.CRSPOOL.put(authorityAndSrid.toUpperCase(), crs);
                }
            }
            catch (RegistryException ex) {
                throw new CRSException("Cannot create the CRS", ex);
            }
        }
        return crs;
    }

    public String[] splitRegistryNameAndCode(String authorityAndSrid) throws RegistryException {
        String[] registryAndCode = authorityAndSrid.split(":");
        if (registryAndCode.length == 2) {
            return registryAndCode;
        }
        throw new RegistryException("The registry pattern '" + authorityAndSrid + "' is not supported");
    }

    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    public boolean isRegistrySupported(String registryName) throws RegistryException {
        if (this.getRegistryManager().contains(registryName.toLowerCase())) {
            return true;
        }
        throw new RegistryException("Registry '" + registryName + "' is not supported");
    }

    public CoordinateReferenceSystem createFromPrj(String prjString) throws CRSException {
        PrjParser p = new PrjParser();
        Map<String, String> prjParameters = p.getParameters(prjString);
        String name = prjParameters.remove("name");
        String refname = prjParameters.remove("refname");
        if (refname != null) {
            String[] authorityNameWithKey = refname.split(":");
            return CRSHelper.createCoordinateReferenceSystem(new Identifier(authorityNameWithKey[0], authorityNameWithKey[1], name), prjParameters);
        }
        return CRSHelper.createCoordinateReferenceSystem(new Identifier(CoordinateReferenceSystem.class, name), prjParameters);
    }

    public CoordinateReferenceSystem createFromPrj(InputStream stream, Charset encoding) throws IOException, CRSException {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, encoding));
        StringBuilder b = new StringBuilder();
        while (r.ready()) {
            b.append(r.readLine());
        }
        return this.createFromPrj(b.toString());
    }

    public CoordinateReferenceSystem createFromPrj(InputStream stream) throws IOException, CRSException {
        return this.createFromPrj(stream, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createFromPrj(File file) throws IOException, CRSException {
        CoordinateReferenceSystem crs;
        try (FileInputStream i2 = null;){
            i2 = new FileInputStream(file);
            crs = this.createFromPrj(i2);
        }
        return crs;
    }

    public Set<String> getSupportedCodes(String registryName) throws RegistryException {
        return this.getRegistryManager().getRegistry(registryName).getSupportedCodes();
    }

    public CoordinateReferenceSystem createFromPrj4(String prj4String) throws CRSException {
        Map<String, String> prjParameters = Proj4Parser.readParameters(prj4String);
        String zone = prjParameters.get("zone");
        String crsName = zone != null ? (prjParameters.get("south") == null ? String.format("UTM %s %s", zone, "NORTH") : String.format("UTM %s %s", zone, "SOUTH")) : String.format("Unknown CRS %s", System.currentTimeMillis());
        return CRSHelper.createCoordinateReferenceSystem(new Identifier(CoordinateReferenceSystem.class, crsName), prjParameters);
    }

    public class CRSCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int limit;

        public CRSCache(int limit) {
            super(16, 0.75f, true);
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.limit;
        }
    }
}

