/*
 * Decompiled with CFR 0.152.
 */
package org.cts.cs;

import java.util.Arrays;
import org.cts.CoordinateDimensionException;
import org.cts.cs.Axis;
import org.cts.units.Unit;

public class CoordinateSystem {
    private Axis[] axes;
    private Unit[] units;

    public CoordinateSystem(Axis[] axes, Unit[] units) {
        this.axes = axes;
        this.units = units;
    }

    public Axis getAxis(int i2) throws ArrayIndexOutOfBoundsException {
        try {
            return this.axes[i2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Try to access Axis " + (i2 + 1) + " in a " + this.axes.length + "-d CoordinateSystem");
        }
    }

    public Unit getUnit(int i2) throws ArrayIndexOutOfBoundsException {
        try {
            return this.units[i2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Try to access unit of Axis " + (i2 + 1) + " in a " + this.axes.length + "-d CoordinateSystem");
        }
    }

    public int getDimension() {
        return this.axes.length;
    }

    public int getIndex(Axis axis) {
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            if (this.axes[i2] != axis) continue;
            return i2;
        }
        return -1;
    }

    public String format(double[] coord) throws CoordinateDimensionException {
        if (coord.length < this.axes.length) {
            throw new CoordinateDimensionException(coord, this.axes.length);
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            if (i2 > 0) {
                sb.append(" ");
            }
            sb.append(this.axes[i2]).append("=").append(coord[i2]);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            sb.append(i2 > 0 ? "|" : "").append(this.axes[i2].toString()).append(" (").append(this.units[i2].getSymbol()).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateSystem that = (CoordinateSystem)o;
        if (!Arrays.equals(this.axes, that.axes)) {
            return false;
        }
        return Arrays.equals(this.units, that.units);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.axes);
        result = 31 * result + Arrays.hashCode(this.units);
        return result;
    }
}

