/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import java.util.Arrays;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;

public class CoordinateRounding
extends AbstractCoordinateOperation {
    public static final CoordinateRounding MILLIMETER = CoordinateRounding.createCoordinateRoundingOperation(0.001);
    public static final CoordinateRounding CENTIMETER = CoordinateRounding.createCoordinateRoundingOperation(0.01);
    public static final CoordinateRounding DECIMETER = CoordinateRounding.createCoordinateRoundingOperation(0.1);
    public static final CoordinateRounding METER = CoordinateRounding.createCoordinateRoundingOperation(0.0);
    public static final CoordinateRounding KILOMETER = CoordinateRounding.createCoordinateRoundingOperation(1000.0);
    private double inv_resolution = 1.0;

    private CoordinateRounding(double resolution) {
        super(new Identifier(CoordinateRounding.class, "ordinates are multiple of " + resolution));
        this.inv_resolution = 1.0 / resolution;
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord == null || coord.length == 0) {
            throw new CoordinateDimensionException(Arrays.toString(coord) + " is an invalid coordinate");
        }
        for (int i2 = 0; i2 < coord.length; ++i2) {
            if (Double.isNaN(coord[i2])) continue;
            coord[i2] = Math.rint(coord[i2] * this.inv_resolution) / this.inv_resolution;
        }
        return coord;
    }

    public static CoordinateRounding createCoordinateRoundingOperationFromDecimalPlaces(int decimalPlaces) {
        double u = 1.0;
        for (int i2 = 0; i2 < decimalPlaces; ++i2) {
            u *= 10.0;
        }
        return new CoordinateRounding(1.0 / u);
    }

    public static CoordinateRounding createCoordinateRoundingOperation(double resolution) {
        return new CoordinateRounding(resolution);
    }
}

