/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

public class CylindricalEqualArea
extends Projection {
    public static final Identifier CEA = new Identifier("EPSG", "9835", "Cylindrical Equal Area (normal case)", "CEA");
    protected final double lat_ts;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double k0;

    public CylindricalEqualArea(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(CEA, ellipsoid, parameters);
        this.lat_ts = this.getLatitudeOfTrueScale();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        double e2 = ellipsoid.getSquareEccentricity();
        this.k0 = Math.cos(this.lat_ts) / Math.sqrt(1.0 - e2 * Math.sin(this.lat_ts) * Math.sin(this.lat_ts));
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.EQUAL_AREA;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.SECANT;
    }

    private double q(double lat) {
        double e = this.ellipsoid.getEccentricity();
        double esin = e * Math.sin(lat);
        return (1.0 - e * e) * (Math.sin(lat) / (1.0 - esin * esin) - Math.log((1.0 - esin) / (1.0 + esin)) / 2.0 / e);
    }

    @Override
    public double[] transform(double[] coord) {
        double lat = coord[0];
        double a = this.ellipsoid.getSemiMajorAxis();
        coord[0] = this.FE + a * this.k0 * (coord[1] - this.lon0);
        coord[1] = this.FN + a * this.q(lat) / 2.0 / this.k0;
        return coord;
    }

    @Override
    public Projection inverse() {
        return new CylindricalEqualArea(this.ellipsoid, this.parameters){

            @Override
            public double[] transform(double[] coord) {
                double a = this.ellipsoid.getSemiMajorAxis();
                double e = this.ellipsoid.getEccentricity();
                double X2 = coord[0];
                double Y = coord[1];
                double qp = CylindricalEqualArea.this.q(1.5707963267948966);
                double beta = Math.asin(2.0 * (Y - this.FN) * this.k0 / a / qp);
                double q = qp * Math.sin(beta);
                if (Math.abs(beta) == 1.5707963267948966) {
                    coord[0] = beta;
                } else {
                    int MAXITER = 10;
                    double lat = Math.asin(q / 2.0);
                    double latold = 1.0E30;
                    int iter = 0;
                    while (++iter < 10 && Math.abs(lat - latold) > 1.0E-15) {
                        latold = lat;
                        double esin = e * Math.sin(lat);
                        lat = latold + Math.pow(1.0 - esin * esin, 2.0) / 2.0 / Math.cos(latold) / (1.0 - e * e) * (q - CylindricalEqualArea.this.q(latold));
                    }
                    if (iter == 10) {
                        throw new ArithmeticException("The inverse Polyconic Projection method diverges. Last value of tolerance = " + Math.abs(lat - latold));
                    }
                    coord[0] = lat;
                }
                coord[1] = this.lon0 + (X2 - this.FE) / a / this.k0;
                return coord;
            }

            @Override
            public Projection inverse() {
                return CylindricalEqualArea.this;
            }

            @Override
            public boolean isDirect() {
                return false;
            }

            @Override
            public String toString() {
                return CylindricalEqualArea.this.toString() + " inverse";
            }
        };
    }
}

