/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import java.util.Arrays;
import java.util.List;
import org.cts.Identifier;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.transformation.GeocentricTransformation;

public class GeocentricTransformationSequence
extends CoordinateOperationSequence
implements GeocentricTransformation {
    public GeocentricTransformationSequence(Identifier identifier, CoordinateOperation ... sequence) {
        super(identifier, sequence);
    }

    public GeocentricTransformationSequence(Identifier identifier, List<CoordinateOperation> sequence) {
        super(identifier, sequence);
    }

    public GeocentricTransformationSequence(Identifier identifier, CoordinateOperation[] sequence, double precision) {
        super(identifier, sequence, precision);
    }

    @Override
    public GeocentricTransformation inverse() throws NonInvertibleOperationException {
        CoordinateOperation[] inverse_sequence = new CoordinateOperation[this.sequence.length];
        for (int i2 = 0; i2 < this.sequence.length; ++i2) {
            inverse_sequence[this.sequence.length - i2 - 1] = this.sequence[i2].inverse();
        }
        return new GeocentricTransformationSequence(this.getIdentifier(), inverse_sequence, this.precision);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GeocentricTransformationSequence && this.sequence.length == ((GeocentricTransformationSequence)o).sequence.length) {
            for (int i2 = 0; i2 < this.sequence.length; ++i2) {
                if (this.sequence[i2].equals(((GeocentricTransformationSequence)o).sequence[i2])) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isIdentity()) {
            return 0;
        }
        int hash = 5;
        hash = 19 * hash + Arrays.deepHashCode(this.sequence);
        return hash;
    }
}

