/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation.grid;

public class Util {
    public static int getIntLE(byte[] b, int i2) {
        return b[i2++] & 0xFF | b[i2++] << 8 & 0xFF00 | b[i2++] << 16 & 0xFF0000 | b[i2] << 24;
    }

    public static int getIntBE(byte[] b, int i2) {
        return b[i2++] << 24 | b[i2++] << 16 & 0xFF0000 | b[i2++] << 8 & 0xFF00 | b[i2] & 0xFF;
    }

    public static int getInt(byte[] b, boolean bigEndian) {
        if (bigEndian) {
            return Util.getIntBE(b, 0);
        }
        return Util.getIntLE(b, 0);
    }

    public static float getFloat(byte[] b, boolean bigEndian) {
        int i2 = bigEndian ? Util.getIntBE(b, 0) : Util.getIntLE(b, 0);
        return Float.intBitsToFloat(i2);
    }

    public static double getDouble(byte[] b, boolean bigEndian) {
        int j;
        int i2;
        if (bigEndian) {
            i2 = Util.getIntBE(b, 0);
            j = Util.getIntBE(b, 4);
        } else {
            i2 = Util.getIntLE(b, 4);
            j = Util.getIntLE(b, 0);
        }
        long l = (long)i2 << 32 | (long)(j & 0xFFFFFFFF);
        return Double.longBitsToDouble(l);
    }

    public static boolean isNioAvailable() {
        boolean nioAvailable = false;
        try {
            Class.forName("java.nio.channels.FileChannel");
            nioAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return nioAvailable;
    }
}

