/*
 * Decompiled with CFR 0.152.
 */
package org.cts.parser.prj;

import java.util.Locale;

public final class PrjWriter {
    private static final double[] currentRatios = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, Math.PI / 180, 57.29577951308232, Math.PI / 90, 114.59155902616465, 0.05235987755982988, 171.88733853924697, 0.06981317007977318, 229.1831180523293, 0.9, 1.1111111111111112, 0.3048, 3.280839895013123, 0.3048006096012192, 3.2808333333333333};

    @Deprecated
    public static String roundToString(double number, double tol) {
        StringBuilder w = new StringBuilder();
        if (PrjWriter.isInteger(number, tol)) {
            w.append(Math.round(number));
        } else {
            double res = 1.0 / tol;
            w.append(Math.rint(number * res) / res);
        }
        return w.toString();
    }

    public static String prettyRound(double number, double tol) {
        for (double f : currentRatios) {
            if (!(Math.abs(number * f - (double)Math.round(number * f)) < tol)) continue;
            if (f == 1.0 || f == 10.0) {
                return Integer.toString((int)((double)Math.round(number * f) / f));
            }
            return String.format(Locale.ENGLISH, "%.32f", (double)Math.round(number * f) / f).replaceAll("(.)0*$", "$1");
        }
        return String.format(Locale.ENGLISH, "%.32f", number).replaceAll("0*$", "");
    }

    private static boolean isInteger(double a, double tol) {
        return Math.abs(a - Math.rint(a)) < tol;
    }

    public static String formatWKT(String wkt) {
        StringBuilder w = new StringBuilder();
        int n = 0;
        boolean dontAddAlinea = false;
        String[] wktexp = wkt.split("]],");
        for (int i2 = 0; i2 < wktexp.length; ++i2) {
            int index = wktexp[i2].indexOf("[");
            String begin = wktexp[i2].substring(0, index + 1);
            w.append(begin);
            String end = wktexp[i2].substring(index + 1);
            int ind = end.indexOf(",");
            while (ind != -1) {
                begin = end.substring(0, ind + 1);
                index = end.indexOf("[");
                end = end.substring(ind + 1);
                if (dontAddAlinea) {
                    w.append("\n").append(PrjWriter.indent(n)).append(begin);
                } else if (ind < index || index == -1) {
                    w.append(begin);
                } else {
                    w.append("\n").append(PrjWriter.indent(++n)).append(begin);
                }
                dontAddAlinea = begin.substring(begin.length() - 2).equals("],");
                ind = end.indexOf(",");
            }
            n = PrjWriter.checkIndent(end, n);
            w.append(end);
            if (i2 == wktexp.length - 1) continue;
            w.append("]],\n").append(PrjWriter.indent(--n));
        }
        return w.toString();
    }

    private static String indent(int n) {
        StringBuilder w = new StringBuilder();
        for (int i2 = 0; i2 < n; ++i2) {
            w = w.append("    ");
        }
        return w.toString();
    }

    private static int checkIndent(String end, int n) {
        int k = end.length() - 1;
        while (end.substring(k, k + 1).equals("]")) {
            --n;
            --k;
        }
        return n;
    }

    private PrjWriter() {
    }
}

