/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;

public class CoordinateSequenceDimensionFilter
implements CoordinateSequenceFilter {
    private boolean isDone = false;
    private int largestDimSoFar = 0;
    public static final int XY = 2;
    public static final int XYZ = 3;
    public static final int XYZM = 4;
    private int maxDim = 4;
    private boolean exists2D = false;
    private boolean exists3D = false;

    @Override
    public void filter(CoordinateSequence seq, int i2) {
        int currentDim = 0;
        if (!seq.hasZ() || Double.isNaN(seq.getOrdinate(i2, 2))) {
            this.exists2D = true;
            currentDim = 2;
        } else {
            this.exists3D = true;
            currentDim = !seq.hasM() || Double.isNaN(seq.getOrdinate(i2, 3)) ? 3 : 4;
        }
        if (currentDim > this.largestDimSoFar) {
            this.largestDimSoFar = currentDim;
        }
        if (i2 == seq.size() || this.largestDimSoFar >= this.maxDim && this.isMixed()) {
            this.isDone = true;
        }
    }

    public static CoordinateSequenceDimensionFilter apply(Geometry geometry) {
        CoordinateSequenceDimensionFilter cd = new CoordinateSequenceDimensionFilter();
        geometry.apply(cd);
        return cd;
    }

    public int getDimension() {
        return this.largestDimSoFar;
    }

    public boolean isMixed() {
        return this.exists2D && this.exists3D;
    }

    public boolean is2D() {
        return !this.exists3D;
    }

    public void setMAXDim(int maxDim) {
        this.maxDim = maxDim;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isGeometryChanged() {
        return false;
    }
}

