/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.util.GeometricShapeFactory;

public class VisibilityAlgorithm {
    private static final double M_2PI = Math.PI * 2;
    private static final Coordinate NAN_COORDINATE = new Coordinate(Double.NaN, Double.NaN);
    private double maxDistance;
    private List<SegmentString> originalSegments = new ArrayList<SegmentString>();
    private double epsilon = 1.0E-6;
    private int numPoints = 32;

    public VisibilityAlgorithm(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    private static List<SegmentString> fixSegments(List<SegmentString> segments) {
        MCIndexNoder mCIndexNoder = new MCIndexNoder();
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        mCIndexNoder.setSegmentIntersector(new IntersectionAdder(robustLineIntersector));
        mCIndexNoder.computeNodes(segments);
        Collection nodedSubstring = mCIndexNoder.getNodedSubstrings();
        ArrayList<SegmentString> ret = new ArrayList<SegmentString>(nodedSubstring.size());
        for (Object aNodedSubstring : nodedSubstring) {
            ret.add((SegmentString)aNodedSubstring);
        }
        return ret;
    }

    public void fixSegments() {
        this.originalSegments = VisibilityAlgorithm.fixSegments(this.originalSegments);
    }

    private static void addSegment(List<SegmentString> segments, Coordinate p0, Coordinate p1) {
        segments.add(new NodedSegmentString(new Coordinate[]{p0, p1}, segments.size() + 1));
    }

    public void setNumPoints(int numPoints) {
        this.numPoints = numPoints;
    }

    public void addSegment(Coordinate p0, Coordinate p1) {
        if (p0.distance(p1) < this.epsilon) {
            return;
        }
        VisibilityAlgorithm.addSegment(this.originalSegments, p0, p1);
    }

    private static double angle(Coordinate a, Coordinate b) {
        return Math.atan2(b.y - a.y, b.x - a.x);
    }

    /*
     * WARNING - void declaration
     */
    public Polygon getIsoVist(Coordinate position, boolean addEnvelope) {
        void var6_12;
        List<SegmentString> bounded = new ArrayList<SegmentString>(this.originalSegments.size() + this.numPoints);
        Envelope env = new Envelope();
        for (SegmentString segmentString : this.originalSegments) {
            env.expandToInclude(segmentString.getCoordinate(0));
            env.expandToInclude(segmentString.getCoordinate(1));
        }
        if (addEnvelope) {
            env.expandToInclude(new Coordinate(position.x - this.maxDistance, position.y - this.maxDistance));
            env.expandToInclude(new Coordinate(position.x + this.maxDistance, position.y + position.x));
            GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory();
            geometricShapeFactory.setCentre(new Coordinate(position.x - env.getMinX(), position.y - env.getMinY()));
            geometricShapeFactory.setWidth(this.maxDistance * 2.0);
            geometricShapeFactory.setHeight(this.maxDistance * 2.0);
            geometricShapeFactory.setNumPoints(this.numPoints);
            VisibilityAlgorithm.addPolygon(bounded, geometricShapeFactory.createEllipse());
            for (SegmentString segment : this.originalSegments) {
                Coordinate a = segment.getCoordinate(0);
                Coordinate b = segment.getCoordinate(1);
                VisibilityAlgorithm.addSegment(bounded, new Coordinate(a.x - env.getMinX(), a.y - env.getMinY()), new Coordinate(b.x - env.getMinX(), b.y - env.getMinY()));
            }
            bounded = VisibilityAlgorithm.fixSegments(bounded);
        } else {
            for (SegmentString segmentString : this.originalSegments) {
                Coordinate a = segmentString.getCoordinate(0);
                Coordinate b = segmentString.getCoordinate(1);
                VisibilityAlgorithm.addSegment(bounded, new Coordinate(a.x - env.getMinX(), a.y - env.getMinY()), new Coordinate(b.x - env.getMinX(), b.y - env.getMinY()));
            }
        }
        position = new Coordinate(position.x - env.getMinX(), position.y - env.getMinY());
        ArrayList<Vertex> sorted = new ArrayList<Vertex>(bounded.size() * 2);
        boolean bl = false;
        while (var6_12 < bounded.size()) {
            SegmentString segment;
            segment = (SegmentString)bounded.get((int)var6_12);
            for (int j = 0; j < 2; ++j) {
                Coordinate pt = segment.getCoordinate(j);
                sorted.add(new Vertex((int)var6_12, j, VisibilityAlgorithm.angle(pt, position)));
            }
            ++var6_12;
        }
        Collections.sort(sorted);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(bounded.size());
        for (int i2 = 0; i2 < bounded.size(); ++i2) {
            arrayList.add(-1);
        }
        ArrayList<Integer> heap = new ArrayList<Integer>(bounded.size());
        Coordinate start = new Coordinate(position.x + 1.0, position.y);
        for (int i3 = 0; i3 < bounded.size(); ++i3) {
            SegmentString seg = (SegmentString)bounded.get(i3);
            double a1 = VisibilityAlgorithm.angle(seg.getCoordinate(0), position);
            double a2 = VisibilityAlgorithm.angle(seg.getCoordinate(1), position);
            boolean active = false;
            if (a1 > -Math.PI && a1 <= 0.0 && a2 <= Math.PI && a2 >= 0.0 && a2 - a1 > Math.PI) {
                active = true;
            }
            if (a2 > -Math.PI && a2 <= 0.0 && a1 <= Math.PI && a1 >= 0.0 && a1 - a2 > Math.PI) {
                active = true;
            }
            if (!active) continue;
            this.insert(i3, heap, position, bounded, start, arrayList);
        }
        ArrayList<Coordinate> polygon = new ArrayList<Coordinate>();
        int i4 = 0;
        while (i4 < sorted.size()) {
            boolean extend = false;
            boolean shorten = false;
            int orig = i4;
            Coordinate vertex = bounded.get(((Vertex)sorted.get((int)i4)).idSegment).getCoordinate(((Vertex)sorted.get((int)i4)).vertexIndex);
            int oldSegment = (Integer)heap.get(0);
            do {
                if ((Integer)arrayList.get(((Vertex)sorted.get((int)i4)).idSegment) != -1) {
                    if (((Vertex)sorted.get((int)i4)).idSegment == oldSegment) {
                        extend = true;
                        vertex = bounded.get(((Vertex)sorted.get((int)i4)).idSegment).getCoordinate(((Vertex)sorted.get((int)i4)).vertexIndex);
                    }
                    this.remove((Integer)arrayList.get(((Vertex)sorted.get((int)i4)).idSegment), heap, position, bounded, vertex, arrayList);
                    continue;
                }
                this.insert(((Vertex)sorted.get((int)i4)).idSegment, heap, position, bounded, vertex, arrayList);
                if ((Integer)heap.get(0) == oldSegment) continue;
                shorten = true;
            } while (++i4 != sorted.size() && ((Vertex)sorted.get((int)i4)).angle < ((Vertex)sorted.get((int)orig)).angle + this.epsilon);
            if (extend) {
                polygon.add(new Coordinate(vertex.x + env.getMinX(), vertex.y + env.getMinY()));
                Coordinate cur = VisibilityAlgorithm.intersectLines(bounded.get((Integer)heap.get(0)), position, vertex);
                if (cur == null || cur.equals2D(vertex, this.epsilon)) continue;
                polygon.add(new Coordinate(cur.x + env.getMinX(), cur.y + env.getMinY()));
                continue;
            }
            if (!shorten) continue;
            Coordinate i1 = VisibilityAlgorithm.intersectLines(bounded.get(oldSegment), position, vertex);
            Coordinate i2 = VisibilityAlgorithm.intersectLines(bounded.get((Integer)heap.get(0)), position, vertex);
            polygon.add(new Coordinate(i1.x + env.getMinX(), i1.y + env.getMinY()));
            polygon.add(new Coordinate(i2.x + env.getMinX(), i2.y + env.getMinY()));
        }
        polygon.add((Coordinate)polygon.get(0));
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPolygon(polygon.toArray(new Coordinate[0]));
    }

    private static Coordinate intersectLines(SegmentString a, Coordinate b1, Coordinate b2) {
        Coordinate a1 = a.getCoordinate(0);
        Coordinate a2 = a.getCoordinate(1);
        double dby = b2.y - b1.y;
        double dax = a2.x - a1.x;
        double dbx = b2.x - b1.x;
        double day = a2.y - a1.y;
        double u_b = dby * dax - dbx * day;
        if (u_b != 0.0) {
            double ua = (dbx * (a1.y - b1.y) - dby * (a1.x - b1.x)) / u_b;
            return new Coordinate(a1.x - ua * -dax, a1.y - ua * -day);
        }
        return NAN_COORDINATE;
    }

    private static int getChild(int index) {
        return 2 * index + 1;
    }

    private static int getParent(int index) {
        return (int)Math.floor((double)(index - 1) / 2.0);
    }

    private double angle2(Coordinate a, Coordinate b, Coordinate c) {
        double a2;
        double a1 = VisibilityAlgorithm.angle(a, b);
        double a3 = a1 - (a2 = VisibilityAlgorithm.angle(b, c));
        if (a3 < 0.0) {
            a3 += Math.PI * 2;
        }
        if (a3 > Math.PI * 2) {
            a3 -= Math.PI * 2;
        }
        return a3;
    }

    private boolean lessThan(int index1, int index2, Coordinate position, List<SegmentString> segments, Coordinate destination) {
        Coordinate inter2;
        Coordinate inter1 = VisibilityAlgorithm.intersectLines(segments.get(index1), position, destination);
        if (!inter1.equals2D(inter2 = VisibilityAlgorithm.intersectLines(segments.get(index2), position, destination), this.epsilon)) {
            double d2;
            double d1 = inter1.distance(position);
            return d1 < (d2 = inter2.distance(position));
        }
        int end1 = 0;
        if (inter1.equals2D(segments.get(index1).getCoordinate(0), this.epsilon)) {
            end1 = 1;
        }
        int end2 = 0;
        if (inter2.equals2D(segments.get(index2).getCoordinate(0), this.epsilon)) {
            end2 = 1;
        }
        double a1 = this.angle2(segments.get(index1).getCoordinate(end1), inter1, position);
        double a2 = this.angle2(segments.get(index2).getCoordinate(end2), inter2, position);
        if (a1 < Math.PI) {
            return a2 > Math.PI || a2 < a1;
        }
        return a1 < a2;
    }

    private void remove(int index, List<Integer> heap, Coordinate position, List<SegmentString> segments, Coordinate destination, List<Integer> map) {
        map.set(heap.get(index), -1);
        if (index == heap.size() - 1) {
            heap.remove(heap.size() - 1);
            return;
        }
        heap.set(index, heap.remove(heap.size() - 1));
        map.set(heap.get(index), index);
        int cur = index;
        if (cur != 0 && this.lessThan(heap.get(cur), heap.get(VisibilityAlgorithm.getParent(cur)), position, segments, destination)) {
            while (cur > 0) {
                int parent = VisibilityAlgorithm.getParent(cur);
                if (this.lessThan(heap.get(cur), heap.get(parent), position, segments, destination)) {
                    map.set(heap.get(parent), cur);
                    map.set(heap.get(cur), parent);
                    int temp = heap.get(cur);
                    heap.set(cur, heap.get(parent));
                    heap.set(parent, temp);
                    cur = parent;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                int temp;
                int left = VisibilityAlgorithm.getChild(cur);
                int right = left + 1;
                if (left < heap.size() && this.lessThan(heap.get(left), heap.get(cur), position, segments, destination) && (right == heap.size() || this.lessThan(heap.get(left), heap.get(right), position, segments, destination))) {
                    map.set(heap.get(left), cur);
                    map.set(heap.get(cur), left);
                    temp = heap.get(left);
                    heap.set(left, heap.get(cur));
                    heap.set(cur, temp);
                    cur = left;
                    continue;
                }
                if (right >= heap.size() || !this.lessThan(heap.get(right), heap.get(cur), position, segments, destination)) break;
                map.set(heap.get(right), cur);
                map.set(heap.get(cur), right);
                temp = heap.get(right);
                heap.set(right, heap.get(cur));
                heap.set(cur, temp);
                cur = right;
            }
        }
    }

    private void insert(int index, List<Integer> heap, Coordinate position, List<SegmentString> segments, Coordinate destination, List<Integer> map) {
        Coordinate inter = VisibilityAlgorithm.intersectLines(segments.get(index), position, destination);
        if (NAN_COORDINATE.equals2D(inter, this.epsilon)) {
            return;
        }
        int cur = heap.size();
        heap.add(index);
        map.set(index, cur);
        while (cur > 0) {
            int parent = VisibilityAlgorithm.getParent(cur);
            if (!this.lessThan(heap.get(cur), heap.get(parent), position, segments, destination)) break;
            map.set(heap.get(parent), cur);
            map.set(heap.get(cur), parent);
            int temp = heap.get(cur);
            heap.set(cur, heap.get(parent));
            heap.set(parent, temp);
            cur = parent;
        }
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void addLineString(LineString lineString) {
        VisibilityAlgorithm.addLineString(this.originalSegments, lineString);
    }

    private static void addLineString(List<SegmentString> segments, LineString lineString) {
        int nPoint = lineString.getNumPoints();
        for (int idPoint = 0; idPoint < nPoint - 1; ++idPoint) {
            VisibilityAlgorithm.addSegment(segments, lineString.getCoordinateN(idPoint), lineString.getCoordinateN(idPoint + 1));
        }
    }

    private static void addPolygon(List<SegmentString> segments, Polygon poly) {
        VisibilityAlgorithm.addLineString(segments, poly.getExteriorRing());
        int ringCount = poly.getNumInteriorRing();
        for (int nr = 0; nr < ringCount; ++nr) {
            VisibilityAlgorithm.addLineString(segments, poly.getInteriorRingN(nr));
        }
    }

    private static void addGeometry(List<SegmentString> segments, GeometryCollection geometry) {
        int geoCount = geometry.getNumGeometries();
        for (int n = 0; n < geoCount; ++n) {
            Geometry simpleGeom = geometry.getGeometryN(n);
            if (simpleGeom instanceof LineString) {
                VisibilityAlgorithm.addLineString(segments, (LineString)simpleGeom);
                continue;
            }
            if (simpleGeom instanceof Polygon) {
                VisibilityAlgorithm.addPolygon(segments, (Polygon)simpleGeom);
                continue;
            }
            if (!(simpleGeom instanceof GeometryCollection)) continue;
            VisibilityAlgorithm.addGeometry(segments, (GeometryCollection)simpleGeom);
        }
    }

    public void addGeometry(Geometry geometry) {
        if (geometry instanceof LineString) {
            VisibilityAlgorithm.addLineString(this.originalSegments, (LineString)geometry);
        } else if (geometry instanceof Polygon) {
            VisibilityAlgorithm.addPolygon(this.originalSegments, (Polygon)geometry);
        } else if (geometry instanceof GeometryCollection) {
            VisibilityAlgorithm.addGeometry(this.originalSegments, (GeometryCollection)geometry);
        }
    }

    private static final class Vertex
    implements Comparable<Vertex> {
        final int idSegment;
        final int vertexIndex;
        final double angle;

        public Vertex(int idSegment, int vertexIndex, double angle) {
            this.idSegment = idSegment;
            this.vertexIndex = vertexIndex;
            this.angle = angle;
        }

        @Override
        public int compareTo(Vertex o) {
            int res = Double.compare(this.angle, o.angle);
            if (res != 0) {
                return res;
            }
            res = Integer.compare(this.idSegment, o.idSegment);
            if (res != 0) {
                return res;
            }
            return Integer.compare(this.vertexIndex, o.vertexIndex);
        }
    }
}

