/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.trigger;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.Trigger;
import org.h2gis.utilities.TableLocation;

public class UpdateTrigger
implements Trigger {
    private int idTrigger;
    public static final String TRIGGER_SCHEMA = "H2GIS_SCHEMA";
    public static final String TRIGGER_TABLE = "UPDATE_TRIGGERS";
    public static final String NOTIFICATION_TABLE = "UPDATE_NOTIFICATIONS";

    @Override
    public void close() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        block11: {
            Statement st = conn.createStatement();
            TableLocation triggerTable = new TableLocation(TRIGGER_SCHEMA, TRIGGER_TABLE);
            TableLocation notificationTable = new TableLocation(TRIGGER_SCHEMA, NOTIFICATION_TABLE);
            try {
                st.execute("create schema if not exists H2GIS_SCHEMA");
                st.execute("create temporary table if not exists " + notificationTable + " ( id BIGINT PRIMARY KEY AUTO_INCREMENT, idtrigger int)");
                st.execute("create index if not exists triggerindex on " + notificationTable + "(idtrigger)");
                st.execute("create temporary table if not exists " + triggerTable + "(idtrigger int primary key auto_increment, trigger_name varchar unique, schema_name VARCHAR, table_name varchar)");
                PreparedStatement preparedStatement = conn.prepareStatement("select idtrigger, trigger_name from " + triggerTable + " where trigger_name = ?");
                preparedStatement.setString(1, triggerName);
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    if (rs.next()) {
                        this.idTrigger = rs.getInt(1);
                        break block11;
                    }
                    preparedStatement.close();
                    preparedStatement = conn.prepareStatement("insert into " + triggerTable + "(trigger_name, schema_name,table_name) VALUES (?,?,?)");
                    preparedStatement.setString(1, triggerName);
                    preparedStatement.setString(2, schemaName);
                    preparedStatement.setString(3, tableName);
                    preparedStatement.execute();
                    preparedStatement.close();
                    preparedStatement = conn.prepareStatement("select idtrigger, trigger_name from " + triggerTable + " where trigger_name = ?");
                    preparedStatement.setString(1, triggerName);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        if (resultSet.next()) {
                            this.idTrigger = resultSet.getInt(1);
                            break block11;
                        }
                        throw new SQLException("Cannot get inserted trigger id");
                    }
                }
                finally {
                    rs.close();
                    preparedStatement.close();
                }
            }
            finally {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        TableLocation notificationTable = new TableLocation(TRIGGER_SCHEMA, NOTIFICATION_TABLE);
        try {
            st.setInt(1, this.idTrigger);
            try (PreparedStatement st = conn.prepareStatement("INSERT INTO " + notificationTable + "(idtrigger) VALUES(?)");){
                st.execute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove() throws SQLException {
    }
}

