/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD.orientationIndex(p1, p2, q);
    }

    public static boolean isPointInRing(Coordinate p, Coordinate[] ring) {
        return CGAlgorithms.locatePointInRing(p, ring) != 2;
    }

    public static int locatePointInRing(Coordinate p, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p, ring);
    }

    public static boolean isOnLine(Coordinate p, Coordinate[] pt) {
        for (int i2 = 1; i2 < pt.length; ++i2) {
            Coordinate p0 = pt[i2 - 1];
            Coordinate p1 = pt[i2];
            if (!PointLocation.isOnSegment(p, p0, p1)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        for (int i2 = 1; i2 <= nPts; ++i2) {
            Coordinate p = ring[i2];
            if (!(p.y > hiPt.y)) continue;
            hiPt = p;
            hiIndex = i2;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = CGAlgorithms.computeOrientation(prev, hiPt, next);
        boolean isCCW = disc == 0 ? prev.x > next.x : disc > 0;
        return isCCW;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithms.orientationIndex(p1, p2, q);
    }

    public static double distancePointLine(Coordinate p, Coordinate A2, Coordinate B) {
        if (A2.x == B.x && A2.y == B.y) {
            return p.distance(A2);
        }
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y);
        double r = ((p.x - A2.x) * (B.x - A2.x) + (p.y - A2.y) * (B.y - A2.y)) / len2;
        if (r <= 0.0) {
            return p.distance(A2);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A2.y - p.y) * (B.x - A2.x) - (A2.x - p.x) * (B.y - A2.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double distancePointLinePerpendicular(Coordinate p, Coordinate A2, Coordinate B) {
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y);
        double s = ((A2.y - p.y) * (B.x - A2.x) - (A2.x - p.x) * (B.y - A2.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double distancePointLine(Coordinate p, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        for (int i2 = 0; i2 < line.length - 1; ++i2) {
            double dist = CGAlgorithms.distancePointLine(p, line[i2], line[i2 + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double distanceLineLine(Coordinate A2, Coordinate B, Coordinate C, Coordinate D) {
        if (A2.equals(B)) {
            return CGAlgorithms.distancePointLine(A2, C, D);
        }
        if (C.equals(D)) {
            return CGAlgorithms.distancePointLine(D, A2, B);
        }
        boolean noIntersection = false;
        if (!Envelope.intersects(A2, B, C, D)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A2.x) * (D.y - C.y) - (B.y - A2.y) * (D.x - C.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A2.y - C.y) * (D.x - C.x) - (A2.x - C.x) * (D.y - C.y);
                double s_num = (A2.y - C.y) * (B.x - A2.x) - (A2.x - C.x) * (B.y - A2.y);
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil.min(CGAlgorithms.distancePointLine(A2, C, D), CGAlgorithms.distancePointLine(B, C, D), CGAlgorithms.distancePointLine(C, A2, B), CGAlgorithms.distancePointLine(D, A2, B));
        }
        return 0.0;
    }

    public static double signedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        for (int i2 = 1; i2 < ring.length - 1; ++i2) {
            double x = ring[i2].x - x0;
            double y1 = ring[i2 + 1].y;
            double y2 = ring[i2 - 1].y;
            sum += x * (y2 - y1);
        }
        return sum / 2.0;
    }

    public static double signedArea(CoordinateSequence ring) {
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x;
        p2.x -= x0;
        double sum = 0.0;
        for (int i2 = 1; i2 < n - 1; ++i2) {
            p0.y = p1.y;
            p1.x = p2.x;
            p1.y = p2.y;
            ring.getCoordinate(i2 + 1, p2);
            p2.x -= x0;
            sum += p1.x * (p0.y - p2.y);
        }
        return sum / 2.0;
    }

    public static double length(CoordinateSequence pts) {
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p = new Coordinate();
        pts.getCoordinate(0, p);
        double x0 = p.x;
        double y0 = p.y;
        for (int i2 = 1; i2 < n; ++i2) {
            pts.getCoordinate(i2, p);
            double x1 = p.x;
            double y1 = p.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.hypot(dx, dy);
            x0 = x1;
            y0 = y1;
        }
        return len;
    }
}

