/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.Rectangle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class MinimumAreaRectangle {
    private final Geometry inputGeom;
    private final boolean isConvex;

    public static Geometry getMinimumRectangle(Geometry geom) {
        return new MinimumAreaRectangle(geom).getMinimumRectangle();
    }

    public MinimumAreaRectangle(Geometry inputGeom) {
        this(inputGeom, false);
    }

    public MinimumAreaRectangle(Geometry inputGeom, boolean isConvex) {
        this.inputGeom = inputGeom;
        this.isConvex = isConvex;
    }

    private Geometry getMinimumRectangle() {
        if (this.inputGeom.isEmpty()) {
            return this.inputGeom.getFactory().createPolygon();
        }
        if (this.isConvex) {
            return this.computeConvex(this.inputGeom);
        }
        Geometry convexGeom = new ConvexHull(this.inputGeom).getConvexHull();
        return this.computeConvex(convexGeom);
    }

    private Geometry computeConvex(Geometry convexGeom) {
        Coordinate[] convexHullPts = null;
        convexHullPts = convexGeom instanceof Polygon ? ((Polygon)convexGeom).getExteriorRing().getCoordinates() : convexGeom.getCoordinates();
        if (convexHullPts.length != 0) {
            if (convexHullPts.length == 1) {
                return this.inputGeom.getFactory().createPoint(convexHullPts[0].copy());
            }
            if (convexHullPts.length == 2 || convexHullPts.length == 3) {
                return MinimumAreaRectangle.computeMaximumLine(convexHullPts, this.inputGeom.getFactory());
            }
        }
        return this.computeConvexRing(convexHullPts);
    }

    private Polygon computeConvexRing(Coordinate[] ring) {
        double minRectangleArea = Double.MAX_VALUE;
        int minRectangleBaseIndex = -1;
        int minRectangleDiamIndex = -1;
        int minRectangleLeftIndex = -1;
        int minRectangleRightIndex = -1;
        int diameterIndex = 1;
        int leftSideIndex = 1;
        int rightSideIndex = -1;
        LineSegment segBase = new LineSegment();
        LineSegment segDiam = new LineSegment();
        for (int i2 = 0; i2 < ring.length - 1; ++i2) {
            Coordinate diamBasePt;
            segBase.p0 = ring[i2];
            segBase.p1 = ring[i2 + 1];
            diameterIndex = this.findFurthestVertex(ring, segBase, diameterIndex, 0);
            Coordinate diamPt = ring[diameterIndex];
            segDiam.p0 = diamBasePt = segBase.project(diamPt);
            segDiam.p1 = diamPt;
            leftSideIndex = this.findFurthestVertex(ring, segDiam, leftSideIndex, 1);
            if (i2 == 0) {
                rightSideIndex = diameterIndex;
            }
            rightSideIndex = this.findFurthestVertex(ring, segDiam, rightSideIndex, -1);
            double rectWidth = segDiam.distancePerpendicular(ring[leftSideIndex]) + segDiam.distancePerpendicular(ring[rightSideIndex]);
            double rectArea = segDiam.getLength() * rectWidth;
            if (!(rectArea < minRectangleArea)) continue;
            minRectangleArea = rectArea;
            minRectangleBaseIndex = i2;
            minRectangleDiamIndex = diameterIndex;
            minRectangleLeftIndex = leftSideIndex;
            minRectangleRightIndex = rightSideIndex;
        }
        return Rectangle.createFromSidePts(ring[minRectangleBaseIndex], ring[minRectangleBaseIndex + 1], ring[minRectangleDiamIndex], ring[minRectangleLeftIndex], ring[minRectangleRightIndex], this.inputGeom.getFactory());
    }

    private int findFurthestVertex(Coordinate[] pts, LineSegment baseSeg, int startIndex, int orient) {
        int maxIndex;
        double maxDistance;
        double nextDistance = maxDistance = MinimumAreaRectangle.orientedDistance(baseSeg, pts[startIndex], orient);
        int nextIndex = maxIndex = startIndex;
        while (this.isFurtherOrEqual(nextDistance, maxDistance, orient)) {
            maxDistance = nextDistance;
            maxIndex = nextIndex;
            if ((nextIndex = MinimumAreaRectangle.nextIndex(pts, maxIndex)) == startIndex) break;
            nextDistance = MinimumAreaRectangle.orientedDistance(baseSeg, pts[nextIndex], orient);
        }
        return maxIndex;
    }

    private boolean isFurtherOrEqual(double d1, double d2, int orient) {
        switch (orient) {
            case 0: {
                return Math.abs(d1) >= Math.abs(d2);
            }
            case 1: {
                return d1 >= d2;
            }
            case -1: {
                return d1 <= d2;
            }
        }
        throw new IllegalArgumentException("Invalid orientation index: " + orient);
    }

    private static double orientedDistance(LineSegment seg, Coordinate p, int orient) {
        double dist = seg.distancePerpendicularOriented(p);
        if (orient == 0) {
            return Math.abs(dist);
        }
        return dist;
    }

    private static int nextIndex(Coordinate[] ring, int index) {
        if (++index >= ring.length - 1) {
            index = 0;
        }
        return index;
    }

    private static LineString computeMaximumLine(Coordinate[] pts, GeometryFactory factory) {
        Coordinate ptMinX = null;
        Coordinate ptMaxX = null;
        Coordinate ptMinY = null;
        Coordinate ptMaxY = null;
        for (Coordinate p : pts) {
            if (ptMinX == null || p.getX() < ptMinX.getX()) {
                ptMinX = p;
            }
            if (ptMaxX == null || p.getX() > ptMaxX.getX()) {
                ptMaxX = p;
            }
            if (ptMinY == null || p.getY() < ptMinY.getY()) {
                ptMinY = p;
            }
            if (ptMaxY != null && !(p.getY() > ptMaxY.getY())) continue;
            ptMaxY = p;
        }
        Coordinate p0 = ptMinX;
        Coordinate p1 = ptMaxX;
        if (p0.getX() == p1.getX()) {
            p0 = ptMinY;
            p1 = ptMaxY;
        }
        return factory.createLineString(new Coordinate[]{p0.copy(), p1.copy()});
    }
}

