/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.hull;

import java.util.ArrayDeque;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.triangulate.tri.Tri;

class HullTri
extends Tri
implements Comparable<HullTri> {
    private double size = this.lengthOfLongestEdge();
    private boolean isMarked = false;

    public HullTri(Coordinate p0, Coordinate p1, Coordinate p2) {
        super(p0, p1, p2);
    }

    public double getSize() {
        return this.size;
    }

    public void setSizeToBoundary() {
        this.size = this.lengthOfBoundary();
    }

    public void setSizeToLongestEdge() {
        this.size = this.lengthOfLongestEdge();
    }

    public void setSizeToCircumradius() {
        this.size = Triangle.circumradius(this.p2, this.p1, this.p0);
    }

    public boolean isMarked() {
        return this.isMarked;
    }

    public void setMarked(boolean isMarked) {
        this.isMarked = isMarked;
    }

    public boolean isRemoved() {
        return !this.hasAdjacent();
    }

    public int boundaryIndex() {
        if (this.isBoundary(0)) {
            return 0;
        }
        if (this.isBoundary(1)) {
            return 1;
        }
        if (this.isBoundary(2)) {
            return 2;
        }
        return -1;
    }

    public int boundaryIndexCCW() {
        int index = this.boundaryIndex();
        if (index < 0) {
            return -1;
        }
        int prevIndex = HullTri.prev(index);
        if (this.isBoundary(prevIndex)) {
            return prevIndex;
        }
        return index;
    }

    public int boundaryIndexCW() {
        int index = this.boundaryIndex();
        if (index < 0) {
            return -1;
        }
        int nextIndex = HullTri.next(index);
        if (this.isBoundary(nextIndex)) {
            return nextIndex;
        }
        return index;
    }

    public boolean isConnecting() {
        int adj2Index = this.adjacent2VertexIndex();
        boolean isInterior = this.isInteriorVertex(adj2Index);
        return !isInterior;
    }

    public int adjacent2VertexIndex() {
        if (this.hasAdjacent(0) && this.hasAdjacent(1)) {
            return 1;
        }
        if (this.hasAdjacent(1) && this.hasAdjacent(2)) {
            return 2;
        }
        if (this.hasAdjacent(2) && this.hasAdjacent(0)) {
            return 0;
        }
        return -1;
    }

    public int isolatedVertexIndex(List<HullTri> triList) {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.degree(i2, triList) > 1) continue;
            return i2;
        }
        return -1;
    }

    public double lengthOfLongestEdge() {
        return Triangle.longestSideLength(this.p0, this.p1, this.p2);
    }

    double lengthOfBoundary() {
        double len = 0.0;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.hasAdjacent(i2)) continue;
            len += this.getCoordinate(i2).distance(this.getCoordinate(Tri.next(i2)));
        }
        return len;
    }

    @Override
    public int compareTo(HullTri o) {
        if (this.size == o.size) {
            return -Double.compare(this.getArea(), o.getArea());
        }
        return -Double.compare(this.size, o.size);
    }

    public boolean hasBoundaryTouch() {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!this.isBoundaryTouch(i2)) continue;
            return true;
        }
        return false;
    }

    private boolean isBoundaryTouch(int index) {
        if (this.isBoundary(index)) {
            return false;
        }
        if (this.isBoundary(HullTri.prev(index))) {
            return false;
        }
        return !this.isInteriorVertex(index);
    }

    public static HullTri findTri(List<HullTri> triList, Tri exceptTri) {
        for (HullTri tri : triList) {
            if (tri == exceptTri) continue;
            return tri;
        }
        return null;
    }

    public static boolean isAllMarked(List<HullTri> triList) {
        for (HullTri tri : triList) {
            if (tri.isMarked()) continue;
            return false;
        }
        return true;
    }

    public static void clearMarks(List<HullTri> triList) {
        for (HullTri tri : triList) {
            tri.setMarked(false);
        }
    }

    public static void markConnected(HullTri triStart, Tri exceptTri) {
        ArrayDeque<HullTri> queue = new ArrayDeque<HullTri>();
        queue.add(triStart);
        while (!queue.isEmpty()) {
            HullTri tri = (HullTri)queue.pop();
            tri.setMarked(true);
            for (int i2 = 0; i2 < 3; ++i2) {
                HullTri adj = (HullTri)tri.getAdjacent(i2);
                if (adj == exceptTri || adj == null || adj.isMarked()) continue;
                queue.add(adj);
            }
        }
    }

    public static boolean isConnected(List<HullTri> triList, HullTri removedTri) {
        if (triList.size() == 0) {
            return false;
        }
        HullTri.clearMarks(triList);
        HullTri triStart = HullTri.findTri(triList, removedTri);
        if (triStart == null) {
            return false;
        }
        HullTri.markConnected(triStart, removedTri);
        removedTri.setMarked(true);
        return HullTri.isAllMarked(triList);
    }
}

