/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.coverage;

import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;

class CoverageBoundarySegmentFinder
implements CoordinateSequenceFilter {
    private Set<LineSegment> boundarySegs;

    public static Set<LineSegment> findBoundarySegments(Geometry[] geoms) {
        HashSet<LineSegment> segs = new HashSet<LineSegment>();
        CoverageBoundarySegmentFinder finder = new CoverageBoundarySegmentFinder(segs);
        for (Geometry geom : geoms) {
            geom.apply(finder);
        }
        return segs;
    }

    public static boolean isBoundarySegment(Set<LineSegment> boundarySegs, CoordinateSequence seq, int i2) {
        LineSegment seg = CoverageBoundarySegmentFinder.createSegment(seq, i2);
        return boundarySegs.contains(seg);
    }

    public CoverageBoundarySegmentFinder(Set<LineSegment> segs) {
        this.boundarySegs = segs;
    }

    @Override
    public void filter(CoordinateSequence seq, int i2) {
        if (i2 >= seq.size() - 1) {
            return;
        }
        LineSegment seg = CoverageBoundarySegmentFinder.createSegment(seq, i2);
        if (this.boundarySegs.contains(seg)) {
            this.boundarySegs.remove(seg);
        } else {
            this.boundarySegs.add(seg);
        }
    }

    private static LineSegment createSegment(CoordinateSequence seq, int i2) {
        LineSegment seg = new LineSegment(seq.getCoordinate(i2), seq.getCoordinate(i2 + 1));
        seg.normalize();
        return seg;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isGeometryChanged() {
        return false;
    }
}

