/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainBuilder;
import org.locationtech.jts.index.chain.MonotoneChainOverlapAction;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentString;

public class MCIndexSegmentSetMutualIntersector
implements SegmentSetMutualIntersector {
    private STRtree index = new STRtree();
    private double overlapTolerance = 0.0;
    private Envelope envelope = null;

    public MCIndexSegmentSetMutualIntersector(Collection baseSegStrings) {
        this.initBaseSegments(baseSegStrings);
    }

    public MCIndexSegmentSetMutualIntersector(Collection baseSegStrings, Envelope env) {
        this.envelope = env;
        this.initBaseSegments(baseSegStrings);
    }

    public MCIndexSegmentSetMutualIntersector(Collection baseSegStrings, double overlapTolerance) {
        this.initBaseSegments(baseSegStrings);
        this.overlapTolerance = overlapTolerance;
    }

    public SpatialIndex getIndex() {
        return this.index;
    }

    private void initBaseSegments(Collection<SegmentString> segStrings) {
        for (SegmentString ss : segStrings) {
            if (ss.size() == 0) continue;
            this.addToIndex(ss);
        }
        this.index.build();
    }

    private void addToIndex(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            if (this.envelope != null && !this.envelope.intersects(mc.getEnvelope())) continue;
            this.index.insert(mc.getEnvelope(this.overlapTolerance), (Object)mc);
        }
    }

    @Override
    public void process(Collection segStrings, SegmentIntersector segInt) {
        ArrayList monoChains = new ArrayList();
        Iterator i2 = segStrings.iterator();
        while (i2.hasNext()) {
            this.addToMonoChains((SegmentString)i2.next(), monoChains);
        }
        this.intersectChains(monoChains, segInt);
    }

    private void addToMonoChains(SegmentString segStr, List monoChains) {
        if (segStr.size() == 0) {
            return;
        }
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            if (this.envelope != null && !this.envelope.intersects(mc.getEnvelope())) continue;
            monoChains.add(mc);
        }
    }

    private void intersectChains(List monoChains, SegmentIntersector segInt) {
        SegmentOverlapAction overlapAction = new SegmentOverlapAction(segInt);
        for (MonotoneChain queryChain : monoChains) {
            Envelope queryEnv = queryChain.getEnvelope(this.overlapTolerance);
            List overlapChains = this.index.query(queryEnv);
            for (MonotoneChain testChain : overlapChains) {
                queryChain.computeOverlaps(testChain, this.overlapTolerance, overlapAction);
                if (!segInt.isDone()) continue;
                return;
            }
        }
    }

    public static class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        private SegmentIntersector si = null;

        public SegmentOverlapAction(SegmentIntersector si) {
            this.si = si;
        }

        @Override
        public void overlap(MonotoneChain mc1, int start1, MonotoneChain mc2, int start2) {
            SegmentString ss1 = (SegmentString)mc1.getContext();
            SegmentString ss2 = (SegmentString)mc2.getContext();
            this.si.processIntersections(ss1, start1, ss2, start2);
        }
    }
}

