/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import org.locationtech.jts.operation.buffer.OffsetCurveSection;
import org.locationtech.jts.operation.buffer.SegmentMCIndex;
import org.locationtech.jts.util.Assert;

public class OffsetCurve {
    private static final int MATCH_DISTANCE_FACTOR = 10000;
    private static final int MIN_QUADRANT_SEGMENTS = 8;
    private Geometry inputGeom;
    private double distance;
    private boolean isJoined = false;
    private BufferParameters bufferParams;
    private double matchDistance;
    private GeometryFactory geomFactory;
    private static final double NOT_IN_CURVE = -1.0;

    public static Geometry getCurve(Geometry geom, double distance) {
        OffsetCurve oc = new OffsetCurve(geom, distance);
        return oc.getCurve();
    }

    public static Geometry getCurve(Geometry geom, double distance, int quadSegs, int joinStyle, double mitreLimit) {
        BufferParameters bufferParams = new BufferParameters();
        if (quadSegs >= 0) {
            bufferParams.setQuadrantSegments(quadSegs);
        }
        if (joinStyle >= 0) {
            bufferParams.setJoinStyle(joinStyle);
        }
        if (mitreLimit >= 0.0) {
            bufferParams.setMitreLimit(mitreLimit);
        }
        OffsetCurve oc = new OffsetCurve(geom, distance, bufferParams);
        return oc.getCurve();
    }

    public static Geometry getCurveJoined(Geometry geom, double distance) {
        OffsetCurve oc = new OffsetCurve(geom, distance);
        oc.setJoined(true);
        return oc.getCurve();
    }

    public OffsetCurve(Geometry geom, double distance) {
        this(geom, distance, null);
    }

    public OffsetCurve(Geometry geom, double distance, BufferParameters bufParams) {
        this.inputGeom = geom;
        this.distance = distance;
        this.matchDistance = Math.abs(distance) / 10000.0;
        this.geomFactory = this.inputGeom.getFactory();
        this.bufferParams = new BufferParameters();
        if (bufParams != null) {
            int quadSegs = bufParams.getQuadrantSegments();
            if (quadSegs < 8) {
                quadSegs = 8;
            }
            this.bufferParams.setQuadrantSegments(quadSegs);
            this.bufferParams.setJoinStyle(bufParams.getJoinStyle());
            this.bufferParams.setMitreLimit(bufParams.getMitreLimit());
        }
    }

    public void setJoined(boolean isJoined) {
        this.isJoined = isJoined;
    }

    public Geometry getCurve() {
        return GeometryMapper.flatMap(this.inputGeom, 1, new GeometryMapper.MapOp(){

            @Override
            public Geometry map(Geometry geom) {
                if (geom instanceof Point) {
                    return null;
                }
                if (geom instanceof Polygon) {
                    return this.toLineString(geom.buffer(OffsetCurve.this.distance).getBoundary());
                }
                return OffsetCurve.this.computeCurve((LineString)geom, OffsetCurve.this.distance);
            }

            private Geometry toLineString(Geometry geom) {
                if (geom instanceof LinearRing) {
                    LinearRing ring = (LinearRing)geom;
                    return geom.getFactory().createLineString(ring.getCoordinateSequence());
                }
                return geom;
            }
        });
    }

    public static Coordinate[] rawOffset(LineString line, double distance, BufferParameters bufParams) {
        Coordinate[] pts = line.getCoordinates();
        Coordinate[] cleanPts = CoordinateArrays.removeRepeatedOrInvalidPoints(pts);
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(line.getFactory().getPrecisionModel(), bufParams);
        Coordinate[] rawPts = ocb.getOffsetCurve(cleanPts, distance);
        return rawPts;
    }

    public static Coordinate[] rawOffset(LineString line, double distance) {
        return OffsetCurve.rawOffset(line, distance, new BufferParameters());
    }

    private Geometry computeCurve(LineString lineGeom, double distance) {
        if (lineGeom.getNumPoints() < 2 || lineGeom.getLength() == 0.0) {
            return this.geomFactory.createLineString();
        }
        if (distance == 0.0) {
            return lineGeom.copy();
        }
        if (lineGeom.getNumPoints() == 2) {
            return this.offsetSegment(lineGeom.getCoordinates(), distance);
        }
        List<OffsetCurveSection> sections = this.computeSections(lineGeom, distance);
        Geometry offsetCurve = this.isJoined ? OffsetCurveSection.toLine(sections, this.geomFactory) : OffsetCurveSection.toGeometry(sections, this.geomFactory);
        return offsetCurve;
    }

    private List<OffsetCurveSection> computeSections(LineString lineGeom, double distance) {
        Coordinate[] rawCurve = OffsetCurve.rawOffset(lineGeom, distance, this.bufferParams);
        ArrayList<OffsetCurveSection> sections = new ArrayList<OffsetCurveSection>();
        if (rawCurve.length == 0) {
            return sections;
        }
        Polygon bufferPoly = OffsetCurve.getBufferOriented(lineGeom, distance, this.bufferParams);
        Coordinate[] shell = bufferPoly.getExteriorRing().getCoordinates();
        this.computeCurveSections(shell, rawCurve, sections);
        for (int i2 = 0; i2 < bufferPoly.getNumInteriorRing(); ++i2) {
            Coordinate[] hole = bufferPoly.getInteriorRingN(i2).getCoordinates();
            this.computeCurveSections(hole, rawCurve, sections);
        }
        return sections;
    }

    private LineString offsetSegment(Coordinate[] pts, double distance) {
        LineSegment offsetSeg = new LineSegment(pts[0], pts[1]).offset(distance);
        return this.geomFactory.createLineString(new Coordinate[]{offsetSeg.p0, offsetSeg.p1});
    }

    private static Polygon getBufferOriented(LineString geom, double distance, BufferParameters bufParams) {
        Geometry buffer = BufferOp.bufferOp((Geometry)geom, Math.abs(distance), bufParams);
        Polygon bufferPoly = OffsetCurve.extractMaxAreaPolygon(buffer);
        if (distance < 0.0) {
            bufferPoly = bufferPoly.reverse();
        }
        return bufferPoly;
    }

    private static Polygon extractMaxAreaPolygon(Geometry geom) {
        if (geom.getNumGeometries() == 1) {
            return (Polygon)geom;
        }
        double maxArea = 0.0;
        Polygon maxPoly = null;
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Polygon poly = (Polygon)geom.getGeometryN(i2);
            double area = poly.getArea();
            if (maxPoly != null && !(area > maxArea)) continue;
            maxPoly = poly;
            maxArea = area;
        }
        return maxPoly;
    }

    private void computeCurveSections(Coordinate[] bufferRingPts, Coordinate[] rawCurve, List<OffsetCurveSection> sections) {
        double[] rawPosition = new double[bufferRingPts.length - 1];
        for (int i2 = 0; i2 < rawPosition.length; ++i2) {
            rawPosition[i2] = -1.0;
        }
        SegmentMCIndex bufferSegIndex = new SegmentMCIndex(bufferRingPts);
        int bufferFirstIndex = -1;
        double minRawPosition = -1.0;
        for (int i3 = 0; i3 < rawCurve.length - 1; ++i3) {
            int minBufferIndexForSeg = this.matchSegments(rawCurve[i3], rawCurve[i3 + 1], i3, bufferSegIndex, bufferRingPts, rawPosition);
            if (minBufferIndexForSeg < 0) continue;
            double pos = rawPosition[minBufferIndexForSeg];
            if (bufferFirstIndex >= 0 && !(pos < minRawPosition)) continue;
            minRawPosition = pos;
            bufferFirstIndex = minBufferIndexForSeg;
        }
        if (bufferFirstIndex < 0) {
            return;
        }
        this.extractSections(bufferRingPts, rawPosition, bufferFirstIndex, sections);
    }

    private int matchSegments(Coordinate raw0, Coordinate raw1, int rawCurveIndex, SegmentMCIndex bufferSegIndex, Coordinate[] bufferPts, double[] rawCurvePos) {
        Envelope matchEnv = new Envelope(raw0, raw1);
        matchEnv.expandBy(this.matchDistance);
        MatchCurveSegmentAction matchAction = new MatchCurveSegmentAction(raw0, raw1, rawCurveIndex, this.matchDistance, bufferPts, rawCurvePos);
        bufferSegIndex.query(matchEnv, matchAction);
        return matchAction.getBufferMinIndex();
    }

    private void extractSections(Coordinate[] ringPts, double[] rawCurveLoc, int startIndex, List<OffsetCurveSection> sections) {
        int sectionEnd;
        int sectionStart = startIndex;
        int sectionCount = 0;
        do {
            sectionEnd = this.findSectionEnd(rawCurveLoc, sectionStart, startIndex);
            double location = rawCurveLoc[sectionStart];
            int lastIndex = OffsetCurve.prev(sectionEnd, rawCurveLoc.length);
            double lastLoc = rawCurveLoc[lastIndex];
            OffsetCurveSection section = OffsetCurveSection.create(ringPts, sectionStart, sectionEnd, location, lastLoc);
            sections.add(section);
            sectionStart = this.findSectionStart(rawCurveLoc, sectionEnd);
            if (sectionCount++ <= ringPts.length) continue;
            Assert.shouldNeverReachHere("Too many sections for ring - probable bug");
        } while (sectionStart != startIndex && sectionEnd != startIndex);
    }

    private int findSectionStart(double[] loc, int end) {
        int start = end;
        do {
            double locDelta;
            int next = OffsetCurve.next(start, loc.length);
            if (loc[start] == -1.0) {
                start = next;
                continue;
            }
            int prev = OffsetCurve.prev(start, loc.length);
            if (loc[prev] == -1.0) {
                return start;
            }
            if (this.isJoined && (locDelta = Math.abs(loc[start] - loc[prev])) > 1.0) {
                return start;
            }
            start = next;
        } while (start != end);
        return start;
    }

    private int findSectionEnd(double[] loc, int start, int firstStartIndex) {
        int next;
        int end = start;
        do {
            double locDelta;
            if (loc[next = OffsetCurve.next(end, loc.length)] == -1.0) {
                return next;
            }
            if (!this.isJoined || !((locDelta = Math.abs(loc[next] - loc[end])) > 1.0)) continue;
            return next;
        } while ((end = next) != start && end != firstStartIndex);
        return end;
    }

    private static int next(int i2, int size) {
        return ++i2 < size ? i2 : 0;
    }

    private static int prev(int i2, int size) {
        return --i2 < 0 ? size - 1 : i2;
    }

    private static class MatchCurveSegmentAction
    extends MonotoneChainSelectAction {
        private Coordinate raw0;
        private Coordinate raw1;
        private double rawLen;
        private int rawCurveIndex;
        private Coordinate[] bufferRingPts;
        private double matchDistance;
        private double[] rawCurveLoc;
        private double minRawLocation = -1.0;
        private int bufferRingMinIndex = -1;

        public MatchCurveSegmentAction(Coordinate raw0, Coordinate raw1, int rawCurveIndex, double matchDistance, Coordinate[] bufferRingPts, double[] rawCurveLoc) {
            this.raw0 = raw0;
            this.raw1 = raw1;
            this.rawLen = raw0.distance(raw1);
            this.rawCurveIndex = rawCurveIndex;
            this.bufferRingPts = bufferRingPts;
            this.matchDistance = matchDistance;
            this.rawCurveLoc = rawCurveLoc;
        }

        public int getBufferMinIndex() {
            return this.bufferRingMinIndex;
        }

        @Override
        public void select(MonotoneChain mc, int segIndex) {
            double location;
            double frac = this.segmentMatchFrac(this.bufferRingPts[segIndex], this.bufferRingPts[segIndex + 1], this.raw0, this.raw1, this.matchDistance);
            if (frac < 0.0) {
                return;
            }
            this.rawCurveLoc[segIndex] = location = (double)this.rawCurveIndex + frac;
            if (this.minRawLocation < 0.0 || location < this.minRawLocation) {
                this.minRawLocation = location;
                this.bufferRingMinIndex = segIndex;
            }
        }

        private double segmentMatchFrac(Coordinate buf0, Coordinate buf1, Coordinate raw0, Coordinate raw1, double matchDistance) {
            if (!this.isMatch(buf0, buf1, raw0, raw1, matchDistance)) {
                return -1.0;
            }
            LineSegment seg = new LineSegment(raw0, raw1);
            return seg.segmentFraction(buf0);
        }

        private boolean isMatch(Coordinate buf0, Coordinate buf1, Coordinate raw0, Coordinate raw1, double matchDistance) {
            double bufSegLen = buf0.distance(buf1);
            if (this.rawLen <= bufSegLen) {
                if (matchDistance < Distance.pointToSegment(raw0, buf0, buf1)) {
                    return false;
                }
                if (matchDistance < Distance.pointToSegment(raw1, buf0, buf1)) {
                    return false;
                }
            } else {
                if (matchDistance < Distance.pointToSegment(buf0, raw0, raw1)) {
                    return false;
                }
                if (matchDistance < Distance.pointToSegment(buf1, raw0, raw1)) {
                    return false;
                }
            }
            return true;
        }
    }
}

