/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.operation.relateng.IMPredicate;

class IMPatternMatcher
extends IMPredicate {
    private String imPattern = null;
    private IntersectionMatrix patternMatrix;

    public IMPatternMatcher(String imPattern) {
        this.imPattern = imPattern;
        this.patternMatrix = new IntersectionMatrix(imPattern);
    }

    @Override
    public String name() {
        return "IMPattern";
    }

    @Override
    public void init(Envelope envA, Envelope envB) {
        super.init(this.dimA, this.dimB);
        boolean requiresInteraction = IMPatternMatcher.requireInteraction(this.patternMatrix);
        boolean isDisjoint = envA.disjoint(envB);
        this.setValueIf(false, requiresInteraction && isDisjoint);
    }

    @Override
    public boolean requireInteraction() {
        return IMPatternMatcher.requireInteraction(this.patternMatrix);
    }

    private static boolean requireInteraction(IntersectionMatrix im) {
        boolean requiresInteraction = IMPatternMatcher.isInteraction(im.get(0, 0)) || IMPatternMatcher.isInteraction(im.get(0, 1)) || IMPatternMatcher.isInteraction(im.get(1, 0)) || IMPatternMatcher.isInteraction(im.get(1, 1));
        return requiresInteraction;
    }

    private static boolean isInteraction(int imDim) {
        return imDim == -2 || imDim >= 0;
    }

    @Override
    public boolean isDetermined() {
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                int patternEntry = this.patternMatrix.get(i2, j);
                if (patternEntry == -3) continue;
                int matrixVal = this.getDimension(i2, j);
                if (patternEntry == -2) {
                    if (matrixVal >= 0) continue;
                    return false;
                }
                if (matrixVal <= patternEntry) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean valueIM() {
        boolean val = this.intMatrix.matches(this.imPattern);
        return val;
    }

    @Override
    public String toString() {
        return this.name() + "(" + this.imPattern + ")";
    }
}

