/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.relateng.NodeSection;
import org.locationtech.jts.operation.relateng.PolygonNodeConverter;
import org.locationtech.jts.operation.relateng.RelateNode;

class NodeSections {
    private Coordinate nodePt;
    private List<NodeSection> sections = new ArrayList<NodeSection>();

    public NodeSections(Coordinate pt) {
        this.nodePt = pt;
    }

    public Coordinate getCoordinate() {
        return this.nodePt;
    }

    public void addNodeSection(NodeSection e) {
        this.sections.add(e);
    }

    public boolean hasInteractionAB() {
        boolean isA = false;
        boolean isB = false;
        for (NodeSection ns : this.sections) {
            if (ns.isA()) {
                isA = true;
            } else {
                isB = true;
            }
            if (!isA || !isB) continue;
            return true;
        }
        return false;
    }

    public Geometry getPolygonal(boolean isA) {
        for (NodeSection ns : this.sections) {
            Geometry poly;
            if (ns.isA() != isA || (poly = ns.getPolygonal()) == null) continue;
            return poly;
        }
        return null;
    }

    public RelateNode createNode() {
        this.prepareSections();
        RelateNode node = new RelateNode(this.nodePt);
        int i2 = 0;
        while (i2 < this.sections.size()) {
            NodeSection ns = this.sections.get(i2);
            if (ns.isArea() && NodeSections.hasMultiplePolygonSections(this.sections, i2)) {
                List<NodeSection> polySections = NodeSections.collectPolygonSections(this.sections, i2);
                List<NodeSection> nsConvert = PolygonNodeConverter.convert(polySections);
                node.addEdges(nsConvert);
                i2 += polySections.size();
                continue;
            }
            node.addEdges(ns);
            ++i2;
        }
        return node;
    }

    private void prepareSections() {
        this.sections.sort(null);
    }

    private static boolean hasMultiplePolygonSections(List<NodeSection> sections, int i2) {
        if (i2 >= sections.size() - 1) {
            return false;
        }
        NodeSection ns = sections.get(i2);
        NodeSection nsNext = sections.get(i2 + 1);
        return ns.isSamePolygon(nsNext);
    }

    private static List<NodeSection> collectPolygonSections(List<NodeSection> sections, int i2) {
        ArrayList<NodeSection> polySections = new ArrayList<NodeSection>();
        NodeSection polySection = sections.get(i2);
        while (i2 < sections.size() && polySection.isSamePolygon(sections.get(i2))) {
            polySections.add(sections.get(i2));
            ++i2;
        }
        return polySections;
    }
}

