/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.Collection;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.simplify.TaggedLineString;

class ComponentJumpChecker {
    private Collection<TaggedLineString> components;

    public ComponentJumpChecker(Collection<TaggedLineString> taggedLines) {
        this.components = taggedLines;
    }

    public boolean hasJump(TaggedLineString line, int start, int end, LineSegment seg) {
        Envelope sectionEnv = ComponentJumpChecker.computeEnvelope(line, start, end);
        for (TaggedLineString comp : this.components) {
            Coordinate compPt;
            if (comp == line || !sectionEnv.intersects(compPt = comp.getComponentPoint()) || !ComponentJumpChecker.hasJumpAtComponent(compPt, line, start, end, seg)) continue;
            return true;
        }
        return false;
    }

    public boolean hasJump(TaggedLineString line, LineSegment seg1, LineSegment seg2, LineSegment seg) {
        Envelope sectionEnv = ComponentJumpChecker.computeEnvelope(seg1, seg2);
        for (TaggedLineString comp : this.components) {
            Coordinate compPt;
            if (comp == line || !sectionEnv.intersects(compPt = comp.getComponentPoint()) || !ComponentJumpChecker.hasJumpAtComponent(compPt, seg1, seg2, seg)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasJumpAtComponent(Coordinate compPt, TaggedLineString line, int start, int end, LineSegment seg) {
        int segCount;
        int sectionCount = ComponentJumpChecker.crossingCount(compPt, line, start, end);
        boolean hasJump = sectionCount % 2 != (segCount = ComponentJumpChecker.crossingCount(compPt, seg)) % 2;
        return hasJump;
    }

    private static boolean hasJumpAtComponent(Coordinate compPt, LineSegment seg1, LineSegment seg2, LineSegment seg) {
        int segCount;
        int sectionCount = ComponentJumpChecker.crossingCount(compPt, seg1, seg2);
        boolean hasJump = sectionCount % 2 != (segCount = ComponentJumpChecker.crossingCount(compPt, seg)) % 2;
        return hasJump;
    }

    private static int crossingCount(Coordinate compPt, LineSegment seg) {
        RayCrossingCounter rcc = new RayCrossingCounter(compPt);
        rcc.countSegment(seg.p0, seg.p1);
        return rcc.getCount();
    }

    private static int crossingCount(Coordinate compPt, LineSegment seg1, LineSegment seg2) {
        RayCrossingCounter rcc = new RayCrossingCounter(compPt);
        rcc.countSegment(seg1.p0, seg1.p1);
        rcc.countSegment(seg2.p0, seg2.p1);
        return rcc.getCount();
    }

    private static int crossingCount(Coordinate compPt, TaggedLineString line, int start, int end) {
        RayCrossingCounter rcc = new RayCrossingCounter(compPt);
        for (int i2 = start; i2 < end; ++i2) {
            rcc.countSegment(line.getCoordinate(i2), line.getCoordinate(i2 + 1));
        }
        return rcc.getCount();
    }

    private static Envelope computeEnvelope(LineSegment seg1, LineSegment seg2) {
        Envelope env = new Envelope();
        env.expandToInclude(seg1.p0);
        env.expandToInclude(seg1.p1);
        env.expandToInclude(seg2.p0);
        env.expandToInclude(seg2.p1);
        return env;
    }

    private static Envelope computeEnvelope(TaggedLineString line, int start, int end) {
        Envelope env = new Envelope();
        for (int i2 = start; i2 <= end; ++i2) {
            env.expandToInclude(line.getCoordinate(i2));
        }
        return env;
    }
}

