/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.io.WKTWriter;

public class LinkedLine {
    private static final int NO_COORD_INDEX = -1;
    private final Coordinate[] coord;
    private boolean isRing;
    private int size;
    private int[] next = null;
    private int[] prev = null;

    public LinkedLine(Coordinate[] pts) {
        this.coord = pts;
        this.isRing = CoordinateArrays.isRing(pts);
        this.size = this.isRing ? pts.length - 1 : pts.length;
        this.next = this.createNextLinks(this.size);
        this.prev = this.createPrevLinks(this.size);
    }

    public boolean isRing() {
        return this.isRing;
    }

    public boolean isCorner(int i2) {
        return this.isRing() || i2 != 0 && i2 != this.coord.length - 1;
    }

    private int[] createNextLinks(int size) {
        int[] next = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            next[i2] = i2 + 1;
        }
        next[size - 1] = this.isRing ? 0 : -1;
        return next;
    }

    private int[] createPrevLinks(int size) {
        int[] prev = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            prev[i2] = i2 - 1;
        }
        prev[0] = this.isRing ? size - 1 : -1;
        return prev;
    }

    public int size() {
        return this.size;
    }

    public int next(int i2) {
        return this.next[i2];
    }

    public int prev(int i2) {
        return this.prev[i2];
    }

    public Coordinate getCoordinate(int index) {
        return this.coord[index];
    }

    public Coordinate prevCoordinate(int index) {
        return this.coord[this.prev(index)];
    }

    public Coordinate nextCoordinate(int index) {
        return this.coord[this.next(index)];
    }

    public boolean hasCoordinate(int index) {
        if (!(this.isRing || index != 0 && index != this.coord.length - 1)) {
            return true;
        }
        return index >= 0 && index < this.prev.length && this.prev[index] != -1;
    }

    public void remove(int index) {
        int iprev = this.prev[index];
        int inext = this.next[index];
        if (iprev != -1) {
            this.next[iprev] = inext;
        }
        if (inext != -1) {
            this.prev[inext] = iprev;
        }
        this.prev[index] = -1;
        this.next[index] = -1;
        --this.size;
    }

    public Coordinate[] getCoordinates() {
        CoordinateList coords = new CoordinateList();
        int len = this.isRing ? this.coord.length - 1 : this.coord.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!this.hasCoordinate(i2)) continue;
            coords.add(this.coord[i2].copy(), false);
        }
        if (this.isRing) {
            coords.closeRing();
        }
        return coords.toCoordinateArray();
    }

    public String toString() {
        return WKTWriter.toLineString(this.getCoordinates());
    }
}

