/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.simplify.TaggedLineSegment;

class TaggedLineString {
    private LineString parentLine;
    private TaggedLineSegment[] segs;
    private List<LineSegment> resultSegs = new ArrayList<LineSegment>();
    private int minimumSize;
    private boolean isRing = true;

    public TaggedLineString(LineString parentLine, int minimumSize, boolean isRing) {
        this.parentLine = parentLine;
        this.minimumSize = minimumSize;
        this.isRing = isRing;
        this.init();
    }

    public boolean isRing() {
        return this.isRing;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public LineString getParent() {
        return this.parentLine;
    }

    public Coordinate[] getParentCoordinates() {
        return this.parentLine.getCoordinates();
    }

    public Coordinate[] getResultCoordinates() {
        return TaggedLineString.extractCoordinates(this.resultSegs);
    }

    public Coordinate getCoordinate(int i2) {
        return this.parentLine.getCoordinateN(i2);
    }

    public int size() {
        return this.parentLine.getNumPoints();
    }

    public Coordinate getComponentPoint() {
        return this.getParentCoordinates()[1];
    }

    public int getResultSize() {
        int resultSegsSize = this.resultSegs.size();
        return resultSegsSize == 0 ? 0 : resultSegsSize + 1;
    }

    public TaggedLineSegment getSegment(int i2) {
        return this.segs[i2];
    }

    public LineSegment getResultSegment(int i2) {
        int index = i2;
        if (i2 < 0) {
            index = this.resultSegs.size() + i2;
        }
        return this.resultSegs.get(index);
    }

    private void init() {
        Coordinate[] pts = this.parentLine.getCoordinates();
        this.segs = new TaggedLineSegment[pts.length - 1];
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            TaggedLineSegment seg;
            this.segs[i2] = seg = new TaggedLineSegment(pts[i2], pts[i2 + 1], this.parentLine, i2);
        }
    }

    public TaggedLineSegment[] getSegments() {
        return this.segs;
    }

    public void addToResult(LineSegment seg) {
        this.resultSegs.add(seg);
    }

    public LineString asLineString() {
        return this.parentLine.getFactory().createLineString(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    public LinearRing asLinearRing() {
        return this.parentLine.getFactory().createLinearRing(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    private static Coordinate[] extractCoordinates(List<LineSegment> segs) {
        Coordinate[] pts = new Coordinate[segs.size() + 1];
        LineSegment seg = null;
        for (int i2 = 0; i2 < segs.size(); ++i2) {
            seg = segs.get(i2);
            pts[i2] = seg.p0;
        }
        pts[pts.length - 1] = seg.p1;
        return pts;
    }

    LineSegment removeRingEndpoint() {
        LineSegment firstSeg = this.resultSegs.get(0);
        LineSegment lastSeg = this.resultSegs.get(this.resultSegs.size() - 1);
        firstSeg.p0 = lastSeg.p0;
        this.resultSegs.remove(this.resultSegs.size() - 1);
        return firstSeg;
    }
}

