/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.data.api.dataset;

import groovy.lang.Closure;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.orbisgis.data.api.dataset.IJdbcTableSummary;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.api.dsl.IResultSetProperties;

public interface IJdbcTable<T>
extends ITable<T, T>,
ResultSet {
    public static final String QUERY_LOCATION = "query";
    public static final String META_PROPERTY = "meta";

    public TableLocation getTableLocation();

    public DBTypes getDbType();

    @Override
    public ResultSetMetaData getMetaData() throws SQLException;

    public boolean isLinked() throws Exception;

    public boolean isTemporary() throws Exception;

    @Override
    default public String getLocation() {
        TableLocation location = this.getTableLocation();
        if (location == null || location.getTable().isEmpty()) {
            return QUERY_LOCATION;
        }
        return location.toString();
    }

    @Override
    default public String getName() {
        TableLocation location = this.getTableLocation();
        if (location == null || location.getTable().isEmpty()) {
            return QUERY_LOCATION;
        }
        return location.getTable();
    }

    @Override
    default public void eachRow(Closure<Object> closure) throws Exception {
        this.forEach(closure::call);
    }

    @Override
    public IJdbcTableSummary getSummary() throws Exception;

    @Override
    public List<Object> getParams();

    public void setResultSetProperties(IResultSetProperties var1);

    public IResultSetProperties getResultSetProperties();
}

