/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.demat;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FileUtils {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final String[] JS_FILES = new String[]{"vega.js", "vega-lite.js", "vega-embed.js"};
    public static final String JS_FOLDER = "js";

    public static void deployJSFiles(File scriptDir) throws IOException {
        File jsFolder = new File(scriptDir, JS_FOLDER);
        if (!jsFolder.exists() && !jsFolder.mkdirs()) {
            throw new IOException("Can't create js folder '" + jsFolder.getAbsolutePath() + "'");
        }
        for (String fileName : JS_FILES) {
            InputStream fis;
            File jsFile = new File(jsFolder, fileName);
            if (jsFile.exists() || (fis = FileUtils.class.getResourceAsStream(fileName)) == null) continue;
            try (FileOutputStream fos = new FileOutputStream(new File(jsFolder, fileName));){
                try {
                    FileUtils.copyStream(fis, fos, 16384);
                }
                catch (Exception e) {
                    throw new IOException("Error copying js file " + fileName, e);
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        try {
            byte[] writeBuffer = new byte[bufferSize];
            int br = inputStream.read(writeBuffer);
            while (br != -1) {
                outputStream.write(writeBuffer, 0, br);
                br = inputStream.read(writeBuffer);
            }
            outputStream.flush();
        }
        finally {
            inputStream.close();
        }
    }

    public static boolean isExtensionWellFormated(File file, String ... prefixes) {
        if (file == null) {
            throw new RuntimeException("The file is null.");
        }
        String path = file.getAbsolutePath();
        String extension = "";
        int i2 = path.lastIndexOf(46);
        if (i2 >= 0) {
            extension = path.substring(i2 + 1);
        }
        for (String prefix : prefixes) {
            if (prefix == null || prefix.isEmpty() || !extension.equalsIgnoreCase(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Object json(File jsonFile) throws IOException {
        if (FileUtils.isExtensionWellFormated(jsonFile, "json", "geojson")) {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(jsonFile, Object.class);
        }
        throw new RuntimeException("Cannot read as json file.");
    }

    public static Object geojson(File jsonFile) throws IOException {
        if (FileUtils.isExtensionWellFormated(jsonFile, "json", "geojson")) {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(jsonFile, Object.class);
        }
        throw new RuntimeException("Cannot read as json file.");
    }

    public static List csv(File csvFile) throws IOException {
        if (FileUtils.isExtensionWellFormated(csvFile, "csv")) {
            String line = "";
            String splitBy = ",";
            ArrayList lines = new ArrayList();
            try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
                line = br.readLine();
                String[] header = null;
                if (line != null) {
                    header = line.split(splitBy);
                }
                while ((line = br.readLine()) != null) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    String[] csvValues = line.split(splitBy);
                    for (int i2 = 0; i2 < header.length; ++i2) {
                        values.put(header[i2], csvValues[i2]);
                    }
                    lines.add(values);
                }
            }
            return lines;
        }
        return null;
    }

    public static List tsv(File tsvFile) throws IOException {
        if (FileUtils.isExtensionWellFormated(tsvFile, "tsv")) {
            String line = "";
            String splitBy = "\t";
            ArrayList lines = new ArrayList();
            try (BufferedReader br = new BufferedReader(new FileReader(tsvFile));){
                line = br.readLine();
                String[] header = null;
                if (line != null) {
                    header = line.split(splitBy);
                }
                while ((line = br.readLine()) != null) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    String[] csvValues = line.split(splitBy);
                    for (int i2 = 0; i2 < header.length; ++i2) {
                        values.put(header[i2], csvValues[i2]);
                    }
                    lines.add(values);
                }
            }
            return lines;
        }
        return null;
    }

    public static void openBrowser(String url) throws Exception {
        boolean isMac;
        if (url == null || url.isEmpty()) {
            throw new RuntimeException("The URL cannot be null or empty");
        }
        String osname = System.getProperty("os.name");
        boolean isWin = osname.startsWith("windows");
        boolean bl = isMac = !isWin && osname.startsWith("mac");
        if (isMac) {
            Runtime.getRuntime().exec("open " + url);
        } else {
            if (isWin) {
                String cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                if (osname.startsWith("Windows 2000")) {
                    cmd = "rundll32 shell32.dll,ShellExec_RunDLL " + url;
                }
                Process process = Runtime.getRuntime().exec(cmd);
                try {
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            String[] browsers = new String[]{"xdg-open", "netscape", "firefox", "konqueror", "mozilla", "opera", "epiphany", "lynx"};
            String browserName = null;
            try {
                for (int count = 0; count < browsers.length && browserName == null; ++count) {
                    String[] c = new String[]{"which", browsers[count]};
                    if (Runtime.getRuntime().exec(c).waitFor() != 0) continue;
                    browserName = browsers[count];
                }
                if (browserName == null) {
                    throw new RuntimeException("Could not find a browser");
                }
                Runtime.getRuntime().exec(new String[]{browserName, url});
            }
            catch (Exception e) {
                throw new IOException("Exception while launching browser: " + e.getMessage());
            }
        }
    }
}

