/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.demat;

import com.caoccao.javet.exceptions.JavetException;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.orbisgis.demat.FileUtils;
import org.orbisgis.demat.JavascriptEngine;

public class IOUtils {
    private static JavascriptEngine javascriptEngine;

    static String saveAsPNG(String json, String jsDirectory, File outputImage, boolean delete) throws IOException, JavetException {
        if (javascriptEngine == null) {
            javascriptEngine = new JavascriptEngine(jsDirectory);
        }
        javascriptEngine.setDirectory(jsDirectory);
        return javascriptEngine.savePNG(json, outputImage, delete, 2.0f);
    }

    static String saveAsSVG(String spec, String jsDirectory, File outputSVG, boolean delete) throws IOException, JavetException {
        if (javascriptEngine == null) {
            javascriptEngine = new JavascriptEngine(jsDirectory);
        }
        javascriptEngine.setDirectory(jsDirectory);
        return javascriptEngine.saveSVG(spec, outputSVG, delete);
    }

    static String saveAsJSON(String json, File outputJson, boolean delete) {
        if (outputJson.exists() && delete) {
            outputJson.delete();
        }
        try {
            FileWriter fileWriter = new FileWriter(outputJson);
            fileWriter.write(json);
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputJson.getAbsolutePath();
    }

    static String saveAsHTML(String json, String jsDirectory, File outputHTML, boolean delete) throws IOException {
        FileUtils.deployJSFiles(new File(jsDirectory));
        if (outputHTML == null) {
            return null;
        }
        if (outputHTML.exists()) {
            if (delete) {
                outputHTML.delete();
            } else {
                return null;
            }
        }
        StringBuilder vega_embed = new StringBuilder("vegaEmbed('#").append("demat").append("',");
        vega_embed.append(json).append(",{renderer: 'svg',downloadFileName :'").append("demat_chart").append("'}).catch(console.error);");
        UnescapedText body = TagCreator.join(TagCreator.div().withId("demat"), TagCreator.script(TagCreator.rawHtml(vega_embed.toString())));
        FileWriter fileWriter = new FileWriter(outputHTML);
        TagCreator.html(TagCreator.head(new DomContent[]{TagCreator.meta().withCharset("UTF-8"), TagCreator.script().withSrc(jsDirectory + File.separator + "js" + File.separator + FileUtils.JS_FILES[0]), TagCreator.script().withSrc(jsDirectory + File.separator + "js" + File.separator + FileUtils.JS_FILES[1]), TagCreator.script().withSrc(jsDirectory + File.separator + "js" + File.separator + FileUtils.JS_FILES[2])}), TagCreator.body(body)).render(fileWriter);
        fileWriter.close();
        return outputHTML.getAbsolutePath();
    }
}

