/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.demat;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.IJavetEngine;
import com.caoccao.javet.interop.engine.JavetEnginePool;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValuePromise;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kitfox.svg.SVGException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.orbisgis.demat.FileUtils;
import org.orbisgis.demat.SvgRasterizer;

public class JavascriptEngine {
    V8Host v8Host = V8Host.getNodeInstance();
    JavetEnginePool<V8Runtime> javetEnginePool = new JavetEnginePool();
    private V8Runtime v8Runtime;
    private String jsDirectory;
    private ObjectMapper jsonMapper;

    public JavascriptEngine(String jsDirectory) {
        this.javetEnginePool.getConfig().setJSRuntimeType(this.v8Host.getJSRuntimeType());
        this.jsDirectory = jsDirectory;
        try {
            this.initV8Engine();
        }
        catch (JavetException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public V8Host getV8Host() {
        return this.v8Host;
    }

    void initV8Engine() throws JavetException, IOException {
        FileUtils.deployJSFiles(new File(this.jsDirectory));
        IJavetEngine<V8Runtime> iJavetEngine = this.javetEnginePool.getEngine();
        this.v8Runtime = iJavetEngine.getV8Runtime();
        this.v8Runtime.allowEval(true);
        this.v8Runtime.getExecutor(new File(this.jsDirectory + File.separator + "js" + File.separator + FileUtils.JS_FILES[0])).executeVoid();
        this.v8Runtime.getExecutor(new File(this.jsDirectory + File.separator + "js" + File.separator + FileUtils.JS_FILES[1])).executeVoid();
        String svgFunction = "var jsonFile;function svg() {\nvar vegaspec = vegaLite.compile(JSON.parse(jsonFile)).spec;    var view = new vega.View(vega.parse(vegaspec))\n            .renderer('none')\n            .initialize()\n            .run()\n            ;\n    return view.toSVG();\n}";
        this.v8Runtime.getExecutor(svgFunction).executeVoid();
        this.jsonMapper = new ObjectMapper();
    }

    public String saveSVG(String json, File outputFile, boolean delete) throws JavetException, IOException {
        boolean success;
        block17: {
            if (outputFile.exists() && delete) {
                outputFile.delete();
            }
            success = false;
            try (V8ValueObject v8ValueObject = this.v8Runtime.createV8ValueObject();){
                this.v8Runtime.getGlobalObject().set((Object)"jsonFile", (Object)v8ValueObject);
            }
            this.v8Runtime.getGlobalObject().set((Object)"jsonFile", (Object)json);
            try (V8ValuePromise v8ValuePromise = (V8ValuePromise)this.v8Runtime.getExecutor("svg();").execute();){
                this.v8Runtime.await();
                if (!v8ValuePromise.isFulfilled()) break block17;
                Object result = v8ValuePromise.getResult();
                try {
                    FileWriter fileWriter = new FileWriter(outputFile);
                    fileWriter.write(result.toString());
                    fileWriter.close();
                    success = true;
                }
                catch (IOException e) {
                    this.v8Runtime.getGlobalObject().delete("jsonFile");
                    throw new RuntimeException(e);
                }
            }
        }
        this.v8Runtime.getGlobalObject().delete("jsonFile");
        if (!success) {
            throw new RuntimeException("Cannot save the SVG file");
        }
        return outputFile.getAbsolutePath();
    }

    public String savePNG(String vega_spec, File outputFile, boolean delete, float ratio) throws JavetException {
        boolean success;
        block17: {
            if (outputFile.exists() && delete) {
                outputFile.delete();
            }
            success = false;
            try (V8ValueObject v8ValueObject = this.v8Runtime.createV8ValueObject();){
                this.v8Runtime.getGlobalObject().set((Object)"jsonFile", (Object)v8ValueObject);
            }
            this.v8Runtime.getGlobalObject().set((Object)"jsonFile", (Object)vega_spec);
            try (V8ValuePromise v8ValuePromise = (V8ValuePromise)this.v8Runtime.getExecutor("svg();").execute();){
                this.v8Runtime.await();
                if (!v8ValuePromise.isFulfilled()) break block17;
                Object result = v8ValuePromise.getResult();
                try {
                    SvgRasterizer svgRasterizer = new SvgRasterizer();
                    svgRasterizer.save(result.toString(), ratio, outputFile);
                    success = true;
                }
                catch (SVGException | IOException e) {
                    this.v8Runtime.getGlobalObject().delete("jsonFile");
                    throw new RuntimeException(e);
                }
            }
        }
        this.v8Runtime.getGlobalObject().delete("jsonFile");
        if (!success) {
            throw new RuntimeException("Cannot save the PNG file");
        }
        return outputFile.getAbsolutePath();
    }

    public void setDirectory(String jsDirectory) throws JavetException, IOException {
        if (!this.jsDirectory.equals(jsDirectory)) {
            this.jsDirectory = jsDirectory;
            this.initV8Engine();
        }
    }
}

