/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.demat;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.orbisgis.demat.FileUtils;

public class LocalFile {
    private final String path;

    public LocalFile(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Object getObject() {
        try {
            File file = Paths.get(this.path, new String[0]).toFile();
            if (FileUtils.isExtensionWellFormated(file, "json", "geojson")) {
                return FileUtils.json(file);
            }
            if (FileUtils.isExtensionWellFormated(file, "csv")) {
                return FileUtils.csv(file);
            }
            if (FileUtils.isExtensionWellFormated(file, "tsv")) {
                return FileUtils.tsv(file);
            }
            throw new RuntimeException("Unsupported file " + this.path);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read the file " + this.path);
        }
    }
}

