/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.demat;

import com.caoccao.javet.exceptions.JavetException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.demat.FileUtils;
import org.orbisgis.demat.IOUtils;
import org.orbisgis.demat.LocalFile;
import org.orbisgis.demat.LocalFileSerializer;
import org.orbisgis.demat.TableSerializer;

public class Plot {
    private static String DEMAT_FOLDER = System.getProperty("java.io.tmpdir") + File.separator + "demat";
    private static String VEGA_SCHEMA = "https://vega.github.io/schema/vega-lite/v5.json";
    private static ObjectMapper jsonMapper;

    public static void toSVG(Map spec, String path) throws IOException, JavetException {
        Plot.toSVG(spec, Path.of(path, new String[0]).toFile());
    }

    public static void toSVG(Map spec, File path) throws IOException, JavetException {
        if (spec == null || spec.isEmpty()) {
            throw new RuntimeException("The input spec cannot be null or empty");
        }
        Plot.prepareSpec(spec);
        if (!FileUtils.isExtensionWellFormated(path, "svg")) {
            throw new RuntimeException("Wrong file extension. Please set .svg");
        }
        IOUtils.saveAsSVG(Plot.getJSONMapper().writeValueAsString(spec), DEMAT_FOLDER, path, true);
    }

    public static void toJSON(Map spec, String path) throws IOException, JavetException {
        Plot.toJSON(spec, Path.of(path, new String[0]).toFile());
    }

    public static void toJSON(Map spec, File path) throws IOException, JavetException {
        if (spec == null || spec.isEmpty()) {
            throw new RuntimeException("The input spec cannot be null or empty");
        }
        Plot.prepareSpec(spec);
        if (!FileUtils.isExtensionWellFormated(path, "json")) {
            throw new RuntimeException("Wrong file extension. Please set .json");
        }
        IOUtils.saveAsJSON(Plot.getJSONMapper().writeValueAsString(spec), path, true);
    }

    public static void toPNG(Map spec, String path) throws IOException, JavetException {
        Plot.toPNG(spec, Path.of(path, new String[0]).toFile());
    }

    public static void toPNG(Map spec, File path) throws IOException, JavetException {
        if (spec == null || spec.isEmpty()) {
            throw new RuntimeException("The input spec cannot be null or empty");
        }
        Plot.prepareSpec(spec);
        if (!FileUtils.isExtensionWellFormated(path, "png")) {
            throw new RuntimeException("Wrong file extension. Please set .png");
        }
        IOUtils.saveAsPNG(Plot.getJSONMapper().writeValueAsString(spec), DEMAT_FOLDER, path, true);
    }

    public static void toHTML(Map spec, String path) throws IOException, JavetException {
        Plot.toHTML(spec, Path.of(path, new String[0]).toFile());
    }

    public static void toHTML(Map spec, File path) throws IOException, JavetException {
        if (spec == null || spec.isEmpty()) {
            throw new RuntimeException("The input spec cannot be null or empty");
        }
        spec.put("$schema", VEGA_SCHEMA);
        IOUtils.saveAsHTML(Plot.getJSONMapper().writeValueAsString(spec), DEMAT_FOLDER, path, true);
    }

    static ObjectMapper getJSONMapper() {
        if (jsonMapper == null) {
            jsonMapper = new ObjectMapper();
            SimpleModule tableModule = new SimpleModule();
            tableModule.addSerializer(ITable.class, new TableSerializer());
            jsonMapper.registerModule(tableModule);
            SimpleModule localFileModule = new SimpleModule();
            localFileModule.addSerializer(LocalFile.class, new LocalFileSerializer());
            jsonMapper.registerModule(localFileModule);
        }
        return jsonMapper;
    }

    static void show(Map spec) {
        try {
            File outputFile = File.createTempFile("demat", ".html", Plot.checkShowDir());
            Plot.toHTML(spec, outputFile);
            FileUtils.openBrowser(outputFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static File checkShowDir() {
        File showDirFile = new File(Plot.getDematFolder());
        if (!showDirFile.isDirectory() && !showDirFile.exists()) {
            showDirFile.mkdir();
        } else if (!showDirFile.isDirectory()) {
            throw new RuntimeException("Invalid directory path");
        }
        return showDirFile;
    }

    public static String getDematFolder() {
        return DEMAT_FOLDER;
    }

    public static void setDematFolder(String dematFolder) {
        DEMAT_FOLDER = dematFolder;
    }

    private static Map prepareSpec(Map spec) {
        if (spec == null || spec.isEmpty()) {
            throw new RuntimeException("The input spec cannot be null or empty");
        }
        spec.put("$schema", VEGA_SCHEMA);
        Plot.findDeep(spec);
        return spec;
    }

    static void findDeep(Object m) {
        if (m instanceof List) {
            ((List)m).forEach(val -> Plot.findDeep(val));
        } else if (m instanceof Map) {
            for (Map.Entry entry : ((Map)m).entrySet()) {
                if (entry.getValue() instanceof Map) {
                    Plot.replace((Map)entry.getValue());
                    continue;
                }
                Plot.findDeep(entry.getValue());
            }
        }
    }

    static void replace(Map data) {
        String url = (String)data.get("url");
        if (url != null && !url.startsWith("http") && (url.endsWith(".json") || url.endsWith(".csv") || url.endsWith(".tsv") || url.endsWith(".geojson"))) {
            data.remove("url");
            data.put("values", new LocalFile(url));
        }
    }
}

