/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.demat;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.imageio.ImageIO;

public class SvgRasterizer {
    public static final Map<Object, Object> RENDERING_HINTS = Map.of(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY, RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY, RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE, RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON, RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY, RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE, RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    private static final SVGUniverse sRenderer = new SVGUniverse();

    public BufferedImage rasterize(InputStream path, float ratio) throws SVGException, IOException {
        SVGDiagram diagram = this.loadDiagram(path);
        float wDiagram = diagram.getWidth();
        float hDiagram = diagram.getHeight();
        Dimension srcDim = new Dimension((int)wDiagram, (int)hDiagram);
        Dimension scaled = this.fit(srcDim, ratio);
        int wScaled = (int)scaled.getWidth();
        int hScaled = (int)scaled.getHeight();
        BufferedImage image = new BufferedImage(wScaled, hScaled, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHints(RENDERING_HINTS);
        AffineTransform transform = g.getTransform();
        transform.setToScale((float)wScaled / wDiagram, (float)hScaled / hDiagram);
        g.setTransform(transform);
        diagram.render(g);
        g.dispose();
        return image;
    }

    private URL getResourceUrl(String path) {
        return SvgRasterizer.class.getResource(path);
    }

    private SVGDiagram loadDiagram(InputStream path) throws IOException {
        URI uri = sRenderer.loadSVG(path, "name");
        SVGDiagram diagram = sRenderer.getDiagram(uri);
        return this.applySettings(diagram);
    }

    private SVGDiagram applySettings(SVGDiagram diagram) {
        diagram.setIgnoringClipHeuristic(true);
        return diagram;
    }

    private Dimension fit(Dimension src, float ratio) {
        double srcWidth = src.getWidth();
        double srcHeight = src.getHeight();
        return new Dimension((int)(srcWidth * (double)ratio), (int)(srcHeight * (double)ratio));
    }

    void save(String svg, float ratio, File outputFile) throws SVGException, IOException {
        BufferedImage bufferedImage = this.rasterize(new ByteArrayInputStream(svg.getBytes()), ratio);
        ImageIO.write((RenderedImage)bufferedImage, "png", outputFile);
    }
}

