/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.demat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.h2gis.utilities.jts_utils.GeometryFeatureUtils;
import org.orbisgis.data.api.dataset.ISpatialTable;
import org.orbisgis.data.api.dataset.ITable;

public class TableSerializer
extends StdSerializer<ITable> {
    public TableSerializer() {
        this((Class<ITable>)null);
    }

    public TableSerializer(Class<ITable> t) {
        super(t);
    }

    @Override
    public void serialize(ITable table, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        if (table instanceof ISpatialTable) {
            try {
                ISpatialTable<?> spatialTable = table.getSpatialTable();
                ArrayList json = new ArrayList();
                Object geomCol = spatialTable.getGeometricColumns().stream().findFirst().get();
                Collection<String> columns = spatialTable.getColumnNames();
                columns.remove(geomCol);
                int colummSize = columns.size();
                while (spatialTable.next()) {
                    LinkedHashMap<String, Object> feature = new LinkedHashMap<String, Object>();
                    feature.put("type", "Feature");
                    feature.putAll(GeometryFeatureUtils.toMap(spatialTable.getGeometry()));
                    if (colummSize > 0) {
                        feature.put("properties", GeometryFeatureUtils.getProperties((ResultSet)((Object)spatialTable), columns));
                    }
                    json.add(feature);
                }
                jgen.writeObject(json);
            }
            catch (Exception e) {
                throw new IOException("Cannot serialize the spatial table " + table.getName(), e);
            }
        }
        try {
            ArrayList<LinkedHashMap> json = new ArrayList<LinkedHashMap>();
            Collection<String> columns = table.getColumnNames();
            int colummSize = columns.size();
            while (table.next()) {
                if (colummSize <= 0) continue;
                json.add(GeometryFeatureUtils.getProperties((ResultSet)((Object)table), columns));
            }
            jgen.writeObject(json);
        }
        catch (Exception e) {
            throw new IOException("Cannot serialize the table " + table.getName(), e);
        }
    }
}

