/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.geoclimate.bdtopo;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.h2gis.functions.io.utility.IOMethods;
import org.h2gis.postgis_jts.PostGISDBFactory;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.orbisgis.data.H2GIS;
import org.orbisgis.data.jdbc.JdbcDataSource;
import org.orbisgis.geoclimate.bdtopo.AbstractBDTopoWorkflow;
import org.orbisgis.geoclimate.bdtopo.BDTopo;

public class BDTopoV2Workflow
extends AbstractBDTopoWorkflow {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public static void main(String ... args) {
        IndyInterface.bootstrap("invoke", "runScript", 0, InvokerHelper.class, BDTopoV2Workflow.class, args);
    }

    public Object run() {
        BDTopoV2Workflow bdTopoWorkflow = this;
        return bdTopoWorkflow;
    }

    @Override
    public Integer loadDataFromPostGIS(Object input_database_properties, Object code, Object distance, Object inputTables, Object inputSRID, H2GIS h2gis_datasource) {
        CallSite commune_location = IndyInterface.bootstrap("getProperty", "commune", 0, inputTables);
        if (IndyInterface.bootstrap("cast", "()", 0, commune_location) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The commune table must be specified to run Geoclimate");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite dataSourceFactory = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PostGISDBFactory.class));
        CallSite sourceConnection = null;
        try {
            CallSite props = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Properties.class));
            IndyInterface.bootstrap("invoke", "forEach", 0, input_database_properties, ScriptBytecodeAdapter.getMethodPointer((Object)props, (String)"put"));
            CallSite ds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createDataSource", 0, dataSourceFactory, props));
            sourceConnection = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getConnection", 0, ds));
        }
        catch (SQLException e) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot connect to the database to import the data ");
        }
        if (ScriptBytecodeAdapter.compareEqual(sourceConnection, null)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot connect to the database to import the data ");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "tableExists", 0, JDBCUtilities.class, sourceConnection, commune_location)) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The commune table doesn't exist");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object commune_srid = IndyInterface.bootstrap("invoke", "getSRID", 0, GeometryTableUtilities.class, sourceConnection, commune_location);
        if (ScriptBytecodeAdapter.compareLessThanEqual((Object)commune_srid, (Object)0)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The commune table doesn't have any SRID");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)commune_srid, (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)inputSRID)) {
            commune_srid = inputSRID;
        } else if (ScriptBytecodeAdapter.compareLessThanEqual((Object)commune_srid, (Object)0)) {
            IndyInterface.bootstrap("invoke", "warn", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "Cannot find a SRID value for the layer commune.\n", "Please set a valid OGC prj or use the parameter srid to force it."));
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        String outputTableName = "COMMUNE";
        if (ScriptBytecodeAdapter.isCase((Object)code, Collection.class)) {
            CallSite inputTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("invoke", "getAt", 0, code, true), IndyInterface.bootstrap("invoke", "getAt", 0, code, false), IndyInterface.bootstrap("invoke", "getAt", 0, code, 3), IndyInterface.bootstrap("invoke", "getAt", 0, code, 2), commune_srid, commune_location, commune_srid, IndyInterface.bootstrap("invoke", "getAt", 0, code, true), IndyInterface.bootstrap("invoke", "getAt", 0, code, false), IndyInterface.bootstrap("invoke", "getAt", 0, code, 3), IndyInterface.bootstrap("invoke", "getAt", 0, code, 2), commune_srid, commune_srid, IndyInterface.bootstrap("invoke", "getAt", 0, code, true), IndyInterface.bootstrap("invoke", "getAt", 0, code, false), IndyInterface.bootstrap("invoke", "getAt", 0, code, 3), IndyInterface.bootstrap("invoke", "getAt", 0, code, 2), commune_srid}, new String[]{"(SELECT\n                    ST_INTERSECTION(st_setsrid(the_geom, ", "), ST_MakeEnvelope(", ",", ",", ",", ", ", ")) as the_geom, CODE_INSEE  from ", " where \n                    st_setsrid(the_geom, ", ") \n                    && ST_MakeEnvelope(", ",", ",", ",", ", ", ") and\n                    st_intersects(st_setsrid(the_geom, ", "), ST_MakeEnvelope(", ",", ",", ",", ", ", ")))"})));
            IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
            IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 10);
        } else if (code instanceof String) {
            CallSite inputTableName = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{commune_srid, commune_location, code, IndyInterface.bootstrap("invoke", "toLowerCase", 0, code)}, new String[]{"(SELECT st_setsrid(the_geom, ", ") as the_geom, CODE_INSEE FROM ", " WHERE CODE_INSEE='", "' or lower(nom)='", "')"}));
            IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
            IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
        }
        CallSite count = IndyInterface.bootstrap("getProperty", "rowCount", 0, ScriptBytecodeAdapter.getGroovyObjectProperty(BDTopoV2Workflow.class, (GroovyObject)h2gis_datasource, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{outputTableName}, new String[]{"", ""})))));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)count, (Object)0)) {
            CallSite geomToExtract = IndyInterface.bootstrap("getProperty", "THE_GEOM", 0, IndyInterface.bootstrap("invoke", "firstRow", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{distance, outputTableName}, new String[]{"SELECT ST_EXPAND(ST_UNION(ST_ACCUM(the_geom)), ", ") AS THE_GEOM FROM ", ""}))));
            String outputTableNameBatiInd = "BATI_INDIFFERENCIE";
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "bati_indifferencie", 0, inputTables)) != false) {
                GStringImpl inputTableName = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "bati_indifferencie", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, HAUTEUR FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableNameBatiInd}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableNameBatiInd, -1, 1000);
            }
            String outputTableNameBatiIndus = "BATI_INDUSTRIEL";
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "bati_industriel", 0, inputTables)) != false) {
                GStringImpl inputTableName = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "bati_industriel", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE, HAUTEUR FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableNameBatiIndus}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableNameBatiIndus, -1, 1000);
            }
            String outputTableNameBatiRem = "BATI_REMARQUABLE";
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "bati_remarquable", 0, inputTables)) != false) {
                GStringImpl inputTableName = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "bati_remarquable", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE, HAUTEUR FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableNameBatiRem}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableNameBatiRem, -1, 1000);
            }
            String outputTableNameRoad = "ROUTE";
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "route", 0, inputTables)) == false) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "The route table must be provided");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            CallSite inputTableName = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "route", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE, LARGEUR, POS_SOL, \n            FRANCHISST, SENS, IMPORTANCE, CL_ADMIN FROM ", "  WHERE \n            st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY \n            AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY)\n            AND NATURE NOT IN ('Bac auto', 'Bac pi\u00e9ton', 'Escalier'))"}));
            IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableNameRoad}, new String[]{"Loading in the H2GIS database ", ""}));
            IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableNameRoad, -1, 1000);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "troncon_voie_ferree", 0, inputTables)) != false) {
                GStringImpl inputTableName2 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "troncon_voie_ferree", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE, LARGEUR, NB_VOIES, POS_SOL, FRANCHISST FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                outputTableName = "TRONCON_VOIE_FERREE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName2, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "surface_eau", 0, inputTables)) != false) {
                GStringImpl inputTableName3 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "surface_eau", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom , NATURE FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                outputTableName = "SURFACE_EAU";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName3, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "zone_vegetation", 0, inputTables)) != false) {
                GStringImpl inputTableName4 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "zone_vegetation", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE  FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                outputTableName = "ZONE_VEGETATION";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName4, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "terrain_sport", 0, inputTables)) != false) {
                GStringImpl inputTableName5 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "terrain_sport", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE  FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY) AND NATURE='Piste de sport')"});
                outputTableName = "TERRAIN_SPORT";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName5, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "construction_surfacique", 0, inputTables)) != false) {
                GStringImpl inputTableName6 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "construction_surfacique", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE  FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY) AND (NATURE='Barrage' OR NATURE='Ecluse' OR NATURE='Escalier'))"});
                outputTableName = "CONSTRUCTION_SURFACIQUE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName6, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "surface_route", 0, inputTables)) != false) {
                GStringImpl inputTableName7 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "surface_route", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom,NATURE  FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                outputTableName = "SURFACE_ROUTE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName7, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "surface_activite", 0, inputTables)) != false) {
                GStringImpl inputTableName8 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "surface_activite", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, CATEGORIE, ORIGINE  FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                outputTableName = "SURFACE_ACTIVITE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName8, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "piste_aerodrome", 0, inputTables)) != false) {
                GStringImpl inputTableName9 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "piste_aerodrome", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE  FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                outputTableName = "PISTE_AERODROME";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName9, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "reservoir", 0, inputTables)) != false) {
                GStringImpl inputTableName10 = new GStringImpl(new Object[]{commune_srid, IndyInterface.bootstrap("getProperty", "reservoir", 0, inputTables), commune_srid, commune_srid, geomToExtract, commune_srid, commune_srid, geomToExtract}, new String[]{"(SELECT ID, st_setsrid(the_geom, ", ") as the_geom, NATURE, HAUTEUR  FROM ", "  WHERE st_setsrid(the_geom, ", ") && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(st_setsrid(the_geom, ", "), 'SRID=", ";", "'::GEOMETRY))"});
                outputTableName = "RESERVOIR";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, sourceConnection, inputTableName10, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), outputTableName, -1, 1000);
            }
            IndyInterface.bootstrap("invoke", "close", 0, sourceConnection);
            return IndyInterface.bootstrap("cast", "()", 0, commune_srid);
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{code}, new String[]{"Cannot find any commune with the insee code : ", ""}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    @Override
    public List getInputTables() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{"commune", "bati_indifferencie", "bati_industriel", "bati_remarquable", "route", "troncon_voie_ferree", "surface_eau", "terrain_sport", "construction_surfacique", "surface_route", "surface_activite", "piste_aerodrome", "reservoir", "zone_vegetation"});
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public Map formatLayers(JdbcDataSource datasource, Map layers, float distance, float hLevMin) {
        float f = hLevMin;
        if (!(f != 0.0f && !Float.isNaN(f))) {
            hLevMin = 3;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, datasource) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The database to store the BD Topo data doesn't exist");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite importPreprocess = IndyInterface.bootstrap("invoke", "loadV2", 0, IndyInterface.bootstrap("getProperty", "InputDataLoading", 0, BDTopo.class), datasource, layers, distance);
        if (IndyInterface.bootstrap("cast", "()", 0, importPreprocess) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot prepare the BDTopo data.");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite zoneTable = IndyInterface.bootstrap("getProperty", "zone", 0, importPreprocess);
        CallSite urbanAreas = IndyInterface.bootstrap("getProperty", "urban_areas", 0, importPreprocess);
        CallSite finalImpervious = IndyInterface.bootstrap("invoke", "formatImperviousLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, BDTopo.class), datasource, IndyInterface.bootstrap("getProperty", "impervious", 0, importPreprocess));
        CallSite finalBuildings = IndyInterface.bootstrap("invoke", "formatBuildingLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, BDTopo.class), datasource, IndyInterface.bootstrap("getProperty", "building", 0, importPreprocess), zoneTable, urbanAreas, hLevMin);
        CallSite finalRoads = IndyInterface.bootstrap("invoke", "formatRoadLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, BDTopo.class), datasource, IndyInterface.bootstrap("getProperty", "road", 0, importPreprocess), zoneTable);
        CallSite finalRails = IndyInterface.bootstrap("invoke", "formatRailsLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, BDTopo.class), datasource, IndyInterface.bootstrap("getProperty", "rail", 0, importPreprocess), zoneTable);
        CallSite finalVeget = IndyInterface.bootstrap("invoke", "formatVegetationLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, BDTopo.class), datasource, IndyInterface.bootstrap("getProperty", "vegetation", 0, importPreprocess), zoneTable);
        CallSite finalHydro = IndyInterface.bootstrap("invoke", "formatHydroLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, BDTopo.class), datasource, IndyInterface.bootstrap("getProperty", "water", 0, importPreprocess), zoneTable);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "End of the BDTopo extract transform process.");
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"building", finalBuildings, "road", finalRoads, "rail", finalRails, "water", finalHydro, "vegetation", finalVeget, "impervious", finalImpervious, "urban_areas", urbanAreas, "zone", zoneTable});
    }

    @Override
    public Object filterLinkedShapeFiles(Object location, float distance, LinkedHashMap inputTables, int sourceSRID, int inputSRID, H2GIS h2gis_datasource) {
        String formatting_geom = "the_geom";
        if (sourceSRID == 0 && sourceSRID != inputSRID) {
            formatting_geom = new GStringImpl(new Object[]{inputSRID}, new String[]{"st_setsrid(the_geom, ", ") as the_geom"});
        } else if (sourceSRID >= 0 && sourceSRID == inputSRID) {
            formatting_geom = new GStringImpl(new Object[]{inputSRID}, new String[]{"st_transform(the_geom, ", ") as the_geom"});
        }
        String outputTableName = "COMMUNE";
        if (ScriptBytecodeAdapter.isCase((Object)location, Collection.class)) {
            IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
            IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, IndyInterface.bootstrap("invoke", "getAt", 0, location, true), IndyInterface.bootstrap("invoke", "getAt", 0, location, false), IndyInterface.bootstrap("invoke", "getAt", 0, location, 3), IndyInterface.bootstrap("invoke", "getAt", 0, location, 2), sourceSRID, IndyInterface.bootstrap("getProperty", "commune", 0, inputTables), IndyInterface.bootstrap("invoke", "getAt", 0, location, true), IndyInterface.bootstrap("invoke", "getAt", 0, location, false), IndyInterface.bootstrap("invoke", "getAt", 0, location, 3), IndyInterface.bootstrap("invoke", "getAt", 0, location, 2), sourceSRID}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " as  SELECT\n                    ST_INTERSECTION(the_geom, ST_MakeEnvelope(", ",", ",", ",", ", ", ")) as the_geom, CODE_INSEE  from ", " where the_geom \n                    && ST_MakeEnvelope(", ",", ",", ",", ", ", ") "})));
        } else if (location instanceof String) {
            IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
            IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "commune", 0, inputTables), location, IndyInterface.bootstrap("invoke", "toLowerCase", 0, location)}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " as SELECT ", ", \n            CODE_INSEE FROM ", " WHERE CODE_INSEE='", "' or lower(nom)='", "'"})));
        }
        CallSite count = IndyInterface.bootstrap("getProperty", "rowCount", 0, ScriptBytecodeAdapter.getGroovyObjectProperty(BDTopoV2Workflow.class, (GroovyObject)h2gis_datasource, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{outputTableName}, new String[]{"", ""})))));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)count, (Object)0)) {
            CallSite geomToExtract = IndyInterface.bootstrap("getProperty", "THE_GEOM", 0, IndyInterface.bootstrap("invoke", "firstRow", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{Float.valueOf(distance), outputTableName}, new String[]{"SELECT ST_EXPAND(ST_UNION(ST_ACCUM(the_geom)), ", ") AS THE_GEOM FROM ", ""}))));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "bati_indifferencie", 0, inputTables)) != false) {
                outputTableName = "BATI_INDIFFERENCIE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "bati_indifferencie", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " as SELECT ID, ", ", HAUTEUR FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "bati_industriel", 0, inputTables)) != false) {
                outputTableName = "BATI_INDUSTRIEL";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "bati_industriel", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " as SELECT ID, ", ", NATURE, HAUTEUR FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "bati_remarquable", 0, inputTables)) != false) {
                outputTableName = "BATI_REMARQUABLE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "bati_remarquable", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " as SELECT ID, ", ", NATURE, HAUTEUR FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "route", 0, inputTables)) == false) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "The route table must be provided");
                return null;
            }
            outputTableName = "ROUTE";
            IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
            IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "route", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; \n            CREATE TABLE ", " as SELECT ID, ", ", NATURE, LARGEUR, POS_SOL, FRANCHISST, SENS,\n            IMPORTANCE, CL_ADMIN FROM ", "  \n            WHERE the_geom && 'SRID=", ";", "'::GEOMETRY \n            AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)\n            AND NATURE NOT IN ('Bac auto', 'Bac pi\u00e9ton', 'Escalier')"})));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "troncon_voie_ferree", 0, inputTables)) != false) {
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                outputTableName = "TRONCON_VOIE_FERREE";
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "troncon_voie_ferree", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " as SELECT ID,", ", NATURE, LARGEUR,NB_VOIES, POS_SOL, FRANCHISST FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "surface_eau", 0, inputTables)) != false) {
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                outputTableName = "SURFACE_EAU";
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "surface_eau", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " as SELECT ID, ", " , NATURE FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "zone_vegetation", 0, inputTables)) != false) {
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                outputTableName = "ZONE_VEGETATION";
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "zone_vegetation", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", "  AS SELECT ID, ", ", NATURE  FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "terrain_sport", 0, inputTables)) != false) {
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                outputTableName = "TERRAIN_SPORT";
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "terrain_sport", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " AS SELECT ID, ", ", NATURE  FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY) AND NATURE='Piste de sport'"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "construction_surfacique", 0, inputTables)) != false) {
                outputTableName = "CONSTRUCTION_SURFACIQUE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "construction_surfacique", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " AS SELECT ID, ", ", NATURE  FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY) AND (NATURE='Barrage' OR NATURE='Ecluse' OR NATURE='Escalier')"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "surface_route", 0, inputTables)) != false) {
                outputTableName = "SURFACE_ROUTE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "surface_route", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " AS SELECT ID, ", ",NATURE  FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "surface_activite", 0, inputTables)) != false) {
                outputTableName = "SURFACE_ACTIVITE";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "surface_activite", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " AS SELECT ID, ", ", CATEGORIE  FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY) AND (CATEGORIE='Administratif' OR CATEGORIE='Enseignement' OR CATEGORIE='Sant\u00e9')"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "piste_aerodrome", 0, inputTables)) != false) {
                outputTableName = "PISTE_AERODROME";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "piste_aerodrome", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", "  AS SELECT ID, ", ", NATURE  FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "reservoir", 0, inputTables)) != false) {
                outputTableName = "RESERVOIR";
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{outputTableName}, new String[]{"Loading in the H2GIS database ", ""}));
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, formatting_geom, IndyInterface.bootstrap("getProperty", "reservoir", 0, inputTables), sourceSRID, geomToExtract, sourceSRID, geomToExtract}, new String[]{"DROP TABLE IF EXISTS ", " ; CREATE TABLE ", " AS SELECT ID, ", ", NATURE, HAUTEUR  FROM ", "  WHERE the_geom && 'SRID=", ";", "'::GEOMETRY AND ST_INTERSECTS(the_geom, 'SRID=", ";", "'::GEOMETRY)"})));
            }
            return true;
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{location}, new String[]{"Cannot find any commune with the insee code : ", ""}));
        return null;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BDTopoV2Workflow.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ MetaClass super$6$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

