/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.geoclimate.bdtopo;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.locationtech.jts.geom.Polygon;
import org.orbisgis.data.H2GIS;
import org.orbisgis.data.jdbc.JdbcDataSource;
import org.orbisgis.geoclimate.Geoindicators;
import org.orbisgis.geoclimate.bdtopo.BDTopo;

public class InputDataFormatting
extends BDTopo {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public static void main(String ... args) {
        IndyInterface.bootstrap("invoke", "runScript", 0, InvokerHelper.class, InputDataFormatting.class, args);
    }

    public Object run() {
        InputDataFormatting bdTopo = this;
        return bdTopo;
    }

    public String formatBuildingLayer(JdbcDataSource datasource, String building, String zone, String urban_areas, float h_lev_min) {
        Reference datasource2 = new Reference((Object)datasource);
        Reference h_lev_min2 = new Reference((Object)Float.valueOf(h_lev_min));
        float f = DefaultTypeTransformation.floatUnbox((Object)h_lev_min2.get());
        if (!(f != 0.0f && !Float.isNaN(f))) {
            h_lev_min2.set((Object)Float.valueOf(3));
        }
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "BUILDING"));
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Formating building layer");
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{"DROP TABLE IF EXISTS ", ";\n            CREATE TABLE ", " (THE_GEOM geometry, ID_BUILD integer, ID_SOURCE varchar(24), \n            HEIGHT_WALL FLOAT, HEIGHT_ROOF FLOAT, NB_LEV INTEGER, TYPE VARCHAR, MAIN_USE VARCHAR, ZINDEX integer, ROOF_SHAPE VARCHAR);"})));
        if (IndyInterface.bootstrap("cast", "()", 0, building) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, (JdbcDataSource)datasource2.get(), building)) != false) {
            Reference queryMapper = new Reference((Object)"SELECT ");
            if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), building, "the_geom");
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), zone, "the_geom");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{building, zone}, new String[]{" a.*  FROM ", " as a,  ", " as b WHERE a.the_geom && b.the_geom and st_intersects(a.the_geom "}), ",b.the_geom) ")));
            } else {
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{building}, new String[]{"* FROM ", " as a  "})));
            }
            Reference types_uses_dictionnary = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"B\u00e2timent agricole", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"farm_auxiliary", "agricultural"}), "B\u00e2timent commercial", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"commercial", "commercial"}), "B\u00e2timent industriel", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"light_industry", "industrial"}), "Serre", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"greenhouse", "agricultural"}), "Silo", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"silo", "agricultural"}), "A\u00e9rogare", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"terminal", "transport"}), "Arc de triomphe", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"monument", "heritage"}), "Ar\u00e8ne ou th\u00e9\u00e2tre antique", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"monument", "monument"}), "B\u00e2timent religieux divers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"religious", "religious"}), "B\u00e2timent sportif", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sports_centre", "entertainment_arts_culture"}), "Chapelle", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"chapel", "religious"}), "Ch\u00e2teau", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"castle", "heritage"}), "Eglise", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"church", "religious"}), "Fort, blockhaus, casemate", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"military", "military"}), "Gare", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"train_station", "transport"}), "Mairie", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"townhall", "government"}), "Monument", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"monument", "monument"}), "P\u00e9age", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"toll_booth", "transport"}), "Pr\u00e9fecture", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"government", "government"}), "Sous-pr\u00e9fecture", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"government", "government"}), "Tour, donjon, moulin", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"historic", "heritage"}), "Moulin \u00e0 vent", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"historic", "heritage"}), "Tour, donjon", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"historic", "heritage"}), "Tribune", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"grandstand", "entertainment_arts_culture"}), "R\u00e9sidentiel", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"residential", "residential"}), "Agricole", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"agricultural", "agricultural"}), "Commercial et services", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"commercial", "commercial"}), "Industriel", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"industrial", "industrial"}), "Religieux", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"religious", "religious"}), "Sportif", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sport", "sport"}), "Annexe", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"annex", "building"}), "Industriel, agricole ou commercial", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"commercial", "commercial"}), "B\u00e2timent", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"building", "building"}), "Industrie lourde", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"heavy_industry", "industrial"})}));
            Reference building_type_level = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"building", 1, "annex", 0, "house", 1, "detached", 1, "residential", 1, "apartments", 1, "bungalow", 0, "historic", 0, "monument", 0, "ruins", 0, "castle", 0, "agricultural", 0, "farm", 0, "farm_auxiliary", 0, "barn", 0, "greenhouse", 0, "silo", 0, "commercial", 2, "industrial", 0, "sport", 0, "sports_centre", 0, "grandstand", 0, "transport", 0, "train_station", 0, "toll_booth", 0, "terminal", 0, "healthcare", 1, "education", 1, "entertainment_arts_culture", 0, "sustenance", 1, "military", 0, "religious", 0, "chapel", 0, "church", 0, "government", 1, "townhall", 1, "office", 1, "heavy_industry", 0, "light_industry", 0}));
            Reference id_build = new Reference((Object)1);
            public final class _formatBuildingLayer_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference datasource;
                private /* synthetic */ Reference queryMapper;
                private /* synthetic */ Reference types_uses_dictionnary;
                private /* synthetic */ Reference h_lev_min;
                private /* synthetic */ Reference building_type_level;
                private /* synthetic */ Reference outputTableName;
                private /* synthetic */ Reference id_build;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _formatBuildingLayer_closure1(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference types_uses_dictionnary, Reference h_lev_min, Reference building_type_level, Reference outputTableName, Reference id_build) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    this.datasource = reference7 = datasource;
                    this.queryMapper = reference6 = queryMapper;
                    this.types_uses_dictionnary = reference5 = types_uses_dictionnary;
                    this.h_lev_min = reference4 = h_lev_min;
                    this.building_type_level = reference3 = building_type_level;
                    this.outputTableName = reference2 = outputTableName;
                    this.id_build = reference = id_build;
                }

                public Object doCall(Object stmt) {
                    Reference stmt2 = new Reference(stmt);
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference types_uses_dictionnary;
                        private /* synthetic */ Reference h_lev_min;
                        private /* synthetic */ Reference building_type_level;
                        private /* synthetic */ Reference stmt;
                        private /* synthetic */ Reference outputTableName;
                        private /* synthetic */ Reference id_build;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure8(Object _outerInstance, Object _thisObject, Reference types_uses_dictionnary, Reference h_lev_min, Reference building_type_level, Reference stmt, Reference outputTableName, Reference id_build) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            Reference reference5;
                            Reference reference6;
                            this.types_uses_dictionnary = reference6 = types_uses_dictionnary;
                            this.h_lev_min = reference5 = h_lev_min;
                            this.building_type_level = reference4 = building_type_level;
                            this.stmt = reference3 = stmt;
                            this.outputTableName = reference2 = outputTableName;
                            this.id_build = reference = id_build;
                        }

                        public Object doCall(Object row) {
                            CallSite values = IndyInterface.bootstrap("invoke", "toRowResult", 0, row);
                            CallSite id_source = IndyInterface.bootstrap("getProperty", "ID_SOURCE", 0, values);
                            CallSite type_use = IndyInterface.bootstrap("invoke", "getTypeAndUse", 2, this, IndyInterface.bootstrap("getProperty", "TYPE", 0, values), IndyInterface.bootstrap("getProperty", "MAIN_USE", 0, values), this.types_uses_dictionnary.get());
                            CallSite feature_type = IndyInterface.bootstrap("invoke", "getAt", 0, type_use, false);
                            CallSite feature_main_use = IndyInterface.bootstrap("invoke", "getAt", 0, type_use, true);
                            Object height_wall = IndyInterface.bootstrap("getProperty", "HEIGHT_WALL", 0, values);
                            Object height_roof = IndyInterface.bootstrap("getProperty", "HEIGHT_ROOF", 0, values);
                            Integer nb_lev = 0;
                            if (IndyInterface.bootstrap("cast", "()", 0, height_wall) == false) {
                                height_wall = 0;
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, height_roof) == false && DefaultTypeTransformation.booleanUnbox((Object)height_wall)) {
                                height_roof = height_wall;
                            }
                            CallSite formatedHeight = IndyInterface.bootstrap("invoke", "formatHeightsAndNbLevels", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), height_wall, height_roof, nb_lev, IndyInterface.bootstrap("cast", "()", 0, this.h_lev_min.get()), feature_type, this.building_type_level.get());
                            Integer zIndex = 0;
                            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "nbLevels", 0, formatedHeight), (Object)0)) {
                                CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, values));
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, geom)) == false) {
                                    CallSite srid = IndyInterface.bootstrap("invoke", "getSRID", 0, geom);
                                    int i = 0;
                                    while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                        CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                        if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                            IndyInterface.bootstrap("invoke", "addBatch", 0, this.stmt.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.outputTableName.get(), subGeom, srid, this.id_build.get(), id_source, IndyInterface.bootstrap("getProperty", "heightWall", 0, formatedHeight), IndyInterface.bootstrap("getProperty", "heightRoof", 0, formatedHeight), IndyInterface.bootstrap("getProperty", "nbLevels", 0, formatedHeight), feature_type, feature_main_use, zIndex}, new String[]{"\n                                                INSERT INTO ", " values(\n                                                    ST_GEOMFROMTEXT('", "',", "), \n                                                    ", ", \n                                                    '", "',\n                                                    ", ",\n                                                    ", ",\n                                                    ", ",\n                                                    '", "',\n                                                    '", "',\n                                                    ", ", null)\n                                            "})));
                                            Object object = this.id_build.get();
                                            this.id_build.set((Object)IndyInterface.bootstrap("invoke", "next", 0, object));
                                        }
                                        int n = i;
                                        i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                    }
                                    return null;
                                }
                            }
                            return null;
                        }

                        @Generated
                        public Object getTypes_uses_dictionnary() {
                            return this.types_uses_dictionnary.get();
                        }

                        @Generated
                        public float getH_lev_min() {
                            return ((Float)((Object)IndyInterface.bootstrap("cast", "()", 0, this.h_lev_min.get()))).floatValue();
                        }

                        @Generated
                        public Object getBuilding_type_level() {
                            return this.building_type_level.get();
                        }

                        @Generated
                        public Object getStmt() {
                            return this.stmt.get();
                        }

                        @Generated
                        public Object getOutputTableName() {
                            return this.outputTableName.get();
                        }

                        @Generated
                        public Object getId_build() {
                            return this.id_build.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, this.queryMapper.get()), new _closure8((Object)this, this.getThisObject(), this.types_uses_dictionnary, this.h_lev_min, this.building_type_level, stmt2, this.outputTableName, this.id_build));
                }

                @Generated
                public JdbcDataSource getDatasource() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                }

                @Generated
                public Object getQueryMapper() {
                    return this.queryMapper.get();
                }

                @Generated
                public Object getTypes_uses_dictionnary() {
                    return this.types_uses_dictionnary.get();
                }

                @Generated
                public float getH_lev_min() {
                    return ((Float)((Object)IndyInterface.bootstrap("cast", "()", 0, this.h_lev_min.get()))).floatValue();
                }

                @Generated
                public Object getBuilding_type_level() {
                    return this.building_type_level.get();
                }

                @Generated
                public Object getOutputTableName() {
                    return this.outputTableName.get();
                }

                @Generated
                public Object getId_build() {
                    return this.id_build.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _formatBuildingLayer_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatBuildingLayer_closure1((Object)this, (Object)this, datasource2, queryMapper, types_uses_dictionnary, h_lev_min2, building_type_level, outputTableName, id_build));
            if (IndyInterface.bootstrap("cast", "()", 0, urban_areas) != false) {
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), outputTableName.get(), "the_geom");
                IndyInterface.bootstrap("invoke", "createIndex", 0, (JdbcDataSource)datasource2.get(), outputTableName.get(), "id_build");
                IndyInterface.bootstrap("invoke", "createIndex", 0, (JdbcDataSource)datasource2.get(), outputTableName.get(), "type");
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), urban_areas, "the_geom");
                CallSite buildinType = IndyInterface.bootstrap("invoke", "postfix", 2, this, "BUILDING_TYPE");
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{buildinType, outputTableName.get(), urban_areas}, new String[]{"create table ", " as SELECT \n                        max(b.type) as type, \n                        max(b.type) as main_use, a.id_build FROM ", " a, ", " b \n                        WHERE ST_POINTONSURFACE(a.the_geom) && b.the_geom and st_intersects(ST_POINTONSURFACE(a.the_geom), b.the_geom) \n                        AND  a.TYPE ='building' AND b.TYPE != 'unknown'\n                         group by a.id_build"})));
                IndyInterface.bootstrap("invoke", "createIndex", 0, (JdbcDataSource)datasource2.get(), buildinType, "id_build");
                CallSite newBuildingWithType = IndyInterface.bootstrap("invoke", "postfix", 2, this, "NEW_BUILDING_TYPE");
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{newBuildingWithType, newBuildingWithType, outputTableName.get(), buildinType}, new String[]{"DROP TABLE IF EXISTS ", ";\n                                           CREATE TABLE ", " as\n                                            SELECT  a.THE_GEOM, a.ID_BUILD,a.ID_SOURCE,\n                                            a.HEIGHT_WALL,\n                                            a.HEIGHT_ROOF,\n                                               a.NB_LEV, \n                                               COALESCE(b.TYPE, a.TYPE) AS TYPE ,\n                                               COALESCE(b.MAIN_USE, a.MAIN_USE) AS MAIN_USE\n                                               , a.ZINDEX, a.ROOF_SHAPE from ", "\n                                        a LEFT JOIN ", " b on a.id_build=b.id_build"})));
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{buildinType, outputTableName.get(), newBuildingWithType, outputTableName.get(), newBuildingWithType}, new String[]{"DROP TABLE IF EXISTS ", ", ", ";\n                        ALTER TABLE ", " RENAME TO ", ";\n                        DROP TABLE IF EXISTS ", ";"})));
            }
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Buildings transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public static String[] getTypeAndUse(Object main_type, Object main_use, Object types_and_uses) {
        Object feature_type = "building";
        Object feature_main_use = "building";
        if (DefaultTypeTransformation.booleanUnbox((Object)main_type) && DefaultTypeTransformation.booleanUnbox((Object)main_use)) {
            CallSite tmp_type_use_from_main_type = IndyInterface.bootstrap("invoke", "get", 0, types_and_uses, IndyInterface.bootstrap("invoke", "trim", 0, main_type));
            CallSite tmp_type_use_from_main_use = IndyInterface.bootstrap("invoke", "get", 0, types_and_uses, IndyInterface.bootstrap("invoke", "trim", 0, main_use));
            feature_type = IndyInterface.bootstrap("getProperty", "key", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "grep", 0, tmp_type_use_from_main_type), false));
            feature_main_use = IndyInterface.bootstrap("getProperty", "key", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "grep", 0, tmp_type_use_from_main_use), false));
        } else if (IndyInterface.bootstrap("cast", "()", 0, main_type) == false && DefaultTypeTransformation.booleanUnbox((Object)main_use)) {
            CallSite tmp_type_use_from_main_use = IndyInterface.bootstrap("invoke", "get", 0, types_and_uses, IndyInterface.bootstrap("invoke", "trim", 0, main_use));
            feature_type = IndyInterface.bootstrap("getProperty", "key", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "grep", 0, tmp_type_use_from_main_use), false));
            feature_main_use = feature_type;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)main_type) && IndyInterface.bootstrap("cast", "()", 0, main_use) == false) {
            CallSite tmp_type_use_from_main_type = IndyInterface.bootstrap("invoke", "get", 0, types_and_uses, IndyInterface.bootstrap("invoke", "trim", 0, main_type));
            CallSite type_main = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "grep", 0, tmp_type_use_from_main_type), false);
            feature_type = IndyInterface.bootstrap("getProperty", "key", 0, type_main);
            feature_main_use = IndyInterface.bootstrap("getProperty", "value", 0, type_main);
        }
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{feature_type, feature_main_use}));
    }

    public String formatRoadLayer(JdbcDataSource datasource, String road, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Formating road layer");
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "ROAD"));
        IndyInterface.bootstrap("invoke", "call", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{"\n            DROP TABLE IF EXISTS ", ";\n            CREATE TABLE ", " (THE_GEOM GEOMETRY, id_road serial, ID_SOURCE VARCHAR, WIDTH FLOAT, TYPE VARCHAR, CROSSING VARCHAR(30),\n                SURFACE VARCHAR, SIDEWALK VARCHAR, MAXSPEED INTEGER, DIRECTION INTEGER, ZINDEX INTEGER);\n        "})));
        if (IndyInterface.bootstrap("cast", "()", 0, road) != false) {
            Reference road_types_width = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"highway", 8, "motorway", 24, "trunk", 16, "primary", 10, "secondary", 10, "tertiary", 8, "residential", 8, "unclassified", 3, "track", 2, "path", 2, "footway", 2, "cycleway", 2, "steps", 2, "highway_link", 8, "roundabout", 4, "ferry", 0, "pedestrian", 3, "service", 3}));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, (JdbcDataSource)datasource2.get(), road)) != false) {
                Reference queryMapper = new Reference((Object)"SELECT a.ID_SOURCE, a.WIDTH, a.TYPE, a.ZINDEX, a.CROSSING, a.DIRECTION, a.RANK, a.ADMIN_SCALE");
                if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), road, "the_geom");
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", ST_CollectionExtract(st_intersection(a.the_geom, b.the_geom), 2) as the_geom ", "FROM "), new GStringImpl(new Object[]{road, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom ")));
                } else {
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{road}, new String[]{", a.the_geom FROM ", "  as a"})));
                }
                Reference rowcount = new Reference((Object)1);
                public final class _formatRoadLayer_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference datasource;
                    private /* synthetic */ Reference queryMapper;
                    private /* synthetic */ Reference road_types_width;
                    private /* synthetic */ Reference outputTableName;
                    private /* synthetic */ Reference rowcount;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _formatRoadLayer_closure2(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference road_types_width, Reference outputTableName, Reference rowcount) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        this.datasource = reference5 = datasource;
                        this.queryMapper = reference4 = queryMapper;
                        this.road_types_width = reference3 = road_types_width;
                        this.outputTableName = reference2 = outputTableName;
                        this.rowcount = reference = rowcount;
                    }

                    public Object doCall(Object stmt) {
                        Reference stmt2 = new Reference(stmt);
                        public final class _closure9
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference road_types_width;
                            private /* synthetic */ Reference stmt;
                            private /* synthetic */ Reference outputTableName;
                            private /* synthetic */ Reference rowcount;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure9(Object _outerInstance, Object _thisObject, Reference road_types_width, Reference stmt, Reference outputTableName, Reference rowcount) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                this.road_types_width = reference4 = road_types_width;
                                this.stmt = reference3 = stmt;
                                this.outputTableName = reference2 = outputTableName;
                                this.rowcount = reference = rowcount;
                            }

                            public Object doCall(Object row) {
                                Integer qualified_road_maxspeed = 50;
                                String qualified_road_type = "unclassified";
                                String qualified_road_surface = "asphalt";
                                String qualified_sidewalk = "no";
                                Object qualified_road_width = 3;
                                String qualified_crossing = null;
                                Object qualified_road_zindex = IndyInterface.bootstrap("getProperty", "ZINDEX", 0, row);
                                CallSite road_rank = IndyInterface.bootstrap("getProperty", "RANK", 0, row);
                                CallSite callSite = IndyInterface.bootstrap("getProperty", "TYPE", 0, row);
                                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Autoroute")) {
                                    qualified_road_maxspeed = 130;
                                    qualified_road_type = "motorway";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Type autoroutier")) {
                                    qualified_road_maxspeed = 130;
                                    qualified_road_type = "motorway";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Quasi-autoroute")) {
                                    qualified_road_maxspeed = 130;
                                    qualified_road_type = "trunk";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Bretelle")) {
                                    qualified_road_maxspeed = 50;
                                    qualified_road_type = "highway_link";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Route \u00e0 2 chauss\u00e9es")) {
                                    qualified_road_maxspeed = 80;
                                    qualified_road_type = "primary";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                    if (ScriptBytecodeAdapter.compareEqual((Object)road_rank, (Object)6)) {
                                        qualified_road_maxspeed = 0;
                                    } else if (ScriptBytecodeAdapter.compareEqual((Object)road_rank, (Object)5)) {
                                        qualified_road_maxspeed = 30;
                                    }
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Route \u00e0 1 chauss\u00e9e")) {
                                    if (ScriptBytecodeAdapter.compareEqual((Object)road_rank, (Object)6)) {
                                        qualified_road_maxspeed = 0;
                                    } else if (ScriptBytecodeAdapter.compareEqual((Object)road_rank, (Object)5)) {
                                        qualified_road_maxspeed = 30;
                                    } else if (ScriptBytecodeAdapter.compareLessThanEqual((Object)road_rank, (Object)4)) {
                                        qualified_road_maxspeed = 80;
                                    }
                                    qualified_road_type = "unclassified";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Route empierr\u00e9e")) {
                                    qualified_road_surface = "paved";
                                    qualified_road_maxspeed = 10;
                                    qualified_road_type = "track";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Chemin")) {
                                    qualified_road_surface = "ground";
                                    qualified_road_maxspeed = 0;
                                    qualified_road_type = "track";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Sentier")) {
                                    qualified_road_surface = "ground";
                                    qualified_road_maxspeed = 0;
                                    qualified_road_type = "path";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Pont")) {
                                    qualified_road_maxspeed = 0;
                                    qualified_road_type = "bridge";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"NC")) {
                                    qualified_road_maxspeed = 0;
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Rond-point")) {
                                    qualified_road_maxspeed = 30;
                                    qualified_road_type = "roundabout";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"Piste cyclable")) {
                                    qualified_road_maxspeed = 0;
                                    qualified_road_type = "cycleway";
                                    qualified_road_width = IndyInterface.bootstrap("invoke", "get", 0, this.road_types_width.get(), qualified_road_type);
                                }
                                CallSite width = IndyInterface.bootstrap("getProperty", "WIDTH", 0, row);
                                if (DefaultTypeTransformation.booleanUnbox((Object)width) || ScriptBytecodeAdapter.compareGreaterThan((Object)width, (Object)0)) {
                                    qualified_road_width = width;
                                }
                                CallSite road_crossing = IndyInterface.bootstrap("getProperty", "CROSSING", 0, row);
                                if (ScriptBytecodeAdapter.compareEqual((Object)road_crossing, (Object)"Gu\u00e9 ou radier")) {
                                    qualified_crossing = "crossing";
                                    qualified_road_zindex = 0;
                                } else if (ScriptBytecodeAdapter.compareEqual((Object)road_crossing, (Object)"Pont")) {
                                    qualified_crossing = "bridge";
                                    if (IndyInterface.bootstrap("cast", "()", 0, qualified_road_zindex) == false) {
                                        qualified_road_zindex = 1;
                                    }
                                } else if (ScriptBytecodeAdapter.compareEqual((Object)road_crossing, (Object)"NC")) {
                                    qualified_crossing = null;
                                }
                                Object road_sens = IndyInterface.bootstrap("getProperty", "DIRECTION", 0, row);
                                road_sens = ScriptBytecodeAdapter.compareEqual((Object)road_sens, (Object)"Double") ? Integer.valueOf(3) : (ScriptBytecodeAdapter.compareEqual((Object)road_sens, (Object)"Direct") ? Integer.valueOf(1) : (ScriptBytecodeAdapter.compareEqual((Object)road_sens, (Object)"Inverse") ? Integer.valueOf(2) : Integer.valueOf(-1)));
                                CallSite ID_SOURCE = IndyInterface.bootstrap("getProperty", "ID_SOURCE", 0, row);
                                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)qualified_road_zindex, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)qualified_road_type, (Object)"path")) {
                                    CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, geom)) == false) {
                                        CallSite epsg = IndyInterface.bootstrap("invoke", "getSRID", 0, geom);
                                        int i = 0;
                                        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                            CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, subGeom)) == false) {
                                                Object object = this.stmt.get();
                                                Object[] objectArray = new Object[13];
                                                objectArray[0] = this.outputTableName.get();
                                                objectArray[1] = subGeom;
                                                objectArray[2] = epsg;
                                                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                                this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite2)));
                                                objectArray[3] = callSite2;
                                                objectArray[4] = ID_SOURCE;
                                                objectArray[5] = qualified_road_width;
                                                objectArray[6] = qualified_road_type;
                                                objectArray[7] = IndyInterface.bootstrap("cast", "()", 0, qualified_crossing) != false ? new GStringImpl(new Object[]{qualified_crossing}, new String[]{"'", "'"}) : qualified_crossing;
                                                objectArray[8] = qualified_road_surface;
                                                objectArray[9] = qualified_sidewalk;
                                                objectArray[10] = qualified_road_maxspeed;
                                                objectArray[11] = road_sens;
                                                objectArray[12] = qualified_road_zindex;
                                                IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"\n                                        INSERT INTO ", " VALUES(ST_GEOMFROMTEXT(\n                                        '", "',", "), \n                                        ", ", \n                                        '", "', \n                                        ", ",\n                                        '", "',\n                                        ", ", \n                                        '", "',\n                                        '", "',\n                                        ", ",\n                                        ", ",\n                                        ", ")\n                                        "})));
                                            }
                                            int n = i;
                                            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                        }
                                        return null;
                                    }
                                }
                                return null;
                            }

                            @Generated
                            public Object getRoad_types_width() {
                                return this.road_types_width.get();
                            }

                            @Generated
                            public Object getStmt() {
                                return this.stmt.get();
                            }

                            @Generated
                            public Object getOutputTableName() {
                                return this.outputTableName.get();
                            }

                            @Generated
                            public Integer getRowcount() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure9.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), this.queryMapper.get(), new _closure9((Object)this, this.getThisObject(), this.road_types_width, stmt2, this.outputTableName, this.rowcount));
                    }

                    @Generated
                    public JdbcDataSource getDatasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                    }

                    @Generated
                    public Object getQueryMapper() {
                        return this.queryMapper.get();
                    }

                    @Generated
                    public Object getRoad_types_width() {
                        return this.road_types_width.get();
                    }

                    @Generated
                    public Object getOutputTableName() {
                        return this.outputTableName.get();
                    }

                    @Generated
                    public Integer getRowcount() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _formatRoadLayer_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatRoadLayer_closure2((Object)this, (Object)this, datasource2, queryMapper, road_types_width, outputTableName, rowcount));
            }
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Roads transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatHydroLayer(JdbcDataSource datasource, String water, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Hydro transformation starts");
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "HYDRO"));
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{"Drop table if exists ", ";\n                    CREATE TABLE ", " (THE_GEOM GEOMETRY, ID_WATER serial, ID_SOURCE VARCHAR, TYPE VARCHAR, ZINDEX INTEGER);"})));
        if (IndyInterface.bootstrap("cast", "()", 0, water) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, (JdbcDataSource)datasource2.get(), water)) != false) {
            Reference query = new Reference(null);
            String cfr_ignored_0 = (String)query.get();
            if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), water, "the_geom");
                query.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "select st_intersection(a.the_geom, b.the_geom) as the_geom ", ", a.ZINDEX, a.ID_SOURCE, a.TYPE "), " FROM "), new GStringImpl(new Object[]{water, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom ")));
            } else {
                query.set((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{water}, new String[]{"select * FROM ", " "})));
            }
            Reference water_types = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Aqueduc", "aqueduct", "Canal", "canal", "Delta", "bay", "Ecoulement canalis\u00e9", "canal", "Ecoulement endor\u00e9ique", "water", "Ecoulement hyporh\u00e9ique", "water", "Ecoulement karstique", "water", "Ecoulement naturel", "water", "Ecoulement phr\u00e9atique", "water", "Estuaire", "bay", "Inconnue", "water", "Lac", "lake", "Lagune", "lagoon", "Mangrove", "mangrove", "Mare", "pond", "Plan d'eau de gravi\u00e8re", "pond", "Plan d'eau de mine", "basin", "Ravine", "water", "R\u00e9servoir-bassin", "basin", "R\u00e9servoir-bassin d'orage", "basin", "R\u00e9servoir-bassin piscicole", "basin", "Retenue", "basin", "Retenuebarrage", "basin", "Retenue-bassin portuaire", "basin", "Retenue-digue", "basin", "Surface d'eau", "water", "Bassin", "basin"}));
            Reference rowcount = new Reference((Object)1);
            public final class _formatHydroLayer_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference datasource;
                private /* synthetic */ Reference query;
                private /* synthetic */ Reference water_types;
                private /* synthetic */ Reference outputTableName;
                private /* synthetic */ Reference rowcount;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _formatHydroLayer_closure3(Object _outerInstance, Object _thisObject, Reference datasource, Reference query, Reference water_types, Reference outputTableName, Reference rowcount) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    this.datasource = reference5 = datasource;
                    this.query = reference4 = query;
                    this.water_types = reference3 = water_types;
                    this.outputTableName = reference2 = outputTableName;
                    this.rowcount = reference = rowcount;
                }

                public Object doCall(Object stmt) {
                    Reference stmt2 = new Reference(stmt);
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference water_types;
                        private /* synthetic */ Reference stmt;
                        private /* synthetic */ Reference outputTableName;
                        private /* synthetic */ Reference rowcount;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure10(Object _outerInstance, Object _thisObject, Reference water_types, Reference stmt, Reference outputTableName, Reference rowcount) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            this.water_types = reference4 = water_types;
                            this.stmt = reference3 = stmt;
                            this.outputTableName = reference2 = outputTableName;
                            this.rowcount = reference = rowcount;
                        }

                        public Object doCall(Object row) {
                            CallSite water_type = IndyInterface.bootstrap("invoke", "get", 0, this.water_types.get(), IndyInterface.bootstrap("getProperty", "TYPE", 0, row));
                            Integer water_zindex = 0;
                            if (IndyInterface.bootstrap("cast", "()", 0, water_type) != false) {
                                CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, geom)) == false) {
                                    CallSite epsg = IndyInterface.bootstrap("invoke", "getSRID", 0, geom);
                                    int i = 0;
                                    while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                        CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                        if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                            Object object = this.stmt.get();
                                            Object[] objectArray = new Object[7];
                                            objectArray[0] = this.outputTableName.get();
                                            objectArray[1] = subGeom;
                                            objectArray[2] = epsg;
                                            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                            this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                            objectArray[3] = callSite;
                                            objectArray[4] = IndyInterface.bootstrap("getProperty", "ID_SOURCE", 0, row);
                                            objectArray[5] = water_type;
                                            objectArray[6] = water_zindex;
                                            IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"insert into ", " values(ST_GEOMFROMTEXT('", "',", "), ", ", '", "', '", "', ", ")"})));
                                        }
                                        int n = i;
                                        i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                    }
                                    return null;
                                }
                            }
                            return null;
                        }

                        @Generated
                        public Object getWater_types() {
                            return this.water_types.get();
                        }

                        @Generated
                        public Object getStmt() {
                            return this.stmt.get();
                        }

                        @Generated
                        public Object getOutputTableName() {
                            return this.outputTableName.get();
                        }

                        @Generated
                        public Integer getRowcount() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), IndyInterface.bootstrap("cast", "()", 0, this.query.get()), new _closure10((Object)this, this.getThisObject(), this.water_types, stmt2, this.outputTableName, this.rowcount));
                }

                @Generated
                public JdbcDataSource getDatasource() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                }

                @Generated
                public String getQuery() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.query.get());
                }

                @Generated
                public Object getWater_types() {
                    return this.water_types.get();
                }

                @Generated
                public Object getOutputTableName() {
                    return this.outputTableName.get();
                }

                @Generated
                public Integer getRowcount() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _formatHydroLayer_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatHydroLayer_closure3((Object)this, (Object)this, datasource2, query, water_types, outputTableName, rowcount));
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Hydro transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatRailsLayer(JdbcDataSource datasource, String rail, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Rails transformation starts");
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "RAILS"));
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{" drop table if exists ", ";\n                CREATE TABLE ", " (THE_GEOM GEOMETRY, id_rail serial,\n                ID_SOURCE VARCHAR, TYPE VARCHAR,CROSSING VARCHAR(30), ZINDEX INTEGER, WIDTH FLOAT, USAGE VARCHAR(30));"})));
        if (IndyInterface.bootstrap("cast", "()", 0, rail) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, (JdbcDataSource)datasource2.get(), rail)) != false) {
            Reference queryMapper = new Reference((Object)"SELECT a.ID_SOURCE, a.TYPE, a.ZINDEX, a.CROSSING, a.WIDTH");
            if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), rail, "the_geom");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", st_intersection(a.the_geom, b.the_geom) as the_geom ", "FROM "), new GStringImpl(new Object[]{rail, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom ")));
            } else {
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{rail}, new String[]{", a.the_geom FROM ", "  as a"})));
            }
            Reference rail_types = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"LGV", "highspeed", "Principale", "rail", "Voie ferr\u00e9e principale", "rail", "Voie de service", "service_track", "Voie non exploit\u00e9e", "disused", "Transport urbain", "tram", "Funiculaire ou cr\u00e9maill\u00e8re", "funicular", "Metro", "subway", "M\u00e9tro", "subway", "Tramway", "tram", "Pont", "bridge", "Tunnel", "tunnel", "Sans objet", null, "NC", null}));
            Reference rowcount = new Reference((Object)1);
            public final class _formatRailsLayer_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference datasource;
                private /* synthetic */ Reference queryMapper;
                private /* synthetic */ Reference rail_types;
                private /* synthetic */ Reference outputTableName;
                private /* synthetic */ Reference rowcount;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _formatRailsLayer_closure4(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference rail_types, Reference outputTableName, Reference rowcount) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    this.datasource = reference5 = datasource;
                    this.queryMapper = reference4 = queryMapper;
                    this.rail_types = reference3 = rail_types;
                    this.outputTableName = reference2 = outputTableName;
                    this.rowcount = reference = rowcount;
                }

                public Object doCall(Object stmt) {
                    Reference stmt2 = new Reference(stmt);
                    public final class _closure11
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference rail_types;
                        private /* synthetic */ Reference stmt;
                        private /* synthetic */ Reference outputTableName;
                        private /* synthetic */ Reference rowcount;
                        private static /* synthetic */ BigDecimal $const$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure11(Object _outerInstance, Object _thisObject, Reference rail_types, Reference stmt, Reference outputTableName, Reference rowcount) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            this.rail_types = reference4 = rail_types;
                            this.stmt = reference3 = stmt;
                            this.outputTableName = reference2 = outputTableName;
                            this.rowcount = reference = rowcount;
                        }

                        public Object doCall(Object row) {
                            Object rail_type = IndyInterface.bootstrap("getProperty", "TYPE", 0, row);
                            rail_type = IndyInterface.bootstrap("cast", "()", 0, rail_type) != false ? IndyInterface.bootstrap("invoke", "get", 0, this.rail_types.get(), rail_type) : "unclassified";
                            String rail_usage = null;
                            if (ScriptBytecodeAdapter.isCase((Object)rail_type, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"highspeed", "rail", "tram", "bridge"}))) {
                                rail_usage = "main";
                            }
                            Object rail_zindex = IndyInterface.bootstrap("getProperty", "ZINDEX", 0, row);
                            if (IndyInterface.bootstrap("cast", "()", 0, rail_zindex) == false) {
                                rail_zindex = 0;
                            }
                            CallSite rail_width = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "WIDTH", 0, row)) == false ? IndyInterface.bootstrap("invoke", "plus", 0, $const$0, true) : IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "WIDTH", 0, row), true);
                            CallSite rail_crossing = IndyInterface.bootstrap("invoke", "get", 0, this.rail_types.get(), IndyInterface.bootstrap("getProperty", "CROSSING", 0, row));
                            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)rail_zindex, (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)rail_type)) {
                                CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, geom)) == false) {
                                    CallSite epsg = IndyInterface.bootstrap("invoke", "getSRID", 0, geom);
                                    int i = 0;
                                    while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                        CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, subGeom)) == false) {
                                            Object object = this.stmt.get();
                                            Object[] objectArray = new Object[10];
                                            objectArray[0] = this.outputTableName.get();
                                            objectArray[1] = subGeom;
                                            objectArray[2] = epsg;
                                            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                            this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                            objectArray[3] = callSite;
                                            objectArray[4] = IndyInterface.bootstrap("getProperty", "ID_SOURCE", 0, row);
                                            objectArray[5] = rail_type;
                                            objectArray[6] = IndyInterface.bootstrap("cast", "()", 0, rail_crossing) != false ? new GStringImpl(new Object[]{rail_crossing}, new String[]{"'", "'"}) : rail_crossing;
                                            objectArray[7] = rail_zindex;
                                            objectArray[8] = rail_width;
                                            objectArray[9] = IndyInterface.bootstrap("cast", "()", 0, rail_usage) != false ? new GStringImpl(new Object[]{rail_usage}, new String[]{"'", "'"}) : rail_usage;
                                            IndyInterface.bootstrap("invoke", "addBatch", 0, object, new GStringImpl(objectArray, new String[]{"\n                                    INSERT INTO ", " values(ST_GEOMFROMTEXT(\n                                    '", "',", "), \n                                    ", ", \n                                    '", "',\n                                    '", "',\n                                    ", ",\n                                    ", ",\n                                    ", ",\n                                    ", ")\n                                "}));
                                        }
                                        int n = i;
                                        i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                    }
                                    return null;
                                }
                            }
                            return null;
                        }

                        @Generated
                        public Object getRail_types() {
                            return this.rail_types.get();
                        }

                        @Generated
                        public Object getStmt() {
                            return this.stmt.get();
                        }

                        @Generated
                        public Object getOutputTableName() {
                            return this.outputTableName.get();
                        }

                        @Generated
                        public Integer getRowcount() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure11.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }

                        public static /* synthetic */ void __$swapInit() {
                            BigDecimal bigDecimal;
                            $const$0 = bigDecimal = new BigDecimal("1.435");
                        }

                        static {
                            _closure11.__$swapInit();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, this.queryMapper.get()), new _closure11((Object)this, this.getThisObject(), this.rail_types, stmt2, this.outputTableName, this.rowcount));
                }

                @Generated
                public JdbcDataSource getDatasource() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                }

                @Generated
                public Object getQueryMapper() {
                    return this.queryMapper.get();
                }

                @Generated
                public Object getRail_types() {
                    return this.rail_types.get();
                }

                @Generated
                public Object getOutputTableName() {
                    return this.outputTableName.get();
                }

                @Generated
                public Integer getRowcount() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _formatRailsLayer_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatRailsLayer_closure4((Object)this, (Object)this, datasource2, queryMapper, rail_types, outputTableName, rowcount));
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Rails transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatVegetationLayer(JdbcDataSource datasource, String vegetation, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Vegetation transformation starts");
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "VEGET"));
        IndyInterface.bootstrap("invoke", "call", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{" \n                DROP TABLE IF EXISTS ", ";\n                CREATE TABLE ", " (THE_GEOM GEOMETRY, id_veget serial, ID_SOURCE VARCHAR, TYPE VARCHAR, HEIGHT_CLASS VARCHAR(4), ZINDEX INTEGER);"})));
        if (IndyInterface.bootstrap("cast", "()", 0, vegetation) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, (JdbcDataSource)datasource2.get(), vegetation)) != false) {
            Reference queryMapper = new Reference((Object)"SELECT a.ID_SOURCE, a.TYPE, a.ZINDEX");
            if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), vegetation, "the_geom");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", st_intersection(a.the_geom, b.the_geom) as the_geom ", "FROM "), new GStringImpl(new Object[]{vegetation, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom ")));
            } else {
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{vegetation}, new String[]{", a.the_geom FROM ", "  as a"})));
            }
            Reference vegetation_types = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Zone arbor\u00e9e", "wood", "For\u00eat ferm\u00e9e de feuillus", "forest", "For\u00eat ferm\u00e9e mixte", "forest", "For\u00eat ferm\u00e9e de conif\u00e8res", "forest", "For\u00eat ouverte", "forest", "Peupleraie", "forest", "Haie", "hedge", "Lande ligneuse", "heath", "Verger", "orchard", "Vigne", "vineyard", "Bois", "forest", "Bananeraie", "banana_plants", "Mangrove", "mangrove", "Canne \u00e0 sucre", "sugar_cane", "Houblonni\u00e8re", "hops", "Rizi\u00e8re", "rice_field", "Piste en herbe", "grass", "Terrain de football", "grass", "Terrain de rugby", "grass", "Marais", "marsh"}));
            Reference vegetation_classes = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tree", "high", "wood", "high", "forest", "high", "scrub", "low", "grassland", "low", "heath", "low", "tree_row", "high", "hedge", "high", "mangrove", "high", "orchard", "high", "vineyard", "low", "banana_plants", "high", "sugar_cane", "low", "unclassified", "low", "hops", "low", "rice_field", "low", "grass", "low", "marsh", "low"}));
            Reference rowcount = new Reference((Object)1);
            public final class _formatVegetationLayer_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference datasource;
                private /* synthetic */ Reference queryMapper;
                private /* synthetic */ Reference vegetation_types;
                private /* synthetic */ Reference vegetation_classes;
                private /* synthetic */ Reference outputTableName;
                private /* synthetic */ Reference rowcount;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _formatVegetationLayer_closure5(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference vegetation_types, Reference vegetation_classes, Reference outputTableName, Reference rowcount) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    this.datasource = reference6 = datasource;
                    this.queryMapper = reference5 = queryMapper;
                    this.vegetation_types = reference4 = vegetation_types;
                    this.vegetation_classes = reference3 = vegetation_classes;
                    this.outputTableName = reference2 = outputTableName;
                    this.rowcount = reference = rowcount;
                }

                public Object doCall(Object stmt) {
                    Reference stmt2 = new Reference(stmt);
                    public final class _closure12
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference vegetation_types;
                        private /* synthetic */ Reference vegetation_classes;
                        private /* synthetic */ Reference stmt;
                        private /* synthetic */ Reference outputTableName;
                        private /* synthetic */ Reference rowcount;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure12(Object _outerInstance, Object _thisObject, Reference vegetation_types, Reference vegetation_classes, Reference stmt, Reference outputTableName, Reference rowcount) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            Reference reference5;
                            this.vegetation_types = reference5 = vegetation_types;
                            this.vegetation_classes = reference4 = vegetation_classes;
                            this.stmt = reference3 = stmt;
                            this.outputTableName = reference2 = outputTableName;
                            this.rowcount = reference = rowcount;
                        }

                        public Object doCall(Object row) {
                            Object vegetation_type = IndyInterface.bootstrap("getProperty", "TYPE", 0, row);
                            vegetation_type = IndyInterface.bootstrap("cast", "()", 0, vegetation_type) != false ? IndyInterface.bootstrap("invoke", "get", 0, this.vegetation_types.get(), vegetation_type) : "unclassified";
                            CallSite height_class = IndyInterface.bootstrap("invoke", "get", 0, this.vegetation_classes.get(), vegetation_type);
                            Object vegetation_zindex = IndyInterface.bootstrap("getProperty", "ZINDEX", 0, row);
                            if (IndyInterface.bootstrap("cast", "()", 0, vegetation_zindex) == false) {
                                vegetation_zindex = 0;
                            }
                            CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                            CallSite epsg = IndyInterface.bootstrap("invoke", "getSRID", 0, geom);
                            int i = 0;
                            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                    Object object = this.stmt.get();
                                    Object[] objectArray = new Object[8];
                                    objectArray[0] = this.outputTableName.get();
                                    objectArray[1] = subGeom;
                                    objectArray[2] = epsg;
                                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                    this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                    objectArray[3] = callSite;
                                    objectArray[4] = IndyInterface.bootstrap("getProperty", "ID_SOURCE", 0, row);
                                    objectArray[5] = vegetation_type;
                                    objectArray[6] = height_class;
                                    objectArray[7] = vegetation_zindex;
                                    IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"\n                                            INSERT INTO ", " VALUES(\n                                                ST_GEOMFROMTEXT('", "',", "), \n                                                ", ", \n                                                '", "',\n                                                '", "', \n                                                '", "', ", ")\n                                    "})));
                                }
                                int n = i;
                                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                            }
                            return null;
                        }

                        @Generated
                        public Object getVegetation_types() {
                            return this.vegetation_types.get();
                        }

                        @Generated
                        public Object getVegetation_classes() {
                            return this.vegetation_classes.get();
                        }

                        @Generated
                        public Object getStmt() {
                            return this.stmt.get();
                        }

                        @Generated
                        public Object getOutputTableName() {
                            return this.outputTableName.get();
                        }

                        @Generated
                        public Integer getRowcount() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure12.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), this.queryMapper.get(), new _closure12((Object)this, this.getThisObject(), this.vegetation_types, this.vegetation_classes, stmt2, this.outputTableName, this.rowcount));
                }

                @Generated
                public JdbcDataSource getDatasource() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                }

                @Generated
                public Object getQueryMapper() {
                    return this.queryMapper.get();
                }

                @Generated
                public Object getVegetation_types() {
                    return this.vegetation_types.get();
                }

                @Generated
                public Object getVegetation_classes() {
                    return this.vegetation_classes.get();
                }

                @Generated
                public Object getOutputTableName() {
                    return this.outputTableName.get();
                }

                @Generated
                public Integer getRowcount() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _formatVegetationLayer_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatVegetationLayer_closure5((Object)this, (Object)this, datasource2, queryMapper, vegetation_types, vegetation_classes, outputTableName, rowcount));
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Vegetation transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatImperviousLayer(H2GIS datasource, String impervious) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Impervious layer");
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "IMPERVIOUS"));
        IndyInterface.bootstrap("invoke", "execute", 0, (H2GIS)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{" drop table if exists ", ";\n                CREATE TABLE ", " (THE_GEOM GEOMETRY, id_impervious serial,TYPE VARCHAR);"})));
        Reference weight_values = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"government", 5, "entertainment_arts_culture", 10, "education", 10, "military", 20, "industrial", 20, "commercial", 20, "healthcare", 10, "transport", 15, "building", 10, "sport", 10, "cemetery", 10, "religious", 10}));
        CallSite polygonizedTable = IndyInterface.bootstrap("invoke", "postfix", 2, this, "impervious_polygonized");
        IndyInterface.bootstrap("invoke", "execute", 0, (H2GIS)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{polygonizedTable, polygonizedTable, impervious}, new String[]{" DROP TABLE IF EXISTS ", ";\n            CREATE TABLE ", " as\n            SELECT * from ST_EXPLODE('(select st_polygonize(st_union(st_accum(ST_ToMultiLine( the_geom)))) as the_geom from ", ")')\n            "})));
        IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (H2GIS)datasource2.get(), impervious, "the_geom");
        IndyInterface.bootstrap("invoke", "execute", 0, (H2GIS)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{polygonizedTable, polygonizedTable}, new String[]{" CREATE SPATIAL INDEX ON ", "(THE_GEOM);\n                        CREATE INDEX ON ", "(EXPLOD_ID);"})));
        Reference query = new Reference((Object)IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{impervious, polygonizedTable}, new String[]{"SELECT LISTAGG(a.ID_IMPERVIOUS, ',') AS ids_impervious, LISTAGG(a.TYPE, ',') AS types, b.EXPLOD_ID as id, b.the_geom  FROM ", " AS a, ", " AS b\n            WHERE a.the_geom && b.the_geom AND st_intersects(st_pointonsurface(b.the_geom), a.the_geom) GROUP BY b.explod_id;"})));
        Reference rowcount = new Reference((Object)1);
        public final class _formatImperviousLayer_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference datasource;
            private /* synthetic */ Reference query;
            private /* synthetic */ Reference weight_values;
            private /* synthetic */ Reference outputTableName;
            private /* synthetic */ Reference rowcount;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _formatImperviousLayer_closure6(Object _outerInstance, Object _thisObject, Reference datasource, Reference query, Reference weight_values, Reference outputTableName, Reference rowcount) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.datasource = reference5 = datasource;
                this.query = reference4 = query;
                this.weight_values = reference3 = weight_values;
                this.outputTableName = reference2 = outputTableName;
                this.rowcount = reference = rowcount;
            }

            public Object doCall(Object stmt) {
                Reference stmt2 = new Reference(stmt);
                public final class _closure13
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference weight_values;
                    private /* synthetic */ Reference stmt;
                    private /* synthetic */ Reference outputTableName;
                    private /* synthetic */ Reference rowcount;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure13(Object _outerInstance, Object _thisObject, Reference weight_values, Reference stmt, Reference outputTableName, Reference rowcount) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.weight_values = reference4 = weight_values;
                        this.stmt = reference3 = stmt;
                        this.outputTableName = reference2 = outputTableName;
                        this.rowcount = reference = rowcount;
                    }

                    public Object doCall(Object row) {
                        CallSite types = IndyInterface.bootstrap("getProperty", "types", 0, row);
                        Set listTypes = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "split", 0, types, ","), Set.class));
                        public final class _closure14
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure14(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return IndyInterface.bootstrap("getProperty", "key", 0, it);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure14.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite type = IndyInterface.bootstrap("getProperty", "key", 0, IndyInterface.bootstrap("invoke", "max", 0, IndyInterface.bootstrap("invoke", "subMap", 0, this.weight_values.get(), listTypes), new _closure14((Object)this, this.getThisObject())));
                        if (IndyInterface.bootstrap("cast", "()", 0, type) != false) {
                            CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                            CallSite epsg = IndyInterface.bootstrap("invoke", "getSRID", 0, geom);
                            int i = 0;
                            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                    Object object = this.stmt.get();
                                    Object[] objectArray = new Object[5];
                                    objectArray[0] = this.outputTableName.get();
                                    objectArray[1] = subGeom;
                                    objectArray[2] = epsg;
                                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                    this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                    objectArray[3] = callSite;
                                    objectArray[4] = type;
                                    IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"insert into ", " values(ST_GEOMFROMTEXT('", "',", "), ", ", '", "')"})));
                                }
                                int n = i;
                                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                            }
                            return null;
                        }
                        return null;
                    }

                    @Generated
                    public Object getWeight_values() {
                        return this.weight_values.get();
                    }

                    @Generated
                    public Object getStmt() {
                        return this.stmt.get();
                    }

                    @Generated
                    public Object getOutputTableName() {
                        return this.outputTableName.get();
                    }

                    @Generated
                    public Integer getRowcount() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), this.query.get(), new _closure13((Object)this, this.getThisObject(), this.weight_values, stmt2, this.outputTableName, this.rowcount));
            }

            @Generated
            public H2GIS getDatasource() {
                return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
            }

            @Generated
            public Object getQuery() {
                return this.query.get();
            }

            @Generated
            public Object getWeight_values() {
                return this.weight_values.get();
            }

            @Generated
            public Object getOutputTableName() {
                return this.outputTableName.get();
            }

            @Generated
            public Integer getRowcount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _formatImperviousLayer_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "withBatch", 0, (H2GIS)datasource2.get(), 100, new _formatImperviousLayer_closure6((Object)this, (Object)this, datasource2, query, weight_values, outputTableName, rowcount));
        IndyInterface.bootstrap("invoke", "execute", 0, (H2GIS)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{polygonizedTable}, new String[]{"DROP TABLE IF EXISTS ", ""})));
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Impervious areas transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String setAliasOnColumns(String tableName) {
        public final class _setAliasOnColumns_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setAliasOnColumns_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object result, Object iter) {
                result = IndyInterface.bootstrap("invoke", "plus", 0, result, new GStringImpl(new Object[]{iter}, new String[]{"a.", ""}));
                return result;
            }

            @Generated
            public Object call(Object result, Object iter) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, result, iter);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setAliasOnColumns_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "inject", 0, IndyInterface.bootstrap("getProperty", "columnNames", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _setAliasOnColumns_closure7((Object)this, (Object)this)), ","));
    }

    @Generated
    public String formatBuildingLayer(JdbcDataSource datasource, String building, String zone, String urban_areas) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatBuildingLayer((JdbcDataSource)datasource2.get(), building, zone, urban_areas, 3);
    }

    @Generated
    public String formatBuildingLayer(JdbcDataSource datasource, String building, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatBuildingLayer((JdbcDataSource)datasource2.get(), building, zone, "", 3);
    }

    @Generated
    public String formatBuildingLayer(JdbcDataSource datasource, String building) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatBuildingLayer((JdbcDataSource)datasource2.get(), building, "", "", 3);
    }

    @Generated
    public String formatRoadLayer(JdbcDataSource datasource, String road) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatRoadLayer((JdbcDataSource)datasource2.get(), road, "");
    }

    @Generated
    public String formatHydroLayer(JdbcDataSource datasource, String water) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatHydroLayer((JdbcDataSource)datasource2.get(), water, "");
    }

    @Generated
    public String formatRailsLayer(JdbcDataSource datasource, String rail) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatRailsLayer((JdbcDataSource)datasource2.get(), rail, "");
    }

    @Generated
    public String formatVegetationLayer(JdbcDataSource datasource, String vegetation) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatVegetationLayer((JdbcDataSource)datasource2.get(), vegetation, "");
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != InputDataFormatting.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ MetaClass super$6$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

