/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.geoclimate.bdtopo;

import groovy.io.FileType;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.h2.tools.DeleteDbFiles;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.URIUtilities;
import org.orbisgis.data.H2GIS;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.jdbc.JdbcDataSource;
import org.orbisgis.geoclimate.Geoindicators;
import org.orbisgis.geoclimate.bdtopo.BDTopoUtils;
import org.orbisgis.geoclimate.worldpoptools.WorldPopTools;

public abstract class AbstractBDTopoWorkflow
extends BDTopoUtils {
    private static /* synthetic */ float $const$0;
    private static /* synthetic */ float $const$1;
    private static /* synthetic */ float $const$2;
    private static /* synthetic */ float $const$3;
    private static /* synthetic */ float $const$4;
    private static /* synthetic */ BigDecimal $const$5;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public AbstractBDTopoWorkflow() {
    }

    public Map execute(Object input) {
        CallSite parameters = null;
        if (IndyInterface.bootstrap("cast", "()", 0, input) != false) {
            if (input instanceof String) {
                CallSite configFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, input);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isFile", 0, configFile)) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, "The configuration file doesn't exist");
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isExtensionWellFormated", 0, FileUtilities.class, configFile, "json")) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, "The configuration file must be a json file");
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                parameters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readJSON", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), configFile));
            } else if (input instanceof Map) {
                parameters = IndyInterface.bootstrap("cast", "()", 0, input);
            }
        } else {
            IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "The input parameters cannot be null or empty.\n Please set a path to a configuration file or ", "a map with all required parameters"));
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, parameters) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Wrong input parameters");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Reference outputTableNamesResult = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Reading file parameters");
        IndyInterface.bootstrap("invoke", "debug", 2, this, IndyInterface.bootstrap("getProperty", "description", 0, parameters));
        CallSite inputParameters = IndyInterface.bootstrap("getProperty", "input", 0, parameters);
        CallSite outputParameters = IndyInterface.bootstrap("getProperty", "output", 0, parameters);
        CallSite databaseFolder = IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "java.io.tmpdir");
        CallSite databaseName = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "bdtopo_", IndyInterface.bootstrap("invoke", "getVersion", 2, this)), IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_"));
        CallSite databasePath = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, databaseFolder, IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), databaseName);
        Map h2gis_properties = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"databaseName", databasePath, "user", "sa", "password", ""});
        Object delete_h2gis = true;
        CallSite geoclimatedb = IndyInterface.bootstrap("getProperty", "geoclimatedb", 0, parameters);
        if (IndyInterface.bootstrap("cast", "()", 0, geoclimatedb) != false) {
            CallSite h2gis_folder = IndyInterface.bootstrap("invoke", "get", 0, geoclimatedb, "folder");
            if (IndyInterface.bootstrap("cast", "()", 0, h2gis_folder) != false) {
                CallSite tmp_folder_db = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, h2gis_folder));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, tmp_folder_db)) == false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdir", 0, tmp_folder_db)) == false) {
                        h2gis_folder = null;
                        IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{h2gis_folder}, new String[]{"You don't have permission to write in the folder ", " \n"}), "Please check the folder."));
                        return IndyInterface.bootstrap("cast", "()", 0, null);
                    }
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, tmp_folder_db)) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_folder}, new String[]{"Invalid output folder ", "."}));
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                databaseFolder = h2gis_folder;
            }
            databasePath = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, databaseFolder, IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), databaseName);
            CallSite h2gis_name = IndyInterface.bootstrap("invoke", "get", 0, geoclimatedb, "name");
            if (IndyInterface.bootstrap("cast", "()", 0, h2gis_name) != false) {
                CallSite dbName = IndyInterface.bootstrap("invoke", "split", 0, h2gis_name, ";");
                databaseName = IndyInterface.bootstrap("invoke", "getAt", 0, dbName, false);
                databasePath = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, databaseFolder, IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), h2gis_name);
            }
            CallSite delete_h2gis_db = IndyInterface.bootstrap("getProperty", "delete", 0, geoclimatedb);
            if (ScriptBytecodeAdapter.compareEqual((Object)delete_h2gis_db, null)) {
                delete_h2gis = true;
            } else if (delete_h2gis_db instanceof String) {
                delete_h2gis = true;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, delete_h2gis_db, "false")) != false) {
                    delete_h2gis = false;
                }
            } else if (delete_h2gis_db instanceof Boolean) {
                delete_h2gis = delete_h2gis_db;
            }
            if (IndyInterface.bootstrap("cast", "()", 0, databasePath) != false) {
                h2gis_properties = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"databaseName", databasePath, "user", "sa", "password", ""});
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, inputParameters) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot find any input parameters.");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite inputDataBase = IndyInterface.bootstrap("getProperty", "database", 0, inputParameters);
        CallSite inputFolder = IndyInterface.bootstrap("getProperty", "folder", 0, inputParameters);
        Set locations = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "locations", 0, inputParameters), Set.class));
        if (IndyInterface.bootstrap("cast", "()", 0, locations) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot find any locations parameter.");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Reference inputSRID = new Reference((Object)IndyInterface.bootstrap("getProperty", "srid", 0, inputParameters));
        if (DefaultTypeTransformation.booleanUnbox((Object)inputSRID.get()) && ScriptBytecodeAdapter.compareLessThanEqual((Object)inputSRID.get(), (Object)0)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The input srid must be greater than 0.");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)inputFolder) && DefaultTypeTransformation.booleanUnbox((Object)inputDataBase)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Please set only one input data provider");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Reference inputWorkflowTableNames = new Reference((Object)IndyInterface.bootstrap("invoke", "getInputTables", 2, this));
        if (IndyInterface.bootstrap("cast", "()", 0, inputWorkflowTableNames.get()) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The input table names cannot be null or empty.");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite outputWorkflowTableNames = IndyInterface.bootstrap("invoke", "getOutputTables", 2, this);
        Reference processing_parameters = new Reference((Object)IndyInterface.bootstrap("invoke", "extractProcessingParameters", 2, this, IndyInterface.bootstrap("getProperty", "parameters", 0, parameters)));
        if (IndyInterface.bootstrap("cast", "()", 0, processing_parameters.get()) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Reference outputDatasource = new Reference(null);
        outputDatasource.get();
        Reference outputTables = new Reference(null);
        outputTables.get();
        Reference file_outputFolder = new Reference(null);
        file_outputFolder.get();
        Reference outputFileTables = new Reference(null);
        outputFileTables.get();
        Reference outputSRID = new Reference(null);
        outputSRID.get();
        Object deleteOutputData = null;
        if (IndyInterface.bootstrap("cast", "()", 0, outputParameters) != false) {
            CallSite outputDataBase = IndyInterface.bootstrap("getProperty", "database", 0, outputParameters);
            CallSite outputFolder = IndyInterface.bootstrap("getProperty", "folder", 0, outputParameters);
            deleteOutputData = IndyInterface.bootstrap("invoke", "get", 0, outputParameters, "delete");
            if (IndyInterface.bootstrap("cast", "()", 0, deleteOutputData) == false) {
                deleteOutputData = true;
            } else if (ScriptBytecodeAdapter.isCase((Object)(IndyInterface.bootstrap("cast", "()", 0, deleteOutputData) == false ? 1 : 0), Boolean.class)) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "The delete parameter must be a boolean value");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            outputSRID.set((Object)IndyInterface.bootstrap("invoke", "get", 0, outputParameters, "srid"));
            if (DefaultTypeTransformation.booleanUnbox((Object)outputSRID.get()) && ScriptBytecodeAdapter.compareLessThanEqual((Object)outputSRID.get(), (Object)0)) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "The output srid must be greater than 0");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, outputFolder) != false) {
                CallSite outputFiles = IndyInterface.bootstrap("invoke", "buildOutputFolderParameters", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), outputFolder, outputWorkflowTableNames);
                outputFileTables.set((Object)IndyInterface.bootstrap("getProperty", "tables", 0, outputFiles));
                file_outputFolder.set((Object)IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("getProperty", "path", 0, outputFiles)));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, file_outputFolder.get())) == false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdir", 0, file_outputFolder.get())) != false) {
                        file_outputFolder.set(null);
                        IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{outputFolder}, new String[]{"You don't have permission to write in the folder ", " \n"}), "Please check the folder."));
                        return IndyInterface.bootstrap("cast", "()", 0, null);
                    }
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, file_outputFolder.get())) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{file_outputFolder.get()}, new String[]{"Invalid output folder ", "."}));
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, outputDataBase) != false) {
                CallSite outputDataBaseData = IndyInterface.bootstrap("invoke", "buildOutputDBParameters", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), outputDataBase, IndyInterface.bootstrap("getProperty", "tables", 0, outputDataBase), outputWorkflowTableNames);
                outputDatasource.set((Object)IndyInterface.bootstrap("getProperty", "datasource", 0, outputDataBaseData));
                outputTables.set((Object)IndyInterface.bootstrap("getProperty", "tables", 0, outputDataBaseData));
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, inputFolder) != false) {
            Reference h2gis_datasource = new Reference((Object)IndyInterface.bootstrap("invoke", "open", 0, H2GIS.class, h2gis_properties));
            if (IndyInterface.bootstrap("cast", "()", 0, h2gis_datasource.get()) == false) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot load the local H2GIS database to run Geoclimate");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            CallSite datafromFolder = IndyInterface.bootstrap("invoke", "linkDataFromFolder", 2, this, inputFolder, inputWorkflowTableNames.get(), h2gis_datasource.get(), inputSRID.get());
            if (IndyInterface.bootstrap("cast", "()", 0, datafromFolder) == false) {
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            inputSRID.set((Object)IndyInterface.bootstrap("getProperty", "inputSrid", 0, datafromFolder));
            Reference sourceSrid = new Reference((Object)IndyInterface.bootstrap("getProperty", "sourceSrid", 0, datafromFolder));
            Reference tablesLinked = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "tableNames", 0, datafromFolder)));
            if (IndyInterface.bootstrap("cast", "()", 0, (LinkedHashMap)tablesLinked.get()) != false) {
                public final class _execute_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference processing_parameters;
                    private /* synthetic */ Reference tablesLinked;
                    private /* synthetic */ Reference sourceSrid;
                    private /* synthetic */ Reference inputSRID;
                    private /* synthetic */ Reference h2gis_datasource;
                    private /* synthetic */ Reference file_outputFolder;
                    private /* synthetic */ Reference outputFileTables;
                    private /* synthetic */ Reference outputDatasource;
                    private /* synthetic */ Reference outputTables;
                    private /* synthetic */ Reference outputSRID;
                    private /* synthetic */ Reference outputTableNamesResult;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure1(Object _outerInstance, Object _thisObject, Reference processing_parameters, Reference tablesLinked, Reference sourceSrid, Reference inputSRID, Reference h2gis_datasource, Reference file_outputFolder, Reference outputFileTables, Reference outputDatasource, Reference outputTables, Reference outputSRID, Reference outputTableNamesResult) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        Reference reference8;
                        Reference reference9;
                        Reference reference10;
                        Reference reference11;
                        this.processing_parameters = reference11 = processing_parameters;
                        this.tablesLinked = reference10 = tablesLinked;
                        this.sourceSrid = reference9 = sourceSrid;
                        this.inputSRID = reference8 = inputSRID;
                        this.h2gis_datasource = reference7 = h2gis_datasource;
                        this.file_outputFolder = reference6 = file_outputFolder;
                        this.outputFileTables = reference5 = outputFileTables;
                        this.outputDatasource = reference4 = outputDatasource;
                        this.outputTables = reference3 = outputTables;
                        this.outputSRID = reference2 = outputSRID;
                        this.outputTableNamesResult = reference = outputTableNamesResult;
                    }

                    public Object doCall(Object location) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "filterLinkedShapeFiles", 2, this, location, IndyInterface.bootstrap("getProperty", "distance", 0, this.processing_parameters.get()), IndyInterface.bootstrap("cast", "()", 0, this.tablesLinked.get()), this.sourceSrid.get(), this.inputSRID.get(), this.h2gis_datasource.get())) != false) {
                            CallSite formatedZone = IndyInterface.bootstrap("invoke", "checkAndFormatLocations", 2, this, location);
                            if (IndyInterface.bootstrap("cast", "()", 0, formatedZone) != false) {
                                CallSite bdtopo_results = IndyInterface.bootstrap("invoke", "bdtopo_processing", 2, this, formatedZone, this.h2gis_datasource.get(), this.processing_parameters.get(), IndyInterface.bootstrap("invoke", "createMainFolder", 2, this, this.file_outputFolder.get(), formatedZone), this.outputFileTables.get(), this.outputDatasource.get(), this.outputTables.get(), this.outputSRID.get(), this.inputSRID.get());
                                if (IndyInterface.bootstrap("cast", "()", 0, bdtopo_results) != false) {
                                    return IndyInterface.bootstrap("invoke", "putAll", 0, this.outputTableNamesResult.get(), bdtopo_results);
                                }
                            }
                        }
                        return null;
                    }

                    @Generated
                    public Object getProcessing_parameters() {
                        return this.processing_parameters.get();
                    }

                    @Generated
                    public LinkedHashMap getTablesLinked() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.tablesLinked.get());
                    }

                    @Generated
                    public Object getSourceSrid() {
                        return this.sourceSrid.get();
                    }

                    @Generated
                    public Object getInputSRID() {
                        return this.inputSRID.get();
                    }

                    @Generated
                    public Object getH2gis_datasource() {
                        return this.h2gis_datasource.get();
                    }

                    @Generated
                    public Object getFile_outputFolder() {
                        return this.file_outputFolder.get();
                    }

                    @Generated
                    public Object getOutputFileTables() {
                        return this.outputFileTables.get();
                    }

                    @Generated
                    public Object getOutputDatasource() {
                        return this.outputDatasource.get();
                    }

                    @Generated
                    public Object getOutputTables() {
                        return this.outputTables.get();
                    }

                    @Generated
                    public Object getOutputSRID() {
                        return this.outputSRID.get();
                    }

                    @Generated
                    public Object getOutputTableNamesResult() {
                        return this.outputTableNamesResult.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, locations, new _execute_closure1((Object)this, (Object)this, processing_parameters, tablesLinked, sourceSrid, inputSRID, h2gis_datasource, file_outputFolder, outputFileTables, outputDatasource, outputTables, outputSRID, outputTableNamesResult));
                IndyInterface.bootstrap("invoke", "deleteH2GISDb", 2, this, delete_h2gis, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource.get()), databaseFolder, databaseName);
                return IndyInterface.bootstrap("cast", "()", 0, outputTableNamesResult.get());
            }
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{inputFolder}, new String[]{"Cannot find any data to process from the folder ", ""}));
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, inputDataBase) != false) {
            Object inputTables = IndyInterface.bootstrap("getProperty", "tables", 0, inputDataBase);
            if (IndyInterface.bootstrap("cast", "()", 0, inputTables) == false) {
                public final class _execute_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object name) {
                        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name});
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                inputTables = IndyInterface.bootstrap("invoke", "collect", 0, inputWorkflowTableNames.get(), new _execute_closure2((Object)this, (Object)this));
            } else {
                Reference inputTables_tmp = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                public final class _execute_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference inputWorkflowTableNames;
                    private /* synthetic */ Reference inputTables_tmp;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure3(Object _outerInstance, Object _thisObject, Reference inputWorkflowTableNames, Reference inputTables_tmp) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.inputWorkflowTableNames = reference2 = inputWorkflowTableNames;
                        this.inputTables_tmp = reference = inputTables_tmp;
                    }

                    public Object doCall(Object table) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.inputWorkflowTableNames.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, table)))) != false) {
                            return IndyInterface.bootstrap("invoke", "put", 0, this.inputTables_tmp.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, table)), IndyInterface.bootstrap("getProperty", "value", 0, table));
                        }
                        return null;
                    }

                    @Generated
                    public Object getInputWorkflowTableNames() {
                        return this.inputWorkflowTableNames.get();
                    }

                    @Generated
                    public Object getInputTables_tmp() {
                        return this.inputTables_tmp.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, inputTables, new _execute_closure3((Object)this, (Object)this, inputWorkflowTableNames, inputTables_tmp));
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, inputTables_tmp.get()), (Object)0)) {
                    public final class _execute_closure4
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _execute_closure4(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object name) {
                            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name});
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _execute_closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "Please set a valid list of input tables as  : \n", new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "collect", 0, inputWorkflowTableNames.get(), new _execute_closure4((Object)this, (Object)this))}, new String[]{"", ""})));
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                inputTables = inputTables_tmp.get();
            }
            CallSite h2gis_datasource = IndyInterface.bootstrap("invoke", "open", 0, H2GIS.class, h2gis_properties);
            if (IndyInterface.bootstrap("cast", "()", 0, h2gis_datasource) == false) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot load the local H2GIS database to run Geoclimate");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            Integer nbzones = 0;
            Object location = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, locations));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    location = callSite.next();
                    Integer n = nbzones;
                    IndyInterface.bootstrap("invoke", "next", 0, n);
                    inputSRID.set((Object)IndyInterface.bootstrap("invoke", "loadDataFromPostGIS", 2, this, IndyInterface.bootstrap("invoke", "subMap", 0, inputDataBase, ScriptBytecodeAdapter.createList((Object[])new Object[]{"user", "password", "url", "databaseName"})), location, IndyInterface.bootstrap("getProperty", "distance", 0, processing_parameters.get()), inputTables, inputSRID.get(), h2gis_datasource));
                    if (IndyInterface.bootstrap("cast", "()", 0, inputSRID.get()) != false) {
                        CallSite formatedZone = IndyInterface.bootstrap("invoke", "checkAndFormatLocations", 2, this, location);
                        if (IndyInterface.bootstrap("cast", "()", 0, formatedZone) != false) {
                            CallSite bdtopo_results = IndyInterface.bootstrap("invoke", "bdtopo_processing", 2, this, formatedZone, h2gis_datasource, processing_parameters.get(), IndyInterface.bootstrap("invoke", "createMainFolder", 2, this, file_outputFolder.get(), formatedZone), outputFileTables.get(), outputDatasource.get(), outputTables.get(), outputSRID.get(), inputSRID.get());
                            if (IndyInterface.bootstrap("cast", "()", 0, bdtopo_results) != false) {
                                IndyInterface.bootstrap("invoke", "putAll", 0, outputTableNamesResult.get(), bdtopo_results);
                            } else {
                                IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{location}, new String[]{"Cannot execute the geoclimate processing chain on ", "\n"}));
                            }
                        }
                    } else {
                        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{location}, new String[]{"Cannot load the data for the location ", ""}));
                    }
                    IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{nbzones, IndyInterface.bootstrap("invoke", "size", 0, locations)}, new String[]{"", " location(s) on ", ""}));
                }
            }
            IndyInterface.bootstrap("invoke", "deleteH2GISDb", 2, this, delete_h2gis, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), databaseFolder, databaseName);
            if (IndyInterface.bootstrap("cast", "()", 0, outputTableNamesResult.get()) != false) {
                return IndyInterface.bootstrap("cast", "()", 0, outputTableNamesResult.get());
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public abstract Object filterLinkedShapeFiles(Object var1, float var2, LinkedHashMap var3, int var4, int var5, H2GIS var6);

    public abstract Integer loadDataFromPostGIS(Object var1, Object var2, Object var3, Object var4, Object var5, H2GIS var6);

    /*
     * WARNING - void declaration
     */
    public Object linkDataFromFolder(Object inputFolder, Object inputWorkflowTableNames, H2GIS h2gis_datasource, Object inputSRID) {
        void var3_3;
        Reference inputWorkflowTableNames2 = new Reference(inputWorkflowTableNames);
        Reference h2gis_datasource2 = new Reference((Object)var3_3);
        CallSite folder = IndyInterface.bootstrap("init", "<init>", 0, File.class, inputFolder);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, folder)) != false) {
            Reference geoFiles = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            public final class _linkDataFromFolder_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference geoFiles;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _linkDataFromFolder_closure5(Object _outerInstance, Object _thisObject, Reference geoFiles) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.geoFiles = reference = geoFiles;
                }

                public Object doCall(Object file) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "endsWith", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "name", 0, file)), ".shp")) != false) {
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, this.geoFiles.get(), IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, file));
                    }
                    return null;
                }

                @Generated
                public Object getGeoFiles() {
                    return this.geoFiles.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _linkDataFromFolder_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "eachFileRecurse", 0, folder, IndyInterface.bootstrap("getProperty", "FILES", 0, FileType.class), new _linkDataFromFolder_closure5((Object)this, (Object)this, geoFiles));
            public final class _linkDataFromFolder_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _linkDataFromFolder_closure6(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "endsWith", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, it), "commune.shp")) != false ? it : null;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _linkDataFromFolder_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite commune_file = IndyInterface.bootstrap("invoke", "find", 0, geoFiles.get(), new _linkDataFromFolder_closure6((Object)this, (Object)this));
            if (IndyInterface.bootstrap("cast", "()", 0, commune_file) != false) {
                IndyInterface.bootstrap("invoke", "link", 0, (H2GIS)h2gis_datasource2.get(), commune_file, "COMMUNE_TMP", true);
                CallSite sp_commune = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, (H2GIS)h2gis_datasource2.get(), "COMMUNE_TMP"));
                IndyInterface.bootstrap("invoke", "remove", 0, geoFiles.get(), commune_file);
                int srid = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("getProperty", "srid", 0, sp_commune));
                Integer sourceSrid = srid;
                if (srid == 0 && DefaultTypeTransformation.booleanUnbox((Object)inputSRID)) {
                    srid = DefaultTypeTransformation.intUnbox((Object)inputSRID);
                } else if (srid == 0) {
                    IndyInterface.bootstrap("invoke", "warn", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "Cannot find a SRID value for the layer commune.shp.\n", "Please set a valid OGC prj or use the parameter srid to force it."));
                    return null;
                }
                Reference numberFiles = new Reference((Object)IndyInterface.bootstrap("invoke", "size", 0, geoFiles.get()));
                Reference tableNames = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                IndyInterface.bootstrap("invoke", "put", 0, tableNames.get(), "commune", "COMMUNE_TMP");
                public final class _linkDataFromFolder_closure7
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference numberFiles;
                    private /* synthetic */ Reference inputWorkflowTableNames;
                    private /* synthetic */ Reference h2gis_datasource;
                    private /* synthetic */ Reference tableNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _linkDataFromFolder_closure7(Object _outerInstance, Object _thisObject, Reference numberFiles, Reference inputWorkflowTableNames, Reference h2gis_datasource, Reference tableNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.numberFiles = reference4 = numberFiles;
                        this.inputWorkflowTableNames = reference3 = inputWorkflowTableNames;
                        this.h2gis_datasource = reference2 = h2gis_datasource;
                        this.tableNames = reference = tableNames;
                    }

                    public Object doCall(Object geoFile, Object index) {
                        IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{geoFile, index, this.numberFiles.get()}, new String[]{"linking file ", " ", " on ", ""}));
                        CallSite fileName = IndyInterface.bootstrap("invoke", "getName", 0, IndyInterface.bootstrap("invoke", "fileFromString", 0, URIUtilities.class, geoFile));
                        CallSite name = IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "substring", 0, fileName, false, IndyInterface.bootstrap("invoke", "lastIndexOf", 0, fileName, ".")));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.inputWorkflowTableNames.get(), name)) != false) {
                            IndyInterface.bootstrap("invoke", "link", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), geoFile, new GStringImpl(new Object[]{name}, new String[]{"", "_tmp"}), true);
                            return IndyInterface.bootstrap("invoke", "put", 0, this.tableNames.get(), name, new GStringImpl(new Object[]{name}, new String[]{"", "_tmp"}));
                        }
                        return null;
                    }

                    @Generated
                    public Object call(Object geoFile, Object index) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, geoFile, index);
                    }

                    @Generated
                    public Object getNumberFiles() {
                        return this.numberFiles.get();
                    }

                    @Generated
                    public Object getInputWorkflowTableNames() {
                        return this.inputWorkflowTableNames.get();
                    }

                    @Generated
                    public H2GIS getH2gis_datasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get());
                    }

                    @Generated
                    public Object getTableNames() {
                        return this.tableNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _linkDataFromFolder_closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "eachWithIndex", 0, geoFiles.get(), new _linkDataFromFolder_closure7((Object)this, (Object)this, numberFiles, inputWorkflowTableNames2, h2gis_datasource2, tableNames));
                IndyInterface.bootstrap("invoke", "execute", 0, (H2GIS)h2gis_datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, "DROP TABLE IF EXISTS COMMUNE_TMP_LINK;"));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceSrid", sourceSrid, "inputSrid", srid, "tableNames", tableNames.get()});
            }
            IndyInterface.bootstrap("invoke", "error", 2, this, "The input folder must contains a file named commune");
            return null;
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, "The input folder must be a directory");
        return null;
    }

    public Object deleteH2GISDb(Object delete, Connection connection, Object dbFolder, Object dbName) {
        if (IndyInterface.bootstrap("cast", "()", 0, delete) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, connection) != false) {
                IndyInterface.bootstrap("invoke", "close", 0, connection);
                IndyInterface.bootstrap("invoke", "execute", 0, DeleteDbFiles.class, dbFolder, dbName, true);
                return IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{dbName}, new String[]{"The local H2GIS database : ", " has been deleted"}));
            }
            return IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{dbName}, new String[]{"Cannot delete the local H2GIS database : ", " "}));
        }
        return null;
    }

    public Object createMainFolder(Object outputFolder, Object location) {
        if (IndyInterface.bootstrap("cast", "()", 0, outputFolder) == false) {
            return null;
        }
        CallSite folder = IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, outputFolder), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), "bdtopo_"), IndyInterface.bootstrap("invoke", "getVersion", 2, this)), "_"), location));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, folder)) == false) {
            IndyInterface.bootstrap("invoke", "mkdir", 0, folder);
        } else {
            IndyInterface.bootstrap("invoke", "deleteFiles", 0, FileUtilities.class, folder);
        }
        return IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, folder);
    }

    public Object extractProcessingParameters(Object processing_parameters) {
        Map defaultParameters = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"distance", Float.valueOf($const$0), "distance_buffer", Float.valueOf($const$1), "prefixName", "", "hLevMin", 3});
        Map rsu_indicators_default = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"indicatorUse", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "svfSimplified", true, "surface_vegetation", Float.valueOf($const$2), "surface_hydro", Float.valueOf($const$3), "surface_urban_areas", Float.valueOf($const$2), "snappingTolerance", Float.valueOf($const$4), "mapOfWeights", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sky_view_factor", 4, "aspect_ratio", 3, "building_surface_fraction", 8, "impervious_surface_fraction", 0, "pervious_surface_fraction", 0, "height_of_roughness_elements", 6, "terrain_roughness_length", $const$5}), "utrfModelName", "UTRF_BDTOPO_V2_RF_2_2.model"});
        IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "rsu_indicators", rsu_indicators_default);
        if (IndyInterface.bootstrap("cast", "()", 0, processing_parameters) != false) {
            CallSite distanceP = IndyInterface.bootstrap("getProperty", "distance", 0, processing_parameters);
            if (DefaultTypeTransformation.booleanUnbox((Object)distanceP) && ScriptBytecodeAdapter.isCase((Object)distanceP, Number.class)) {
                CallSite callSite = distanceP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)defaultParameters, (String)"distance");
            }
            CallSite prefixNameP = IndyInterface.bootstrap("getProperty", "prefixName", 0, processing_parameters);
            if (DefaultTypeTransformation.booleanUnbox((Object)prefixNameP) && ScriptBytecodeAdapter.isCase((Object)prefixNameP, String.class)) {
                CallSite callSite = prefixNameP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)defaultParameters, (String)"prefixName");
            }
            CallSite hLevMinP = IndyInterface.bootstrap("getProperty", "hLevMin", 0, processing_parameters);
            if (DefaultTypeTransformation.booleanUnbox((Object)hLevMinP) && ScriptBytecodeAdapter.isCase((Object)hLevMinP, Integer.class)) {
                CallSite callSite = hLevMinP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)defaultParameters, (String)"hLevMin");
            }
            Reference rsu_indicators = new Reference((Object)IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, processing_parameters));
            if (IndyInterface.bootstrap("cast", "()", 0, rsu_indicators.get()) != false) {
                CallSite indicatorUseP = IndyInterface.bootstrap("getProperty", "indicatorUse", 0, rsu_indicators.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)indicatorUseP) && ScriptBytecodeAdapter.isCase((Object)indicatorUseP, List.class)) {
                    List allowed_rsu_indicators = ScriptBytecodeAdapter.createList((Object[])new Object[]{"LCZ", "UTRF", "TEB"});
                    CallSite allowedOutputRSUIndicators = IndyInterface.bootstrap("invoke", "intersect", 0, allowed_rsu_indicators, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(AbstractBDTopoWorkflow.class, (Object)indicatorUseP, (String)"toUpperCase"));
                    if (IndyInterface.bootstrap("cast", "()", 0, allowedOutputRSUIndicators) == false) {
                        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{allowedOutputRSUIndicators}, new String[]{"Please set a valid list of RSU indicator names in ", ""}));
                        return null;
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "error", 2, this, "The list of RSU indicator names cannot be null or empty");
                    return null;
                }
                CallSite callSite = indicatorUseP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"indicatorUse");
                CallSite snappingToleranceP = IndyInterface.bootstrap("getProperty", "snappingTolerance", 0, rsu_indicators.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)snappingToleranceP) && ScriptBytecodeAdapter.isCase((Object)snappingToleranceP, Number.class)) {
                    CallSite callSite2 = snappingToleranceP;
                    ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)rsu_indicators_default, (String)"snappingTolerance");
                }
                CallSite surface_vegetationP = IndyInterface.bootstrap("getProperty", "surface_vegetation", 0, rsu_indicators.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)surface_vegetationP) && ScriptBytecodeAdapter.isCase((Object)surface_vegetationP, Number.class)) {
                    CallSite callSite3 = surface_vegetationP;
                    ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)rsu_indicators_default, (String)"surface_vegetation");
                }
                CallSite surface_hydroP = IndyInterface.bootstrap("getProperty", "surface_hydro", 0, rsu_indicators.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)surface_hydroP) && ScriptBytecodeAdapter.isCase((Object)surface_hydroP, Number.class)) {
                    CallSite callSite4 = surface_hydroP;
                    ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)rsu_indicators_default, (String)"surface_hydro");
                }
                CallSite surface_UrbanAreasP = IndyInterface.bootstrap("getProperty", "surface_urban_areas", 0, rsu_indicators.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)surface_UrbanAreasP) && ScriptBytecodeAdapter.isCase((Object)surface_UrbanAreasP, Number.class)) {
                    CallSite callSite5 = surface_UrbanAreasP;
                    ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)rsu_indicators_default, (String)"surface_urban_areas");
                }
                CallSite svfSimplifiedP = IndyInterface.bootstrap("getProperty", "svfSimplified", 0, rsu_indicators.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)svfSimplifiedP) && ScriptBytecodeAdapter.isCase((Object)svfSimplifiedP, Boolean.class)) {
                    CallSite callSite6 = svfSimplifiedP;
                    ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)rsu_indicators_default, (String)"svfSimplified");
                }
                CallSite mapOfWeightsP = IndyInterface.bootstrap("getProperty", "mapOfWeights", 0, rsu_indicators.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)mapOfWeightsP) && ScriptBytecodeAdapter.isCase((Object)mapOfWeightsP, Map.class)) {
                    CallSite defaultmapOfWeights = IndyInterface.bootstrap("getProperty", "mapOfWeights", 0, rsu_indicators_default);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "plus", 0, defaultmapOfWeights, mapOfWeightsP)), (Object)IndyInterface.bootstrap("invoke", "size", 0, defaultmapOfWeights))) {
                        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "keySet", 0, defaultmapOfWeights), ",")}, new String[]{"The number of mapOfWeights parameters must contain exactly the parameters ", ""}));
                        return null;
                    }
                    CallSite callSite7 = mapOfWeightsP;
                    ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)rsu_indicators_default, (String)"mapOfWeights");
                }
            } else {
                rsu_indicators.set((Object)rsu_indicators_default);
            }
            CallSite grid_indicators = IndyInterface.bootstrap("getProperty", "grid_indicators", 0, processing_parameters);
            if (IndyInterface.bootstrap("cast", "()", 0, grid_indicators) != false) {
                CallSite x_size = IndyInterface.bootstrap("getProperty", "x_size", 0, grid_indicators);
                CallSite y_size = IndyInterface.bootstrap("getProperty", "y_size", 0, grid_indicators);
                CallSite list_indicators = IndyInterface.bootstrap("getProperty", "indicators", 0, grid_indicators);
                if (DefaultTypeTransformation.booleanUnbox((Object)x_size) && DefaultTypeTransformation.booleanUnbox((Object)y_size)) {
                    if (ScriptBytecodeAdapter.compareLessThanEqual((Object)x_size, (Object)0) || ScriptBytecodeAdapter.compareLessThanEqual((Object)y_size, (Object)0)) {
                        IndyInterface.bootstrap("invoke", "error", 2, this, "Invalid grid size padding. Must be greater that 0");
                        return null;
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, list_indicators) == false) {
                        IndyInterface.bootstrap("invoke", "error", 2, this, "The list of indicator names cannot be null or empty");
                        return null;
                    }
                    List allowed_grid_indicators = ScriptBytecodeAdapter.createList((Object[])new Object[]{"BUILDING_FRACTION", "BUILDING_HEIGHT", "BUILDING_POP", "BUILDING_TYPE_FRACTION", "WATER_FRACTION", "VEGETATION_FRACTION", "ROAD_FRACTION", "IMPERVIOUS_FRACTION", "UTRF_AREA_FRACTION", "UTRF_FLOOR_AREA_FRACTION", "LCZ_FRACTION", "LCZ_PRIMARY", "FREE_EXTERNAL_FACADE_DENSITY", "BUILDING_HEIGHT_WEIGHTED", "BUILDING_SURFACE_DENSITY", "BUILDING_HEIGHT_DIST", "FRONTAL_AREA_INDEX", "SEA_LAND_FRACTION", "ASPECT_RATIO", "SVF", "HEIGHT_OF_ROUGHNESS_ELEMENTS", "TERRAIN_ROUGHNESS_CLASS"});
                    CallSite allowedOutputIndicators = IndyInterface.bootstrap("invoke", "intersect", 0, allowed_grid_indicators, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(AbstractBDTopoWorkflow.class, (Object)list_indicators, (String)"toUpperCase"));
                    if (IndyInterface.bootstrap("cast", "()", 0, allowedOutputIndicators) != false) {
                        public final class _extractProcessingParameters_closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference rsu_indicators;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _extractProcessingParameters_closure8(Object _outerInstance, Object _thisObject, Reference rsu_indicators) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.rsu_indicators = reference = rsu_indicators;
                            }

                            public Object doCall(Object val) {
                                if (ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, IndyInterface.bootstrap("invoke", "trim", 0, val)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"LCZ_FRACTION", "LCZ_PRIMARY"}))) {
                                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "indicatorUse", 0, this.rsu_indicators.get()), "LCZ");
                                }
                                if (ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, IndyInterface.bootstrap("invoke", "trim", 0, val)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"UTRF_AREA_FRACTION", "UTRF_FLOOR_AREA_FRACTION"}))) {
                                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "indicatorUse", 0, this.rsu_indicators.get()), "UTRF");
                                }
                                return null;
                            }

                            @Generated
                            public Object getRsu_indicators() {
                                return this.rsu_indicators.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _extractProcessingParameters_closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        IndyInterface.bootstrap("invoke", "each", 0, list_indicators, new _extractProcessingParameters_closure8((Object)this, (Object)this, rsu_indicators));
                        Map grid_indicators_tmp = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"x_size", x_size, "y_size", y_size, "output", "geojson", "rowCol", false, "indicators", allowedOutputIndicators});
                        CallSite grid_output = IndyInterface.bootstrap("getProperty", "output", 0, grid_indicators);
                        if (IndyInterface.bootstrap("cast", "()", 0, grid_output) != false && ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, grid_output), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"asc", "geojson"}))) {
                            CallSite callSite = IndyInterface.bootstrap("invoke", "toLowerCase", 0, grid_output);
                            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)grid_indicators_tmp, (String)"output");
                        }
                        CallSite grid_rowCol = IndyInterface.bootstrap("getProperty", "rowCol", 0, grid_indicators);
                        if (DefaultTypeTransformation.booleanUnbox((Object)grid_rowCol) && ScriptBytecodeAdapter.isCase((Object)grid_rowCol, Boolean.class)) {
                            CallSite callSite = grid_rowCol;
                            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)grid_indicators_tmp, (String)"rowCol");
                        }
                        IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "grid_indicators", grid_indicators_tmp);
                    } else {
                        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{allowed_grid_indicators}, new String[]{"Please set a valid list of indicator names in ", ""}));
                        return null;
                    }
                }
            }
            CallSite road_traffic = IndyInterface.bootstrap("getProperty", "road_traffic", 0, processing_parameters);
            if (DefaultTypeTransformation.booleanUnbox((Object)road_traffic) && ScriptBytecodeAdapter.isCase((Object)road_traffic, Boolean.class)) {
                IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "road_traffic", road_traffic);
            }
            CallSite pop_indics = IndyInterface.bootstrap("getProperty", "worldpop_indicators", 0, processing_parameters);
            if (DefaultTypeTransformation.booleanUnbox((Object)pop_indics) && ScriptBytecodeAdapter.isCase((Object)pop_indics, Boolean.class)) {
                IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "worldpop_indicators", pop_indics);
            }
            CallSite noise_indicators = IndyInterface.bootstrap("getProperty", "noise_indicators", 0, processing_parameters);
            if (IndyInterface.bootstrap("cast", "()", 0, noise_indicators) != false) {
                CallSite ground_acoustic = IndyInterface.bootstrap("getProperty", "ground_acoustic", 0, noise_indicators);
                if (DefaultTypeTransformation.booleanUnbox((Object)ground_acoustic) && ScriptBytecodeAdapter.isCase((Object)ground_acoustic, Boolean.class)) {
                    IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "noise_indicators", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ground_acoustic", ground_acoustic}));
                }
            }
            return defaultParameters;
        }
        return defaultParameters;
    }

    public abstract List getInputTables();

    public List getOutputTables() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{"building_indicators", "block_indicators", "rsu_indicators", "rsu_lcz", "zone", "building", "road", "rail", "water", "vegetation", "impervious", "urban_areas", "rsu_utrf_area", "rsu_utrf_floor_area", "building_utrf", "grid_indicators", "road_traffic", "population", "ground_acoustic"});
    }

    public Object checkAndFormatLocations(Object locations) {
        if (ScriptBytecodeAdapter.isCase((Object)locations, Collection.class)) {
            return IndyInterface.bootstrap("invoke", "join", 0, locations, "_");
        }
        if (locations instanceof String) {
            return IndyInterface.bootstrap("invoke", "trim", 0, locations);
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "Invalid location input. \n", "The location input must be a string value or an array of 4 coordinates to define a bbox "));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object bdtopo_processing(Object location, H2GIS h2gis_datasource, Object processing_parameters, Object outputFolder, Object outputFiles, Object output_datasource, Object outputTableNames, Object outputSRID, Object inputSRID, Object deleteOutputData) {
        void var3_3;
        Reference h2gis_datasource2 = new Reference((Object)h2gis_datasource);
        Reference processing_parameters2 = new Reference((Object)var3_3);
        Reference inputSRID2 = new Reference(inputSRID);
        Map outputTableNamesResult = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        CallSite grid_indicators_params = IndyInterface.bootstrap("getProperty", "grid_indicators", 0, processing_parameters2.get());
        Object outputGrid = "geojson";
        if (IndyInterface.bootstrap("cast", "()", 0, grid_indicators_params) != false) {
            outputGrid = IndyInterface.bootstrap("getProperty", "output", 0, grid_indicators_params);
        }
        Reference tmp_results = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _bdtopo_processing_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference h2gis_datasource;
            private /* synthetic */ Reference inputSRID;
            private /* synthetic */ Reference processing_parameters;
            private /* synthetic */ Reference tmp_results;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _bdtopo_processing_closure9(Object _outerInstance, Object _thisObject, Reference h2gis_datasource, Reference inputSRID, Reference processing_parameters, Reference tmp_results) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.h2gis_datasource = reference4 = h2gis_datasource;
                this.inputSRID = reference3 = inputSRID;
                this.processing_parameters = reference2 = processing_parameters;
                this.tmp_results = reference = tmp_results;
            }

            public Object doCall(Object row) {
                CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                CallSite code_insee = IndyInterface.bootstrap("getProperty", "code_insee", 0, row);
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{code_insee}, new String[]{"Processing the commune with the code insee :  ", ""}));
                CallSite numGeom = IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom);
                if (ScriptBytecodeAdapter.compareEqual((Object)numGeom, (Object)1)) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, geom)) == false) {
                        CallSite subCommuneTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "COMMUNE");
                        IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{subCommuneTableName, subCommuneTableName, this.inputSRID.get(), IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, false), this.inputSRID.get(), code_insee}, new String[]{"\n                DROP TABLE IF EXISTS ", ";\n                CREATE TABLE ", "(the_geom GEOMETRY(POLYGON,", "), CODE_INSEE VARCHAR)  AS \n                SELECT ST_GEOMFROMTEXT('", "', ", ") as the_geom , '", "' AS CODE_INSEE\n                "})));
                        CallSite results = IndyInterface.bootstrap("invoke", "bdTopoProcessingSingleArea", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), code_insee, subCommuneTableName, this.inputSRID.get(), this.processing_parameters.get());
                        if (IndyInterface.bootstrap("cast", "()", 0, results) != false) {
                            return IndyInterface.bootstrap("invoke", "put", 0, this.tmp_results.get(), code_insee, results);
                        }
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "info", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{code_insee, numGeom}, new String[]{"The location ", " is represented by ", " polygons\n. "}), "GeoClimate will process each polygon individually."));
                    int subAreaCount = 1;
                    Object i = null;
                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ScriptBytecodeAdapter.createRange((Object)0, (Object)numGeom, (boolean)false, (boolean)true)));
                    if (callSite != null) {
                        while (callSite.hasNext()) {
                            i = callSite.next();
                            IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{subAreaCount, numGeom}, new String[]{"Processing the polygon ", " on ", " "}));
                            CallSite subGeom = IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i);
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, subGeom)) == false) {
                                CallSite subCommuneTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "COMMUNE");
                                GStringImpl code_insee_plus_indice = new GStringImpl(new Object[]{code_insee, subAreaCount}, new String[]{"", "_", ""});
                                IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{subCommuneTableName, subCommuneTableName, this.inputSRID.get(), subGeom, this.inputSRID.get(), code_insee_plus_indice}, new String[]{"\n                DROP TABLE IF EXISTS ", ";\n                CREATE TABLE ", "(the_geom GEOMETRY(POLYGON,", "), CODE_INSEE VARCHAR)  AS \n                SELECT ST_GEOMFROMTEXT('", "', ", ") as the_geom , '", "' AS CODE_INSEE\n                "})));
                                CallSite results = IndyInterface.bootstrap("invoke", "bdTopoProcessingSingleArea", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), code_insee, subCommuneTableName, this.inputSRID.get(), this.processing_parameters.get());
                                if (IndyInterface.bootstrap("cast", "()", 0, results) != false) {
                                    IndyInterface.bootstrap("invoke", "put", 0, this.tmp_results.get(), code_insee_plus_indice, results);
                                }
                            }
                            int n = subAreaCount;
                            subAreaCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                        }
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public H2GIS getH2gis_datasource() {
                return IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get());
            }

            @Generated
            public Object getInputSRID() {
                return this.inputSRID.get();
            }

            @Generated
            public Object getProcessing_parameters() {
                return this.processing_parameters.get();
            }

            @Generated
            public Object getTmp_results() {
                return this.tmp_results.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _bdtopo_processing_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachRow", 0, (H2GIS)h2gis_datasource2.get(), "SELECT ST_CollectionExtract(THE_GEOM, 3) as the_geom,code_insee  FROM COMMUNE", new _bdtopo_processing_closure9((Object)this, (Object)this, h2gis_datasource2, inputSRID2, processing_parameters2, tmp_results));
        if (IndyInterface.bootstrap("cast", "()", 0, tmp_results.get()) != false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, tmp_results.get()), (Object)1)) {
                Reference res = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                public final class _bdtopo_processing_closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference res;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _bdtopo_processing_closure10(Object _outerInstance, Object _thisObject, Reference res) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.res = reference = res;
                    }

                    public Object doCall(Object code) {
                        public final class _closure25
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference res;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure25(Object _outerInstance, Object _thisObject, Reference res) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.res = reference = res;
                            }

                            public Object doCall(Object it) {
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 0, it)) != false) {
                                    return IndyInterface.bootstrap("invoke", "put", 0, this.res.get(), IndyInterface.bootstrap("getProperty", "key", 0, it), IndyInterface.bootstrap("getProperty", "value", 0, it));
                                }
                                return null;
                            }

                            @Generated
                            public Object getRes() {
                                return this.res.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure25.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "value", 0, code), new _closure25((Object)this, this.getThisObject(), this.res));
                    }

                    @Generated
                    public Object getRes() {
                        return this.res.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _bdtopo_processing_closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, tmp_results.get(), new _bdtopo_processing_closure10((Object)this, (Object)this, res));
                IndyInterface.bootstrap("invoke", "computeGridIndicators", 2, this, (H2GIS)h2gis_datasource2.get(), location, inputSRID2.get(), processing_parameters2.get(), res.get());
                IndyInterface.bootstrap("invoke", "put", 0, outputTableNamesResult, location, res.get());
                IndyInterface.bootstrap("invoke", "saveResults", 2, this, (H2GIS)h2gis_datasource2.get(), location, res.get(), inputSRID2.get(), outputFolder, outputFiles, output_datasource, outputTableNames, outputSRID, deleteOutputData, outputGrid);
            } else {
                Reference tablesToMerge = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"zone", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "road", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "rail", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "water", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "vegetation", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "impervious", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "building", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "building_indicators", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "block_indicators", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "rsu_indicators", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "rsu_lcz", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "rsu_utrf_area", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "rsu_utrf_floor_area", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "building_utrf", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "population", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "road_traffic", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "grid_indicators", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "urban_areas", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "ground_acoustic", ScriptBytecodeAdapter.createList((Object[])new Object[0])}));
                public final class _bdtopo_processing_closure11
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tablesToMerge;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _bdtopo_processing_closure11(Object _outerInstance, Object _thisObject, Reference tablesToMerge) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.tablesToMerge = reference = tablesToMerge;
                    }

                    public Object doCall(Object code) {
                        public final class _closure26
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference tablesToMerge;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure26(Object _outerInstance, Object _thisObject, Reference tablesToMerge) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.tablesToMerge = reference = tablesToMerge;
                            }

                            public Object doCall(Object it) {
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 0, it)) != false) {
                                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.tablesToMerge.get(), IndyInterface.bootstrap("getProperty", "key", 0, it)), IndyInterface.bootstrap("getProperty", "value", 0, it));
                                }
                                return null;
                            }

                            @Generated
                            public Object getTablesToMerge() {
                                return this.tablesToMerge.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure26.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "value", 0, code), new _closure26((Object)this, this.getThisObject(), this.tablesToMerge));
                    }

                    @Generated
                    public Object getTablesToMerge() {
                        return this.tablesToMerge.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _bdtopo_processing_closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, tmp_results.get(), new _bdtopo_processing_closure11((Object)this, (Object)this, tablesToMerge));
                CallSite results = IndyInterface.bootstrap("invoke", "mergeResultTables", 2, this, tablesToMerge.get(), (H2GIS)h2gis_datasource2.get());
                IndyInterface.bootstrap("invoke", "computeGridIndicators", 2, this, (H2GIS)h2gis_datasource2.get(), location, inputSRID2.get(), processing_parameters2.get(), results);
                IndyInterface.bootstrap("invoke", "put", 0, outputTableNamesResult, location, results);
                IndyInterface.bootstrap("invoke", "saveResults", 2, this, (H2GIS)h2gis_datasource2.get(), location, results, inputSRID2.get(), outputFolder, outputFiles, output_datasource, outputTableNames, outputSRID, deleteOutputData, outputGrid);
            }
        }
        return outputTableNamesResult;
    }

    public Object mergeResultTables(Object tablesToMerge, H2GIS h2gis_datasource) {
        Reference h2gis_datasource2 = new Reference((Object)h2gis_datasource);
        Reference results = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Reference con = new Reference((Object)IndyInterface.bootstrap("invoke", "getConnection", 0, (H2GIS)h2gis_datasource2.get()));
        public final class _mergeResultTables_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference con;
            private /* synthetic */ Reference h2gis_datasource;
            private /* synthetic */ Reference results;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mergeResultTables_closure12(Object _outerInstance, Object _thisObject, Reference con, Reference h2gis_datasource, Reference results) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.con = reference3 = con;
                this.h2gis_datasource = reference2 = h2gis_datasource;
                this.results = reference = results;
            }

            public Object doCall(Object it) {
                CallSite tableNames = IndyInterface.bootstrap("getProperty", "value", 0, it);
                Reference queryToJoin = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                Reference tmp_table = new Reference(null);
                String cfr_ignored_0 = (String)tmp_table.get();
                Reference allColumns = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class)));
                Reference tableAndColumns = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                public final class _closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference con;
                    private /* synthetic */ Reference allColumns;
                    private /* synthetic */ Reference tableAndColumns;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure27(Object _outerInstance, Object _thisObject, Reference con, Reference allColumns, Reference tableAndColumns) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.con = reference3 = con;
                        this.allColumns = reference2 = allColumns;
                        this.tableAndColumns = reference = tableAndColumns;
                    }

                    public Object doCall(Object tableName) {
                        if (IndyInterface.bootstrap("cast", "()", 0, tableName) != false) {
                            CallSite tableColumns = IndyInterface.bootstrap("invoke", "getColumnNames", 0, JDBCUtilities.class, this.con.get(), tableName);
                            IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.allColumns.get()), tableColumns);
                            return IndyInterface.bootstrap("invoke", "put", 0, this.tableAndColumns.get(), tableName, tableColumns);
                        }
                        return null;
                    }

                    @Generated
                    public Object getCon() {
                        return this.con.get();
                    }

                    @Generated
                    public HashSet getAllColumns() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.allColumns.get());
                    }

                    @Generated
                    public Object getTableAndColumns() {
                        return this.tableAndColumns.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, tableNames, new _closure27((Object)this, this.getThisObject(), this.con, allColumns, tableAndColumns));
                public final class _closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tableAndColumns;
                    private /* synthetic */ Reference allColumns;
                    private /* synthetic */ Reference queryToJoin;
                    private /* synthetic */ Reference tmp_table;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure28(Object _outerInstance, Object _thisObject, Reference tableAndColumns, Reference allColumns, Reference queryToJoin, Reference tmp_table) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.tableAndColumns = reference4 = tableAndColumns;
                        this.allColumns = reference3 = allColumns;
                        this.queryToJoin = reference2 = queryToJoin;
                        this.tmp_table = reference = tmp_table;
                    }

                    public Object doCall(Object tableName) {
                        Reference columns = new Reference((Object)IndyInterface.bootstrap("invoke", "get", 0, this.tableAndColumns.get(), tableName));
                        Reference joinColumns = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                        public final class _closure29
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference columns;
                            private /* synthetic */ Reference joinColumns;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure29(Object _outerInstance, Object _thisObject, Reference columns, Reference joinColumns) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.columns = reference2 = columns;
                                this.joinColumns = reference = joinColumns;
                            }

                            public Object doCall(Object col) {
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.columns.get(), col)) == false) {
                                    return IndyInterface.bootstrap("invoke", "leftShift", 0, this.joinColumns.get(), new GStringImpl(new Object[]{col}, new String[]{"null as ", ""}));
                                }
                                return IndyInterface.bootstrap("invoke", "leftShift", 0, this.joinColumns.get(), col);
                            }

                            @Generated
                            public Object getColumns() {
                                return this.columns.get();
                            }

                            @Generated
                            public Object getJoinColumns() {
                                return this.joinColumns.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure29.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("cast", "()", 0, this.allColumns.get()), new _closure29((Object)this, this.getThisObject(), columns, joinColumns));
                        IndyInterface.bootstrap("invoke", "leftShift", 0, this.queryToJoin.get(), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, joinColumns.get(), ","), tableName}, new String[]{"SELECT ", " FROM ", ""}));
                        Object object = tableName;
                        this.tmp_table.set((Object)IndyInterface.bootstrap("cast", "()", 0, object));
                        return object;
                    }

                    @Generated
                    public Object getTableAndColumns() {
                        return this.tableAndColumns.get();
                    }

                    @Generated
                    public HashSet getAllColumns() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.allColumns.get());
                    }

                    @Generated
                    public Object getQueryToJoin() {
                        return this.queryToJoin.get();
                    }

                    @Generated
                    public String getTmp_table() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.tmp_table.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, tableNames, new _closure28((Object)this, this.getThisObject(), tableAndColumns, allColumns, queryToJoin, tmp_table));
                if (IndyInterface.bootstrap("cast", "()", 0, (String)tmp_table.get()) != false) {
                    CallSite finalTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, IndyInterface.bootstrap("invoke", "substring", 0, (String)tmp_table.get(), false, IndyInterface.bootstrap("invoke", "lastIndexOf", 0, (String)tmp_table.get(), "_")));
                    IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{finalTableName, finalTableName, IndyInterface.bootstrap("invoke", "join", 0, queryToJoin.get(), " union all "), IndyInterface.bootstrap("invoke", "join", 0, tableNames, ",")}, new String[]{"\n                        DROP TABLE IF EXISTS ", ";\n                        CREATE TABLE ", " as ", ";\n                        DROP TABLE IF EXISTS  ", " "})));
                    return IndyInterface.bootstrap("invoke", "put", 0, this.results.get(), IndyInterface.bootstrap("getProperty", "key", 0, it), finalTableName);
                }
                return null;
            }

            @Generated
            public Object getCon() {
                return this.con.get();
            }

            @Generated
            public H2GIS getH2gis_datasource() {
                return IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get());
            }

            @Generated
            public Object getResults() {
                return this.results.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergeResultTables_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, tablesToMerge, new _mergeResultTables_closure12((Object)this, (Object)this, con, h2gis_datasource2, results));
        return results.get();
    }

    public Object computeGridIndicators(H2GIS h2gis_datasource, Object id_zone, Object srid, Object processing_parameters, Object results) {
        CallSite grid_indicators_params = IndyInterface.bootstrap("getProperty", "grid_indicators", 0, processing_parameters);
        if (IndyInterface.bootstrap("cast", "()", 0, grid_indicators_params) != false) {
            CallSite x_size = IndyInterface.bootstrap("getProperty", "x_size", 0, grid_indicators_params);
            CallSite y_size = IndyInterface.bootstrap("getProperty", "y_size", 0, grid_indicators_params);
            CallSite geomEnv = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getExtent", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, IndyInterface.bootstrap("getProperty", "zone", 0, results))));
            CallSite gridTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createGrid", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), h2gis_datasource, geomEnv, x_size, y_size, srid, IndyInterface.bootstrap("getProperty", "rowCol", 0, grid_indicators_params)));
            if (IndyInterface.bootstrap("cast", "()", 0, gridTableName) != false) {
                CallSite rasterizedIndicators = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "rasterizeIndicators", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), h2gis_datasource, gridTableName, IndyInterface.bootstrap("getProperty", "indicators", 0, grid_indicators_params), IndyInterface.bootstrap("getProperty", "building", 0, results), IndyInterface.bootstrap("getProperty", "road", 0, results), IndyInterface.bootstrap("getProperty", "vegetation", 0, results), IndyInterface.bootstrap("getProperty", "water", 0, results), IndyInterface.bootstrap("getProperty", "impervious", 0, results), IndyInterface.bootstrap("getProperty", "rsu_lcz", 0, results), IndyInterface.bootstrap("getProperty", "rsu_utrf_area", 0, results), "", "", IndyInterface.bootstrap("getProperty", "prefixName", 0, processing_parameters)));
                if (IndyInterface.bootstrap("cast", "()", 0, rasterizedIndicators) != false) {
                    return IndyInterface.bootstrap("invoke", "put", 0, results, "grid_indicators", rasterizedIndicators);
                }
            } else {
                return IndyInterface.bootstrap("invoke", "info", 2, this, "Cannot create a grid to aggregate the indicators");
            }
        }
        return null;
    }

    public Object saveResults(Object h2gis_datasource, Object id_zone, Object results, Object srid, Object outputFolder, Object outputFiles, Object output_datasource, Object outputTableNames, Object outputSRID, Object deleteOutputData, Object outputGrid) {
        Boolean reproject = false;
        if (IndyInterface.bootstrap("cast", "()", 0, outputSRID) != false) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)outputSRID, (Object)srid)) {
                reproject = true;
            }
        } else {
            outputSRID = srid;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)outputFolder) && DefaultTypeTransformation.booleanUnbox((Object)outputFiles)) {
            IndyInterface.bootstrap("invoke", "saveOutputFiles", 2, this, h2gis_datasource, results, outputFiles, outputFolder, outputSRID, reproject, deleteOutputData, outputGrid);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, output_datasource) != false) {
            return IndyInterface.bootstrap("invoke", "saveTablesInDatabase", 2, this, output_datasource, h2gis_datasource, outputTableNames, results, id_zone, srid, outputSRID, reproject);
        }
        return null;
    }

    public Object bdTopoProcessingSingleArea(Object h2gis_datasource, Object id_zone, Object subCommuneTableName, Object srid, Object processing_parameters) {
        Reference subCommuneTableName2 = new Reference(subCommuneTableName);
        Map results = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        public final class _bdTopoProcessingSingleArea_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference subCommuneTableName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _bdTopoProcessingSingleArea_closure13(Object _outerInstance, Object _thisObject, Reference subCommuneTableName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.subCommuneTableName = reference = subCommuneTableName;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{it, ScriptBytecodeAdapter.compareEqual((Object)it, (Object)"commune") ? this.subCommuneTableName.get() : it});
            }

            @Generated
            public Object getSubCommuneTableName() {
                return this.subCommuneTableName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _bdTopoProcessingSingleArea_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite layers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "getInputTables", 2, this), new _bdTopoProcessingSingleArea_closure13((Object)this, (Object)this, subCommuneTableName2)));
        CallSite dataFormated = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatLayers", 2, this, h2gis_datasource, layers, IndyInterface.bootstrap("getProperty", "distance", 0, processing_parameters), IndyInterface.bootstrap("getProperty", "hLevMin", 0, processing_parameters)));
        if (IndyInterface.bootstrap("cast", "()", 0, dataFormated) != false) {
            List tablesToDrop = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            CallSite building = IndyInterface.bootstrap("getProperty", "building", 0, dataFormated);
            CallSite road = IndyInterface.bootstrap("getProperty", "road", 0, dataFormated);
            CallSite rail = IndyInterface.bootstrap("getProperty", "rail", 0, dataFormated);
            CallSite water = IndyInterface.bootstrap("getProperty", "water", 0, dataFormated);
            CallSite vegetation = IndyInterface.bootstrap("getProperty", "vegetation", 0, dataFormated);
            CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, dataFormated);
            CallSite impervious = IndyInterface.bootstrap("getProperty", "impervious", 0, dataFormated);
            CallSite urban_areas = IndyInterface.bootstrap("getProperty", "urban_areas", 0, dataFormated);
            IndyInterface.bootstrap("invoke", "info", 2, this, "BDTOPO V2 GIS layers formated");
            CallSite rsu_indicators_params = IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, processing_parameters);
            CallSite worldpop_indicators = IndyInterface.bootstrap("getProperty", "worldpop_indicators", 0, processing_parameters);
            IndyInterface.bootstrap("invoke", "put", 0, results, "zone", zone);
            IndyInterface.bootstrap("invoke", "put", 0, results, "road", road);
            IndyInterface.bootstrap("invoke", "put", 0, results, "rail", rail);
            IndyInterface.bootstrap("invoke", "put", 0, results, "water", water);
            IndyInterface.bootstrap("invoke", "put", 0, results, "vegetation", vegetation);
            IndyInterface.bootstrap("invoke", "put", 0, results, "impervious", impervious);
            IndyInterface.bootstrap("invoke", "put", 0, results, "urban_areas", urban_areas);
            IndyInterface.bootstrap("invoke", "put", 0, results, "building", building);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "indicatorUse", 0, rsu_indicators_params)) != false) {
                IndyInterface.bootstrap("invoke", "put", 0, rsu_indicators_params, "utrfModelName", "UTRF_BDTOPO_V2_RF_2_2.model");
                CallSite geoIndicators = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "computeAllGeoIndicators", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), h2gis_datasource, zone, building, road, rail, vegetation, water, impervious, "", "", urban_areas, "", rsu_indicators_params, IndyInterface.bootstrap("getProperty", "prefixName", 0, processing_parameters)));
                if (IndyInterface.bootstrap("cast", "()", 0, geoIndicators) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{id_zone}, new String[]{"Cannot build the geoindicators for the zone ", ""}));
                } else {
                    IndyInterface.bootstrap("invoke", "putAll", 0, results, geoIndicators);
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, worldpop_indicators) != false) {
                CallSite envelope = IndyInterface.bootstrap("invoke", "getEnvelopeInternal", 0, IndyInterface.bootstrap("getProperty", "geom", 0, IndyInterface.bootstrap("invoke", "firstRow", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{zone}, new String[]{"select st_transform(the_geom, 4326) as geom from ", ""})))));
                List bbox = ScriptBytecodeAdapter.createList((Object[])new Object[]{(Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMinY", 0, envelope), Float.class)), (Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMinX", 0, envelope), Float.class)), (Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMaxY", 0, envelope), Float.class)), (Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMaxX", 0, envelope), Float.class))});
                String coverageId = "wpGlobal:ppp_2018";
                CallSite worldPopFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractWorldPopLayer", 0, IndyInterface.bootstrap("getProperty", "Extract", 0, WorldPopTools.class), coverageId, bbox));
                if (IndyInterface.bootstrap("cast", "()", 0, worldPopFile) != false) {
                    CallSite worldPopTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "importAscGrid", 0, IndyInterface.bootstrap("getProperty", "Extract", 0, WorldPopTools.class), h2gis_datasource, worldPopFile, srid, IndyInterface.bootstrap("invoke", "replaceAll", 0, coverageId, ":", "_")));
                    if (IndyInterface.bootstrap("cast", "()", 0, worldPopTableName) != false) {
                        IndyInterface.bootstrap("invoke", "put", 0, results, "population", worldPopTableName);
                        building = IndyInterface.bootstrap("invoke", "buildingPopulation", 0, IndyInterface.bootstrap("getProperty", "BuildingIndicators", 0, Geoindicators.class), h2gis_datasource, IndyInterface.bootstrap("getProperty", "building", 0, results), worldPopTableName, ScriptBytecodeAdapter.createList((Object[])new Object[]{"pop"}));
                        if (IndyInterface.bootstrap("cast", "()", 0, building) == false) {
                            IndyInterface.bootstrap("invoke", "info", 2, this, "Cannot compute any population data at building level");
                        }
                        IndyInterface.bootstrap("invoke", "leftShift", 0, tablesToDrop, IndyInterface.bootstrap("getProperty", "building", 0, results));
                        IndyInterface.bootstrap("invoke", "put", 0, results, "building", building);
                    } else {
                        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{worldPopFile}, new String[]{"Cannot import the worldpop asc file ", ""}));
                        IndyInterface.bootstrap("invoke", "info", 2, this, "Create a default empty worldpop table");
                        CallSite outputTableWorldPopName = IndyInterface.bootstrap("invoke", "postfix", 0, AbstractBDTopoWorkflow.class, "world_pop");
                        IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, srid}, new String[]{"drop table if exists ", ";\n                    create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_POP INTEGER, POP FLOAT);"})));
                        IndyInterface.bootstrap("invoke", "put", 0, results, "population", outputTableWorldPopName);
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{coverageId}, new String[]{"Cannot find the population grid ", " \n Create a default empty worldpop table"}));
                    CallSite outputTableWorldPopName = IndyInterface.bootstrap("invoke", "postfix", 0, AbstractBDTopoWorkflow.class, "world_pop");
                    IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, srid}, new String[]{"drop table if exists ", ";\n                    create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_POP INTEGER, POP FLOAT);"})));
                    IndyInterface.bootstrap("invoke", "put", 0, results, "population", outputTableWorldPopName);
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "road_traffic", 0, processing_parameters)) != false) {
                CallSite road_traffic = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build_road_traffic", 0, IndyInterface.bootstrap("getProperty", "RoadIndicators", 0, Geoindicators.class), h2gis_datasource, road));
                IndyInterface.bootstrap("invoke", "put", 0, results, "road_traffic", road_traffic);
            }
            CallSite noise_indicators = IndyInterface.bootstrap("getProperty", "noise_indicators", 0, processing_parameters);
            CallSite geomEnv = null;
            if (IndyInterface.bootstrap("cast", "()", 0, noise_indicators) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ground_acoustic", 0, noise_indicators)) != false) {
                geomEnv = IndyInterface.bootstrap("invoke", "getExtent", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, zone));
                CallSite gridP = IndyInterface.bootstrap("invoke", "createGrid", 0, IndyInterface.bootstrap("getProperty", "SpatialUnits", 0, Geoindicators.class), h2gis_datasource, geomEnv, 200, 200);
                if (IndyInterface.bootstrap("cast", "()", 0, gridP) != false) {
                    CallSite ground_acoustic = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groundAcousticAbsorption", 0, IndyInterface.bootstrap("getProperty", "NoiseIndicators", 0, Geoindicators.class), h2gis_datasource, gridP, "id_grid", building, road, water, vegetation, impervious));
                    if (IndyInterface.bootstrap("cast", "()", 0, ground_acoustic) != false) {
                        IndyInterface.bootstrap("invoke", "put", 0, results, "ground_acoustic", ground_acoustic);
                    }
                    IndyInterface.bootstrap("invoke", "leftShift", 0, tablesToDrop, gridP);
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, tablesToDrop) != false) {
                IndyInterface.bootstrap("invoke", "execute", 0, h2gis_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, tablesToDrop, ",")}, new String[]{"DROP TABLE IF EXISTS ", ""})));
            }
            IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{id_zone}, new String[]{"", " has been processed"}));
            return results;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object saveOutputFiles(Object h2gis_datasource, Object results, Object outputFiles, Object outputFolder, Object outputSRID, Object reproject, Object deleteOutputData, Object outputGrid) {
        void var2_2;
        Reference h2gis_datasource2 = new Reference(h2gis_datasource);
        Reference results2 = new Reference((Object)var2_2);
        Reference outputFolder2 = new Reference(outputFolder);
        Reference outputSRID2 = new Reference(outputSRID);
        Reference reproject2 = new Reference(reproject);
        Reference deleteOutputData2 = new Reference(deleteOutputData);
        Reference outputGrid2 = new Reference(outputGrid);
        public final class _saveOutputFiles_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference outputGrid;
            private /* synthetic */ Reference results;
            private /* synthetic */ Reference outputFolder;
            private /* synthetic */ Reference h2gis_datasource;
            private /* synthetic */ Reference outputSRID;
            private /* synthetic */ Reference reproject;
            private /* synthetic */ Reference deleteOutputData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _saveOutputFiles_closure14(Object _outerInstance, Object _thisObject, Reference outputGrid, Reference results, Reference outputFolder, Reference h2gis_datasource, Reference outputSRID, Reference reproject, Reference deleteOutputData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                this.outputGrid = reference7 = outputGrid;
                this.results = reference6 = results;
                this.outputFolder = reference5 = outputFolder;
                this.h2gis_datasource = reference4 = h2gis_datasource;
                this.outputSRID = reference3 = outputSRID;
                this.reproject = reference2 = reproject;
                this.deleteOutputData = reference = deleteOutputData;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareEqual((Object)it, (Object)"grid_indicators")) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)this.outputGrid.get(), (Object)"geojson")) {
                        return IndyInterface.bootstrap("invoke", "saveToGeojson", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), ScriptBytecodeAdapter.getProperty(_saveOutputFiles_closure14.class, (Object)this.results.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, this.outputFolder.get(), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), it)}, new String[]{"", ".geojson"}), this.h2gis_datasource.get(), this.outputSRID.get(), this.reproject.get(), this.deleteOutputData.get());
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)this.outputGrid.get(), (Object)"asc")) {
                        return IndyInterface.bootstrap("invoke", "saveToAscGrid", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), ScriptBytecodeAdapter.getProperty(_saveOutputFiles_closure14.class, (Object)this.results.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), this.outputFolder.get(), it, this.h2gis_datasource.get(), this.outputSRID.get(), this.reproject.get(), this.deleteOutputData.get());
                    }
                } else {
                    return IndyInterface.bootstrap("invoke", "saveToGeojson", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), ScriptBytecodeAdapter.getProperty(_saveOutputFiles_closure14.class, (Object)this.results.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, this.outputFolder.get(), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), it)}, new String[]{"", ".geojson"}), this.h2gis_datasource.get(), this.outputSRID.get(), this.reproject.get(), this.deleteOutputData.get());
                }
                return null;
            }

            @Generated
            public Object getOutputGrid() {
                return this.outputGrid.get();
            }

            @Generated
            public Object getResults() {
                return this.results.get();
            }

            @Generated
            public Object getOutputFolder() {
                return this.outputFolder.get();
            }

            @Generated
            public Object getH2gis_datasource() {
                return this.h2gis_datasource.get();
            }

            @Generated
            public Object getOutputSRID() {
                return this.outputSRID.get();
            }

            @Generated
            public Object getReproject() {
                return this.reproject.get();
            }

            @Generated
            public Object getDeleteOutputData() {
                return this.deleteOutputData.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _saveOutputFiles_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "each", 0, outputFiles, new _saveOutputFiles_closure14((Object)this, (Object)this, outputGrid2, results2, outputFolder2, h2gis_datasource2, outputSRID2, reproject2, deleteOutputData2));
    }

    public Object saveTablesInDatabase(Object output_datasource, Object h2gis_datasource, Object outputTableNames, Object h2gis_tables, Object id_zone, Object inputSRID, Object outputSRID, Object reproject) {
        CallSite con = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getConnection", 0, output_datasource));
        IndyInterface.bootstrap("invoke", "setAutoCommit", 0, con, true);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "building_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "building_indicators", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "block_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "block_indicators", 0, h2gis_tables), "where ID_RSU IS NOT NULL", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_lcz", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_lcz", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_area", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_area", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_floor_area", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_floor_area", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "building_utrf", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "building_utrf", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "grid_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "grid_indicators", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "road_traffic", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "road_traffic", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "zone", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "zone", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "building", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "building", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "road", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "road", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rail", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rail", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "vegetation", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "vegetation", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "water", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "water", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "impervious", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "impervious", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "population", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "population", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        return IndyInterface.bootstrap("invoke", "setAutoCommit", 0, con, false);
    }

    public Object abstractModelTableBatchExportTable(Object output_datasource, Object output_table, Object id_zone, Object h2gis_datasource, Object h2gis_table_to_save, Object filter, Object inputSRID, Object outputSRID, Object reproject) {
        block15: {
            Reference output_table2;
            block16: {
                output_table2 = new Reference(output_table);
                if (IndyInterface.bootstrap("cast", "()", 0, output_table2.get()) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, h2gis_datasource, h2gis_table_to_save)) == false) break block15;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, output_datasource, output_table2.get())) == false) break block16;
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get(), id_zone}, new String[]{"Start to export the table ", " into the table ", " for the zone ", ""}));
                int BATCH_MAX_SIZE = 100;
                Reference inputRes = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "prepareTableOutput", 2, this, h2gis_table_to_save, filter, inputSRID, h2gis_datasource, output_table2.get(), outputSRID, output_datasource)));
                if (IndyInterface.bootstrap("cast", "()", 0, (ITable)inputRes.get()) == false) break block15;
                Reference outputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, IndyInterface.bootstrap("invoke", "getTable", 0, output_datasource, output_table2.get())));
                CallSite outputconnection = IndyInterface.bootstrap("invoke", "getConnection", 0, output_datasource);
                Reference inputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, (ITable)inputRes.get()));
                Reference outPutColumnsNames = new Reference((Object)IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get()));
                IndyInterface.bootstrap("invoke", "remove", 0, outPutColumnsNames.get(), "gid");
                public final class _abstractModelTableBatchExportTable_closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference outPutColumnsNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure15(Object _outerInstance, Object _thisObject, Reference outPutColumnsNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.outPutColumnsNames = reference = outPutColumnsNames;
                    }

                    public Object doCall(Object e) {
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(_abstractModelTableBatchExportTable_closure15.class, (Object)this.outPutColumnsNames.get(), (String)"toLowerCase"), IndyInterface.bootstrap("invoke", "toLowerCase", 0, e))) == false;
                    }

                    @Generated
                    public Object getOutPutColumnsNames() {
                        return this.outPutColumnsNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference diffCols = new Reference((Object)IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "keySet", 0, inputColumns.get()), new _abstractModelTableBatchExportTable_closure15((Object)this, (Object)this, outPutColumnsNames)));
                Reference alterTable = new Reference((Object)"");
                if (IndyInterface.bootstrap("cast", "()", 0, diffCols.get()) != false) {
                    public final class _abstractModelTableBatchExportTable_closure16
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference diffCols;
                        private /* synthetic */ Reference alterTable;
                        private /* synthetic */ Reference output_table;
                        private /* synthetic */ Reference outputColumns;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _abstractModelTableBatchExportTable_closure16(Object _outerInstance, Object _thisObject, Reference diffCols, Reference alterTable, Reference output_table, Reference outputColumns) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            this.diffCols = reference4 = diffCols;
                            this.alterTable = reference3 = alterTable;
                            this.output_table = reference2 = output_table;
                            this.outputColumns = reference = outputColumns;
                        }

                        public Object doCall(Object entry) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.diffCols.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry))) != false) {
                                Object dataType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry), "decfloat")) != false ? "FLOAT" : IndyInterface.bootstrap("getProperty", "value", 0, entry);
                                this.alterTable.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, this.alterTable.get(), new GStringImpl(new Object[]{this.output_table.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType}, new String[]{"ALTER TABLE ", " ADD COLUMN ", " ", ";"})));
                                return IndyInterface.bootstrap("invoke", "put", 0, this.outputColumns.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType);
                            }
                            return null;
                        }

                        @Generated
                        public Object getDiffCols() {
                            return this.diffCols.get();
                        }

                        @Generated
                        public Object getAlterTable() {
                            return this.alterTable.get();
                        }

                        @Generated
                        public Object getOutput_table() {
                            return this.output_table.get();
                        }

                        @Generated
                        public Object getOutputColumns() {
                            return this.outputColumns.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure16.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, inputColumns.get(), new _abstractModelTableBatchExportTable_closure16((Object)this, (Object)this, diffCols, alterTable, output_table2, outputColumns));
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, alterTable.get()));
                }
                CallSite finalOutputColumns = IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get());
                Object insertTable = new GStringImpl(new Object[]{output_table2.get(), IndyInterface.bootstrap("invoke", "join", 0, finalOutputColumns, ",")}, new String[]{"INSERT INTO ", " (", ") VALUES("});
                public final class _abstractModelTableBatchExportTable_closure17
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure17(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object result, Object iter) {
                        result = IndyInterface.bootstrap("invoke", "plus", 0, result, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, iter))}, new String[]{":", ""}));
                        return result;
                    }

                    @Generated
                    public Object call(Object result, Object iter) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, result, iter);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure17.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite flatList = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "inject", 0, outputColumns.get(), ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _abstractModelTableBatchExportTable_closure17((Object)this, (Object)this)), ",");
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, flatList);
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, ")");
                public final class _abstractModelTableBatchExportTable_closure18
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure18(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, it), null});
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference ouputValues = new Reference((Object)IndyInterface.bootstrap("invoke", "collectEntries", 0, finalOutputColumns, new _abstractModelTableBatchExportTable_closure18((Object)this, (Object)this)));
                IndyInterface.bootstrap("invoke", "put", 0, ouputValues.get(), "id_zone", id_zone);
                IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, false);
                public final class _abstractModelTableBatchExportTable_closure19
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference inputRes;
                    private /* synthetic */ Reference inputColumns;
                    private /* synthetic */ Reference ouputValues;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure19(Object _outerInstance, Object _thisObject, Reference inputRes, Reference inputColumns, Reference ouputValues) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.inputRes = reference3 = inputRes;
                        this.inputColumns = reference2 = inputColumns;
                        this.ouputValues = reference = ouputValues;
                    }

                    public Object doCall(Object ps) {
                        Reference ps2 = new Reference(ps);
                        public final class _closure30
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference inputColumns;
                            private /* synthetic */ Reference ouputValues;
                            private /* synthetic */ Reference ps;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure30(Object _outerInstance, Object _thisObject, Reference inputColumns, Reference ouputValues, Reference ps) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                this.inputColumns = reference3 = inputColumns;
                                this.ouputValues = reference2 = ouputValues;
                                this.ps = reference = ps;
                            }

                            public Object doCall(Object row) {
                                Reference row2 = new Reference(row);
                                public final class _closure31
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference row;
                                    private /* synthetic */ Reference ouputValues;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure31(Object _outerInstance, Object _thisObject, Reference row, Reference ouputValues) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.row = reference2 = row;
                                        this.ouputValues = reference = ouputValues;
                                    }

                                    public Object doCall(Object columnName) {
                                        CallSite inputValue = IndyInterface.bootstrap("invoke", "getObject", 0, this.row.get(), columnName);
                                        if (IndyInterface.bootstrap("cast", "()", 0, inputValue) != false) {
                                            return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), inputValue);
                                        }
                                        return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), null);
                                    }

                                    @Generated
                                    public Object getRow() {
                                        return this.row.get();
                                    }

                                    @Generated
                                    public Object getOuputValues() {
                                        return this.ouputValues.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure31.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "keySet", 0, this.inputColumns.get()), new _closure31((Object)this, this.getThisObject(), row2, this.ouputValues));
                                return IndyInterface.bootstrap("invoke", "addBatch", 0, this.ps.get(), this.ouputValues.get());
                            }

                            @Generated
                            public Object getInputColumns() {
                                return this.inputColumns.get();
                            }

                            @Generated
                            public Object getOuputValues() {
                                return this.ouputValues.get();
                            }

                            @Generated
                            public Object getPs() {
                                return this.ps.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure30.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get()), new _closure30((Object)this, this.getThisObject(), this.inputColumns, this.ouputValues, ps2));
                    }

                    @Generated
                    public ITable getInputRes() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get());
                    }

                    @Generated
                    public Object getInputColumns() {
                        return this.inputColumns.get();
                    }

                    @Generated
                    public Object getOuputValues() {
                        return this.ouputValues.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure19.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "withBatch", 0, output_datasource, BATCH_MAX_SIZE, IndyInterface.bootstrap("invoke", "toString", 0, insertTable), new _abstractModelTableBatchExportTable_closure19((Object)this, (Object)this, inputRes, inputColumns, ouputValues));
                IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                try {
                    return callSite;
                }
                catch (SQLException e) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"Cannot save the table ", ".\n"}), e);
                    Boolean bl = false;
                    IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                    IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                    try {
                        return bl;
                    }
                    catch (Throwable throwable) {
                        IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                        IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                        throw throwable;
                    }
                }
            }
            CallSite tmpTable = null;
            IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"Start to export the table ", " into the table ", ""}));
            if (IndyInterface.bootstrap("cast", "()", 0, filter) != false) {
                if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), output_datasource, output_table2.get(), true);
                } else {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), outputSRID), output_datasource, output_table2.get(), true);
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", "\n                            ALTER COLUMN the_geom TYPE geometry(geometry, ", ")\n                            USING ST_SetSRID(the_geom,", ");"})));
                }
                if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), inputSRID, inputSRID}, new String[]{"ALTER TABLE ", " ALTER COLUMN the_geom TYPE geometry(GEOMETRY, ", ") USING ST_SetSRID(the_geom,", ");"})));
                }
            } else if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), output_datasource, output_table2.get(), true);
            } else {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), outputSRID), output_datasource, output_table2.get(), true);
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", "\n                            ALTER COLUMN the_geom TYPE geometry(geometry, ", ")\n                            USING ST_SetSRID(the_geom,", ");"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS gid serial;"})));
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), id_zone}, new String[]{"UPDATE ", " SET id_zone= '", "'"})));
                return IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
            }
            return IndyInterface.bootstrap("invoke", "warn", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " hasn't been exported into the table ", ""}));
        }
        return null;
    }

    public Object indicatorTableBatchExportTable(Object output_datasource, Object output_table, Object id_zone, Object h2gis_datasource, Object h2gis_table_to_save, Object filter, Object inputSRID, Object outputSRID, Object reproject) {
        block17: {
            Reference output_table2;
            block18: {
                output_table2 = new Reference(output_table);
                if (IndyInterface.bootstrap("cast", "()", 0, output_table2.get()) == false || IndyInterface.bootstrap("cast", "()", 0, h2gis_table_to_save) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, h2gis_datasource, h2gis_table_to_save)) == false) break block17;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, output_datasource, output_table2.get())) == false) break block18;
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get(), id_zone}, new String[]{"Start to export the table ", " into the table ", " for the zone ", ""}));
                int BATCH_MAX_SIZE = 100;
                Reference inputRes = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "prepareTableOutput", 2, this, h2gis_table_to_save, filter, inputSRID, h2gis_datasource, output_table2.get(), outputSRID, output_datasource)));
                if (IndyInterface.bootstrap("cast", "()", 0, (ITable)inputRes.get()) == false) break block17;
                Reference outputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, IndyInterface.bootstrap("invoke", "getTable", 0, output_datasource, output_table2.get())));
                IndyInterface.bootstrap("invoke", "remove", 0, outputColumns.get(), "gid");
                CallSite outputconnection = IndyInterface.bootstrap("invoke", "getConnection", 0, output_datasource);
                Reference inputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, (ITable)inputRes.get()));
                Reference outPutColumnsNames = new Reference((Object)IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get()));
                public final class _indicatorTableBatchExportTable_closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference outPutColumnsNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure20(Object _outerInstance, Object _thisObject, Reference outPutColumnsNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.outPutColumnsNames = reference = outPutColumnsNames;
                    }

                    public Object doCall(Object e) {
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(_indicatorTableBatchExportTable_closure20.class, (Object)this.outPutColumnsNames.get(), (String)"toLowerCase"), IndyInterface.bootstrap("invoke", "toLowerCase", 0, e))) == false;
                    }

                    @Generated
                    public Object getOutPutColumnsNames() {
                        return this.outPutColumnsNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference diffCols = new Reference((Object)IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "keySet", 0, inputColumns.get()), new _indicatorTableBatchExportTable_closure20((Object)this, (Object)this, outPutColumnsNames)));
                Reference alterTable = new Reference((Object)"");
                if (IndyInterface.bootstrap("cast", "()", 0, diffCols.get()) != false) {
                    public final class _indicatorTableBatchExportTable_closure21
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference diffCols;
                        private /* synthetic */ Reference alterTable;
                        private /* synthetic */ Reference output_table;
                        private /* synthetic */ Reference outputColumns;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _indicatorTableBatchExportTable_closure21(Object _outerInstance, Object _thisObject, Reference diffCols, Reference alterTable, Reference output_table, Reference outputColumns) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            this.diffCols = reference4 = diffCols;
                            this.alterTable = reference3 = alterTable;
                            this.output_table = reference2 = output_table;
                            this.outputColumns = reference = outputColumns;
                        }

                        public Object doCall(Object entry) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.diffCols.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry))) != false) {
                                Object dataType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry), "decfloat")) != false ? "FLOAT" : IndyInterface.bootstrap("getProperty", "value", 0, entry);
                                this.alterTable.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, this.alterTable.get(), new GStringImpl(new Object[]{this.output_table.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType}, new String[]{"ALTER TABLE ", " ADD COLUMN ", " ", ";"})));
                                return IndyInterface.bootstrap("invoke", "put", 0, this.outputColumns.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType);
                            }
                            return null;
                        }

                        @Generated
                        public Object getDiffCols() {
                            return this.diffCols.get();
                        }

                        @Generated
                        public Object getAlterTable() {
                            return this.alterTable.get();
                        }

                        @Generated
                        public Object getOutput_table() {
                            return this.output_table.get();
                        }

                        @Generated
                        public Object getOutputColumns() {
                            return this.outputColumns.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure21.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, inputColumns.get(), new _indicatorTableBatchExportTable_closure21((Object)this, (Object)this, diffCols, alterTable, output_table2, outputColumns));
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, alterTable.get()));
                }
                CallSite finalOutputColumns = IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get());
                Object insertTable = new GStringImpl(new Object[]{output_table2.get(), IndyInterface.bootstrap("invoke", "join", 0, finalOutputColumns, ",")}, new String[]{"INSERT INTO ", " (", ") VALUES("});
                public final class _indicatorTableBatchExportTable_closure22
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure22(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object result, Object iter) {
                        result = IndyInterface.bootstrap("invoke", "plus", 0, result, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, iter))}, new String[]{":", ""}));
                        return result;
                    }

                    @Generated
                    public Object call(Object result, Object iter) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, result, iter);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite flatList = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "inject", 0, outputColumns.get(), ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _indicatorTableBatchExportTable_closure22((Object)this, (Object)this)), ",");
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, flatList);
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, ")");
                public final class _indicatorTableBatchExportTable_closure23
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure23(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, it), null});
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference ouputValues = new Reference((Object)IndyInterface.bootstrap("invoke", "collectEntries", 0, finalOutputColumns, new _indicatorTableBatchExportTable_closure23((Object)this, (Object)this)));
                IndyInterface.bootstrap("invoke", "put", 0, ouputValues.get(), "id_zone", id_zone);
                IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, false);
                public final class _indicatorTableBatchExportTable_closure24
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference inputRes;
                    private /* synthetic */ Reference inputColumns;
                    private /* synthetic */ Reference ouputValues;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure24(Object _outerInstance, Object _thisObject, Reference inputRes, Reference inputColumns, Reference ouputValues) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.inputRes = reference3 = inputRes;
                        this.inputColumns = reference2 = inputColumns;
                        this.ouputValues = reference = ouputValues;
                    }

                    public Object doCall(Object ps) {
                        Reference ps2 = new Reference(ps);
                        public final class _closure32
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference inputColumns;
                            private /* synthetic */ Reference ouputValues;
                            private /* synthetic */ Reference ps;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure32(Object _outerInstance, Object _thisObject, Reference inputColumns, Reference ouputValues, Reference ps) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                this.inputColumns = reference3 = inputColumns;
                                this.ouputValues = reference2 = ouputValues;
                                this.ps = reference = ps;
                            }

                            public Object doCall(Object row) {
                                Reference row2 = new Reference(row);
                                public final class _closure33
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference row;
                                    private /* synthetic */ Reference ouputValues;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure33(Object _outerInstance, Object _thisObject, Reference row, Reference ouputValues) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.row = reference2 = row;
                                        this.ouputValues = reference = ouputValues;
                                    }

                                    public Object doCall(Object columnName) {
                                        CallSite inputValue = IndyInterface.bootstrap("invoke", "getObject", 0, this.row.get(), columnName);
                                        if (IndyInterface.bootstrap("cast", "()", 0, inputValue) != false) {
                                            return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), inputValue);
                                        }
                                        return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), null);
                                    }

                                    @Generated
                                    public Object getRow() {
                                        return this.row.get();
                                    }

                                    @Generated
                                    public Object getOuputValues() {
                                        return this.ouputValues.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure33.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "keySet", 0, this.inputColumns.get()), new _closure33((Object)this, this.getThisObject(), row2, this.ouputValues));
                                return IndyInterface.bootstrap("invoke", "addBatch", 0, this.ps.get(), this.ouputValues.get());
                            }

                            @Generated
                            public Object getInputColumns() {
                                return this.inputColumns.get();
                            }

                            @Generated
                            public Object getOuputValues() {
                                return this.ouputValues.get();
                            }

                            @Generated
                            public Object getPs() {
                                return this.ps.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure32.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get()), new _closure32((Object)this, this.getThisObject(), this.inputColumns, this.ouputValues, ps2));
                    }

                    @Generated
                    public ITable getInputRes() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get());
                    }

                    @Generated
                    public Object getInputColumns() {
                        return this.inputColumns.get();
                    }

                    @Generated
                    public Object getOuputValues() {
                        return this.ouputValues.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "withBatch", 0, output_datasource, BATCH_MAX_SIZE, IndyInterface.bootstrap("invoke", "toString", 0, insertTable), new _indicatorTableBatchExportTable_closure24((Object)this, (Object)this, inputRes, inputColumns, ouputValues));
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                try {
                    return callSite;
                }
                catch (SQLException e) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{output_table2.get(), e}, new String[]{"Cannot save the table ", ".\n ", ""}));
                    Boolean bl = false;
                    IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                    try {
                        return bl;
                    }
                    catch (Throwable throwable) {
                        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                        throw throwable;
                    }
                }
            }
            CallSite tmpTable = null;
            IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get(), id_zone}, new String[]{"Start to export the table ", " into the table ", " for the zone ", ""}));
            if (IndyInterface.bootstrap("cast", "()", 0, filter) != false) {
                if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), output_datasource, output_table2.get(), true);
                    if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                        IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", " ALTER COLUMN the_geom TYPE geometry(GEOMETRY, ", ") USING ST_SetSRID(the_geom,", ");"})));
                    }
                } else {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), outputSRID), output_datasource, output_table2.get(), true);
                    if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                        IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", " ALTER COLUMN the_geom TYPE geometry(GEOMETRY, ", ") USING ST_SetSRID(the_geom,", ");"})));
                    }
                }
            } else if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), output_datasource, output_table2.get(), true);
            } else {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), outputSRID), output_datasource, output_table2.get(), true);
                if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", " \n                            ALTER COLUMN the_geom TYPE geometry(geometry, ", ") \n                            USING ST_SetSRID(the_geom,", ");"})));
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS id_zone VARCHAR"})));
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), id_zone}, new String[]{"UPDATE ", " SET id_zone= '", "'"})));
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS gid serial;"})));
                return IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
            }
            return IndyInterface.bootstrap("invoke", "warn", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " hasn't been exported into the table ", ""}));
        }
        return null;
    }

    public Object prepareTableOutput(Object h2gis_table_to_save, Object filter, Object inputSRID, Object h2gis_datasource, Object output_table, Object outputSRID, Object output_datasource) {
        CallSite targetTableSrid = IndyInterface.bootstrap("getProperty", "srid", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, output_datasource, output_table));
        if (IndyInterface.bootstrap("cast", "()", 0, filter) != false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)outputSRID, (Object)0)) {
                if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "getTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, AbstractBDTopoWorkflow.class, (GroovyObject)this, (String)"inputRes");
                    return callSite;
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
                    return IndyInterface.bootstrap("invoke", "getTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter));
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
                    return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), targetTableSrid);
                }
                IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
                return null;
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), targetTableSrid);
            }
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
            return null;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)outputSRID, (Object)0)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), targetTableSrid);
            }
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
            return null;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
            return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
            return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
            return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), targetTableSrid);
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
        return null;
    }

    public abstract int getVersion();

    public abstract Map formatLayers(JdbcDataSource var1, Map var2, float var3, float var4);

    /*
     * WARNING - void declaration
     */
    @Generated
    public Object bdtopo_processing(Object location, H2GIS h2gis_datasource, Object processing_parameters, Object outputFolder, Object outputFiles, Object output_datasource, Object outputTableNames, Object outputSRID, Object inputSRID) {
        void var3_3;
        Reference h2gis_datasource2 = new Reference((Object)h2gis_datasource);
        Reference processing_parameters2 = new Reference((Object)var3_3);
        Reference inputSRID2 = new Reference(inputSRID);
        return this.bdtopo_processing(location, (H2GIS)h2gis_datasource2.get(), processing_parameters2.get(), outputFolder, outputFiles, output_datasource, outputTableNames, outputSRID, inputSRID2.get(), true);
    }

    @Generated
    public Map formatLayers(JdbcDataSource datasource, Map layers, float distance) {
        return this.formatLayers(datasource, layers, distance, 3);
    }

    @Generated
    public Map formatLayers(JdbcDataSource datasource, Map layers) {
        return this.formatLayers(datasource, layers, 1000, 3);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AbstractBDTopoWorkflow.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        $const$0 = f5 = 1000.0f;
        $const$1 = f4 = 500.0f;
        $const$2 = f3 = 10000.0f;
        $const$3 = f2 = 2500.0f;
        $const$4 = f = 0.01f;
        $const$5 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        AbstractBDTopoWorkflow.__$swapInit();
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

