/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.geoclimate.osm;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.h2.tools.DeleteDbFiles;
import org.h2gis.functions.io.utility.IOMethods;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.GeographyUtilities;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.orbisgis.data.H2GIS;
import org.orbisgis.data.api.dataset.ITable;
import org.orbisgis.data.jdbc.JdbcDataSource;
import org.orbisgis.geoclimate.Geoindicators;
import org.orbisgis.geoclimate.osm.OSM;
import org.orbisgis.geoclimate.osmtools.OSMTools;
import org.orbisgis.geoclimate.osmtools.utils.OSMElement;
import org.orbisgis.geoclimate.worldpoptools.WorldPopTools;

public class WorkflowOSM
extends OSM {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ float $const$1;
    private static /* synthetic */ float $const$2;
    private static /* synthetic */ float $const$3;
    private static /* synthetic */ float $const$4;
    private static /* synthetic */ BigDecimal $const$5;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public static void main(String ... args) {
        IndyInterface.bootstrap("invoke", "runScript", 0, InvokerHelper.class, WorkflowOSM.class, args);
    }

    public Object run() {
        WorkflowOSM OSM2 = this;
        return OSM2;
    }

    @Override
    public Map workflow(Object input) {
        CallSite parameters = null;
        if (IndyInterface.bootstrap("cast", "()", 0, input) != false) {
            if (input instanceof String) {
                CallSite configFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, input);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isFile", 0, configFile)) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, "The configuration file doesn't exist");
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isExtensionWellFormated", 0, FileUtilities.class, configFile, "json")) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, "The configuration file must be a json file");
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                parameters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readJSON", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), configFile));
            } else if (input instanceof Map) {
                parameters = IndyInterface.bootstrap("cast", "()", 0, input);
            }
        } else {
            IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "The input parameters cannot be null or empty.\n Please set a path to a configuration file or ", "a map with all required parameters"));
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, parameters) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Wrong input parameters");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Reading file parameters");
        IndyInterface.bootstrap("invoke", "debug", 2, this, IndyInterface.bootstrap("invoke", "get", 0, parameters, "description"));
        CallSite inputParameters = IndyInterface.bootstrap("invoke", "get", 0, parameters, "input");
        CallSite outputParameter = IndyInterface.bootstrap("invoke", "get", 0, parameters, "output");
        CallSite databaseFolder = IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "java.io.tmpdir");
        CallSite databaseName = IndyInterface.bootstrap("invoke", "plus", 0, "osm", IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_"));
        CallSite databasePath = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, databaseFolder, IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), databaseName);
        Map h2gis_properties = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"databaseName", databasePath, "user", "sa", "password", ""});
        Object delete_h2gis = true;
        CallSite geoclimatedb = IndyInterface.bootstrap("invoke", "get", 0, parameters, "geoclimatedb");
        if (IndyInterface.bootstrap("cast", "()", 0, geoclimatedb) != false) {
            CallSite h2gis_folder = IndyInterface.bootstrap("invoke", "get", 0, geoclimatedb, "folder");
            if (IndyInterface.bootstrap("cast", "()", 0, h2gis_folder) != false) {
                CallSite tmp_folder_db = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, h2gis_folder));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, tmp_folder_db)) == false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdir", 0, tmp_folder_db)) == false) {
                        h2gis_folder = null;
                        IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{h2gis_folder}, new String[]{"You don't have permission to write in the folder ", " \n"}), "Please check the folder."));
                        return IndyInterface.bootstrap("cast", "()", 0, null);
                    }
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, tmp_folder_db)) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_folder}, new String[]{"Invalid output folder ", "."}));
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                databaseFolder = h2gis_folder;
            }
            databasePath = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, databaseFolder, IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), databaseName);
            CallSite h2gis_name = IndyInterface.bootstrap("invoke", "get", 0, geoclimatedb, "name");
            if (IndyInterface.bootstrap("cast", "()", 0, h2gis_name) != false) {
                CallSite dbName = IndyInterface.bootstrap("invoke", "split", 0, h2gis_name, ";");
                databaseName = IndyInterface.bootstrap("invoke", "getAt", 0, dbName, false);
                databasePath = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, databaseFolder, IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), h2gis_name);
            }
            CallSite delete_h2gis_db = IndyInterface.bootstrap("invoke", "get", 0, geoclimatedb, "delete");
            if (ScriptBytecodeAdapter.compareEqual((Object)delete_h2gis_db, null)) {
                delete_h2gis = true;
            } else if (delete_h2gis_db instanceof String) {
                delete_h2gis = true;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, delete_h2gis_db, "false")) != false) {
                    delete_h2gis = false;
                }
            } else if (delete_h2gis_db instanceof Boolean) {
                delete_h2gis = delete_h2gis_db;
            }
            if (IndyInterface.bootstrap("cast", "()", 0, databasePath) != false) {
                h2gis_properties = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"databaseName", databasePath, "user", "sa", "password", ""});
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, inputParameters) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot find any input parameters.");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Set locations = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "locations", 0, inputParameters), Set.class));
        if (IndyInterface.bootstrap("cast", "()", 0, locations) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Please set at least one OSM location (place name or bounding box).");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object downloadAllOSMData = IndyInterface.bootstrap("invoke", "get", 0, inputParameters, "all");
        if (IndyInterface.bootstrap("cast", "()", 0, downloadAllOSMData) == false) {
            downloadAllOSMData = true;
        } else if (ScriptBytecodeAdapter.isCase((Object)(IndyInterface.bootstrap("cast", "()", 0, downloadAllOSMData) == false ? 1 : 0), Boolean.class)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The all parameter must be a boolean value");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object osm_size_area = IndyInterface.bootstrap("invoke", "get", 0, inputParameters, "area");
        if (IndyInterface.bootstrap("cast", "()", 0, osm_size_area) == false) {
            osm_size_area = 1000;
        } else if (ScriptBytecodeAdapter.compareLessThan((Object)osm_size_area, (Object)0)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The area of the bounding box to be extracted from OSM must be greater than 0 km\u00b2");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object overpass_timeout = IndyInterface.bootstrap("invoke", "get", 0, inputParameters, "timeout");
        if (IndyInterface.bootstrap("cast", "()", 0, overpass_timeout) == false) {
            overpass_timeout = 900;
        } else if (ScriptBytecodeAdapter.compareLessThanEqual((Object)overpass_timeout, (Object)180)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The timeout value must be greater than the default value : 180 s");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object overpass_maxsize = IndyInterface.bootstrap("invoke", "get", 0, inputParameters, "maxsize");
        if (IndyInterface.bootstrap("cast", "()", 0, overpass_maxsize) == false) {
            overpass_maxsize = 0x20000000;
        } else if (ScriptBytecodeAdapter.compareLessThanEqual((Object)overpass_maxsize, (Object)0x20000000)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The maxsize value must be greater than the default value :  536870912 (512 MB)");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object overpass_enpoint = IndyInterface.bootstrap("invoke", "get", 0, inputParameters, "endpoint");
        if (IndyInterface.bootstrap("cast", "()", 0, overpass_enpoint) == false) {
            overpass_enpoint = "https://overpass-api.de/api";
        }
        IndyInterface.bootstrap("invoke", "setProperty", 0, System.class, "OVERPASS_ENPOINT", overpass_enpoint);
        Object deleteOSMFile = IndyInterface.bootstrap("invoke", "get", 0, inputParameters, "delete");
        if (IndyInterface.bootstrap("cast", "()", 0, deleteOSMFile) == false) {
            deleteOSMFile = false;
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "valueOf", 0, Boolean.class, deleteOSMFile)) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The delete option must be false or true");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        List outputWorkflowTableNames = ScriptBytecodeAdapter.createList((Object[])new Object[]{"building_indicators", "block_indicators", "rsu_indicators", "rsu_lcz", "zone", "building", "road", "rail", "water", "vegetation", "impervious", "urban_areas", "rsu_utrf_area", "rsu_utrf_floor_area", "building_utrf", "grid_indicators", "sea_land_mask", "building_height_missing", "road_traffic", "population", "ground_acoustic"});
        CallSite processing_parameters = IndyInterface.bootstrap("invoke", "extractProcessingParameters", 2, this, IndyInterface.bootstrap("invoke", "get", 0, parameters, "parameters"));
        if (IndyInterface.bootstrap("cast", "()", 0, processing_parameters) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite outputDatasource = null;
        CallSite outputTables = null;
        CallSite file_outputFolder = null;
        CallSite outputFileTables = null;
        CallSite outputSRID = null;
        Object deleteOutputData = null;
        if (IndyInterface.bootstrap("cast", "()", 0, outputParameter) != false) {
            CallSite outputDataBase = IndyInterface.bootstrap("invoke", "get", 0, outputParameter, "database");
            CallSite outputFolder = IndyInterface.bootstrap("invoke", "get", 0, outputParameter, "folder");
            deleteOutputData = IndyInterface.bootstrap("invoke", "get", 0, outputParameter, "delete");
            if (IndyInterface.bootstrap("cast", "()", 0, deleteOutputData) == false) {
                deleteOutputData = true;
            } else if (ScriptBytecodeAdapter.isCase((Object)(IndyInterface.bootstrap("cast", "()", 0, deleteOutputData) == false ? 1 : 0), Boolean.class)) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "The delete parameter must be a boolean value");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            outputSRID = IndyInterface.bootstrap("invoke", "get", 0, outputParameter, "srid");
            if (DefaultTypeTransformation.booleanUnbox((Object)outputSRID) && ScriptBytecodeAdapter.compareLessThanEqual((Object)outputSRID, (Object)0)) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "The output srid must be greater or equal than 0");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, outputFolder) != false) {
                CallSite outputFiles = IndyInterface.bootstrap("invoke", "buildOutputFolderParameters", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), outputFolder, outputWorkflowTableNames);
                outputFileTables = IndyInterface.bootstrap("getProperty", "tables", 0, outputFiles);
                file_outputFolder = IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("getProperty", "path", 0, outputFiles));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, file_outputFolder)) == false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdir", 0, file_outputFolder)) != false) {
                        file_outputFolder = null;
                        IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{outputFolder}, new String[]{"You don't have permission to write in the folder ", " \n"}), "Please check the folder."));
                        return IndyInterface.bootstrap("cast", "()", 0, null);
                    }
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, file_outputFolder)) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{file_outputFolder}, new String[]{"Invalid output folder ", "."}));
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
            }
            if (IndyInterface.bootstrap("cast", "()", 0, outputDataBase) != false) {
                CallSite outputDataBaseData = IndyInterface.bootstrap("invoke", "buildOutputDBParameters", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), outputDataBase, IndyInterface.bootstrap("getProperty", "tables", 0, outputDataBase), outputWorkflowTableNames);
                outputDatasource = IndyInterface.bootstrap("getProperty", "datasource", 0, outputDataBaseData);
                outputTables = IndyInterface.bootstrap("getProperty", "tables", 0, outputDataBaseData);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)locations) && ScriptBytecodeAdapter.isCase((Object)locations, Collection.class)) {
            CallSite h2gis_datasource = IndyInterface.bootstrap("invoke", "open", 0, H2GIS.class, h2gis_properties);
            if (IndyInterface.bootstrap("cast", "()", 0, h2gis_datasource) == false) {
                IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot load the local H2GIS database to run Geoclimate");
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            CallSite logTableZones = IndyInterface.bootstrap("invoke", "postfix", 2, this, "log_zones");
            public final class _workflow_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _workflow_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _workflow_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite osmprocessing = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "osm_processing", 2, this, h2gis_datasource, processing_parameters, IndyInterface.bootstrap("invoke", "findAll", 0, locations, new _workflow_closure1((Object)this, (Object)this)), file_outputFolder, outputFileTables, outputDatasource, outputTables, outputSRID, downloadAllOSMData, deleteOutputData, deleteOSMFile, logTableZones, osm_size_area, overpass_timeout, overpass_maxsize));
            if (IndyInterface.bootstrap("cast", "()", 0, osmprocessing) == false) {
                IndyInterface.bootstrap("invoke", "save", 0, h2gis_datasource, logTableZones, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, file_outputFolder), IndyInterface.bootstrap("getProperty", "separator", 0, File.class))}, new String[]{"", "logzones.geojson"}), true);
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, delete_h2gis) != false) {
                CallSite localCon = IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource);
                if (IndyInterface.bootstrap("cast", "()", 0, localCon) != false) {
                    IndyInterface.bootstrap("invoke", "close", 0, localCon);
                    IndyInterface.bootstrap("invoke", "execute", 0, DeleteDbFiles.class, databaseFolder, databaseName, true);
                    IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{databasePath}, new String[]{"The local H2GIS database : ", " has been deleted"}));
                } else {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{databasePath}, new String[]{"Cannot delete the local H2GIS database : ", " "}));
                }
            }
            return osmprocessing;
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{locations}, new String[]{"Invalid  OSM area from ", ""}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    /*
     * WARNING - void declaration
     */
    public Map osm_processing(JdbcDataSource h2gis_datasource, Object processing_parameters, Object id_zones, File outputFolder, Object ouputTableFiles, Object output_datasource, Object outputTableNames, Object outputSRID, Object downloadAllOSMData, Object deleteOutputData, Object deleteOSMFile, Object logTableZones, Object bbox_size, Object overpass_timeout, Object overpass_maxsize) {
        void var2_2;
        Reference h2gis_datasource2 = new Reference((Object)h2gis_datasource);
        Reference processing_parameters2 = new Reference((Object)var2_2);
        Reference outputFolder2 = new Reference((Object)outputFolder);
        Reference ouputTableFiles2 = new Reference(ouputTableFiles);
        Reference output_datasource2 = new Reference(output_datasource);
        Reference outputTableNames2 = new Reference(outputTableNames);
        Reference outputSRID2 = new Reference(outputSRID);
        Reference downloadAllOSMData2 = new Reference(downloadAllOSMData);
        Reference deleteOutputData2 = new Reference(deleteOutputData);
        Reference deleteOSMFile2 = new Reference(deleteOSMFile);
        Reference logTableZones2 = new Reference(logTableZones);
        Reference bbox_size2 = new Reference(bbox_size);
        Reference overpass_timeout2 = new Reference(overpass_timeout);
        Reference overpass_maxsize2 = new Reference(overpass_maxsize);
        Reference outputTableNamesResult = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)h2gis_datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{logTableZones2.get(), logTableZones2.get()}, new String[]{"DROP TABLE IF EXISTS ", ";\n            CREATE TABLE ", " (the_geom GEOMETRY(GEOMETRY, 4326), \n            location VARCHAR, info VARCHAR, version  VARCHAR, build_number VARCHAR);"})));
        int nbAreas = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, id_zones));
        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{nbAreas}, new String[]{"", " osm areas will be processed"}));
        public final class _osm_processing_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference h2gis_datasource;
            private /* synthetic */ Reference processing_parameters;
            private /* synthetic */ Reference bbox_size;
            private /* synthetic */ Reference outputSRID;
            private /* synthetic */ Reference overpass_timeout;
            private /* synthetic */ Reference overpass_maxsize;
            private /* synthetic */ Reference downloadAllOSMData;
            private /* synthetic */ Reference deleteOSMFile;
            private /* synthetic */ Reference logTableZones;
            private /* synthetic */ Reference outputFolder;
            private /* synthetic */ Reference ouputTableFiles;
            private /* synthetic */ Reference deleteOutputData;
            private /* synthetic */ Reference output_datasource;
            private /* synthetic */ Reference outputTableNames;
            private /* synthetic */ Reference outputTableNamesResult;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _osm_processing_closure2(Object _outerInstance, Object _thisObject, Reference h2gis_datasource, Reference processing_parameters, Reference bbox_size, Reference outputSRID, Reference overpass_timeout, Reference overpass_maxsize, Reference downloadAllOSMData, Reference deleteOSMFile, Reference logTableZones, Reference outputFolder, Reference ouputTableFiles, Reference deleteOutputData, Reference output_datasource, Reference outputTableNames, Reference outputTableNamesResult) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                Reference reference9;
                Reference reference10;
                Reference reference11;
                Reference reference12;
                Reference reference13;
                Reference reference14;
                Reference reference15;
                this.h2gis_datasource = reference15 = h2gis_datasource;
                this.processing_parameters = reference14 = processing_parameters;
                this.bbox_size = reference13 = bbox_size;
                this.outputSRID = reference12 = outputSRID;
                this.overpass_timeout = reference11 = overpass_timeout;
                this.overpass_maxsize = reference10 = overpass_maxsize;
                this.downloadAllOSMData = reference9 = downloadAllOSMData;
                this.deleteOSMFile = reference8 = deleteOSMFile;
                this.logTableZones = reference7 = logTableZones;
                this.outputFolder = reference6 = outputFolder;
                this.ouputTableFiles = reference5 = ouputTableFiles;
                this.deleteOutputData = reference4 = deleteOutputData;
                this.output_datasource = reference3 = output_datasource;
                this.outputTableNames = reference2 = outputTableNames;
                this.outputTableNamesResult = reference = outputTableNamesResult;
            }

            public Object doCall(Object id_zone) {
                CallSite zones = IndyInterface.bootstrap("invoke", "extractOSMZone", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), id_zone, IndyInterface.bootstrap("getProperty", "distance", 0, this.processing_parameters.get()), this.bbox_size.get());
                if (IndyInterface.bootstrap("cast", "()", 0, zones) != false) {
                    id_zone = ScriptBytecodeAdapter.isCase((Object)id_zone, Collection.class) ? IndyInterface.bootstrap("invoke", "join", 0, id_zone, "_") : id_zone;
                    CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, zones);
                    CallSite zoneEnvelopeTableName = IndyInterface.bootstrap("getProperty", "zone_envelope", 0, zones);
                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), zone), (Object)0)) {
                        IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot find any geometry to define the zone to extract the OSM data");
                        return null;
                    }
                    CallSite srid = IndyInterface.bootstrap("getProperty", "srid", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), zone));
                    Boolean reproject = false;
                    if (IndyInterface.bootstrap("cast", "()", 0, this.outputSRID.get()) != false) {
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.outputSRID.get(), (Object)srid)) {
                            reproject = true;
                        }
                    } else {
                        CallSite callSite = srid;
                        this.outputSRID.set((Object)callSite);
                    }
                    CallSite query = IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.overpass_timeout.get(), this.overpass_maxsize.get()}, new String[]{"[timeout:", "][maxsize:", "]"}), IndyInterface.bootstrap("invoke", "buildOSMQuery", 0, IndyInterface.bootstrap("getProperty", "Utilities", 0, OSMTools.class), IndyInterface.bootstrap("getProperty", "envelope", 0, zones), null, IndyInterface.bootstrap("getProperty", "NODE", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "WAY", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "RELATION", 0, OSMElement.class)));
                    if (IndyInterface.bootstrap("cast", "()", 0, this.downloadAllOSMData.get()) != false) {
                        List keysValues = ScriptBytecodeAdapter.createList((Object[])new Object[]{"building", "railway", "amenity", "leisure", "highway", "natural", "landuse", "landcover", "vegetation", "waterway", "area", "aeroway", "area:aeroway", "tourism", "sport"});
                        query = IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{this.overpass_timeout.get(), this.overpass_maxsize.get()}, new String[]{"[timeout:", "][maxsize:", "]"}), IndyInterface.bootstrap("invoke", "buildOSMQueryWithAllData", 0, IndyInterface.bootstrap("getProperty", "Utilities", 0, OSMTools.class), IndyInterface.bootstrap("getProperty", "envelope", 0, zones), keysValues, IndyInterface.bootstrap("getProperty", "NODE", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "WAY", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "RELATION", 0, OSMElement.class)));
                    }
                    CallSite extract = IndyInterface.bootstrap("invoke", "extract", 0, IndyInterface.bootstrap("getProperty", "Loader", 0, OSMTools.class), query);
                    if (IndyInterface.bootstrap("cast", "()", 0, extract) != false) {
                        CallSite geomArea = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getExtent", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "zone", 0, zones)));
                        IndyInterface.bootstrap("invoke", "setSRID", 0, geomArea, srid);
                        CallSite gisLayersResults = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createGISLayers", 0, IndyInterface.bootstrap("getProperty", "InputDataLoading", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), extract, geomArea, srid));
                        if (IndyInterface.bootstrap("cast", "()", 0, gisLayersResults) != false) {
                            if (IndyInterface.bootstrap("cast", "()", 0, this.deleteOSMFile.get()) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, extract))) != false) {
                                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{extract}, new String[]{"The osm file ", "has been deleted"}));
                            }
                            CallSite rsu_indicators_params = IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, this.processing_parameters.get());
                            CallSite grid_indicators_params = IndyInterface.bootstrap("getProperty", "grid_indicators", 0, this.processing_parameters.get());
                            CallSite road_traffic = IndyInterface.bootstrap("getProperty", "road_traffic", 0, this.processing_parameters.get());
                            CallSite worldpop_indicators = IndyInterface.bootstrap("getProperty", "worldpop_indicators", 0, this.processing_parameters.get());
                            IndyInterface.bootstrap("invoke", "debug", 2, this, "Formating OSM GIS layers");
                            CallSite urbanAreasTable = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatUrbanAreas", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "urban_areas", 0, gisLayersResults), zoneEnvelopeTableName));
                            CallSite formatBuilding = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatBuildingLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "building", 0, gisLayersResults), zoneEnvelopeTableName, urbanAreasTable, IndyInterface.bootstrap("getProperty", "hLevMin", 0, this.processing_parameters.get())));
                            CallSite buildingTableName = IndyInterface.bootstrap("getProperty", "building", 0, formatBuilding);
                            CallSite buildingEstimateTableName = IndyInterface.bootstrap("getProperty", "building_estimated", 0, formatBuilding);
                            CallSite railTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatRailsLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "rail", 0, gisLayersResults), zoneEnvelopeTableName));
                            CallSite vegetationTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatVegetationLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "vegetation", 0, gisLayersResults), zoneEnvelopeTableName));
                            CallSite hydrographicTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatWaterLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "water", 0, gisLayersResults), zoneEnvelopeTableName));
                            CallSite imperviousTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatImperviousLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "impervious", 0, gisLayersResults), zoneEnvelopeTableName));
                            CallSite seaLandMaskTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatSeaLandMask", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "coastline", 0, gisLayersResults), zoneEnvelopeTableName, hydrographicTableName));
                            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), seaLandMaskTableName), (Object)0)) {
                                IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{hydrographicTableName, hydrographicTableName, seaLandMaskTableName}, new String[]{"Drop table if exists ", ";\n                    CREATE TABLE ", " as select the_geom, id as id_water, cast(0 as integer) as zindex, type from ", " where type in ('water', 'sea') "})));
                            }
                            CallSite roadTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatRoadLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "road", 0, gisLayersResults), zoneEnvelopeTableName));
                            IndyInterface.bootstrap("invoke", "dropTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toArray", 0, IndyInterface.bootstrap("invoke", "values", 0, gisLayersResults), new String[0]));
                            IndyInterface.bootstrap("invoke", "debug", 2, this, "OSM GIS layers formated");
                            Map results = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "zone", zone);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "road", roadTableName);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "rail", railTableName);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "water", hydrographicTableName);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "vegetation", vegetationTableName);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "impervious", imperviousTableName);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "urban_areas", urbanAreasTable);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "building", buildingTableName);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "sea_land_mask", seaLandMaskTableName);
                            IndyInterface.bootstrap("invoke", "put", 0, results, "building_height_missing", buildingEstimateTableName);
                            if (IndyInterface.bootstrap("cast", "()", 0, road_traffic) != false) {
                                CallSite format_traffic = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build_road_traffic", 0, IndyInterface.bootstrap("getProperty", "RoadIndicators", 0, Geoindicators.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), roadTableName));
                                IndyInterface.bootstrap("invoke", "put", 0, results, "road_traffic", format_traffic);
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "indicatorUse", 0, rsu_indicators_params)) != false) {
                                String estimateHeight = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "estimateHeight", 0, rsu_indicators_params)) != false ? "BUILDING_HEIGHT_OSM_RF_2_2.model" : "";
                                IndyInterface.bootstrap("invoke", "put", 0, rsu_indicators_params, "utrfModelName", "UTRF_OSM_RF_2_2.model");
                                IndyInterface.bootstrap("invoke", "put", 0, rsu_indicators_params, "buildingHeightModelName", estimateHeight);
                                CallSite geoIndicators = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "computeAllGeoIndicators", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), zone, buildingTableName, roadTableName, railTableName, vegetationTableName, hydrographicTableName, imperviousTableName, buildingEstimateTableName, seaLandMaskTableName, urbanAreasTable, "", rsu_indicators_params, IndyInterface.bootstrap("getProperty", "prefixName", 0, this.processing_parameters.get())));
                                if (IndyInterface.bootstrap("cast", "()", 0, geoIndicators) == false) {
                                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{id_zone}, new String[]{"Cannot build the geoindicators for the zone ", ""}));
                                    IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.logTableZones.get(), IndyInterface.bootstrap("getProperty", "geometry", 0, zones), id_zone, IndyInterface.bootstrap("invoke", "version", 0, Geoindicators.class), IndyInterface.bootstrap("invoke", "buildNumber", 0, Geoindicators.class)}, new String[]{"\n                            INSERT INTO ", " VALUES(st_geomfromtext('", "',4326) ,\n                            '", "', 'Error computing geoindicators', \n                            '", "',\n                            '", "' )"})));
                                    return null;
                                }
                                IndyInterface.bootstrap("invoke", "putAll", 0, results, geoIndicators);
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, worldpop_indicators) != false) {
                                List bbox = ScriptBytecodeAdapter.createList((Object[])new Object[]{(Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMinY", 0, IndyInterface.bootstrap("getProperty", "envelope", 0, zones)), Float.class)), (Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMinX", 0, IndyInterface.bootstrap("getProperty", "envelope", 0, zones)), Float.class)), (Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMaxY", 0, IndyInterface.bootstrap("getProperty", "envelope", 0, zones)), Float.class)), (Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getMaxX", 0, IndyInterface.bootstrap("getProperty", "envelope", 0, zones)), Float.class))});
                                String coverageId = "wpGlobal:ppp_2020";
                                CallSite worldPopFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractWorldPopLayer", 0, IndyInterface.bootstrap("getProperty", "Extract", 0, WorldPopTools.class), coverageId, bbox));
                                if (IndyInterface.bootstrap("cast", "()", 0, worldPopFile) != false) {
                                    CallSite worldPopTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "importAscGrid", 0, IndyInterface.bootstrap("getProperty", "Extract", 0, WorldPopTools.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), worldPopFile, srid, IndyInterface.bootstrap("invoke", "replaceAll", 0, coverageId, ":", "_")));
                                    if (IndyInterface.bootstrap("cast", "()", 0, worldPopTableName) != false) {
                                        IndyInterface.bootstrap("invoke", "put", 0, results, "population", worldPopTableName);
                                        CallSite buildingWithPop = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildingPopulation", 0, IndyInterface.bootstrap("getProperty", "BuildingIndicators", 0, Geoindicators.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "building", 0, results), worldPopTableName, ScriptBytecodeAdapter.createList((Object[])new Object[]{"pop"})));
                                        IndyInterface.bootstrap("invoke", "dropTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), worldPopTableName);
                                        if (IndyInterface.bootstrap("cast", "()", 0, buildingWithPop) == false) {
                                            IndyInterface.bootstrap("invoke", "info", 2, this, "Cannot compute any population data at building level");
                                        } else {
                                            IndyInterface.bootstrap("invoke", "dropTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("getProperty", "building", 0, results));
                                            IndyInterface.bootstrap("invoke", "put", 0, results, "building", buildingWithPop);
                                        }
                                    } else {
                                        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{worldPopFile}, new String[]{"Cannot import the worldpop asc file ", ""}));
                                        IndyInterface.bootstrap("invoke", "info", 2, this, "Create a default empty worldpop table");
                                        CallSite outputTableWorldPopName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "world_pop");
                                        IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, srid}, new String[]{"drop table if exists ", ";\n                                        create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_POP INTEGER, POP FLOAT);"})));
                                        IndyInterface.bootstrap("invoke", "put", 0, results, "population", outputTableWorldPopName);
                                    }
                                } else {
                                    IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{coverageId}, new String[]{"Cannot find the population grid ", " \n Create a default empty worldpop table"}));
                                    CallSite outputTableWorldPopName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "world_pop");
                                    IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, srid}, new String[]{"drop table if exists ", ";\n                                    create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_POP INTEGER, POP FLOAT);"})));
                                    IndyInterface.bootstrap("invoke", "put", 0, results, "population", outputTableWorldPopName);
                                }
                            }
                            CallSite noise_indicators = IndyInterface.bootstrap("getProperty", "noise_indicators", 0, this.processing_parameters.get());
                            CallSite geomEnv = null;
                            if (IndyInterface.bootstrap("cast", "()", 0, noise_indicators) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ground_acoustic", 0, noise_indicators)) != false) {
                                geomEnv = IndyInterface.bootstrap("invoke", "getExtent", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), zone));
                                CallSite outputTable = IndyInterface.bootstrap("invoke", "createGrid", 0, IndyInterface.bootstrap("getProperty", "SpatialUnits", 0, Geoindicators.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), geomEnv, 200, 200);
                                if (IndyInterface.bootstrap("cast", "()", 0, outputTable) != false) {
                                    CallSite ground_acoustic = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groundAcousticAbsorption", 0, IndyInterface.bootstrap("getProperty", "NoiseIndicators", 0, Geoindicators.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), outputTable, "id_grid", IndyInterface.bootstrap("getProperty", "building", 0, results), roadTableName, hydrographicTableName, vegetationTableName, imperviousTableName));
                                    if (IndyInterface.bootstrap("cast", "()", 0, ground_acoustic) != false) {
                                        IndyInterface.bootstrap("invoke", "put", 0, results, "ground_acoustic", ground_acoustic);
                                    }
                                    IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTable}, new String[]{"DROP TABLE IF EXISTS ", ""})));
                                }
                            }
                            Object outputGrid = "geojson";
                            if (IndyInterface.bootstrap("cast", "()", 0, grid_indicators_params) != false) {
                                if (IndyInterface.bootstrap("cast", "()", 0, geomEnv) == false) {
                                    geomEnv = IndyInterface.bootstrap("invoke", "getExtent", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), zone));
                                }
                                outputGrid = IndyInterface.bootstrap("getProperty", "output", 0, grid_indicators_params);
                                CallSite x_size = IndyInterface.bootstrap("getProperty", "x_size", 0, grid_indicators_params);
                                CallSite y_size = IndyInterface.bootstrap("getProperty", "y_size", 0, grid_indicators_params);
                                CallSite grid = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createGrid", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), geomEnv, x_size, y_size, srid, IndyInterface.bootstrap("getProperty", "rowCol", 0, grid_indicators_params)));
                                if (IndyInterface.bootstrap("cast", "()", 0, grid) != false) {
                                    CallSite rasterizedIndicators = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "rasterizeIndicators", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), grid, IndyInterface.bootstrap("getProperty", "indicators", 0, grid_indicators_params), IndyInterface.bootstrap("getProperty", "building", 0, results), roadTableName, vegetationTableName, hydrographicTableName, imperviousTableName, IndyInterface.bootstrap("getProperty", "rsu_lcz", 0, results), IndyInterface.bootstrap("getProperty", "rsu_utrf_area", 0, results), IndyInterface.bootstrap("getProperty", "rsu_utrf_floor_area", 0, results), seaLandMaskTableName, IndyInterface.bootstrap("getProperty", "prefixName", 0, this.processing_parameters.get())));
                                    if (IndyInterface.bootstrap("cast", "()", 0, rasterizedIndicators) != false) {
                                        IndyInterface.bootstrap("invoke", "dropTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), grid);
                                        IndyInterface.bootstrap("invoke", "put", 0, results, "grid_indicators", rasterizedIndicators);
                                    }
                                } else {
                                    IndyInterface.bootstrap("invoke", "info", 2, this, "Cannot create a grid to aggregate the indicators");
                                    IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.logTableZones.get(), IndyInterface.bootstrap("getProperty", "geometry", 0, zones), id_zone, IndyInterface.bootstrap("invoke", "version", 0, Geoindicators.class), IndyInterface.bootstrap("invoke", "buildNumber", 0, Geoindicators.class)}, new String[]{"INSERT INTO ", " \n                            VALUES(st_geomfromtext('", "',4326) ,'", "', 'Error computing the grid indicators'\n                            '", "',\n                            '", "')"})));
                                }
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.outputFolder.get())) && DefaultTypeTransformation.booleanUnbox((Object)this.ouputTableFiles.get())) {
                                IndyInterface.bootstrap("invoke", "saveOutputFiles", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), id_zone, results, this.ouputTableFiles.get(), IndyInterface.bootstrap("cast", "()", 0, this.outputFolder.get()), "osm_", this.outputSRID.get(), reproject, this.deleteOutputData.get(), outputGrid);
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, this.output_datasource.get()) != false) {
                                IndyInterface.bootstrap("invoke", "saveTablesInDatabase", 2, this, this.output_datasource.get(), IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), this.outputTableNames.get(), results, id_zone, srid, this.outputSRID.get(), reproject);
                            }
                            public final class _closure15
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure15(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "value", 0, it), null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure15.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            IndyInterface.bootstrap("invoke", "put", 0, this.outputTableNamesResult.get(), ScriptBytecodeAdapter.isCase((Object)id_zone, Collection.class) ? IndyInterface.bootstrap("invoke", "join", 0, id_zone, "_") : id_zone, IndyInterface.bootstrap("invoke", "findAll", 0, results, new _closure15((Object)this, this.getThisObject())));
                            return IndyInterface.bootstrap("invoke", "dropTable", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "getCachedTableNames", 0, Geoindicators.class));
                        }
                        IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.logTableZones.get(), IndyInterface.bootstrap("getProperty", "geometry", 0, zones), id_zone, IndyInterface.bootstrap("invoke", "version", 0, Geoindicators.class), IndyInterface.bootstrap("invoke", "buildNumber", 0, Geoindicators.class)}, new String[]{"INSERT INTO ", " \n                    VALUES(st_geomfromtext('", "',4326) ,'", "', 'Error loading the OSM file', \n                            '", "',\n                            '", "')"})));
                        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{extract}, new String[]{"Cannot load the OSM file ", ""}));
                        return null;
                    }
                    IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.logTableZones.get(), IndyInterface.bootstrap("getProperty", "geometry", 0, zones), id_zone, IndyInterface.bootstrap("invoke", "version", 0, Geoindicators.class), IndyInterface.bootstrap("invoke", "buildNumber", 0, Geoindicators.class)}, new String[]{"INSERT INTO ", " \n                VALUES(st_geomfromtext('", "',4326) ,'", "', 'Error to extract the data with OverPass'\n                ,'", "', '", "')"})));
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{query}, new String[]{"Cannot execute the overpass query ", ""}));
                    return null;
                }
                IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.logTableZones.get(), id_zone, IndyInterface.bootstrap("invoke", "version", 0, Geoindicators.class), IndyInterface.bootstrap("invoke", "buildNumber", 0, Geoindicators.class)}, new String[]{"INSERT INTO ", " \n            VALUES(null,'", "', 'Error to extract the zone with Nominatim', \n                            '", "',\n                            '", "')"})));
                return null;
            }

            @Generated
            public JdbcDataSource getH2gis_datasource() {
                return IndyInterface.bootstrap("cast", "()", 0, this.h2gis_datasource.get());
            }

            @Generated
            public Object getProcessing_parameters() {
                return this.processing_parameters.get();
            }

            @Generated
            public Object getBbox_size() {
                return this.bbox_size.get();
            }

            @Generated
            public Object getOutputSRID() {
                return this.outputSRID.get();
            }

            @Generated
            public Object getOverpass_timeout() {
                return this.overpass_timeout.get();
            }

            @Generated
            public Object getOverpass_maxsize() {
                return this.overpass_maxsize.get();
            }

            @Generated
            public Object getDownloadAllOSMData() {
                return this.downloadAllOSMData.get();
            }

            @Generated
            public Object getDeleteOSMFile() {
                return this.deleteOSMFile.get();
            }

            @Generated
            public Object getLogTableZones() {
                return this.logTableZones.get();
            }

            @Generated
            public File getOutputFolder() {
                return IndyInterface.bootstrap("cast", "()", 0, this.outputFolder.get());
            }

            @Generated
            public Object getOuputTableFiles() {
                return this.ouputTableFiles.get();
            }

            @Generated
            public Object getDeleteOutputData() {
                return this.deleteOutputData.get();
            }

            @Generated
            public Object getOutput_datasource() {
                return this.output_datasource.get();
            }

            @Generated
            public Object getOutputTableNames() {
                return this.outputTableNames.get();
            }

            @Generated
            public Object getOutputTableNamesResult() {
                return this.outputTableNamesResult.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _osm_processing_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, id_zones, new _osm_processing_closure2((Object)this, (Object)this, h2gis_datasource2, processing_parameters2, bbox_size2, outputSRID2, overpass_timeout2, overpass_maxsize2, downloadAllOSMData2, deleteOSMFile2, logTableZones2, outputFolder2, ouputTableFiles2, deleteOutputData2, output_datasource2, outputTableNames2, outputTableNamesResult));
        if (IndyInterface.bootstrap("cast", "()", 0, outputTableNamesResult.get()) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, outputTableNamesResult.get());
        }
        return null;
    }

    public Object extractOSMZone(Object datasource, Object zoneToExtract, Object distance, Object bbox_size) {
        CallSite outputZoneTable = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"ZONE_", ""}));
        CallSite outputZoneEnvelopeTable = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"ZONE_ENVELOPE_", ""}));
        if (IndyInterface.bootstrap("cast", "()", 0, zoneToExtract) != false) {
            String GEOMETRY_TYPE = "GEOMETRY";
            CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getArea", 0, IndyInterface.bootstrap("getProperty", "Utilities", 0, OSMTools.class), zoneToExtract));
            if (IndyInterface.bootstrap("cast", "()", 0, geom) == false) {
                IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{zoneToExtract}, new String[]{"Cannot find an area from the location ", ""}));
                return null;
            }
            if (geom instanceof Polygon) {
                GEOMETRY_TYPE = "POLYGON";
            } else if (geom instanceof MultiPolygon) {
                GEOMETRY_TYPE = "MULTIPOLYGON";
            } else {
                IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getGeometryType", 0, geom)}, new String[]{"Invalid geometry to extract the OSM data ", ""}));
                return null;
            }
            CallSite envelope = IndyInterface.bootstrap("invoke", "expandEnvelopeByMeters", 0, GeographyUtilities.class, IndyInterface.bootstrap("invoke", "getEnvelopeInternal", 0, geom), distance);
            CallSite con = IndyInterface.bootstrap("invoke", "getConnection", 0, datasource);
            CallSite interiorPoint = IndyInterface.bootstrap("invoke", "centre", 0, envelope);
            CallSite epsg = IndyInterface.bootstrap("invoke", "getSRID", 0, GeographyUtilities.class, con, ScriptBytecodeAdapter.createPojoWrapper((Object)Float.valueOf(((Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "y", 0, interiorPoint), Float.class))).floatValue()), Float.TYPE), ScriptBytecodeAdapter.createPojoWrapper((Object)Float.valueOf(((Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "x", 0, interiorPoint), Float.class))).floatValue()), Float.TYPE));
            CallSite geomUTM = IndyInterface.bootstrap("invoke", "ST_Transform", 0, ST_Transform.class, con, geom, epsg);
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)IndyInterface.bootstrap("invoke", "div", 0, IndyInterface.bootstrap("invoke", "getArea", 0, IndyInterface.bootstrap("invoke", "getEnvelopeInternal", 0, geomUTM)), $const$0), (Object)bbox_size)) {
                IndyInterface.bootstrap("invoke", "error", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{bbox_size}, new String[]{"The size of the OSM BBOX is greated than the limit : ", " in km\u00b2.\n"}), "Please increase the area parameter if you want to skip this limit."));
                return null;
            }
            CallSite tmpGeomEnv = IndyInterface.bootstrap("invoke", "toGeometry", 0, IndyInterface.bootstrap("invoke", "getFactory", 0, geom), envelope);
            IndyInterface.bootstrap("invoke", "setSRID", 0, tmpGeomEnv, 4326);
            IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputZoneTable, outputZoneTable, GEOMETRY_TYPE, epsg, outputZoneTable, IndyInterface.bootstrap("invoke", "toString", 0, geomUTM), epsg, IndyInterface.bootstrap("invoke", "toString", 0, zoneToExtract)}, new String[]{"drop table if exists ", "; \n        create table ", " (the_geom GEOMETRY(", ", ", "), ID_ZONE VARCHAR);\n        INSERT INTO ", " VALUES (ST_GEOMFROMTEXT('", "', ", "), '", "');"})));
            IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputZoneEnvelopeTable, outputZoneEnvelopeTable, epsg, outputZoneEnvelopeTable, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "ST_Transform", 0, ST_Transform.class, con, tmpGeomEnv, epsg)), epsg, IndyInterface.bootstrap("invoke", "toString", 0, zoneToExtract)}, new String[]{"drop table if exists ", "; \n         create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_ZONE VARCHAR);\n        INSERT INTO ", " VALUES (ST_GEOMFROMTEXT('", "',", "), '", "');\n        "})));
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"zone", outputZoneTable, "zone_envelope", outputZoneEnvelopeTable, "envelope", envelope, "geometry", geom});
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, "The zone to extract cannot be null or empty");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object extractProcessingParameters(Object processing_parameters) {
        Map defaultParameters = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"distance", Float.valueOf($const$1), "prefixName", "", "hLevMin", 3});
        Map rsu_indicators_default = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"indicatorUse", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "svfSimplified", true, "surface_vegetation", Float.valueOf($const$2), "surface_hydro", Float.valueOf($const$3), "surface_urban_areas", Float.valueOf($const$2), "snappingTolerance", Float.valueOf($const$4), "mapOfWeights", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sky_view_factor", 4, "aspect_ratio", 3, "building_surface_fraction", 8, "impervious_surface_fraction", 0, "pervious_surface_fraction", 0, "height_of_roughness_elements", 6, "terrain_roughness_length", $const$5}), "estimateHeight", true, "utrfModelName", "UTRF_OSM_RF_2_2.model"});
        IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "rsu_indicators", rsu_indicators_default);
        if (IndyInterface.bootstrap("cast", "()", 0, processing_parameters) == false) {
            return defaultParameters;
        }
        CallSite distanceP = IndyInterface.bootstrap("getProperty", "distance", 0, processing_parameters);
        if (DefaultTypeTransformation.booleanUnbox((Object)distanceP) && ScriptBytecodeAdapter.isCase((Object)distanceP, Number.class)) {
            CallSite callSite = distanceP;
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)defaultParameters, (String)"distance");
        }
        CallSite prefixNameP = IndyInterface.bootstrap("getProperty", "prefixName", 0, processing_parameters);
        if (DefaultTypeTransformation.booleanUnbox((Object)prefixNameP) && ScriptBytecodeAdapter.isCase((Object)prefixNameP, String.class)) {
            CallSite callSite = prefixNameP;
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)defaultParameters, (String)"prefixName");
        }
        CallSite hLevMinP = IndyInterface.bootstrap("getProperty", "hLevMin", 0, processing_parameters);
        if (DefaultTypeTransformation.booleanUnbox((Object)hLevMinP) && ScriptBytecodeAdapter.isCase((Object)hLevMinP, Integer.class)) {
            CallSite callSite = hLevMinP;
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)defaultParameters, (String)"hLevMin");
        }
        Reference rsu_indicators = new Reference((Object)IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, processing_parameters));
        if (IndyInterface.bootstrap("cast", "()", 0, rsu_indicators.get()) != false) {
            CallSite indicatorUseP = IndyInterface.bootstrap("getProperty", "indicatorUse", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)indicatorUseP) && ScriptBytecodeAdapter.isCase((Object)indicatorUseP, List.class)) {
                List allowed_rsu_indicators = ScriptBytecodeAdapter.createList((Object[])new Object[]{"LCZ", "UTRF", "TEB"});
                CallSite allowedOutputRSUIndicators = IndyInterface.bootstrap("invoke", "intersect", 0, allowed_rsu_indicators, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(WorkflowOSM.class, (Object)indicatorUseP, (String)"toUpperCase"));
                if (IndyInterface.bootstrap("cast", "()", 0, allowedOutputRSUIndicators) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{allowedOutputRSUIndicators}, new String[]{"Please set a valid list of RSU indicator names in ", ""}));
                    return null;
                }
                CallSite callSite = indicatorUseP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"indicatorUse");
            } else {
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)rsu_indicators_default, (String)"indicatorUse");
            }
            CallSite snappingToleranceP = IndyInterface.bootstrap("getProperty", "snappingTolerance", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)snappingToleranceP) && ScriptBytecodeAdapter.isCase((Object)snappingToleranceP, Number.class)) {
                CallSite callSite = snappingToleranceP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"snappingTolerance");
            }
            CallSite surface_vegetationP = IndyInterface.bootstrap("getProperty", "surface_vegetation", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)surface_vegetationP) && ScriptBytecodeAdapter.isCase((Object)surface_vegetationP, Number.class)) {
                CallSite callSite = surface_vegetationP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"surface_vegetation");
            }
            CallSite surface_hydroP = IndyInterface.bootstrap("getProperty", "surface_hydro", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)surface_hydroP) && ScriptBytecodeAdapter.isCase((Object)surface_hydroP, Number.class)) {
                CallSite callSite = surface_hydroP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"surface_hydro");
            }
            CallSite surface_urbanAreasP = IndyInterface.bootstrap("getProperty", "surface_urban_areas", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)surface_urbanAreasP) && ScriptBytecodeAdapter.isCase((Object)surface_urbanAreasP, Number.class)) {
                CallSite callSite = surface_urbanAreasP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"surface_urban_areas");
            }
            CallSite svfSimplifiedP = IndyInterface.bootstrap("getProperty", "svfSimplified", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)svfSimplifiedP) && ScriptBytecodeAdapter.isCase((Object)svfSimplifiedP, Boolean.class)) {
                CallSite callSite = svfSimplifiedP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"svfSimplified");
            }
            CallSite estimateHeight = IndyInterface.bootstrap("getProperty", "estimateHeight", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)estimateHeight) && ScriptBytecodeAdapter.isCase((Object)estimateHeight, Boolean.class)) {
                CallSite callSite = estimateHeight;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"estimateHeight");
            }
            CallSite mapOfWeightsP = IndyInterface.bootstrap("getProperty", "mapOfWeights", 0, rsu_indicators.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)mapOfWeightsP) && ScriptBytecodeAdapter.isCase((Object)mapOfWeightsP, Map.class)) {
                CallSite defaultmapOfWeights = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "mapOfWeights", 0, rsu_indicators_default));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "plus", 0, defaultmapOfWeights, mapOfWeightsP)), (Object)IndyInterface.bootstrap("invoke", "size", 0, defaultmapOfWeights))) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "keySet", 0, defaultmapOfWeights), ",")}, new String[]{"The number of mapOfWeights parameters must contain exactly the parameters ", ""}));
                    return null;
                }
                CallSite callSite = mapOfWeightsP;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)rsu_indicators_default, (String)"mapOfWeights");
            }
        } else {
            rsu_indicators.set((Object)rsu_indicators_default);
        }
        CallSite grid_indicators = IndyInterface.bootstrap("getProperty", "grid_indicators", 0, processing_parameters);
        if (IndyInterface.bootstrap("cast", "()", 0, grid_indicators) != false) {
            CallSite x_size = IndyInterface.bootstrap("getProperty", "x_size", 0, grid_indicators);
            CallSite y_size = IndyInterface.bootstrap("getProperty", "y_size", 0, grid_indicators);
            CallSite list_indicators = IndyInterface.bootstrap("getProperty", "indicators", 0, grid_indicators);
            if (DefaultTypeTransformation.booleanUnbox((Object)x_size) && DefaultTypeTransformation.booleanUnbox((Object)y_size)) {
                if (ScriptBytecodeAdapter.compareLessThanEqual((Object)x_size, (Object)0) || ScriptBytecodeAdapter.compareLessThanEqual((Object)y_size, (Object)0)) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, "Invalid grid size padding. Must be greater that 0");
                    return null;
                }
                if (IndyInterface.bootstrap("cast", "()", 0, list_indicators) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, "The list of indicator names cannot be null or empty");
                    return null;
                }
                List allowed_grid_indicators = ScriptBytecodeAdapter.createList((Object[])new Object[]{"BUILDING_FRACTION", "BUILDING_HEIGHT", "BUILDING_POP", "BUILDING_TYPE_FRACTION", "WATER_FRACTION", "VEGETATION_FRACTION", "ROAD_FRACTION", "IMPERVIOUS_FRACTION", "UTRF_AREA_FRACTION", "UTRF_FLOOR_AREA_FRACTION", "LCZ_FRACTION", "LCZ_PRIMARY", "FREE_EXTERNAL_FACADE_DENSITY", "BUILDING_HEIGHT_WEIGHTED", "BUILDING_SURFACE_DENSITY", "BUILDING_HEIGHT_DIST", "FRONTAL_AREA_INDEX", "SEA_LAND_FRACTION", "ASPECT_RATIO", "SVF", "HEIGHT_OF_ROUGHNESS_ELEMENTS", "TERRAIN_ROUGHNESS_CLASS"});
                CallSite allowedOutputIndicators = IndyInterface.bootstrap("invoke", "intersect", 0, allowed_grid_indicators, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(WorkflowOSM.class, (Object)list_indicators, (String)"toUpperCase"));
                if (IndyInterface.bootstrap("cast", "()", 0, allowedOutputIndicators) == false) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{allowed_grid_indicators}, new String[]{"Please set a valid list of indicator names in ", ""}));
                    return null;
                }
                public final class _extractProcessingParameters_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference rsu_indicators;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _extractProcessingParameters_closure3(Object _outerInstance, Object _thisObject, Reference rsu_indicators) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.rsu_indicators = reference = rsu_indicators;
                    }

                    public Object doCall(Object val) {
                        if (ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, IndyInterface.bootstrap("invoke", "trim", 0, val)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"LCZ_FRACTION", "LCZ_PRIMARY"}))) {
                            return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "indicatorUse", 0, this.rsu_indicators.get()), "LCZ");
                        }
                        if (ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, IndyInterface.bootstrap("invoke", "trim", 0, val)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"UTRF_AREA_FRACTION", "UTRF_FLOOR_AREA_FRACTION"}))) {
                            return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "indicatorUse", 0, this.rsu_indicators.get()), "UTRF");
                        }
                        return null;
                    }

                    @Generated
                    public Object getRsu_indicators() {
                        return this.rsu_indicators.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _extractProcessingParameters_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, list_indicators, new _extractProcessingParameters_closure3((Object)this, (Object)this, rsu_indicators));
                Map grid_indicators_tmp = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"x_size", x_size, "y_size", y_size, "output", "geojson", "rowCol", false, "indicators", allowedOutputIndicators});
                CallSite grid_output = IndyInterface.bootstrap("getProperty", "output", 0, grid_indicators);
                if (IndyInterface.bootstrap("cast", "()", 0, grid_output) != false && ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, grid_output), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"asc", "geojson"}))) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "toLowerCase", 0, grid_output);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)grid_indicators_tmp, (String)"output");
                }
                CallSite grid_rowCol = IndyInterface.bootstrap("getProperty", "rowCol", 0, grid_indicators);
                if (DefaultTypeTransformation.booleanUnbox((Object)grid_rowCol) && ScriptBytecodeAdapter.isCase((Object)grid_rowCol, Boolean.class)) {
                    CallSite callSite = grid_rowCol;
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)grid_indicators_tmp, (String)"rowCol");
                }
                IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "grid_indicators", grid_indicators_tmp);
            }
        }
        CallSite road_traffic = IndyInterface.bootstrap("getProperty", "road_traffic", 0, processing_parameters);
        if (DefaultTypeTransformation.booleanUnbox((Object)road_traffic) && ScriptBytecodeAdapter.isCase((Object)road_traffic, Boolean.class)) {
            IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "road_traffic", road_traffic);
        }
        CallSite pop_indics = IndyInterface.bootstrap("getProperty", "worldpop_indicators", 0, processing_parameters);
        if (DefaultTypeTransformation.booleanUnbox((Object)pop_indics) && ScriptBytecodeAdapter.isCase((Object)pop_indics, Boolean.class)) {
            IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "worldpop_indicators", pop_indics);
        }
        CallSite noise_indicators = IndyInterface.bootstrap("getProperty", "noise_indicators", 0, processing_parameters);
        if (IndyInterface.bootstrap("cast", "()", 0, noise_indicators) != false) {
            CallSite ground_acoustic = IndyInterface.bootstrap("getProperty", "ground_acoustic", 0, noise_indicators);
            if (DefaultTypeTransformation.booleanUnbox((Object)ground_acoustic) && ScriptBytecodeAdapter.isCase((Object)ground_acoustic, Boolean.class)) {
                IndyInterface.bootstrap("invoke", "put", 0, defaultParameters, "noise_indicators", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ground_acoustic", ground_acoustic}));
            }
        }
        return defaultParameters;
    }

    /*
     * WARNING - void declaration
     */
    public Object saveOutputFiles(Object h2gis_datasource, Object id_zone, Object results, Object outputFiles, Object ouputFolder, Object subFolderName, Object outputSRID, Object reproject, Object deleteOutputData, Object outputGrid) {
        void var3_3;
        Reference h2gis_datasource2 = new Reference(h2gis_datasource);
        Reference results2 = new Reference((Object)var3_3);
        Reference outputSRID2 = new Reference(outputSRID);
        Reference reproject2 = new Reference(reproject);
        Reference deleteOutputData2 = new Reference(deleteOutputData);
        Reference outputGrid2 = new Reference(outputGrid);
        Object folderName = ScriptBytecodeAdapter.isCase((Object)id_zone, Collection.class) ? IndyInterface.bootstrap("invoke", "join", 0, id_zone, "_") : id_zone;
        Reference subFolder = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, ouputFolder), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), subFolderName), folderName)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, subFolder.get())) == false) {
            IndyInterface.bootstrap("invoke", "mkdir", 0, subFolder.get());
        } else {
            IndyInterface.bootstrap("invoke", "deleteFiles", 0, FileUtilities.class, subFolder.get());
        }
        public final class _saveOutputFiles_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference outputGrid;
            private /* synthetic */ Reference results;
            private /* synthetic */ Reference subFolder;
            private /* synthetic */ Reference h2gis_datasource;
            private /* synthetic */ Reference outputSRID;
            private /* synthetic */ Reference reproject;
            private /* synthetic */ Reference deleteOutputData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _saveOutputFiles_closure4(Object _outerInstance, Object _thisObject, Reference outputGrid, Reference results, Reference subFolder, Reference h2gis_datasource, Reference outputSRID, Reference reproject, Reference deleteOutputData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                this.outputGrid = reference7 = outputGrid;
                this.results = reference6 = results;
                this.subFolder = reference5 = subFolder;
                this.h2gis_datasource = reference4 = h2gis_datasource;
                this.outputSRID = reference3 = outputSRID;
                this.reproject = reference2 = reproject;
                this.deleteOutputData = reference = deleteOutputData;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareEqual((Object)it, (Object)"grid_indicators")) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)this.outputGrid.get(), (Object)"geojson")) {
                        return IndyInterface.bootstrap("invoke", "saveToGeojson", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), ScriptBytecodeAdapter.getProperty(_saveOutputFiles_closure4.class, (Object)this.results.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, this.subFolder.get()), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), it)}, new String[]{"", ".geojson"}), this.h2gis_datasource.get(), this.outputSRID.get(), this.reproject.get(), this.deleteOutputData.get());
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)this.outputGrid.get(), (Object)"asc")) {
                        return IndyInterface.bootstrap("invoke", "saveToAscGrid", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), ScriptBytecodeAdapter.getProperty(_saveOutputFiles_closure4.class, (Object)this.results.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, this.subFolder.get()), it, this.h2gis_datasource.get(), this.outputSRID.get(), this.reproject.get(), this.deleteOutputData.get());
                    }
                } else {
                    if (ScriptBytecodeAdapter.compareEqual((Object)it, (Object)"building_height_missing")) {
                        return IndyInterface.bootstrap("invoke", "saveToCSV", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), ScriptBytecodeAdapter.getProperty(_saveOutputFiles_closure4.class, (Object)this.results.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, this.subFolder.get()), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), it)}, new String[]{"", ".csv"}), this.h2gis_datasource.get(), this.deleteOutputData.get());
                    }
                    return IndyInterface.bootstrap("invoke", "saveToGeojson", 0, IndyInterface.bootstrap("getProperty", "WorkflowUtilities", 0, Geoindicators.class), ScriptBytecodeAdapter.getProperty(_saveOutputFiles_closure4.class, (Object)this.results.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAbsolutePath", 0, this.subFolder.get()), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), it)}, new String[]{"", ".geojson"}), this.h2gis_datasource.get(), this.outputSRID.get(), this.reproject.get(), this.deleteOutputData.get());
                }
                return null;
            }

            @Generated
            public Object getOutputGrid() {
                return this.outputGrid.get();
            }

            @Generated
            public Object getResults() {
                return this.results.get();
            }

            @Generated
            public Object getSubFolder() {
                return this.subFolder.get();
            }

            @Generated
            public Object getH2gis_datasource() {
                return this.h2gis_datasource.get();
            }

            @Generated
            public Object getOutputSRID() {
                return this.outputSRID.get();
            }

            @Generated
            public Object getReproject() {
                return this.reproject.get();
            }

            @Generated
            public Object getDeleteOutputData() {
                return this.deleteOutputData.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _saveOutputFiles_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "each", 0, outputFiles, new _saveOutputFiles_closure4((Object)this, (Object)this, outputGrid2, results2, subFolder, h2gis_datasource2, outputSRID2, reproject2, deleteOutputData2));
    }

    public Object saveTablesInDatabase(JdbcDataSource output_datasource, JdbcDataSource h2gis_datasource, Object outputTableNames, Object h2gis_tables, Object id_zone, Object inputSRID, Object outputSRID, Object reproject) {
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "building_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "building_indicators", 0, h2gis_tables), "WHERE ID_RSU IS NOT NULL", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "block_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "block_indicators", 0, h2gis_tables), "WHERE ID_RSU IS NOT NULL", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_indicators", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_lcz", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_lcz", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_area", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_area", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_floor_area", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rsu_utrf_floor_area", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "grid_indicators", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "grid_indicators", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "building_utrf", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "building_utrf", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "indicatorTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "road_traffic", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "road_traffic", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "zone", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "zone", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "building", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "building", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "road", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "road", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "rail", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "rail", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "vegetation", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "vegetation", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "water", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "water", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "impervious", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "impervious", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "urban_areas", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "urban_areas", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "sea_land_mask", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "sea_land_mask", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        IndyInterface.bootstrap("invoke", "abstractModelTableBatchExportTable", 2, this, output_datasource, IndyInterface.bootstrap("getProperty", "population", 0, outputTableNames), id_zone, h2gis_datasource, IndyInterface.bootstrap("getProperty", "population", 0, h2gis_tables), "", inputSRID, outputSRID, reproject);
        CallSite output_table = IndyInterface.bootstrap("getProperty", "building_height_missing", 0, outputTableNames);
        CallSite h2gis_table_to_save = IndyInterface.bootstrap("getProperty", "building_height_missing", 0, h2gis_tables);
        if (IndyInterface.bootstrap("cast", "()", 0, output_table) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, h2gis_datasource, h2gis_table_to_save)) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, output_datasource, output_table)) != false) {
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table, id_zone}, new String[]{"DELETE FROM ", " WHERE id_zone= '", "'"})));
            } else {
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table}, new String[]{"CREATE TABLE ", "(ID_BUILD INTEGER, ID_SOURCE VARCHAR, ID_ZONE VARCHAR)"})));
            }
            return IndyInterface.bootstrap("invoke", "exportToDataBase", 0, IOMethods.class, IndyInterface.bootstrap("invoke", "getConnection", 0, h2gis_datasource), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{id_zone, h2gis_table_to_save}, new String[]{"(SELECT ID_BUILD, ID_SOURCE, '", "' as ID_ZONE from ", ")"})), IndyInterface.bootstrap("invoke", "getConnection", 0, output_datasource), output_table, 2, 100);
        }
        return null;
    }

    public Object abstractModelTableBatchExportTable(JdbcDataSource output_datasource, Object output_table, Object id_zone, Object h2gis_datasource, Object h2gis_table_to_save, Object filter, Object inputSRID, Object outputSRID, Object reproject) {
        block15: {
            Reference output_table2;
            block16: {
                output_table2 = new Reference(output_table);
                if (IndyInterface.bootstrap("cast", "()", 0, output_table2.get()) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, h2gis_datasource, h2gis_table_to_save)) == false) break block15;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, output_datasource, output_table2.get())) == false) break block16;
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), id_zone}, new String[]{"DELETE FROM ", " WHERE id_zone= '", "'"})));
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get(), id_zone}, new String[]{"Start to export the table ", " into the table ", " for the zone ", ""}));
                int BATCH_MAX_SIZE = 100;
                Reference inputRes = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "prepareTableOutput", 2, this, h2gis_table_to_save, filter, inputSRID, h2gis_datasource, output_table2.get(), outputSRID, output_datasource)));
                if (IndyInterface.bootstrap("cast", "()", 0, (ITable)inputRes.get()) == false) break block15;
                Reference outputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, IndyInterface.bootstrap("invoke", "getTable", 0, output_datasource, output_table2.get())));
                CallSite outputconnection = IndyInterface.bootstrap("invoke", "getConnection", 0, output_datasource);
                Reference inputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, (ITable)inputRes.get()));
                Reference outPutColumnsNames = new Reference((Object)IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get()));
                IndyInterface.bootstrap("invoke", "remove", 0, outPutColumnsNames.get(), "gid");
                public final class _abstractModelTableBatchExportTable_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference outPutColumnsNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure5(Object _outerInstance, Object _thisObject, Reference outPutColumnsNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.outPutColumnsNames = reference = outPutColumnsNames;
                    }

                    public Object doCall(Object e) {
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(_abstractModelTableBatchExportTable_closure5.class, (Object)this.outPutColumnsNames.get(), (String)"toLowerCase"), IndyInterface.bootstrap("invoke", "toLowerCase", 0, e))) == false;
                    }

                    @Generated
                    public Object getOutPutColumnsNames() {
                        return this.outPutColumnsNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference diffCols = new Reference((Object)IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "keySet", 0, inputColumns.get()), new _abstractModelTableBatchExportTable_closure5((Object)this, (Object)this, outPutColumnsNames)));
                Reference alterTable = new Reference((Object)"");
                if (IndyInterface.bootstrap("cast", "()", 0, diffCols.get()) != false) {
                    public final class _abstractModelTableBatchExportTable_closure6
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference diffCols;
                        private /* synthetic */ Reference alterTable;
                        private /* synthetic */ Reference output_table;
                        private /* synthetic */ Reference outputColumns;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _abstractModelTableBatchExportTable_closure6(Object _outerInstance, Object _thisObject, Reference diffCols, Reference alterTable, Reference output_table, Reference outputColumns) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            this.diffCols = reference4 = diffCols;
                            this.alterTable = reference3 = alterTable;
                            this.output_table = reference2 = output_table;
                            this.outputColumns = reference = outputColumns;
                        }

                        public Object doCall(Object entry) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.diffCols.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry))) != false) {
                                Object dataType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry), "decfloat")) != false ? "FLOAT" : IndyInterface.bootstrap("getProperty", "value", 0, entry);
                                this.alterTable.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, this.alterTable.get(), new GStringImpl(new Object[]{this.output_table.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType}, new String[]{"ALTER TABLE ", " ADD COLUMN ", " ", ";"})));
                                return IndyInterface.bootstrap("invoke", "put", 0, this.outputColumns.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType);
                            }
                            return null;
                        }

                        @Generated
                        public Object getDiffCols() {
                            return this.diffCols.get();
                        }

                        @Generated
                        public Object getAlterTable() {
                            return this.alterTable.get();
                        }

                        @Generated
                        public Object getOutput_table() {
                            return this.output_table.get();
                        }

                        @Generated
                        public Object getOutputColumns() {
                            return this.outputColumns.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure6.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, inputColumns.get(), new _abstractModelTableBatchExportTable_closure6((Object)this, (Object)this, diffCols, alterTable, output_table2, outputColumns));
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, alterTable.get()));
                }
                CallSite finalOutputColumns = IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get());
                Object insertTable = new GStringImpl(new Object[]{output_table2.get(), IndyInterface.bootstrap("invoke", "join", 0, finalOutputColumns, ",")}, new String[]{"INSERT INTO ", " (", ") VALUES("});
                public final class _abstractModelTableBatchExportTable_closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure7(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object result, Object iter) {
                        result = IndyInterface.bootstrap("invoke", "plus", 0, result, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, iter))}, new String[]{":", ""}));
                        return result;
                    }

                    @Generated
                    public Object call(Object result, Object iter) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, result, iter);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite flatList = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "inject", 0, outputColumns.get(), ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _abstractModelTableBatchExportTable_closure7((Object)this, (Object)this)), ",");
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, flatList);
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, ")");
                public final class _abstractModelTableBatchExportTable_closure8
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure8(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, it), null});
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference ouputValues = new Reference((Object)IndyInterface.bootstrap("invoke", "collectEntries", 0, finalOutputColumns, new _abstractModelTableBatchExportTable_closure8((Object)this, (Object)this)));
                IndyInterface.bootstrap("invoke", "put", 0, ouputValues.get(), "id_zone", id_zone);
                IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, false);
                public final class _abstractModelTableBatchExportTable_closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference inputRes;
                    private /* synthetic */ Reference inputColumns;
                    private /* synthetic */ Reference ouputValues;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _abstractModelTableBatchExportTable_closure9(Object _outerInstance, Object _thisObject, Reference inputRes, Reference inputColumns, Reference ouputValues) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.inputRes = reference3 = inputRes;
                        this.inputColumns = reference2 = inputColumns;
                        this.ouputValues = reference = ouputValues;
                    }

                    public Object doCall(Object ps) {
                        Reference ps2 = new Reference(ps);
                        public final class _closure16
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference inputColumns;
                            private /* synthetic */ Reference ouputValues;
                            private /* synthetic */ Reference ps;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure16(Object _outerInstance, Object _thisObject, Reference inputColumns, Reference ouputValues, Reference ps) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                this.inputColumns = reference3 = inputColumns;
                                this.ouputValues = reference2 = ouputValues;
                                this.ps = reference = ps;
                            }

                            public Object doCall(Object row) {
                                Reference row2 = new Reference(row);
                                public final class _closure17
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference row;
                                    private /* synthetic */ Reference ouputValues;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure17(Object _outerInstance, Object _thisObject, Reference row, Reference ouputValues) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.row = reference2 = row;
                                        this.ouputValues = reference = ouputValues;
                                    }

                                    public Object doCall(Object columnName) {
                                        CallSite inputValue = IndyInterface.bootstrap("invoke", "getObject", 0, this.row.get(), columnName);
                                        if (IndyInterface.bootstrap("cast", "()", 0, inputValue) != false) {
                                            return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), inputValue);
                                        }
                                        return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), null);
                                    }

                                    @Generated
                                    public Object getRow() {
                                        return this.row.get();
                                    }

                                    @Generated
                                    public Object getOuputValues() {
                                        return this.ouputValues.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure17.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "keySet", 0, this.inputColumns.get()), new _closure17((Object)this, this.getThisObject(), row2, this.ouputValues));
                                return IndyInterface.bootstrap("invoke", "addBatch", 0, this.ps.get(), this.ouputValues.get());
                            }

                            @Generated
                            public Object getInputColumns() {
                                return this.inputColumns.get();
                            }

                            @Generated
                            public Object getOuputValues() {
                                return this.ouputValues.get();
                            }

                            @Generated
                            public Object getPs() {
                                return this.ps.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure16.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get()), new _closure16((Object)this, this.getThisObject(), this.inputColumns, this.ouputValues, ps2));
                    }

                    @Generated
                    public ITable getInputRes() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get());
                    }

                    @Generated
                    public Object getInputColumns() {
                        return this.inputColumns.get();
                    }

                    @Generated
                    public Object getOuputValues() {
                        return this.ouputValues.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _abstractModelTableBatchExportTable_closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "withBatch", 0, output_datasource, BATCH_MAX_SIZE, IndyInterface.bootstrap("invoke", "toString", 0, insertTable), new _abstractModelTableBatchExportTable_closure9((Object)this, (Object)this, inputRes, inputColumns, ouputValues));
                IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                try {
                    return callSite;
                }
                catch (SQLException e) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"Cannot save the table ", ".\n"}), e);
                    Boolean bl = false;
                    IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                    IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                    try {
                        return bl;
                    }
                    catch (Throwable throwable) {
                        IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                        throw throwable;
                    }
                }
            }
            CallSite tmpTable = null;
            IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"Start to export the table ", " into the table ", ""}));
            if (IndyInterface.bootstrap("cast", "()", 0, filter) != false) {
                if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), output_datasource, output_table2.get(), true);
                } else {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), outputSRID), output_datasource, output_table2.get(), true);
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", "\n                            ALTER COLUMN the_geom TYPE geometry(geometry, ", ")\n                            USING ST_SetSRID(the_geom,", ");"})));
                }
                if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), inputSRID, inputSRID}, new String[]{"ALTER TABLE ", " ALTER COLUMN the_geom TYPE geometry(GEOMETRY, ", ") USING ST_SetSRID(the_geom,", ");"})));
                }
            } else if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), output_datasource, output_table2.get(), true);
            } else {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), outputSRID), output_datasource, output_table2.get(), true);
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", "\n                            ALTER COLUMN the_geom TYPE geometry(geometry, ", ")\n                            USING ST_SetSRID(the_geom,", ");"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS gid serial;"})));
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), id_zone}, new String[]{"UPDATE ", " SET id_zone= '", "'"})));
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, output_table2.get(), ".", "_"), output_table2.get()}, new String[]{"CREATE INDEX IF NOT EXISTS idx_", "_id_zone  ON ", " (ID_ZONE)"})));
                return IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
            }
            return IndyInterface.bootstrap("invoke", "warn", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " hasn't been exported into the table ", ""}));
        }
        return null;
    }

    public Object indicatorTableBatchExportTable(Object output_datasource, Object output_table, Object id_zone, Object h2gis_datasource, Object h2gis_table_to_save, Object filter, Object inputSRID, Object outputSRID, Object reproject) {
        block16: {
            Reference output_table2;
            block17: {
                output_table2 = new Reference(output_table);
                if (IndyInterface.bootstrap("cast", "()", 0, output_table2.get()) == false || IndyInterface.bootstrap("cast", "()", 0, h2gis_table_to_save) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, h2gis_datasource, h2gis_table_to_save)) == false) break block16;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTable", 0, output_datasource, output_table2.get())) == false) break block17;
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), id_zone}, new String[]{"DELETE FROM ", " WHERE id_zone='", "'"})));
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get(), id_zone}, new String[]{"Start to export the table ", " into the table ", " for the zone ", ""}));
                int BATCH_MAX_SIZE = 100;
                Reference inputRes = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "prepareTableOutput", 2, this, h2gis_table_to_save, filter, inputSRID, h2gis_datasource, output_table2.get(), outputSRID, output_datasource)));
                if (IndyInterface.bootstrap("cast", "()", 0, (ITable)inputRes.get()) == false) break block16;
                Reference outputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, IndyInterface.bootstrap("invoke", "getTable", 0, output_datasource, output_table2.get())));
                IndyInterface.bootstrap("invoke", "remove", 0, outputColumns.get(), "gid");
                CallSite outputconnection = IndyInterface.bootstrap("invoke", "getConnection", 0, output_datasource);
                Reference inputColumns = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnsTypes", 0, (ITable)inputRes.get()));
                Reference outPutColumnsNames = new Reference((Object)IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get()));
                public final class _indicatorTableBatchExportTable_closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference outPutColumnsNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure10(Object _outerInstance, Object _thisObject, Reference outPutColumnsNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.outPutColumnsNames = reference = outPutColumnsNames;
                    }

                    public Object doCall(Object e) {
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(_indicatorTableBatchExportTable_closure10.class, (Object)this.outPutColumnsNames.get(), (String)"toLowerCase"), IndyInterface.bootstrap("invoke", "toLowerCase", 0, e))) == false;
                    }

                    @Generated
                    public Object getOutPutColumnsNames() {
                        return this.outPutColumnsNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference diffCols = new Reference((Object)IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "keySet", 0, inputColumns.get()), new _indicatorTableBatchExportTable_closure10((Object)this, (Object)this, outPutColumnsNames)));
                Reference alterTable = new Reference((Object)"");
                if (IndyInterface.bootstrap("cast", "()", 0, diffCols.get()) != false) {
                    public final class _indicatorTableBatchExportTable_closure11
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference diffCols;
                        private /* synthetic */ Reference alterTable;
                        private /* synthetic */ Reference output_table;
                        private /* synthetic */ Reference outputColumns;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _indicatorTableBatchExportTable_closure11(Object _outerInstance, Object _thisObject, Reference diffCols, Reference alterTable, Reference output_table, Reference outputColumns) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            this.diffCols = reference4 = diffCols;
                            this.alterTable = reference3 = alterTable;
                            this.output_table = reference2 = output_table;
                            this.outputColumns = reference = outputColumns;
                        }

                        public Object doCall(Object entry) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.diffCols.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry))) != false) {
                                Object dataType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry), "decfloat")) != false ? "FLOAT" : IndyInterface.bootstrap("getProperty", "value", 0, entry);
                                this.alterTable.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, this.alterTable.get(), new GStringImpl(new Object[]{this.output_table.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType}, new String[]{"ALTER TABLE ", " ADD COLUMN ", " ", ";"})));
                                return IndyInterface.bootstrap("invoke", "put", 0, this.outputColumns.get(), IndyInterface.bootstrap("getProperty", "key", 0, entry), dataType);
                            }
                            return null;
                        }

                        @Generated
                        public Object getDiffCols() {
                            return this.diffCols.get();
                        }

                        @Generated
                        public Object getAlterTable() {
                            return this.alterTable.get();
                        }

                        @Generated
                        public Object getOutput_table() {
                            return this.output_table.get();
                        }

                        @Generated
                        public Object getOutputColumns() {
                            return this.outputColumns.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure11.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, inputColumns.get(), new _indicatorTableBatchExportTable_closure11((Object)this, (Object)this, diffCols, alterTable, output_table2, outputColumns));
                    IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, alterTable.get()));
                }
                CallSite finalOutputColumns = IndyInterface.bootstrap("invoke", "keySet", 0, outputColumns.get());
                Object insertTable = new GStringImpl(new Object[]{output_table2.get(), IndyInterface.bootstrap("invoke", "join", 0, finalOutputColumns, ",")}, new String[]{"INSERT INTO ", " (", ") VALUES("});
                public final class _indicatorTableBatchExportTable_closure12
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure12(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object result, Object iter) {
                        result = IndyInterface.bootstrap("invoke", "plus", 0, result, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, iter))}, new String[]{":", ""}));
                        return result;
                    }

                    @Generated
                    public Object call(Object result, Object iter) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, result, iter);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite flatList = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "inject", 0, outputColumns.get(), ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _indicatorTableBatchExportTable_closure12((Object)this, (Object)this)), ",");
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, flatList);
                insertTable = IndyInterface.bootstrap("invoke", "plus", 0, insertTable, ")");
                public final class _indicatorTableBatchExportTable_closure13
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure13(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, it), null});
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference ouputValues = new Reference((Object)IndyInterface.bootstrap("invoke", "collectEntries", 0, finalOutputColumns, new _indicatorTableBatchExportTable_closure13((Object)this, (Object)this)));
                IndyInterface.bootstrap("invoke", "put", 0, ouputValues.get(), "id_zone", id_zone);
                IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, false);
                public final class _indicatorTableBatchExportTable_closure14
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference inputRes;
                    private /* synthetic */ Reference inputColumns;
                    private /* synthetic */ Reference ouputValues;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _indicatorTableBatchExportTable_closure14(Object _outerInstance, Object _thisObject, Reference inputRes, Reference inputColumns, Reference ouputValues) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.inputRes = reference3 = inputRes;
                        this.inputColumns = reference2 = inputColumns;
                        this.ouputValues = reference = ouputValues;
                    }

                    public Object doCall(Object ps) {
                        Reference ps2 = new Reference(ps);
                        public final class _closure18
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference inputColumns;
                            private /* synthetic */ Reference ouputValues;
                            private /* synthetic */ Reference ps;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure18(Object _outerInstance, Object _thisObject, Reference inputColumns, Reference ouputValues, Reference ps) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                this.inputColumns = reference3 = inputColumns;
                                this.ouputValues = reference2 = ouputValues;
                                this.ps = reference = ps;
                            }

                            public Object doCall(Object row) {
                                Reference row2 = new Reference(row);
                                public final class _closure19
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference row;
                                    private /* synthetic */ Reference ouputValues;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure19(Object _outerInstance, Object _thisObject, Reference row, Reference ouputValues) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.row = reference2 = row;
                                        this.ouputValues = reference = ouputValues;
                                    }

                                    public Object doCall(Object columnName) {
                                        CallSite inputValue = IndyInterface.bootstrap("invoke", "getObject", 0, this.row.get(), columnName);
                                        if (IndyInterface.bootstrap("cast", "()", 0, inputValue) != false) {
                                            return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), inputValue);
                                        }
                                        return IndyInterface.bootstrap("invoke", "put", 0, this.ouputValues.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, columnName), null);
                                    }

                                    @Generated
                                    public Object getRow() {
                                        return this.row.get();
                                    }

                                    @Generated
                                    public Object getOuputValues() {
                                        return this.ouputValues.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure19.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "keySet", 0, this.inputColumns.get()), new _closure19((Object)this, this.getThisObject(), row2, this.ouputValues));
                                return IndyInterface.bootstrap("invoke", "addBatch", 0, this.ps.get(), this.ouputValues.get());
                            }

                            @Generated
                            public Object getInputColumns() {
                                return this.inputColumns.get();
                            }

                            @Generated
                            public Object getOuputValues() {
                                return this.ouputValues.get();
                            }

                            @Generated
                            public Object getPs() {
                                return this.ps.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure18.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get()), new _closure18((Object)this, this.getThisObject(), this.inputColumns, this.ouputValues, ps2));
                    }

                    @Generated
                    public ITable getInputRes() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.inputRes.get());
                    }

                    @Generated
                    public Object getInputColumns() {
                        return this.inputColumns.get();
                    }

                    @Generated
                    public Object getOuputValues() {
                        return this.ouputValues.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _indicatorTableBatchExportTable_closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "withBatch", 0, output_datasource, BATCH_MAX_SIZE, IndyInterface.bootstrap("invoke", "toString", 0, insertTable), new _indicatorTableBatchExportTable_closure14((Object)this, (Object)this, inputRes, inputColumns, ouputValues));
                IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                try {
                    return callSite;
                }
                catch (SQLException e) {
                    IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{output_table2.get(), e}, new String[]{"Cannot save the table ", ".\n ", ""}));
                    Boolean bl = false;
                    IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                    IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                    try {
                        return bl;
                    }
                    catch (Throwable throwable) {
                        IndyInterface.bootstrap("invoke", "setAutoCommit", 0, outputconnection, true);
                        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
                        throw throwable;
                    }
                }
            }
            CallSite tmpTable = null;
            IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get(), id_zone}, new String[]{"Start to export the table ", " into the table ", " for the zone ", ""}));
            if (IndyInterface.bootstrap("cast", "()", 0, filter) != false) {
                if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), output_datasource, output_table2.get(), true);
                    if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                        IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), inputSRID, inputSRID}, new String[]{"ALTER TABLE ", " ALTER COLUMN the_geom TYPE geometry(GEOMETRY, ", ") USING ST_SetSRID(the_geom,", ");"})));
                    }
                } else {
                    tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), outputSRID), output_datasource, output_table2.get(), true);
                    if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                        IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", " ALTER COLUMN the_geom TYPE geometry(GEOMETRY, ", ") USING ST_SetSRID(the_geom,", ");"})));
                    }
                }
            } else if (IndyInterface.bootstrap("cast", "()", 0, reproject) == false) {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), output_datasource, output_table2.get(), true);
            } else {
                tmpTable = IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), outputSRID), output_datasource, output_table2.get(), true);
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get(), outputSRID, outputSRID}, new String[]{"ALTER TABLE ", "\n                            ALTER COLUMN the_geom TYPE geometry(geometry, ", ")\n                            USING ST_SetSRID(the_geom,", ");"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, tmpTable) != false) {
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS id_zone VARCHAR"})));
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"UPDATE ", " SET id_zone= ?"}), id_zone);
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, output_table2.get(), ".", "_"), output_table2.get()}, new String[]{"CREATE INDEX IF NOT EXISTS idx_", "_id_zone  ON ", " (ID_ZONE)"})));
                IndyInterface.bootstrap("invoke", "execute", 0, output_datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{output_table2.get()}, new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS gid serial;"})));
                return IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " has been exported into the table ", ""}));
            }
            return IndyInterface.bootstrap("invoke", "warn", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table2.get()}, new String[]{"The table ", " hasn't been exported into the table ", ""}));
        }
        return null;
    }

    public Object prepareTableOutput(Object h2gis_table_to_save, Object filter, Object inputSRID, H2GIS h2gis_datasource, Object output_table, Object outputSRID, Object output_datasource) {
        CallSite targetTableSrid = IndyInterface.bootstrap("getProperty", "srid", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, output_datasource, output_table));
        if (IndyInterface.bootstrap("cast", "()", 0, filter) != false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)outputSRID, (Object)0)) {
                if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "getTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, WorkflowOSM.class, (GroovyObject)this, (String)"inputRes");
                    return callSite;
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
                    return IndyInterface.bootstrap("invoke", "getTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter));
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
                    return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save), filter)), targetTableSrid);
                }
                IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
                return null;
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), targetTableSrid);
            }
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
            return null;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)outputSRID, (Object)0)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
                return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), targetTableSrid);
            }
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
            return null;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)targetTableSrid)) {
            return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareEqual((Object)inputSRID, (Object)0)) {
            return IndyInterface.bootstrap("invoke", "getTable", 0, h2gis_datasource, h2gis_table_to_save);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)targetTableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)inputSRID, (Object)0)) {
            return IndyInterface.bootstrap("invoke", "reproject", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, h2gis_datasource, h2gis_table_to_save), targetTableSrid);
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{h2gis_table_to_save, output_table}, new String[]{"Cannot export the ", " into the table ", " \n due to inconsistent SRID"}));
        return null;
    }

    public Map buildGeoclimateLayers(JdbcDataSource datasource, Object zoneToExtract, float distance, int hLevMin) {
        if (ScriptBytecodeAdapter.compareEqual((Object)datasource, null)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot access to the database to store the osm data");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Building OSM GIS layers");
        CallSite res = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractAndCreateGISLayers", 0, IndyInterface.bootstrap("getProperty", "InputDataLoading", 0, OSM.class), datasource, zoneToExtract, distance));
        if (IndyInterface.bootstrap("cast", "()", 0, res) != false) {
            IndyInterface.bootstrap("invoke", "debug", 2, this, "OSM GIS layers created");
            CallSite buildingTableName = IndyInterface.bootstrap("getProperty", "building", 0, res);
            CallSite roadTableName = IndyInterface.bootstrap("getProperty", "road", 0, res);
            CallSite railTableName = IndyInterface.bootstrap("getProperty", "rail", 0, res);
            CallSite vegetationTableName = IndyInterface.bootstrap("getProperty", "vegetation", 0, res);
            CallSite hydroTableName = IndyInterface.bootstrap("getProperty", "water", 0, res);
            CallSite imperviousTableName = IndyInterface.bootstrap("getProperty", "impervious", 0, res);
            CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, res);
            CallSite zoneEnvelopeTableName = IndyInterface.bootstrap("getProperty", "zone_envelope", 0, res);
            CallSite epsg = IndyInterface.bootstrap("getProperty", "srid", 0, IndyInterface.bootstrap("invoke", "getSpatialTable", 0, datasource, zone));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)zoneEnvelopeTableName, null)) {
                IndyInterface.bootstrap("invoke", "debug", 2, this, "Formating OSM GIS layers");
                CallSite buildingLayers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "formatBuildingLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), datasource, buildingTableName, zoneEnvelopeTableName));
                buildingTableName = IndyInterface.bootstrap("getProperty", "building", 0, buildingLayers);
                roadTableName = IndyInterface.bootstrap("invoke", "formatRoadLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), datasource, roadTableName, zoneEnvelopeTableName);
                railTableName = IndyInterface.bootstrap("invoke", "formatRailsLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), datasource, railTableName, zoneEnvelopeTableName);
                vegetationTableName = IndyInterface.bootstrap("invoke", "formatVegetationLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), datasource, vegetationTableName, zoneEnvelopeTableName);
                hydroTableName = IndyInterface.bootstrap("invoke", "formatWaterLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), datasource, hydroTableName, zoneEnvelopeTableName);
                imperviousTableName = IndyInterface.bootstrap("invoke", "formatImperviousLayer", 0, IndyInterface.bootstrap("getProperty", "InputDataFormatting", 0, OSM.class), datasource, imperviousTableName, zoneEnvelopeTableName);
                IndyInterface.bootstrap("invoke", "debug", 2, this, "OSM GIS layers formated");
            }
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"building", buildingTableName, "road", roadTableName, "rail", railTableName, "water", hydroTableName, "vegetation", vegetationTableName, "impervious", imperviousTableName, "zone", zone, "zone_envelope", zoneEnvelopeTableName});
        }
        return null;
    }

    @Generated
    public Map buildGeoclimateLayers(JdbcDataSource datasource, Object zoneToExtract, float distance) {
        return this.buildGeoclimateLayers(datasource, zoneToExtract, distance, 3);
    }

    @Generated
    public Map buildGeoclimateLayers(JdbcDataSource datasource, Object zoneToExtract) {
        return this.buildGeoclimateLayers(datasource, zoneToExtract, 500, 3);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != WorkflowOSM.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        float f;
        float f2;
        float f3;
        float f4;
        BigDecimal bigDecimal2;
        $const$0 = bigDecimal2 = new BigDecimal("1.0E+6");
        $const$1 = f4 = 0.0f;
        $const$2 = f3 = 10000.0f;
        $const$3 = f2 = 2500.0f;
        $const$4 = f = 0.01f;
        $const$5 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        org.orbisgis.geoclimate.osm.WorkflowOSM.__$swapInit();
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

