/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.geoclimate.osm;

import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.locationtech.jts.geom.Polygon;
import org.orbisgis.data.jdbc.JdbcDataSource;
import org.orbisgis.geoclimate.Geoindicators;
import org.orbisgis.geoclimate.osm.OSM;

public class InputDataFormatting
extends OSM {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ BigDecimal $const$2;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public static void main(String ... args) {
        IndyInterface.bootstrap("invoke", "runScript", 0, InvokerHelper.class, InputDataFormatting.class, args);
    }

    public Object run() {
        InputDataFormatting OSM2 = this;
        return OSM2;
    }

    public Map formatBuildingLayer(JdbcDataSource datasource, String building, String zone, String urban_areas, int h_lev_min, String jsonFilename) {
        Reference datasource2 = new Reference((Object)datasource);
        Reference h_lev_min2 = new Reference((Object)h_lev_min);
        if (!(DefaultTypeTransformation.intUnbox((Object)h_lev_min2.get()) != 0)) {
            h_lev_min2.set((Object)3);
        }
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "INPUT_BUILDING"));
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Formating building layer");
        Reference outputEstimateTableName = new Reference((Object)new GStringImpl(new Object[]{outputTableName.get()}, new String[]{"EST_", ""}));
        IndyInterface.bootstrap("invoke", "call", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputEstimateTableName.get(), outputEstimateTableName.get()}, new String[]{"\n                    DROP TABLE if exists ", ";\n                    CREATE TABLE ", " (\n                        id_build INTEGER,\n                        ID_SOURCE VARCHAR)\n                "})));
        IndyInterface.bootstrap("invoke", "call", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{" \n                DROP TABLE if exists ", ";\n                CREATE TABLE ", " (THE_GEOM GEOMETRY, id_build INTEGER, ID_SOURCE VARCHAR, \n                    HEIGHT_WALL FLOAT, HEIGHT_ROOF FLOAT, NB_LEV INTEGER, TYPE VARCHAR, MAIN_USE VARCHAR, ZINDEX INTEGER, ROOF_SHAPE VARCHAR);\n            "})));
        if (IndyInterface.bootstrap("cast", "()", 0, building) != false) {
            CallSite paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "buildingParams.json");
            CallSite parametersMap = IndyInterface.bootstrap("invoke", "parametersMapping", 0, InputDataFormatting.class, jsonFilename, paramsDefaultFile);
            Reference mappingTypeAndUse = new Reference((Object)IndyInterface.bootstrap("getProperty", "type", 0, parametersMap));
            Reference typeAndLevel = new Reference((Object)IndyInterface.bootstrap("getProperty", "level", 0, parametersMap));
            Reference queryMapper = new Reference((Object)"SELECT ");
            CallSite columnToMap = IndyInterface.bootstrap("getProperty", "columns", 0, parametersMap);
            Object inputSpatialTable = ScriptBytecodeAdapter.getGroovyObjectProperty(InputDataFormatting.class, (GroovyObject)((JdbcDataSource)datasource2.get()), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{building}, new String[]{"", ""}))));
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "rowCount", 0, inputSpatialTable), (Object)0)) {
                Reference columnNames = new Reference((Object)IndyInterface.bootstrap("getProperty", "columns", 0, inputSpatialTable));
                IndyInterface.bootstrap("invoke", "remove", 0, columnNames.get(), "THE_GEOM");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "columnsMapper", 0, InputDataFormatting.class, columnNames.get(), columnToMap)));
                if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), building, "the_geom");
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), zone, "the_geom");
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{building, zone}, new String[]{" , st_force2D(a.the_geom) as the_geom FROM ", " as a,  ", " as b WHERE a.the_geom && b.the_geom and st_intersects( "}), "a.the_geom, b.the_geom) ")));
                } else {
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{building}, new String[]{" , st_force2D(a.the_geom) as the_geom FROM ", " as a "})));
                }
                Reference heightPattern = new Reference((Object)IndyInterface.bootstrap("invoke", "compile", 0, Pattern.class, "((?:\\d+\\/|(?:\\d+|^|\\s)\\.)?\\d+)\\s*([^\\s\\d+\\-.,:;^\\/]+(?:\\^\\d+(?:$|(?=[\\s:;\\/])))?(?:\\/[^\\s\\d+\\-.,:;^\\/]+(?:\\^\\d+(?:$|(?=[\\s:;\\/])))?)*)?", IndyInterface.bootstrap("getProperty", "CASE_INSENSITIVE", 0, Pattern.class)));
                Reference id_build = new Reference((Object)1);
                public final class _formatBuildingLayer_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference datasource;
                    private /* synthetic */ Reference queryMapper;
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference mappingTypeAndUse;
                    private /* synthetic */ Reference heightPattern;
                    private /* synthetic */ Reference h_lev_min;
                    private /* synthetic */ Reference typeAndLevel;
                    private /* synthetic */ Reference outputTableName;
                    private /* synthetic */ Reference id_build;
                    private /* synthetic */ Reference outputEstimateTableName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _formatBuildingLayer_closure1(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference columnNames, Reference mappingTypeAndUse, Reference heightPattern, Reference h_lev_min, Reference typeAndLevel, Reference outputTableName, Reference id_build, Reference outputEstimateTableName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        Reference reference8;
                        Reference reference9;
                        Reference reference10;
                        this.datasource = reference10 = datasource;
                        this.queryMapper = reference9 = queryMapper;
                        this.columnNames = reference8 = columnNames;
                        this.mappingTypeAndUse = reference7 = mappingTypeAndUse;
                        this.heightPattern = reference6 = heightPattern;
                        this.h_lev_min = reference5 = h_lev_min;
                        this.typeAndLevel = reference4 = typeAndLevel;
                        this.outputTableName = reference3 = outputTableName;
                        this.id_build = reference2 = id_build;
                        this.outputEstimateTableName = reference = outputEstimateTableName;
                    }

                    public Object doCall(Object stmt) {
                        Reference stmt2 = new Reference(stmt);
                        public final class _closure13
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference columnNames;
                            private /* synthetic */ Reference mappingTypeAndUse;
                            private /* synthetic */ Reference heightPattern;
                            private /* synthetic */ Reference h_lev_min;
                            private /* synthetic */ Reference typeAndLevel;
                            private /* synthetic */ Reference stmt;
                            private /* synthetic */ Reference outputTableName;
                            private /* synthetic */ Reference id_build;
                            private /* synthetic */ Reference outputEstimateTableName;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure13(Object _outerInstance, Object _thisObject, Reference columnNames, Reference mappingTypeAndUse, Reference heightPattern, Reference h_lev_min, Reference typeAndLevel, Reference stmt, Reference outputTableName, Reference id_build, Reference outputEstimateTableName) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                Reference reference7;
                                Reference reference8;
                                Reference reference9;
                                this.columnNames = reference9 = columnNames;
                                this.mappingTypeAndUse = reference8 = mappingTypeAndUse;
                                this.heightPattern = reference7 = heightPattern;
                                this.h_lev_min = reference6 = h_lev_min;
                                this.typeAndLevel = reference5 = typeAndLevel;
                                this.stmt = reference4 = stmt;
                                this.outputTableName = reference3 = outputTableName;
                                this.id_build = reference2 = id_build;
                                this.outputEstimateTableName = reference = outputEstimateTableName;
                            }

                            public Object doCall(Object row) {
                                CallSite typeAndUseValues = IndyInterface.bootstrap("invoke", "getTypeAndUse", 2, this, row, this.columnNames.get(), this.mappingTypeAndUse.get());
                                CallSite use = IndyInterface.bootstrap("invoke", "getAt", 0, typeAndUseValues, true);
                                CallSite type = IndyInterface.bootstrap("invoke", "getAt", 0, typeAndUseValues, false);
                                if (IndyInterface.bootstrap("cast", "()", 0, type) != false) {
                                    CallSite height = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "height", 0, row));
                                    CallSite roof_height = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "roof:height", 0, row));
                                    CallSite b_lev = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "building:levels", 0, row));
                                    CallSite roof_lev = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "roof:levels", 0, row));
                                    CallSite heightRoof = IndyInterface.bootstrap("invoke", "getHeightRoof", 2, this, height, this.heightPattern.get());
                                    CallSite heightWall = IndyInterface.bootstrap("invoke", "getHeightWall", 2, this, heightRoof, roof_height);
                                    CallSite nbLevels = IndyInterface.bootstrap("invoke", "getNbLevels", 2, this, b_lev, roof_lev);
                                    CallSite formatedHeight = IndyInterface.bootstrap("invoke", "formatHeightsAndNbLevels", 0, IndyInterface.bootstrap("getProperty", "WorkflowGeoIndicators", 0, Geoindicators.class), heightWall, heightRoof, nbLevels, IndyInterface.bootstrap("cast", "()", 0, this.h_lev_min.get()), type, this.typeAndLevel.get());
                                    CallSite zIndex = IndyInterface.bootstrap("invoke", "getZIndex", 2, this, IndyInterface.bootstrap("getProperty", "layer", 0, row));
                                    CallSite roof_shape = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "roof:shape", 0, row));
                                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "nbLevels", 0, formatedHeight), (Object)0) && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)zIndex, (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)type)) {
                                        CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                        CallSite srid = IndyInterface.bootstrap("invoke", "getSRID", 0, geom);
                                        int i = 0;
                                        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                            CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                            if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                                IndyInterface.bootstrap("invoke", "addBatch", 0, this.stmt.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.outputTableName.get(), subGeom, srid, this.id_build.get(), IndyInterface.bootstrap("getProperty", "id", 0, row), IndyInterface.bootstrap("getProperty", "heightWall", 0, formatedHeight), IndyInterface.bootstrap("getProperty", "heightRoof", 0, formatedHeight), IndyInterface.bootstrap("getProperty", "nbLevels", 0, formatedHeight), IndyInterface.bootstrap("invoke", "singleQuote", 2, this, type), IndyInterface.bootstrap("invoke", "singleQuote", 2, this, use), zIndex, IndyInterface.bootstrap("cast", "()", 0, roof_shape) != false ? IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "'", roof_shape), "'") : null}, new String[]{"\n                                                INSERT INTO ", " values(\n                                                    ST_GEOMFROMTEXT('", "',", "), \n                                                    ", ", \n                                                    '", "',\n                                                    ", ",\n                                                    ", ",\n                                                    ", ",\n                                                    ", ",\n                                                    ", ",\n                                                    ", ",\n                                                    ", ")\n                                            "})));
                                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "estimated", 0, formatedHeight)) != false) {
                                                    IndyInterface.bootstrap("invoke", "addBatch", 0, this.stmt.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.outputEstimateTableName.get(), this.id_build.get(), IndyInterface.bootstrap("getProperty", "id", 0, row)}, new String[]{"\n                                                INSERT INTO ", " values(\n                                                    ", ", \n                                                    '", "')\n                                                "})));
                                                }
                                                Object object = this.id_build.get();
                                                this.id_build.set((Object)IndyInterface.bootstrap("invoke", "next", 0, object));
                                            }
                                            int n = i;
                                            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                        }
                                        return null;
                                    }
                                }
                                return null;
                            }

                            @Generated
                            public Object getColumnNames() {
                                return this.columnNames.get();
                            }

                            @Generated
                            public Object getMappingTypeAndUse() {
                                return this.mappingTypeAndUse.get();
                            }

                            @Generated
                            public Object getHeightPattern() {
                                return this.heightPattern.get();
                            }

                            @Generated
                            public int getH_lev_min() {
                                return (Integer)((Object)IndyInterface.bootstrap("cast", "()", 0, this.h_lev_min.get()));
                            }

                            @Generated
                            public Object getTypeAndLevel() {
                                return this.typeAndLevel.get();
                            }

                            @Generated
                            public Object getStmt() {
                                return this.stmt.get();
                            }

                            @Generated
                            public Object getOutputTableName() {
                                return this.outputTableName.get();
                            }

                            @Generated
                            public Object getId_build() {
                                return this.id_build.get();
                            }

                            @Generated
                            public Object getOutputEstimateTableName() {
                                return this.outputEstimateTableName.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure13.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), this.queryMapper.get(), new _closure13((Object)this, this.getThisObject(), this.columnNames, this.mappingTypeAndUse, this.heightPattern, this.h_lev_min, this.typeAndLevel, stmt2, this.outputTableName, this.id_build, this.outputEstimateTableName));
                    }

                    @Generated
                    public JdbcDataSource getDatasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                    }

                    @Generated
                    public Object getQueryMapper() {
                        return this.queryMapper.get();
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getMappingTypeAndUse() {
                        return this.mappingTypeAndUse.get();
                    }

                    @Generated
                    public Object getHeightPattern() {
                        return this.heightPattern.get();
                    }

                    @Generated
                    public int getH_lev_min() {
                        return (Integer)((Object)IndyInterface.bootstrap("cast", "()", 0, this.h_lev_min.get()));
                    }

                    @Generated
                    public Object getTypeAndLevel() {
                        return this.typeAndLevel.get();
                    }

                    @Generated
                    public Object getOutputTableName() {
                        return this.outputTableName.get();
                    }

                    @Generated
                    public Object getId_build() {
                        return this.id_build.get();
                    }

                    @Generated
                    public Object getOutputEstimateTableName() {
                        return this.outputEstimateTableName.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _formatBuildingLayer_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatBuildingLayer_closure1((Object)this, (Object)this, datasource2, queryMapper, columnNames, mappingTypeAndUse, heightPattern, h_lev_min2, typeAndLevel, outputTableName, id_build, outputEstimateTableName));
                if (IndyInterface.bootstrap("cast", "()", 0, urban_areas) != false) {
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), outputTableName.get(), "the_geom");
                    IndyInterface.bootstrap("invoke", "createIndex", 0, (JdbcDataSource)datasource2.get(), outputTableName.get(), "id_build");
                    IndyInterface.bootstrap("invoke", "createIndex", 0, (JdbcDataSource)datasource2.get(), outputTableName.get(), "type");
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), urban_areas, "the_geom");
                    GStringImpl urbanAreasPart = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"urbanAreasPart", ""});
                    Reference buildinType = new Reference((Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"BUILDING_TYPE_", ""}));
                    IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{urbanAreasPart, buildinType.get(), urbanAreasPart, outputTableName.get(), urban_areas, urbanAreasPart, buildinType.get(), urbanAreasPart}, new String[]{"DROP TABLE IF EXISTS ", ", ", " ;\n            CREATE TABLE ", " as SELECT b.type, a.id_build, st_area(st_intersection(a.the_geom,b.the_geom))/st_area(a.the_geom) as part FROM ", " a, ", " b \n                        WHERE a.the_geom && b.the_geom and st_intersects(a.the_geom, b.the_geom) AND  a.TYPE ='building';   \n            CREATE INDEX ON ", "(id_build);                     \n            create table ", " as select \n            MAX(part) FILTER (WHERE type = 'residential') as \"residential\",\n            MAX(part) FILTER (WHERE  type = 'education')  as \"education\",\n            MAX(part) FILTER (WHERE  type = 'commercial')  as \"commercial\",\n            MAX(part) FILTER (WHERE  type = 'heavy_industry')  as \"heavy_industry\",\n            MAX(part) FILTER (WHERE  type = 'light_industry')  as \"light_industry\",\n            MAX(part) FILTER (WHERE  type = 'government')  as \"government\",\n            MAX(part) FILTER (WHERE  type = 'military')  as \"military\",\n            MAX(part) FILTER (WHERE  type = 'transport')  as \"transport\",\n            MAX(part) FILTER (WHERE  type = 'construction')  as \"construction\",\n            MAX(part) FILTER (WHERE  type = 'agricultural')  as \"agricultural\",\n            MAX(part) FILTER (WHERE  type = 'social_building')  as \"social_building\",\n            id_build FROM ", " where part > 0.9 group by id_build "})));
                    public final class _formatBuildingLayer_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference datasource;
                        private /* synthetic */ Reference buildinType;
                        private /* synthetic */ Reference outputTableName;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _formatBuildingLayer_closure2(Object _outerInstance, Object _thisObject, Reference datasource, Reference buildinType, Reference outputTableName) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.datasource = reference3 = datasource;
                            this.buildinType = reference2 = buildinType;
                            this.outputTableName = reference = outputTableName;
                        }

                        public Object doCall(Object stmt) {
                            Reference stmt2 = new Reference(stmt);
                            public final class _closure14
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference stmt;
                                private /* synthetic */ Reference outputTableName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure14(Object _outerInstance, Object _thisObject, Reference stmt, Reference outputTableName) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    Reference reference2;
                                    this.stmt = reference2 = stmt;
                                    this.outputTableName = reference = outputTableName;
                                }

                                public Object doCall(Object row) {
                                    Object new_type = "building";
                                    CallSite id_build_ = IndyInterface.bootstrap("getProperty", "id_build", 0, row);
                                    CallSite mapTypes = IndyInterface.bootstrap("invoke", "toRowResult", 0, row);
                                    IndyInterface.bootstrap("invoke", "remove", 0, mapTypes, "ID_BUILD");
                                    public final class _closure15
                                    extends Closure
                                    implements GeneratedClosure {
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;

                                        public _closure15(Object _outerInstance, Object _thisObject) {
                                            super(_outerInstance, _thisObject);
                                        }

                                        public Object doCall(Object it) {
                                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "value", 0, it), null);
                                        }

                                        @Generated
                                        public Object doCall() {
                                            return this.doCall(null);
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _closure15.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                            return MethodHandles.lookup();
                                        }
                                    }
                                    IndyInterface.bootstrap("invoke", "removeAll", 0, mapTypes, new _closure15((Object)this, this.getThisObject()));
                                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, mapTypes), (Object)1)) {
                                        new_type = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "findFirst", 0, IndyInterface.bootstrap("invoke", "stream", 0, IndyInterface.bootstrap("invoke", "keySet", 0, mapTypes))));
                                    } else {
                                        public final class _closure16
                                        extends Closure
                                        implements GeneratedClosure {
                                            private static /* synthetic */ ClassInfo $staticClassInfo;
                                            public static transient /* synthetic */ boolean __$stMC;

                                            public _closure16(Object _outerInstance, Object _thisObject) {
                                                super(_outerInstance, _thisObject);
                                            }

                                            public Object doCall(Object it) {
                                                return IndyInterface.bootstrap("getProperty", "value", 0, it);
                                            }

                                            @Generated
                                            public Object doCall() {
                                                return this.doCall(null);
                                            }

                                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                if (((Object)((Object)this)).getClass() != _closure16.class) {
                                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                }
                                                ClassInfo classInfo = $staticClassInfo;
                                                if (classInfo == null) {
                                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                }
                                                return classInfo.getMetaClass();
                                            }

                                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                return MethodHandles.lookup();
                                            }
                                        }
                                        CallSite maxType = IndyInterface.bootstrap("invoke", "max", 0, mapTypes, new _closure16((Object)this, this.getThisObject()));
                                        if (IndyInterface.bootstrap("cast", "()", 0, maxType) != false) {
                                            CallSite maxKeyType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "key", 0, maxType));
                                            public final class _closure17
                                            extends Closure
                                            implements GeneratedClosure {
                                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                                public static transient /* synthetic */ boolean __$stMC;

                                                public _closure17(Object _outerInstance, Object _thisObject) {
                                                    super(_outerInstance, _thisObject);
                                                }

                                                public Object doCall(Object it) {
                                                    return ScriptBytecodeAdapter.unaryMinus((Object)IndyInterface.bootstrap("getProperty", "value", 0, it));
                                                }

                                                @Generated
                                                public Object doCall() {
                                                    return this.doCall(null);
                                                }

                                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                    if (((Object)((Object)this)).getClass() != _closure17.class) {
                                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                    }
                                                    ClassInfo classInfo = $staticClassInfo;
                                                    if (classInfo == null) {
                                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                    }
                                                    return classInfo.getMetaClass();
                                                }

                                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                    return MethodHandles.lookup();
                                                }
                                            }
                                            CallSite sortValues = IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("invoke", "sort", 0, mapTypes, new _closure17((Object)this, this.getThisObject())));
                                            IndyInterface.bootstrap("invoke", "remove", 0, sortValues, maxKeyType);
                                            CallSite callSite = maxKeyType;
                                            new_type = ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"residential") ? (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, sortValues, "education")) != false ? "education" : IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "take", 0, sortValues, true), false)) : (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"education") ? "education" : IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "take", 0, sortValues, true), false));
                                        }
                                    }
                                    return IndyInterface.bootstrap("invoke", "addBatch", 0, this.stmt.get(), new GStringImpl(new Object[]{this.outputTableName.get(), new_type, new_type, id_build_}, new String[]{"UPDATE ", " set type = '", "' , main_use = '", "'where id_build=", ""}));
                                }

                                @Generated
                                public Object getStmt() {
                                    return this.stmt.get();
                                }

                                @Generated
                                public Object getOutputTableName() {
                                    return this.outputTableName.get();
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure14.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.buildinType.get()}, new String[]{"SELECT * FROM ", ""})), new _closure14((Object)this, this.getThisObject(), stmt2, this.outputTableName));
                        }

                        @Generated
                        public JdbcDataSource getDatasource() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                        }

                        @Generated
                        public Object getBuildinType() {
                            return this.buildinType.get();
                        }

                        @Generated
                        public Object getOutputTableName() {
                            return this.outputTableName.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _formatBuildingLayer_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatBuildingLayer_closure2((Object)this, (Object)this, datasource2, buildinType, outputTableName));
                    IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{urbanAreasPart, buildinType.get()}, new String[]{"DROP TABLE IF EXISTS ", ", ", ""})));
                }
            }
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Buildings transformation finishes");
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"building", outputTableName.get(), "building_estimated", outputEstimateTableName.get()});
    }

    public String formatRoadLayer(JdbcDataSource datasource, String road, String zone, String jsonFilename) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Formating road layer");
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "INPUT_ROAD"));
        IndyInterface.bootstrap("invoke", "call", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{"\n            DROP TABLE IF EXISTS ", ";\n            CREATE TABLE ", " (THE_GEOM GEOMETRY, id_road serial, ID_SOURCE VARCHAR, WIDTH FLOAT, TYPE VARCHAR, CROSSING VARCHAR(30),\n                SURFACE VARCHAR, SIDEWALK VARCHAR, MAXSPEED INTEGER, DIRECTION INTEGER, ZINDEX INTEGER);\n        "})));
        if (IndyInterface.bootstrap("cast", "()", 0, road) != false) {
            CallSite paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "roadParams.json");
            CallSite parametersMap = IndyInterface.bootstrap("invoke", "parametersMapping", 0, InputDataFormatting.class, jsonFilename, paramsDefaultFile);
            Reference mappingForRoadType = new Reference((Object)IndyInterface.bootstrap("getProperty", "type", 0, parametersMap));
            Reference mappingForSurface = new Reference((Object)IndyInterface.bootstrap("getProperty", "surface", 0, parametersMap));
            Reference typeAndWidth = new Reference((Object)IndyInterface.bootstrap("getProperty", "width", 0, parametersMap));
            Reference crossingValues = new Reference((Object)IndyInterface.bootstrap("getProperty", "crossing", 0, parametersMap));
            Reference queryMapper = new Reference((Object)"SELECT ");
            CallSite columnToMap = IndyInterface.bootstrap("getProperty", "columns", 0, parametersMap);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, (JdbcDataSource)datasource2.get(), road), (Object)0)) {
                Reference columnNames = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnNames", 0, (JdbcDataSource)datasource2.get(), road));
                IndyInterface.bootstrap("invoke", "remove", 0, columnNames.get(), "THE_GEOM");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "columnsMapper", 0, InputDataFormatting.class, columnNames.get(), columnToMap)));
                if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), road);
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", st_intersection(a.the_geom, b.the_geom) as the_geom ", "FROM "), new GStringImpl(new Object[]{road, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom")));
                } else {
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{road}, new String[]{", a.the_geom as the_geom FROM ", "  as a"})));
                }
                Reference rowcount = new Reference((Object)1);
                Reference speedPattern = new Reference((Object)IndyInterface.bootstrap("invoke", "compile", 0, Pattern.class, "([0-9]+)( ([a-zA-Z]+))?", IndyInterface.bootstrap("getProperty", "CASE_INSENSITIVE", 0, Pattern.class)));
                public final class _formatRoadLayer_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference datasource;
                    private /* synthetic */ Reference queryMapper;
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference mappingForRoadType;
                    private /* synthetic */ Reference typeAndWidth;
                    private /* synthetic */ Reference crossingValues;
                    private /* synthetic */ Reference mappingForSurface;
                    private /* synthetic */ Reference speedPattern;
                    private /* synthetic */ Reference outputTableName;
                    private /* synthetic */ Reference rowcount;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _formatRoadLayer_closure3(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference columnNames, Reference mappingForRoadType, Reference typeAndWidth, Reference crossingValues, Reference mappingForSurface, Reference speedPattern, Reference outputTableName, Reference rowcount) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        Reference reference8;
                        Reference reference9;
                        Reference reference10;
                        this.datasource = reference10 = datasource;
                        this.queryMapper = reference9 = queryMapper;
                        this.columnNames = reference8 = columnNames;
                        this.mappingForRoadType = reference7 = mappingForRoadType;
                        this.typeAndWidth = reference6 = typeAndWidth;
                        this.crossingValues = reference5 = crossingValues;
                        this.mappingForSurface = reference4 = mappingForSurface;
                        this.speedPattern = reference3 = speedPattern;
                        this.outputTableName = reference2 = outputTableName;
                        this.rowcount = reference = rowcount;
                    }

                    public Object doCall(Object stmt) {
                        Reference stmt2 = new Reference(stmt);
                        public final class _closure18
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference columnNames;
                            private /* synthetic */ Reference mappingForRoadType;
                            private /* synthetic */ Reference typeAndWidth;
                            private /* synthetic */ Reference crossingValues;
                            private /* synthetic */ Reference mappingForSurface;
                            private /* synthetic */ Reference speedPattern;
                            private /* synthetic */ Reference stmt;
                            private /* synthetic */ Reference outputTableName;
                            private /* synthetic */ Reference rowcount;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure18(Object _outerInstance, Object _thisObject, Reference columnNames, Reference mappingForRoadType, Reference typeAndWidth, Reference crossingValues, Reference mappingForSurface, Reference speedPattern, Reference stmt, Reference outputTableName, Reference rowcount) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                Reference reference7;
                                Reference reference8;
                                Reference reference9;
                                this.columnNames = reference9 = columnNames;
                                this.mappingForRoadType = reference8 = mappingForRoadType;
                                this.typeAndWidth = reference7 = typeAndWidth;
                                this.crossingValues = reference6 = crossingValues;
                                this.mappingForSurface = reference5 = mappingForSurface;
                                this.speedPattern = reference4 = speedPattern;
                                this.stmt = reference3 = stmt;
                                this.outputTableName = reference2 = outputTableName;
                                this.rowcount = reference = rowcount;
                            }

                            public Object doCall(Object row) {
                                Boolean processRow = true;
                                Object zIndex = IndyInterface.bootstrap("invoke", "getZIndex", 2, this, IndyInterface.bootstrap("getProperty", "layer", 0, row));
                                CallSite road_access = IndyInterface.bootstrap("getProperty", "access", 0, row);
                                CallSite road_area = IndyInterface.bootstrap("getProperty", "area", 0, row);
                                if (ScriptBytecodeAdapter.isCase((Object)road_area, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"yes"}))) {
                                    processRow = false;
                                }
                                CallSite road_service = IndyInterface.bootstrap("getProperty", "service", 0, row);
                                if (DefaultTypeTransformation.booleanUnbox((Object)road_service) && ScriptBytecodeAdapter.isCase((Object)road_service, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"parking_aisle", "alley", "slipway", "drive-through", "driveway"}))) {
                                    processRow = false;
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)road_access) && ScriptBytecodeAdapter.isCase((Object)road_access, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"agricultural", "forestry"}))) {
                                    processRow = false;
                                }
                                if (IndyInterface.bootstrap("cast", "()", 0, processRow) != false) {
                                    Object type = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTypeValue", 2, this, row, this.columnNames.get(), this.mappingForRoadType.get()));
                                    CallSite width = IndyInterface.bootstrap("invoke", "getWidth", 2, this, IndyInterface.bootstrap("getProperty", "width", 0, row));
                                    if (IndyInterface.bootstrap("cast", "()", 0, type) == false) {
                                        type = "unclassified";
                                    }
                                    CallSite widthFromType = IndyInterface.bootstrap("invoke", "getAt", 0, this.typeAndWidth.get(), type);
                                    if (ScriptBytecodeAdapter.compareLessThanEqual((Object)width, (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)widthFromType)) {
                                        width = widthFromType;
                                    }
                                    Object crossing = IndyInterface.bootstrap("getProperty", "bridge", 0, row);
                                    if (IndyInterface.bootstrap("cast", "()", 0, crossing) != false) {
                                        crossing = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "bridge", 0, this.crossingValues.get()), crossing)) != false ? "'bridge'" : null;
                                        if (IndyInterface.bootstrap("cast", "()", 0, zIndex) == false && DefaultTypeTransformation.booleanUnbox((Object)crossing)) {
                                            zIndex = 1;
                                        }
                                    }
                                    Object surface = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTypeValue", 2, this, row, this.columnNames.get(), this.mappingForSurface.get()));
                                    if (IndyInterface.bootstrap("cast", "()", 0, surface) == false) {
                                        CallSite tracktype = IndyInterface.bootstrap("getProperty", "tracktype", 0, row);
                                        CallSite callSite = tracktype;
                                        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"grade1")) {
                                            surface = "compacted";
                                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"grade2")) {
                                            surface = "gravel";
                                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"grade3")) {
                                            surface = "gravel";
                                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"grade4")) {
                                            surface = "ground";
                                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"grade5")) {
                                            surface = "ground";
                                        }
                                    }
                                    CallSite sidewalk = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSidewalk", 2, this, IndyInterface.bootstrap("getProperty", "sidewalk", 0, row)));
                                    int maxspeed_value = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getSpeedInKmh", 2, this, this.speedPattern.get(), IndyInterface.bootstrap("getProperty", "maxspeed", 0, row)));
                                    CallSite onewayValue = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "oneway", 0, row));
                                    int direction = 3;
                                    if (DefaultTypeTransformation.booleanUnbox((Object)onewayValue) && ScriptBytecodeAdapter.compareEqual((Object)onewayValue, (Object)"yes")) {
                                        direction = 1;
                                    }
                                    if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)zIndex, (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)type)) {
                                        boolean addGeom = false;
                                        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"track") && ScriptBytecodeAdapter.isCase((Object)surface, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"unpaved", "asphalt", "paved", "cobblestone", "metal", "concrete", "compacted"}))) {
                                            addGeom = true;
                                        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)type, (Object)"track")) {
                                            addGeom = true;
                                        }
                                        if (addGeom) {
                                            CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                            int epsg = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getSRID", 0, geom));
                                            int i = 0;
                                            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                                Object object = this.stmt.get();
                                                Object[] objectArray = new Object[13];
                                                objectArray[0] = this.outputTableName.get();
                                                objectArray[1] = IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i);
                                                objectArray[2] = epsg;
                                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                                this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                                objectArray[3] = callSite;
                                                objectArray[4] = IndyInterface.bootstrap("getProperty", "id", 0, row);
                                                objectArray[5] = width;
                                                objectArray[6] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, type);
                                                objectArray[7] = crossing;
                                                objectArray[8] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, surface);
                                                objectArray[9] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, sidewalk);
                                                objectArray[10] = maxspeed_value;
                                                objectArray[11] = direction;
                                                objectArray[12] = zIndex;
                                                IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"\n                                    INSERT INTO ", " VALUES(ST_GEOMFROMTEXT(\n                                        '", "',", "), \n                                        ", ", \n                                        '", "', \n                                        ", ",\n                                        ", ",\n                                        ", ", \n                                        ", ",\n                                        ", ",\n                                        ", ",\n                                        ", ",\n                                        ", ")\n                                "})));
                                                int n = i;
                                                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                            }
                                            return null;
                                        }
                                    }
                                }
                                return null;
                            }

                            @Generated
                            public Object getColumnNames() {
                                return this.columnNames.get();
                            }

                            @Generated
                            public Object getMappingForRoadType() {
                                return this.mappingForRoadType.get();
                            }

                            @Generated
                            public Object getTypeAndWidth() {
                                return this.typeAndWidth.get();
                            }

                            @Generated
                            public Object getCrossingValues() {
                                return this.crossingValues.get();
                            }

                            @Generated
                            public Object getMappingForSurface() {
                                return this.mappingForSurface.get();
                            }

                            @Generated
                            public Object getSpeedPattern() {
                                return this.speedPattern.get();
                            }

                            @Generated
                            public Object getStmt() {
                                return this.stmt.get();
                            }

                            @Generated
                            public Object getOutputTableName() {
                                return this.outputTableName.get();
                            }

                            @Generated
                            public Integer getRowcount() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure18.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), this.queryMapper.get(), new _closure18((Object)this, this.getThisObject(), this.columnNames, this.mappingForRoadType, this.typeAndWidth, this.crossingValues, this.mappingForSurface, this.speedPattern, stmt2, this.outputTableName, this.rowcount));
                    }

                    @Generated
                    public JdbcDataSource getDatasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                    }

                    @Generated
                    public Object getQueryMapper() {
                        return this.queryMapper.get();
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getMappingForRoadType() {
                        return this.mappingForRoadType.get();
                    }

                    @Generated
                    public Object getTypeAndWidth() {
                        return this.typeAndWidth.get();
                    }

                    @Generated
                    public Object getCrossingValues() {
                        return this.crossingValues.get();
                    }

                    @Generated
                    public Object getMappingForSurface() {
                        return this.mappingForSurface.get();
                    }

                    @Generated
                    public Object getSpeedPattern() {
                        return this.speedPattern.get();
                    }

                    @Generated
                    public Object getOutputTableName() {
                        return this.outputTableName.get();
                    }

                    @Generated
                    public Integer getRowcount() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _formatRoadLayer_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatRoadLayer_closure3((Object)this, (Object)this, datasource2, queryMapper, columnNames, mappingForRoadType, typeAndWidth, crossingValues, mappingForSurface, speedPattern, outputTableName, rowcount));
            }
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Roads transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatRailsLayer(JdbcDataSource datasource, String rail, String zone, String jsonFilename) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Rails transformation starts");
        Reference outputTableName = new Reference((Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"INPUT_RAILS_", ""}));
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{" drop table if exists ", ";\n                CREATE TABLE ", " (THE_GEOM GEOMETRY, id_rail serial,ID_SOURCE VARCHAR, TYPE VARCHAR,CROSSING VARCHAR(30), ZINDEX INTEGER, WIDTH FLOAT, USAGE VARCHAR(30));"})));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)rail, null)) {
            CallSite paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "railParams.json");
            CallSite parametersMap = IndyInterface.bootstrap("invoke", "parametersMapping", 0, InputDataFormatting.class, jsonFilename, paramsDefaultFile);
            Reference mappingType = new Reference((Object)IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "type"));
            Reference crossingValues = new Reference((Object)IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "crossing"));
            Reference queryMapper = new Reference((Object)"SELECT ");
            CallSite columnToMap = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, (JdbcDataSource)datasource2.get(), rail), (Object)0)) {
                Reference columnNames = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnNames", 0, (JdbcDataSource)datasource2.get(), rail));
                IndyInterface.bootstrap("invoke", "remove", 0, columnNames.get(), "THE_GEOM");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "columnsMapper", 0, InputDataFormatting.class, columnNames.get(), columnToMap)));
                if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), rail);
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", st_intersection(a.the_geom, b.the_geom) as the_geom ", "FROM "), new GStringImpl(new Object[]{rail, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom ")));
                } else {
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{rail}, new String[]{", a.the_geom as the_geom FROM ", "  as a"})));
                }
                Reference rowcount = new Reference((Object)1);
                public final class _formatRailsLayer_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference datasource;
                    private /* synthetic */ Reference queryMapper;
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference mappingType;
                    private /* synthetic */ Reference crossingValues;
                    private /* synthetic */ Reference outputTableName;
                    private /* synthetic */ Reference rowcount;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _formatRailsLayer_closure4(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference columnNames, Reference mappingType, Reference crossingValues, Reference outputTableName, Reference rowcount) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        this.datasource = reference7 = datasource;
                        this.queryMapper = reference6 = queryMapper;
                        this.columnNames = reference5 = columnNames;
                        this.mappingType = reference4 = mappingType;
                        this.crossingValues = reference3 = crossingValues;
                        this.outputTableName = reference2 = outputTableName;
                        this.rowcount = reference = rowcount;
                    }

                    public Object doCall(Object stmt) {
                        Reference stmt2 = new Reference(stmt);
                        public final class _closure19
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference columnNames;
                            private /* synthetic */ Reference mappingType;
                            private /* synthetic */ Reference crossingValues;
                            private /* synthetic */ Reference stmt;
                            private /* synthetic */ Reference outputTableName;
                            private /* synthetic */ Reference rowcount;
                            private static /* synthetic */ BigDecimal $const$0;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure19(Object _outerInstance, Object _thisObject, Reference columnNames, Reference mappingType, Reference crossingValues, Reference stmt, Reference outputTableName, Reference rowcount) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                this.columnNames = reference6 = columnNames;
                                this.mappingType = reference5 = mappingType;
                                this.crossingValues = reference4 = crossingValues;
                                this.stmt = reference3 = stmt;
                                this.outputTableName = reference2 = outputTableName;
                                this.rowcount = reference = rowcount;
                            }

                            public Object doCall(Object row) {
                                CallSite type = IndyInterface.bootstrap("invoke", "getTypeValue", 2, this, row, this.columnNames.get(), this.mappingType.get());
                                Object zIndex = IndyInterface.bootstrap("invoke", "getZIndex", 2, this, IndyInterface.bootstrap("getProperty", "layer", 0, row));
                                if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"subway") && !(ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "tunnel", 0, row), null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "tunnel", 0, row), (Object)"no") && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)zIndex, (Object)0) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "bridge", 0, row), null) && (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "bridge", 0, row), (Object)"yes") || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "bridge", 0, row), (Object)"viaduct")))) {
                                    type = null;
                                }
                                Object crossing = IndyInterface.bootstrap("getProperty", "bridge", 0, row);
                                if (IndyInterface.bootstrap("cast", "()", 0, crossing) != false) {
                                    crossing = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "bridge", 0, this.crossingValues.get()), crossing)) != false ? "bridge" : null;
                                    if (IndyInterface.bootstrap("cast", "()", 0, zIndex) == false && DefaultTypeTransformation.booleanUnbox((Object)crossing)) {
                                        zIndex = 1;
                                    }
                                }
                                CallSite gauge = IndyInterface.bootstrap("getProperty", "gauge", 0, row);
                                CallSite rail_width = IndyInterface.bootstrap("invoke", "plus", 0, $const$0, true);
                                if (DefaultTypeTransformation.booleanUnbox((Object)gauge) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFloat", 0, gauge))) {
                                    rail_width = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "div", 0, IndyInterface.bootstrap("invoke", "toFloat", 0, gauge), 1000), true);
                                }
                                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)zIndex, (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)type)) {
                                    CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                    int epsg = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getSRID", 0, geom));
                                    int i = 0;
                                    while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                        Object object = this.stmt.get();
                                        Object[] objectArray = new Object[10];
                                        objectArray[0] = this.outputTableName.get();
                                        objectArray[1] = IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i);
                                        objectArray[2] = epsg;
                                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                        this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                        objectArray[3] = callSite;
                                        objectArray[4] = IndyInterface.bootstrap("getProperty", "id", 0, row);
                                        objectArray[5] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, type);
                                        objectArray[6] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, crossing);
                                        objectArray[7] = zIndex;
                                        objectArray[8] = rail_width;
                                        objectArray[9] = IndyInterface.bootstrap("getProperty", "usage", 0, row);
                                        IndyInterface.bootstrap("invoke", "addBatch", 0, object, new GStringImpl(objectArray, new String[]{"\n                                    INSERT INTO ", " values(ST_GEOMFROMTEXT(\n                                    '", "',", "), \n                                    ", ", \n                                    '", "',\n                                    ", ",\n                                    ", ",\n                                    ", ", ", ", '", "')\n                                "}));
                                        int n = i;
                                        i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                    }
                                    return null;
                                }
                                return null;
                            }

                            @Generated
                            public Object getColumnNames() {
                                return this.columnNames.get();
                            }

                            @Generated
                            public Object getMappingType() {
                                return this.mappingType.get();
                            }

                            @Generated
                            public Object getCrossingValues() {
                                return this.crossingValues.get();
                            }

                            @Generated
                            public Object getStmt() {
                                return this.stmt.get();
                            }

                            @Generated
                            public Object getOutputTableName() {
                                return this.outputTableName.get();
                            }

                            @Generated
                            public Integer getRowcount() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure19.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }

                            public static /* synthetic */ void __$swapInit() {
                                BigDecimal bigDecimal;
                                $const$0 = bigDecimal = new BigDecimal("1.435");
                            }

                            static {
                                _closure19.__$swapInit();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, this.queryMapper.get()), new _closure19((Object)this, this.getThisObject(), this.columnNames, this.mappingType, this.crossingValues, stmt2, this.outputTableName, this.rowcount));
                    }

                    @Generated
                    public JdbcDataSource getDatasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                    }

                    @Generated
                    public Object getQueryMapper() {
                        return this.queryMapper.get();
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getMappingType() {
                        return this.mappingType.get();
                    }

                    @Generated
                    public Object getCrossingValues() {
                        return this.crossingValues.get();
                    }

                    @Generated
                    public Object getOutputTableName() {
                        return this.outputTableName.get();
                    }

                    @Generated
                    public Integer getRowcount() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _formatRailsLayer_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatRailsLayer_closure4((Object)this, (Object)this, datasource2, queryMapper, columnNames, mappingType, crossingValues, outputTableName, rowcount));
            }
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Rails transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatVegetationLayer(JdbcDataSource datasource, String vegetation, String zone, String jsonFilename) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Vegetation transformation starts");
        Reference outputTableName = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "INPUT_VEGET"));
        IndyInterface.bootstrap("invoke", "call", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{" \n                DROP TABLE IF EXISTS ", ";\n                CREATE TABLE ", " (THE_GEOM GEOMETRY, id_veget serial, ID_SOURCE VARCHAR, TYPE VARCHAR, HEIGHT_CLASS VARCHAR(4), ZINDEX INTEGER);"})));
        if (IndyInterface.bootstrap("cast", "()", 0, vegetation) != false) {
            CallSite paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "vegetParams.json");
            CallSite parametersMap = IndyInterface.bootstrap("invoke", "parametersMapping", 0, InputDataFormatting.class, jsonFilename, paramsDefaultFile);
            Reference mappingType = new Reference((Object)IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "type"));
            Reference typeAndVegClass = new Reference((Object)IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "class"));
            Reference queryMapper = new Reference((Object)"SELECT ");
            CallSite columnToMap = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, (JdbcDataSource)datasource2.get(), vegetation), (Object)0)) {
                Reference columnNames = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnNames", 0, (JdbcDataSource)datasource2.get(), vegetation));
                IndyInterface.bootstrap("invoke", "remove", 0, columnNames.get(), "THE_GEOM");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "columnsMapper", 0, InputDataFormatting.class, columnNames.get(), columnToMap)));
                if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), vegetation);
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", st_intersection(a.the_geom, b.the_geom) as the_geom ", "FROM "), new GStringImpl(new Object[]{vegetation, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom  ")));
                } else {
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{vegetation}, new String[]{", a.the_geom as the_geom FROM ", "  as a"})));
                }
                Reference rowcount = new Reference((Object)1);
                public final class _formatVegetationLayer_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference datasource;
                    private /* synthetic */ Reference queryMapper;
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference mappingType;
                    private /* synthetic */ Reference typeAndVegClass;
                    private /* synthetic */ Reference outputTableName;
                    private /* synthetic */ Reference rowcount;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _formatVegetationLayer_closure5(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference columnNames, Reference mappingType, Reference typeAndVegClass, Reference outputTableName, Reference rowcount) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        this.datasource = reference7 = datasource;
                        this.queryMapper = reference6 = queryMapper;
                        this.columnNames = reference5 = columnNames;
                        this.mappingType = reference4 = mappingType;
                        this.typeAndVegClass = reference3 = typeAndVegClass;
                        this.outputTableName = reference2 = outputTableName;
                        this.rowcount = reference = rowcount;
                    }

                    public Object doCall(Object stmt) {
                        Reference stmt2 = new Reference(stmt);
                        public final class _closure20
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference columnNames;
                            private /* synthetic */ Reference mappingType;
                            private /* synthetic */ Reference typeAndVegClass;
                            private /* synthetic */ Reference stmt;
                            private /* synthetic */ Reference outputTableName;
                            private /* synthetic */ Reference rowcount;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure20(Object _outerInstance, Object _thisObject, Reference columnNames, Reference mappingType, Reference typeAndVegClass, Reference stmt, Reference outputTableName, Reference rowcount) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                this.columnNames = reference6 = columnNames;
                                this.mappingType = reference5 = mappingType;
                                this.typeAndVegClass = reference4 = typeAndVegClass;
                                this.stmt = reference3 = stmt;
                                this.outputTableName = reference2 = outputTableName;
                                this.rowcount = reference = rowcount;
                            }

                            public Object doCall(Object row) {
                                CallSite type = IndyInterface.bootstrap("invoke", "getTypeValue", 2, this, row, this.columnNames.get(), this.mappingType.get());
                                if (IndyInterface.bootstrap("cast", "()", 0, type) != false) {
                                    boolean addGeom = true;
                                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "surface", 0, row)) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "surface", 0, row), (Object)"grass")) {
                                        addGeom = false;
                                    }
                                    if (addGeom) {
                                        CallSite height_class = IndyInterface.bootstrap("invoke", "getAt", 0, this.typeAndVegClass.get(), type);
                                        CallSite zindex = IndyInterface.bootstrap("invoke", "getZIndex", 2, this, IndyInterface.bootstrap("getProperty", "layer", 0, row));
                                        CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                        int epsg = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getSRID", 0, geom));
                                        int i = 0;
                                        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                            CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                            if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                                Object object = this.stmt.get();
                                                Object[] objectArray = new Object[8];
                                                objectArray[0] = this.outputTableName.get();
                                                objectArray[1] = subGeom;
                                                objectArray[2] = epsg;
                                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                                this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                                objectArray[3] = callSite;
                                                objectArray[4] = IndyInterface.bootstrap("getProperty", "id", 0, row);
                                                objectArray[5] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, type);
                                                objectArray[6] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, height_class);
                                                objectArray[7] = zindex;
                                                IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"\n                                            INSERT INTO ", " VALUES(\n                                                ST_GEOMFROMTEXT('", "',", "), \n                                                ", ", \n                                                '", "',\n                                                ", ", \n                                                ", ", ", ")\n                                    "})));
                                            }
                                            int n = i;
                                            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                        }
                                        return null;
                                    }
                                }
                                return null;
                            }

                            @Generated
                            public Object getColumnNames() {
                                return this.columnNames.get();
                            }

                            @Generated
                            public Object getMappingType() {
                                return this.mappingType.get();
                            }

                            @Generated
                            public Object getTypeAndVegClass() {
                                return this.typeAndVegClass.get();
                            }

                            @Generated
                            public Object getStmt() {
                                return this.stmt.get();
                            }

                            @Generated
                            public Object getOutputTableName() {
                                return this.outputTableName.get();
                            }

                            @Generated
                            public Integer getRowcount() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure20.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), this.queryMapper.get(), new _closure20((Object)this, this.getThisObject(), this.columnNames, this.mappingType, this.typeAndVegClass, stmt2, this.outputTableName, this.rowcount));
                    }

                    @Generated
                    public JdbcDataSource getDatasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                    }

                    @Generated
                    public Object getQueryMapper() {
                        return this.queryMapper.get();
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getMappingType() {
                        return this.mappingType.get();
                    }

                    @Generated
                    public Object getTypeAndVegClass() {
                        return this.typeAndVegClass.get();
                    }

                    @Generated
                    public Object getOutputTableName() {
                        return this.outputTableName.get();
                    }

                    @Generated
                    public Integer getRowcount() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _formatVegetationLayer_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatVegetationLayer_closure5((Object)this, (Object)this, datasource2, queryMapper, columnNames, mappingType, typeAndVegClass, outputTableName, rowcount));
            }
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Vegetation transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatWaterLayer(JdbcDataSource datasource, String water, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Hydro transformation starts");
        Reference outputTableName = new Reference((Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"INPUT_HYDRO_", ""}));
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{"Drop table if exists ", ";\n                    CREATE TABLE ", " (THE_GEOM GEOMETRY, id_water serial, ID_SOURCE VARCHAR, TYPE VARCHAR, ZINDEX INTEGER);"})));
        if (IndyInterface.bootstrap("cast", "()", 0, water) != false && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, (JdbcDataSource)datasource2.get(), water), (Object)0)) {
            Reference query = new Reference(null);
            String cfr_ignored_0 = (String)query.get();
            if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), water, "the_geom");
                query.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "select id ,  st_intersection(a.the_geom, b.the_geom) as the_geom", ", a.\"natural\", a.\"layer\""), " FROM "), new GStringImpl(new Object[]{water, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom ")));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "getColumnNames", 0, (JdbcDataSource)datasource2.get(), water), "seamark:type")) != false) {
                    query.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, (String)query.get(), " and (a.\"seamark:type\" is null or a.\"seamark:type\" in ('harbour_basin', 'harbour'))")));
                }
            } else {
                query.set((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{water}, new String[]{"select id,  the_geom, \"natural\", \"layer\" FROM ", " "})));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "getColumnNames", 0, (JdbcDataSource)datasource2.get(), water), "seamark:type")) != false) {
                    query.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, (String)query.get(), " where \"seamark:type\" is null")));
                }
            }
            Reference rowcount = new Reference((Object)1);
            public final class _formatWaterLayer_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference datasource;
                private /* synthetic */ Reference query;
                private /* synthetic */ Reference outputTableName;
                private /* synthetic */ Reference rowcount;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _formatWaterLayer_closure6(Object _outerInstance, Object _thisObject, Reference datasource, Reference query, Reference outputTableName, Reference rowcount) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.datasource = reference4 = datasource;
                    this.query = reference3 = query;
                    this.outputTableName = reference2 = outputTableName;
                    this.rowcount = reference = rowcount;
                }

                public Object doCall(Object stmt) {
                    Reference stmt2 = new Reference(stmt);
                    public final class _closure21
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference stmt;
                        private /* synthetic */ Reference outputTableName;
                        private /* synthetic */ Reference rowcount;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure21(Object _outerInstance, Object _thisObject, Reference stmt, Reference outputTableName, Reference rowcount) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.stmt = reference3 = stmt;
                            this.outputTableName = reference2 = outputTableName;
                            this.rowcount = reference = rowcount;
                        }

                        public Object doCall(Object row) {
                            String water_type = ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "natural", 0, row), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"bay", "strait"})) ? "sea" : "water";
                            CallSite zIndex = IndyInterface.bootstrap("invoke", "getZIndex", 2, this, IndyInterface.bootstrap("getProperty", "layer", 0, row));
                            CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                            int epsg = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getSRID", 0, geom));
                            int i = 0;
                            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                    Object object = this.stmt.get();
                                    Object[] objectArray = new Object[7];
                                    objectArray[0] = this.outputTableName.get();
                                    objectArray[1] = subGeom;
                                    objectArray[2] = epsg;
                                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                    this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                    objectArray[3] = callSite;
                                    objectArray[4] = IndyInterface.bootstrap("getProperty", "id", 0, row);
                                    objectArray[5] = water_type;
                                    objectArray[6] = zIndex;
                                    IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"insert into ", " values(ST_GEOMFROMTEXT('", "',", "), ", ", '", "', '", "', ", ")"})));
                                }
                                int n = i;
                                i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                            }
                            return null;
                        }

                        @Generated
                        public Object getStmt() {
                            return this.stmt.get();
                        }

                        @Generated
                        public Object getOutputTableName() {
                            return this.outputTableName.get();
                        }

                        @Generated
                        public Integer getRowcount() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure21.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), IndyInterface.bootstrap("cast", "()", 0, this.query.get()), new _closure21((Object)this, this.getThisObject(), stmt2, this.outputTableName, this.rowcount));
                }

                @Generated
                public JdbcDataSource getDatasource() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                }

                @Generated
                public String getQuery() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.query.get());
                }

                @Generated
                public Object getOutputTableName() {
                    return this.outputTableName.get();
                }

                @Generated
                public Integer getRowcount() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _formatWaterLayer_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatWaterLayer_closure6((Object)this, (Object)this, datasource2, query, outputTableName, rowcount));
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Hydro transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatImperviousLayer(JdbcDataSource datasource, String impervious, String zone, String jsonFilename) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Impervious transformation starts");
        GStringImpl outputTableName = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"INPUT_IMPERVIOUS_", ""});
        IndyInterface.bootstrap("invoke", "debug", 2, this, impervious);
        if (IndyInterface.bootstrap("cast", "()", 0, impervious) != false) {
            CallSite paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "imperviousParams.json");
            CallSite parametersMap = IndyInterface.bootstrap("invoke", "parametersMapping", 0, InputDataFormatting.class, jsonFilename, paramsDefaultFile);
            Reference mappingTypeAndUse = new Reference((Object)IndyInterface.bootstrap("getProperty", "type", 0, parametersMap));
            Object queryMapper = "SELECT ";
            CallSite columnToMap = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, (JdbcDataSource)datasource2.get(), impervious), (Object)0)) {
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), impervious);
                Reference columnNames = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnNames", 0, (JdbcDataSource)datasource2.get(), impervious));
                IndyInterface.bootstrap("invoke", "remove", 0, columnNames.get(), "THE_GEOM");
                queryMapper = IndyInterface.bootstrap("invoke", "plus", 0, queryMapper, IndyInterface.bootstrap("invoke", "columnsMapper", 0, InputDataFormatting.class, columnNames.get(), columnToMap));
                queryMapper = IndyInterface.bootstrap("cast", "()", 0, zone) != false ? IndyInterface.bootstrap("invoke", "plus", 0, queryMapper, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", st_intersection(a.the_geom, b.the_geom) as the_geom ", "FROM "), new GStringImpl(new Object[]{impervious, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom")) : IndyInterface.bootstrap("invoke", "plus", 0, queryMapper, new GStringImpl(new Object[]{impervious}, new String[]{",  a.the_geom FROM ", "  as a"}));
                CallSite polygonizedTable = IndyInterface.bootstrap("invoke", "postfix", 2, this, "polygonized");
                CallSite polygonizedExploded = IndyInterface.bootstrap("invoke", "postfix", 2, this, "polygonized_exploded");
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{polygonizedTable, polygonizedTable, queryMapper, polygonizedExploded, polygonizedExploded, polygonizedTable}, new String[]{"  \n                    DROP TABLE IF EXISTS ", ";\n                    CREATE TABLE ", " as select st_polygonize(st_union(st_accum(ST_ToMultiLine( the_geom)))) as the_geom from \n                    (", ") as foo where \"surface\" not in('grass') or \"parking\" not in ('underground') or \"building\" is null;\n                    DROP TABLE IF EXISTS ", ";\n                    CREATE TABLE ", " as select * from st_explode('", "');\n                    "})));
                Reference filtered_area = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "filtered_area"));
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{filtered_area.get(), filtered_area.get(), polygonizedExploded, impervious, filtered_area.get()}, new String[]{"DROP TABLE IF EXISTS ", ";\n                    CREATE TABLE  ", " AS \n                    SELECT a.EXPLOD_ID , a.the_geom, st_area(b.the_geom) as area_imp, b.* EXCEPT(the_geom) from ", " as a , ", " as b where\n                    a.the_geom && b.the_geom AND st_intersects(st_pointonsurface(a.the_geom), b.the_geom) ;\n                    CREATE INDEX ON ", "(EXPLOD_ID);"})));
                Reference impervious_prepared = new Reference((Object)IndyInterface.bootstrap("invoke", "postfix", 2, this, "impervious_prepared"));
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{impervious_prepared.get(), impervious_prepared.get()}, new String[]{"Drop table if exists ", ";\n                    CREATE TABLE ", " (THE_GEOM GEOMETRY, id_impervious serial, type varchar);"})));
                Reference rowcount = new Reference((Object)1);
                public final class _formatImperviousLayer_closure7
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference datasource;
                    private /* synthetic */ Reference filtered_area;
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference mappingTypeAndUse;
                    private /* synthetic */ Reference impervious_prepared;
                    private /* synthetic */ Reference rowcount;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _formatImperviousLayer_closure7(Object _outerInstance, Object _thisObject, Reference datasource, Reference filtered_area, Reference columnNames, Reference mappingTypeAndUse, Reference impervious_prepared, Reference rowcount) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        this.datasource = reference6 = datasource;
                        this.filtered_area = reference5 = filtered_area;
                        this.columnNames = reference4 = columnNames;
                        this.mappingTypeAndUse = reference3 = mappingTypeAndUse;
                        this.impervious_prepared = reference2 = impervious_prepared;
                        this.rowcount = reference = rowcount;
                    }

                    public Object doCall(Object stmt) {
                        Reference stmt2 = new Reference(stmt);
                        public final class _closure22
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference columnNames;
                            private /* synthetic */ Reference mappingTypeAndUse;
                            private /* synthetic */ Reference stmt;
                            private /* synthetic */ Reference impervious_prepared;
                            private /* synthetic */ Reference rowcount;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure22(Object _outerInstance, Object _thisObject, Reference columnNames, Reference mappingTypeAndUse, Reference stmt, Reference impervious_prepared, Reference rowcount) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                this.columnNames = reference5 = columnNames;
                                this.mappingTypeAndUse = reference4 = mappingTypeAndUse;
                                this.stmt = reference3 = stmt;
                                this.impervious_prepared = reference2 = impervious_prepared;
                                this.rowcount = reference = rowcount;
                            }

                            public Object doCall(Object row) {
                                CallSite typeAndUseValues = IndyInterface.bootstrap("invoke", "getTypeAndUse", 2, this, row, this.columnNames.get(), this.mappingTypeAndUse.get());
                                CallSite use = IndyInterface.bootstrap("invoke", "getAt", 0, typeAndUseValues, true);
                                CallSite type = IndyInterface.bootstrap("invoke", "getAt", 0, typeAndUseValues, false);
                                if (IndyInterface.bootstrap("cast", "()", 0, type) != false) {
                                    CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                    int epsg = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getSRID", 0, geom));
                                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, geom)) == false) {
                                        int i = 0;
                                        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                            CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, subGeom)) == false && subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                                Object object = this.stmt.get();
                                                Object[] objectArray = new Object[5];
                                                objectArray[0] = this.impervious_prepared.get();
                                                objectArray[1] = subGeom;
                                                objectArray[2] = epsg;
                                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                                this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                                objectArray[3] = callSite;
                                                objectArray[4] = type;
                                                IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"insert into ", " values(ST_GEOMFROMTEXT('", "',", "), ", ", '", "')"})));
                                            }
                                            int n = i;
                                            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                        }
                                        return null;
                                    }
                                }
                                return null;
                            }

                            @Generated
                            public Object getColumnNames() {
                                return this.columnNames.get();
                            }

                            @Generated
                            public Object getMappingTypeAndUse() {
                                return this.mappingTypeAndUse.get();
                            }

                            @Generated
                            public Object getStmt() {
                                return this.stmt.get();
                            }

                            @Generated
                            public Object getImpervious_prepared() {
                                return this.impervious_prepared.get();
                            }

                            @Generated
                            public Integer getRowcount() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure22.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.filtered_area.get(), this.filtered_area.get()}, new String[]{"SELECT \n                                g1.*\n                                 FROM ", " g1\n                                 LEFT JOIN ", " g2 ON \n                                    g1.EXPLOD_ID = g2.EXPLOD_ID AND g1.AREA_IMP  > g2.AREA_IMP \n                                 WHERE g2.EXPLOD_ID  IS NULL\n                                 ORDER BY g1.EXPLOD_ID  ASC"})), new _closure22((Object)this, this.getThisObject(), this.columnNames, this.mappingTypeAndUse, stmt2, this.impervious_prepared, this.rowcount));
                    }

                    @Generated
                    public JdbcDataSource getDatasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                    }

                    @Generated
                    public Object getFiltered_area() {
                        return this.filtered_area.get();
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getMappingTypeAndUse() {
                        return this.mappingTypeAndUse.get();
                    }

                    @Generated
                    public Object getImpervious_prepared() {
                        return this.impervious_prepared.get();
                    }

                    @Generated
                    public Integer getRowcount() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _formatImperviousLayer_closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatImperviousLayer_closure7((Object)this, (Object)this, datasource2, filtered_area, columnNames, mappingTypeAndUse, impervious_prepared, rowcount));
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName, impervious_prepared.get()}, new String[]{"DROP TABLE IF EXISTS ", ";\n                    CREATE TABLE ", " as SELECT EXPLOD_ID AS id_impervious, THE_GEOM, TYPE\n                    FROM ST_EXPLODE('(\n                    SELECT ST_UNION(ST_ACCUM(the_geom)) as the_geom, TYPE from ", " group by type\n                    )');"})));
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{polygonizedTable, filtered_area.get(), polygonizedExploded, impervious_prepared.get()}, new String[]{"DROP TABLE IF EXISTS  ", ", ", ", ", ", ", ""})));
                return IndyInterface.bootstrap("cast", "()", 0, outputTableName);
            }
        }
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName}, new String[]{"Drop table if exists ", ";\n                    CREATE TABLE ", " (THE_GEOM GEOMETRY, id_impervious serial, type varchar);"})));
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Impervious transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getTypeAndUse(Object row, Object columnNames, Object myMap) {
        void var1_1;
        Reference row2 = new Reference(row);
        Reference columnNames2 = new Reference((Object)var1_1);
        Reference strType = new Reference(null);
        Reference strUse = new Reference(null);
        public final class _getTypeAndUse_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference columnNames;
            private /* synthetic */ Reference row;
            private /* synthetic */ Reference strType;
            private /* synthetic */ Reference strUse;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTypeAndUse_closure8(Object _outerInstance, Object _thisObject, Reference columnNames, Reference row, Reference strType, Reference strUse) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.columnNames = reference4 = columnNames;
                this.row = reference3 = row;
                this.strType = reference2 = strType;
                this.strUse = reference = strUse;
            }

            public Object doCall(Object finalVal) {
                CallSite type_use = IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "key", 0, finalVal), ":");
                Reference type = new Reference(null);
                type.get();
                Reference use = new Reference(null);
                use.get();
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, type_use), (Object)2)) {
                    type.set((Object)IndyInterface.bootstrap("invoke", "getAt", 0, type_use, false));
                    use.set((Object)IndyInterface.bootstrap("invoke", "getAt", 0, type_use, true));
                } else {
                    type.set((Object)IndyInterface.bootstrap("getProperty", "key", 0, finalVal));
                    use.set(type.get());
                }
                public final class _closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference row;
                    private /* synthetic */ Reference strType;
                    private /* synthetic */ Reference type;
                    private /* synthetic */ Reference strUse;
                    private /* synthetic */ Reference use;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure23(Object _outerInstance, Object _thisObject, Reference columnNames, Reference row, Reference strType, Reference type, Reference strUse, Reference use) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        this.columnNames = reference6 = columnNames;
                        this.row = reference5 = row;
                        this.strType = reference4 = strType;
                        this.type = reference3 = type;
                        this.strUse = reference2 = strUse;
                        this.use = reference = use;
                    }

                    public Object doCall(Object osmVals) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.columnNames.get(), IndyInterface.bootstrap("getProperty", "key", 0, osmVals))) != false) {
                            Reference columnValue = new Reference((Object)IndyInterface.bootstrap("invoke", "getString", 0, this.row.get(), IndyInterface.bootstrap("getProperty", "key", 0, osmVals)));
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)columnValue.get(), null)) {
                                public final class _closure24
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference columnValue;
                                    private /* synthetic */ Reference strType;
                                    private /* synthetic */ Reference type;
                                    private /* synthetic */ Reference strUse;
                                    private /* synthetic */ Reference use;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure24(Object _outerInstance, Object _thisObject, Reference columnValue, Reference strType, Reference type, Reference strUse, Reference use) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        Reference reference3;
                                        Reference reference4;
                                        Reference reference5;
                                        this.columnValue = reference5 = columnValue;
                                        this.strType = reference4 = strType;
                                        this.type = reference3 = type;
                                        this.strUse = reference2 = strUse;
                                        this.use = reference = use;
                                    }

                                    public Object doCall(Object osmVal) {
                                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, osmVal, "!")) != false) {
                                            osmVal = IndyInterface.bootstrap("invoke", "replace", 0, osmVal, "! ", "");
                                            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.columnValue.get(), (Object)osmVal) && ScriptBytecodeAdapter.compareNotEqual((Object)this.columnValue.get(), null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.strType.get()), null)) {
                                                Object object = this.type.get();
                                                this.strType.set((Object)IndyInterface.bootstrap("cast", "()", 0, object));
                                                Object object2 = this.use.get();
                                                this.strUse.set((Object)IndyInterface.bootstrap("cast", "()", 0, object2));
                                                return object2;
                                            }
                                        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.columnValue.get(), (Object)osmVal) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.strType.get()), null)) {
                                            Object object = this.type.get();
                                            this.strType.set((Object)IndyInterface.bootstrap("cast", "()", 0, object));
                                            Object object3 = this.use.get();
                                            this.strUse.set((Object)IndyInterface.bootstrap("cast", "()", 0, object3));
                                            return object3;
                                        }
                                        return null;
                                    }

                                    @Generated
                                    public Object getColumnValue() {
                                        return this.columnValue.get();
                                    }

                                    @Generated
                                    public String getStrType() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.strType.get());
                                    }

                                    @Generated
                                    public Object getType() {
                                        return this.type.get();
                                    }

                                    @Generated
                                    public String getStrUse() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.strUse.get());
                                    }

                                    @Generated
                                    public Object getUse() {
                                        return this.use.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure24.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "value", 0, osmVals), new _closure24((Object)this, this.getThisObject(), columnValue, this.strType, this.type, this.strUse, this.use));
                            }
                        }
                        return null;
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getRow() {
                        return this.row.get();
                    }

                    @Generated
                    public String getStrType() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.strType.get());
                    }

                    @Generated
                    public Object getType() {
                        return this.type.get();
                    }

                    @Generated
                    public String getStrUse() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.strUse.get());
                    }

                    @Generated
                    public Object getUse() {
                        return this.use.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "value", 0, finalVal), new _closure23((Object)this, this.getThisObject(), this.columnNames, this.row, this.strType, type, this.strUse, use));
            }

            @Generated
            public Object getColumnNames() {
                return this.columnNames.get();
            }

            @Generated
            public Object getRow() {
                return this.row.get();
            }

            @Generated
            public String getStrType() {
                return IndyInterface.bootstrap("cast", "()", 0, this.strType.get());
            }

            @Generated
            public String getStrUse() {
                return IndyInterface.bootstrap("cast", "()", 0, this.strUse.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTypeAndUse_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, myMap, new _getTypeAndUse_closure8(InputDataFormatting.class, InputDataFormatting.class, columnNames2, row2, strType, strUse));
        if (ScriptBytecodeAdapter.compareEqual((Object)((String)strUse.get()), null)) {
            strUse.set((Object)((String)strType.get()));
        }
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)strType.get(), (String)strUse.get()}));
    }

    public static float getHeightWall(Object height, Object r_height) {
        float result = 0.0f;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)r_height, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFloat", 0, r_height))) {
            if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "toFloat", 0, r_height), (Object)height)) {
                result = DefaultTypeTransformation.floatUnbox((Object)IndyInterface.bootstrap("invoke", "minus", 0, height, IndyInterface.bootstrap("invoke", "toFloat", 0, r_height)));
            }
        } else {
            result = DefaultTypeTransformation.floatUnbox((Object)height);
        }
        return result;
    }

    public static float getHeightRoof(Object height, Object heightPattern) {
        if (IndyInterface.bootstrap("cast", "()", 0, height) == false) {
            return 0.0f;
        }
        CallSite matcher = IndyInterface.bootstrap("invoke", "matcher", 0, heightPattern, height);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, matcher)) == false) {
            return 0.0f;
        }
        Object new_h = 0;
        CallSite match1_group1 = IndyInterface.bootstrap("invoke", "group", 0, matcher, true);
        CallSite match1_group2 = IndyInterface.bootstrap("invoke", "group", 0, matcher, 2);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, matcher)) != false) {
            CallSite match2_group1 = IndyInterface.bootstrap("invoke", "group", 0, matcher, true);
            CallSite match2_group2 = IndyInterface.bootstrap("invoke", "group", 0, matcher, 2);
            if (IndyInterface.bootstrap("cast", "()", 0, match1_group1) != false) {
                new_h = IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "parseFloat", 0, Float.class, match1_group1), 12);
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)match2_group2, (Object)"''")) {
                new_h = IndyInterface.bootstrap("invoke", "plus", 0, new_h, IndyInterface.bootstrap("invoke", "parseFloat", 0, Float.class, match2_group1));
            }
            return DefaultTypeTransformation.floatUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, new_h, $const$0));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)match1_group1) && ScriptBytecodeAdapter.compareEqual((Object)match1_group2, null)) {
            return DefaultTypeTransformation.floatUnbox((Object)IndyInterface.bootstrap("invoke", "parseFloat", 0, Float.class, match1_group1));
        }
        CallSite type = IndyInterface.bootstrap("invoke", "toLowerCase", 0, match1_group2);
        CallSite callSite = type;
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"m")) {
            return DefaultTypeTransformation.floatUnbox((Object)IndyInterface.bootstrap("invoke", "parseFloat", 0, Float.class, match1_group1));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"foot")) {
            return DefaultTypeTransformation.floatUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "parseFloat", 0, Float.class, match1_group1), $const$1));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"'")) {
            return DefaultTypeTransformation.floatUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "parseFloat", 0, Float.class, match1_group1), 12), $const$0));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"''")) {
            return DefaultTypeTransformation.floatUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "parseFloat", 0, Float.class, match1_group1), $const$0));
        }
        return 0.0f;
    }

    public static int getNbLevels(Object b_lev, Object r_lev) {
        int result = 0;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)b_lev, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFloat", 0, b_lev))) {
            result = ScriptBytecodeAdapter.compareNotEqual((Object)r_lev, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFloat", 0, r_lev)) ? DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "toFloat", 0, b_lev), IndyInterface.bootstrap("invoke", "toFloat", 0, r_lev))) : DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "toFloat", 0, b_lev));
        }
        return result;
    }

    public static Float getWidth(String width) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareNotEqual((Object)width, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isFloat", 0, width)) ? IndyInterface.bootstrap("invoke", "toFloat", 0, width) : Integer.valueOf(0));
    }

    public static int getZIndex(String zindex) {
        return DefaultTypeTransformation.intUnbox((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)zindex, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isInteger", 0, zindex)) ? IndyInterface.bootstrap("invoke", "toInteger", 0, zindex) : Integer.valueOf(0)));
    }

    /*
     * WARNING - void declaration
     */
    public static String getTypeValue(Object row, Object columnNames, Object myMap) {
        void var1_1;
        Reference row2 = new Reference(row);
        Reference columnNames2 = new Reference((Object)var1_1);
        Reference strType = new Reference(null);
        public final class _getTypeValue_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference columnNames;
            private /* synthetic */ Reference row;
            private /* synthetic */ Reference strType;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTypeValue_closure9(Object _outerInstance, Object _thisObject, Reference columnNames, Reference row, Reference strType) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.columnNames = reference3 = columnNames;
                this.row = reference2 = row;
                this.strType = reference = strType;
            }

            public Object doCall(Object finalVal) {
                Reference finalKey = new Reference((Object)IndyInterface.bootstrap("getProperty", "key", 0, finalVal));
                public final class _closure25
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference row;
                    private /* synthetic */ Reference strType;
                    private /* synthetic */ Reference finalKey;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure25(Object _outerInstance, Object _thisObject, Reference columnNames, Reference row, Reference strType, Reference finalKey) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.columnNames = reference4 = columnNames;
                        this.row = reference3 = row;
                        this.strType = reference2 = strType;
                        this.finalKey = reference = finalKey;
                    }

                    public Object doCall(Object osmVals) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.columnNames.get(), IndyInterface.bootstrap("getProperty", "key", 0, osmVals))) != false) {
                            Reference columnValue = new Reference((Object)IndyInterface.bootstrap("invoke", "getString", 0, this.row.get(), IndyInterface.bootstrap("getProperty", "key", 0, osmVals)));
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)columnValue.get(), null)) {
                                public final class _closure26
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference columnValue;
                                    private /* synthetic */ Reference strType;
                                    private /* synthetic */ Reference finalKey;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure26(Object _outerInstance, Object _thisObject, Reference columnValue, Reference strType, Reference finalKey) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        Reference reference3;
                                        this.columnValue = reference3 = columnValue;
                                        this.strType = reference2 = strType;
                                        this.finalKey = reference = finalKey;
                                    }

                                    public Object doCall(Object osmVal) {
                                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, osmVal, "!")) != false) {
                                            osmVal = IndyInterface.bootstrap("invoke", "replace", 0, osmVal, "! ", "");
                                            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.columnValue.get(), (Object)osmVal) && ScriptBytecodeAdapter.compareNotEqual((Object)this.columnValue.get(), null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.strType.get()), null)) {
                                                Object object = this.finalKey.get();
                                                this.strType.set((Object)IndyInterface.bootstrap("cast", "()", 0, object));
                                                return object;
                                            }
                                        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.columnValue.get(), (Object)osmVal) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.strType.get()), null)) {
                                            Object object = this.finalKey.get();
                                            this.strType.set((Object)IndyInterface.bootstrap("cast", "()", 0, object));
                                            return object;
                                        }
                                        return null;
                                    }

                                    @Generated
                                    public Object getColumnValue() {
                                        return this.columnValue.get();
                                    }

                                    @Generated
                                    public String getStrType() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.strType.get());
                                    }

                                    @Generated
                                    public Object getFinalKey() {
                                        return this.finalKey.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure26.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "value", 0, osmVals), new _closure26((Object)this, this.getThisObject(), columnValue, this.strType, this.finalKey));
                            }
                        }
                        return null;
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getRow() {
                        return this.row.get();
                    }

                    @Generated
                    public String getStrType() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.strType.get());
                    }

                    @Generated
                    public Object getFinalKey() {
                        return this.finalKey.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure25.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "value", 0, finalVal), new _closure25((Object)this, this.getThisObject(), this.columnNames, this.row, this.strType, finalKey));
            }

            @Generated
            public Object getColumnNames() {
                return this.columnNames.get();
            }

            @Generated
            public Object getRow() {
                return this.row.get();
            }

            @Generated
            public String getStrType() {
                return IndyInterface.bootstrap("cast", "()", 0, this.strType.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTypeValue_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, myMap, new _getTypeValue_closure9(InputDataFormatting.class, InputDataFormatting.class, columnNames2, row2, strType));
        return (String)strType.get();
    }

    public static String singleQuote(String value) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, value) != false ? IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "'", value), "'") : value);
    }

    public static String getSidewalk(String sidewalk) {
        String result = null;
        String string = sidewalk;
        result = ScriptBytecodeAdapter.isCase((Object)string, (Object)"both") ? "two" : (ScriptBytecodeAdapter.isCase((Object)string, (Object)"right") || ScriptBytecodeAdapter.isCase((Object)string, (Object)"left") || ScriptBytecodeAdapter.isCase((Object)string, (Object)"yes") ? "one" : "no");
        return result;
    }

    public static String columnsMapper(Object inputColumns, Object columnsToMap) {
        Reference inputColumns2 = new Reference(inputColumns);
        public final class _columnsMapper_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _columnsMapper_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object result, Object iter) {
                result = IndyInterface.bootstrap("invoke", "plus", 0, result, new GStringImpl(new Object[]{iter}, new String[]{"a.\"", "\""}));
                return result;
            }

            @Generated
            public Object call(Object result, Object iter) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, result, iter);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _columnsMapper_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference flatList = new Reference((Object)IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "inject", 0, inputColumns2.get(), ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _columnsMapper_closure10(InputDataFormatting.class, InputDataFormatting.class)), ","));
        public final class _columnsMapper_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference inputColumns;
            private /* synthetic */ Reference flatList;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _columnsMapper_closure11(Object _outerInstance, Object _thisObject, Reference inputColumns, Reference flatList) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.inputColumns = reference2 = inputColumns;
                this.flatList = reference = flatList;
            }

            public Object doCall(Object it) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, ScriptBytecodeAdapter.invokeMethod0SpreadSafe(_columnsMapper_closure11.class, (Object)this.inputColumns.get(), (String)"toLowerCase"), it)) == false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, this.flatList.get(), new GStringImpl(new Object[]{it}, new String[]{", null as \"", "\""}));
                    this.flatList.set((Object)callSite);
                    return callSite;
                }
                return null;
            }

            @Generated
            public Object getInputColumns() {
                return this.inputColumns.get();
            }

            @Generated
            public Object getFlatList() {
                return this.flatList.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _columnsMapper_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, columnsToMap, new _columnsMapper_closure11(InputDataFormatting.class, InputDataFormatting.class, inputColumns2, flatList));
        return IndyInterface.bootstrap("cast", "()", 0, flatList.get());
    }

    public static Map parametersMapping(Object file, Object altResourceStream) {
        Object paramStream = null;
        CallSite jsonSlurper = IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class);
        if (IndyInterface.bootstrap("cast", "()", 0, file) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isFile", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, file))) != false) {
                paramStream = IndyInterface.bootstrap("init", "<init>", 0, FileInputStream.class, file);
            } else {
                IndyInterface.bootstrap("invoke", "warn", 0, InputDataFormatting.class, new GStringImpl(new Object[]{file}, new String[]{"No file named ", " found. Taking default instead"}));
                paramStream = altResourceStream;
            }
        } else {
            paramStream = altResourceStream;
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, jsonSlurper, paramStream));
    }

    public String formatUrbanAreas(JdbcDataSource datasource, String urban_areas, String zone, String jsonFilename) {
        Reference datasource2 = new Reference((Object)datasource);
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Urban areas transformation starts");
        Reference outputTableName = new Reference((Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"INPUT_URBAN_AREAS_", ""}));
        IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName.get(), outputTableName.get()}, new String[]{"Drop table if exists ", ";\n                    CREATE TABLE ", " (THE_GEOM GEOMETRY, id_urban serial, ID_SOURCE VARCHAR, TYPE VARCHAR);"})));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)urban_areas, null)) {
            CallSite paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "urbanAreasParams.json");
            CallSite parametersMap = IndyInterface.bootstrap("invoke", "parametersMapping", 0, InputDataFormatting.class, jsonFilename, paramsDefaultFile);
            Reference mappingType = new Reference((Object)IndyInterface.bootstrap("getProperty", "type", 0, parametersMap));
            Reference queryMapper = new Reference((Object)"SELECT ");
            CallSite columnToMap = IndyInterface.bootstrap("getProperty", "columns", 0, parametersMap);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, (JdbcDataSource)datasource2.get(), urban_areas), (Object)0)) {
                Reference columnNames = new Reference((Object)IndyInterface.bootstrap("invoke", "getColumnNames", 0, (JdbcDataSource)datasource2.get(), urban_areas));
                IndyInterface.bootstrap("invoke", "remove", 0, columnNames.get(), "THE_GEOM");
                queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "columnsMapper", 0, InputDataFormatting.class, columnNames.get(), columnToMap)));
                if (IndyInterface.bootstrap("cast", "()", 0, zone) != false) {
                    IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, (JdbcDataSource)datasource2.get(), urban_areas);
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ", st_intersection(a.the_geom, b.the_geom) as the_geom ", "FROM "), new GStringImpl(new Object[]{urban_areas, zone}, new String[]{"", " AS a, ", " AS b "})), "WHERE "), "a.the_geom && b.the_geom ")));
                } else {
                    queryMapper.set((Object)IndyInterface.bootstrap("invoke", "plus", 0, queryMapper.get(), new GStringImpl(new Object[]{urban_areas}, new String[]{",  a.the_geom as the_geom FROM ", "  as a"})));
                }
                Reference constructions = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"industrial", "commercial", "residential"}));
                Reference rowcount = new Reference((Object)1);
                public final class _formatUrbanAreas_closure12
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference datasource;
                    private /* synthetic */ Reference queryMapper;
                    private /* synthetic */ Reference columnNames;
                    private /* synthetic */ Reference mappingType;
                    private /* synthetic */ Reference constructions;
                    private /* synthetic */ Reference outputTableName;
                    private /* synthetic */ Reference rowcount;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _formatUrbanAreas_closure12(Object _outerInstance, Object _thisObject, Reference datasource, Reference queryMapper, Reference columnNames, Reference mappingType, Reference constructions, Reference outputTableName, Reference rowcount) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        Reference reference6;
                        Reference reference7;
                        this.datasource = reference7 = datasource;
                        this.queryMapper = reference6 = queryMapper;
                        this.columnNames = reference5 = columnNames;
                        this.mappingType = reference4 = mappingType;
                        this.constructions = reference3 = constructions;
                        this.outputTableName = reference2 = outputTableName;
                        this.rowcount = reference = rowcount;
                    }

                    public Object doCall(Object stmt) {
                        Reference stmt2 = new Reference(stmt);
                        public final class _closure27
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference columnNames;
                            private /* synthetic */ Reference mappingType;
                            private /* synthetic */ Reference constructions;
                            private /* synthetic */ Reference stmt;
                            private /* synthetic */ Reference outputTableName;
                            private /* synthetic */ Reference rowcount;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure27(Object _outerInstance, Object _thisObject, Reference columnNames, Reference mappingType, Reference constructions, Reference stmt, Reference outputTableName, Reference rowcount) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                this.columnNames = reference6 = columnNames;
                                this.mappingType = reference5 = mappingType;
                                this.constructions = reference4 = constructions;
                                this.stmt = reference3 = stmt;
                                this.outputTableName = reference2 = outputTableName;
                                this.rowcount = reference = rowcount;
                            }

                            public Object doCall(Object row) {
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "building", 0, row)) == false) {
                                    CallSite typeAndUseValues = IndyInterface.bootstrap("invoke", "getTypeAndUse", 2, this, row, this.columnNames.get(), this.mappingType.get());
                                    CallSite type = IndyInterface.bootstrap("invoke", "getAt", 0, typeAndUseValues, false);
                                    if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"construction")) {
                                        CallSite construction = IndyInterface.bootstrap("getProperty", "construction", 0, row);
                                        if (DefaultTypeTransformation.booleanUnbox((Object)construction) && ScriptBytecodeAdapter.isCase((Object)construction, (Object)this.constructions.get())) {
                                            type = construction;
                                        }
                                    }
                                    if (IndyInterface.bootstrap("cast", "()", 0, type) != false) {
                                        CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "the_geom", 0, row));
                                        int epsg = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "getSRID", 0, geom));
                                        int i = 0;
                                        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "getNumGeometries", 0, geom))) {
                                            CallSite subGeom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGeometryN", 0, geom, i));
                                            if (subGeom instanceof Polygon && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getArea", 0, subGeom), (Object)1)) {
                                                Object object = this.stmt.get();
                                                Object[] objectArray = new Object[6];
                                                objectArray[0] = this.outputTableName.get();
                                                objectArray[1] = subGeom;
                                                objectArray[2] = epsg;
                                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                                                this.rowcount.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                                                objectArray[3] = callSite;
                                                objectArray[4] = IndyInterface.bootstrap("getProperty", "id", 0, row);
                                                objectArray[5] = IndyInterface.bootstrap("invoke", "singleQuote", 2, this, type);
                                                IndyInterface.bootstrap("invoke", "addBatch", 0, object, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(objectArray, new String[]{"insert into ", " values(ST_GEOMFROMTEXT('", "',", "), ", ", '", "', ", ")"})));
                                            }
                                            int n = i;
                                            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                                        }
                                        return null;
                                    }
                                }
                                return null;
                            }

                            @Generated
                            public Object getColumnNames() {
                                return this.columnNames.get();
                            }

                            @Generated
                            public Object getMappingType() {
                                return this.mappingType.get();
                            }

                            @Generated
                            public Object getConstructions() {
                                return this.constructions.get();
                            }

                            @Generated
                            public Object getStmt() {
                                return this.stmt.get();
                            }

                            @Generated
                            public Object getOutputTableName() {
                                return this.outputTableName.get();
                            }

                            @Generated
                            public Integer getRowcount() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure27.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "eachRow", 0, IndyInterface.bootstrap("cast", "()", 0, this.datasource.get()), this.queryMapper.get(), new _closure27((Object)this, this.getThisObject(), this.columnNames, this.mappingType, this.constructions, stmt2, this.outputTableName, this.rowcount));
                    }

                    @Generated
                    public JdbcDataSource getDatasource() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.datasource.get());
                    }

                    @Generated
                    public Object getQueryMapper() {
                        return this.queryMapper.get();
                    }

                    @Generated
                    public Object getColumnNames() {
                        return this.columnNames.get();
                    }

                    @Generated
                    public Object getMappingType() {
                        return this.mappingType.get();
                    }

                    @Generated
                    public Object getConstructions() {
                        return this.constructions.get();
                    }

                    @Generated
                    public Object getOutputTableName() {
                        return this.outputTableName.get();
                    }

                    @Generated
                    public Integer getRowcount() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rowcount.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _formatUrbanAreas_closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "withBatch", 0, (JdbcDataSource)datasource2.get(), 100, new _formatUrbanAreas_closure12((Object)this, (Object)this, datasource2, queryMapper, columnNames, mappingType, constructions, outputTableName, rowcount));
                CallSite mergingUrbanAreas = IndyInterface.bootstrap("invoke", "postfix", 2, this, "merging_urban_areas");
                IndyInterface.bootstrap("invoke", "execute", 0, (JdbcDataSource)datasource2.get(), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{mergingUrbanAreas, outputTableName.get(), outputTableName.get(), mergingUrbanAreas, outputTableName.get()}, new String[]{"\n            CREATE TABLE ", " as select CAST((row_number() over()) as Integer) as id_urban,the_geom, type from \n            ST_EXPLODE('(SELECT ST_UNION(ST_ACCUM(the_geom)) as the_geom, type from ", " group by type)');\n            DROP TABLE IF EXISTS ", ";\n            ALTER TABLE  ", " RENAME to ", ";\n            "})));
            }
        }
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Urban areas transformation finishes");
        return IndyInterface.bootstrap("cast", "()", 0, outputTableName.get());
    }

    public String formatSeaLandMask(JdbcDataSource datasource, String coastline, String zone, String water) {
        CallSite outputTableName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "postfix", 2, this, "INPUT_SEA_LAND_MASK_"));
        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, outputTableName}, new String[]{"Drop table if exists ", ";\n                    CREATE TABLE ", " (THE_GEOM GEOMETRY, id serial, type varchar);"})));
        if (IndyInterface.bootstrap("cast", "()", 0, zone) == false) {
            IndyInterface.bootstrap("invoke", "debug", 2, this, "A zone table must be provided to compute the sea/land mask");
        } else if (IndyInterface.bootstrap("cast", "()", 0, coastline) != false) {
            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "hasTable", 0, datasource, coastline)) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, datasource, coastline), (Object)0)) {
                IndyInterface.bootstrap("invoke", "debug", 2, this, "Computing sea/land mask table");
                IndyInterface.bootstrap("invoke", "call", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName}, new String[]{" DROP TABLE if exists ", ";"})));
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, datasource, coastline, "the_geom");
                GStringImpl mergingDataTable = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"coatline_merged", ""});
                GStringImpl coastLinesIntersects = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"coatline_intersect_zone", ""});
                GStringImpl islands_mark = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"islands_mark_zone", ""});
                GStringImpl coastLinesIntersectsPoints = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"coatline_intersect_points_zone", ""});
                GStringImpl coastLinesPoints = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"coatline_points_zone", ""});
                GStringImpl sea_land_mask = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"sea_land_mask", ""});
                GStringImpl water_to_be_filtered = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"water_to_be_filtered", ""});
                GStringImpl water_filtered_exploded = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"water_filtered_exploded", ""});
                GStringImpl sea_land_triangles = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"sea_land_triangles", ""});
                GStringImpl sea_id_triangles = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"sea_id_triangles", ""});
                GStringImpl water_id_triangles = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"water_id_triangles", ""});
                IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, datasource, coastline, "the_geom");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{coastLinesIntersects, islands_mark, mergingDataTable, coastLinesIntersectsPoints, coastLinesPoints, sea_land_mask, water_filtered_exploded, water_to_be_filtered, sea_land_triangles, sea_id_triangles, water_id_triangles, coastLinesIntersects, coastline, zone}, new String[]{"DROP TABLE IF EXISTS ", ", \n                        ", ", ", ",  ", ", ", ",", ",\n                        ", ",", ", ", ", ", ", ", ";\n                        CREATE TABLE ", " AS SELECT ST_intersection(a.the_geom, b.the_geom) as the_geom\n                        from ", "  AS  a,  ", "  AS b WHERE\n                        a.the_geom && b.the_geom AND st_intersects(a.the_geom, b.the_geom) and \"natural\"= 'coastline';\n                        "})));
                if (IndyInterface.bootstrap("cast", "()", 0, water) != false) {
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "getRowCount", 0, datasource, coastLinesIntersects), (Object)0)) {
                        IndyInterface.bootstrap("invoke", "createSpatialIndex", 0, datasource, water, "the_geom");
                        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{islands_mark, coastLinesIntersects}, new String[]{"\n                        CREATE TABLE ", " (the_geom GEOMETRY, ID SERIAL) AS \n                       SELECT the_geom, EXPLOD_ID  FROM st_explode('(  \n                       SELECT ST_LINEMERGE(st_accum(THE_GEOM)) AS the_geom, NULL FROM ", ")');"})));
                        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{mergingDataTable, coastLinesIntersects, zone, water, sea_land_mask, mergingDataTable}, new String[]{"  \n                        CREATE TABLE ", "  AS\n                        SELECT  THE_GEOM FROM ", " \n                        UNION ALL\n                        SELECT st_tomultiline(st_buffer(the_geom, -0.01))\n                        from ", " \n                        UNION ALL\n                        SELECT st_tomultiline(the_geom)\n                        from ", " ;\n                        CREATE TABLE ", " (THE_GEOM GEOMETRY,ID serial, TYPE VARCHAR, ZINDEX INTEGER) AS SELECT THE_GEOM, EXPLOD_ID, 'land', 0 AS ZINDEX FROM\n                        st_explode('(SELECT st_polygonize(st_union(ST_NODE(st_accum(the_geom)))) AS the_geom FROM ", ")')\n                        as foo where ST_DIMENSION(the_geom) = 2 AND st_area(the_geom) >0;  "})));
                        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{sea_land_mask, sea_land_mask, islands_mark, islands_mark, coastLinesPoints, islands_mark, zone, coastLinesIntersectsPoints, coastLinesPoints, coastLinesIntersectsPoints, coastLinesIntersectsPoints}, new String[]{"\n                        CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);\n                       \n                        CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);\n\n                        CREATE TABLE ", " as  SELECT ST_LocateAlong(the_geom, 0.5, -0.01) AS the_geom FROM \n                        st_explode('(select ST_GeometryN(ST_ToMultiSegments(st_intersection(a.the_geom, b.the_geom)), 1) as the_geom from ", " as a,\n                        ", " as b WHERE a.the_geom && b.the_geom AND st_intersects(a.the_geom, b.the_geom))');\n    \n                        CREATE TABLE ", " as  SELECT the_geom FROM st_explode('", "'); \n\n                        CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);"})));
                        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{sea_land_triangles, sea_land_triangles, sea_land_mask, sea_land_triangles, sea_land_triangles, sea_id_triangles, sea_id_triangles, sea_land_triangles, coastLinesIntersectsPoints, sea_id_triangles}, new String[]{"\n                         DROP TABLE IF EXISTS ", ";\n                       CREATE TABLE ", " AS \n                       SELECT * FROM \n                        st_explode('(SELECT CASE WHEN ST_AREA(THE_GEOM) > 100000 THEN ST_Tessellate(the_geom) ELSE THE_GEOM END AS THE_GEOM,\n                      ID, TYPE, ZINDEX FROM ", ")');\n\n                    CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);\n\n                    DROP TABLE IF EXISTS ", ";\n                    CREATE TABLE ", " AS SELECT DISTINCT a.id FROM ", " a, \n                    ", " b WHERE a.THE_GEOM && b.THE_GEOM AND\n                                st_intersects(a.THE_GEOM, b.THE_GEOM);  \n                    CREATE INDEX ON  ", " (id);"})));
                        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{sea_land_triangles, sea_id_triangles}, new String[]{"                                     \n                    UPDATE ", " SET TYPE='sea' WHERE ID IN(SELECT ID FROM ", ");   \n                    "})));
                        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{water_id_triangles, water_id_triangles, sea_land_triangles, water, water_id_triangles, sea_land_triangles, water_id_triangles}, new String[]{"\n                    DROP TABLE IF EXISTS ", ";\n                    CREATE TABLE ", " AS SELECT a.ID\n                                FROM ", " a, ", " b WHERE a.THE_GEOM && b.THE_GEOM AND\n                                st_intersects( a.THE_GEOM, st_pointonsurface(b.the_geom)) and b.type='water';\n                               \n                    CREATE INDEX ON  ", " (id);\n                         \n                    --Update water triangles            \n                    UPDATE ", " SET TYPE='water' WHERE ID IN(SELECT ID FROM ", ");                         \n                         "})));
                        IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, sea_land_triangles}, new String[]{"\n                    create table ", " as select id , \n                    st_union(st_accum(the_geom)) the_geom, type from ", " a group by id, type;\n                    "})));
                    } else {
                        CallSite waterTypes = IndyInterface.bootstrap("invoke", "firstRow", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{water}, new String[]{"SELECT COUNT(*) as count, type from ", " group by type"})));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsValue", 0, waterTypes, "water")) == false) {
                            IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{water, water, zone}, new String[]{"\n                            DROP TABLE IF EXISTS ", ";\n                            CREATE TABLE ", " as select CAST(1 AS INTEGER) AS ID_WATER, NULL AS ID_SOURCE , CAST(0 AS INTEGER) AS ZINDEX, the_geom, 'sea' as type from ", "  ;                     \n                            "})));
                            return outputTableName;
                        }
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{islands_mark, coastLinesIntersects}, new String[]{"\n                        CREATE TABLE ", " (the_geom GEOMETRY, ID SERIAL) AS \n                       SELECT the_geom, EXPLOD_ID  FROM st_explode('(  \n                       SELECT ST_LINEMERGE(st_accum(THE_GEOM)) AS the_geom, NULL FROM ", ")');"})));
                    IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{mergingDataTable, coastLinesIntersects, zone, sea_land_mask, mergingDataTable, sea_land_mask, sea_land_mask, islands_mark, islands_mark, coastLinesPoints, islands_mark, zone, coastLinesIntersectsPoints, coastLinesPoints, coastLinesIntersectsPoints, coastLinesIntersectsPoints}, new String[]{"  \n                        CREATE TABLE ", "  AS\n                        SELECT  THE_GEOM FROM ", " \n                        UNION ALL\n                        SELECT st_tomultiline(st_buffer(the_geom, -0.01))\n                        from ", " ;\n\n                        CREATE TABLE ", " (THE_GEOM GEOMETRY,ID serial, TYPE VARCHAR, ZINDEX INTEGER) AS SELECT THE_GEOM, EXPLOD_ID, 'land', 0 AS ZINDEX FROM\n                        st_explode('(SELECT st_polygonize(st_union(ST_NODE(st_accum(the_geom)))) AS the_geom FROM ", ")') as foo where ST_DIMENSION(the_geom) = 2 AND st_area(the_geom) >0;                \n                        \n                        CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);\n\n                        CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);\n\n                        CREATE TABLE ", " as  SELECT ST_LocateAlong(the_geom, 0.5, -0.01) AS the_geom FROM \n                        st_explode('(select ST_GeometryN(ST_ToMultiSegments(st_intersection(a.the_geom, b.the_geom)), 1) as the_geom from ", " as a,\n                        ", " as b WHERE a.the_geom && b.the_geom AND st_intersects(a.the_geom, b.the_geom))');\n    \n                        CREATE TABLE ", " as  SELECT the_geom FROM st_explode('", "'); \n\n                        CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);\n                         "})));
                    IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{sea_land_triangles, sea_land_triangles, sea_land_mask, sea_land_triangles, sea_land_triangles, sea_id_triangles, sea_id_triangles, sea_land_triangles, coastLinesIntersectsPoints, sea_id_triangles, sea_land_triangles, sea_id_triangles}, new String[]{"\n                         DROP TABLE IF EXISTS ", ";\n                       CREATE TABLE ", " AS \n                       SELECT * FROM \n                        st_explode('(SELECT CASE WHEN ST_AREA(THE_GEOM) > 100000 THEN ST_Tessellate(the_geom) ELSE THE_GEOM END AS THE_GEOM,\n                      ID, TYPE, ZINDEX FROM ", ")');\n\n                    CREATE SPATIAL INDEX IF NOT EXISTS ", "_the_geom_idx ON ", " (THE_GEOM);\n\n                    DROP TABLE IF EXISTS ", ";\n                    CREATE TABLE ", " AS SELECT DISTINCT a.id FROM ", " a, \n                    ", " b WHERE a.THE_GEOM && b.THE_GEOM AND\n                                st_contains(a.THE_GEOM, b.THE_GEOM);  \n                    CREATE INDEX ON  ", " (id);\n                    \n                    --Update sea triangles                    \n                    UPDATE ", " SET TYPE='sea' WHERE ID IN(SELECT ID FROM ", ");   \n                     "})));
                    IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableName, sea_land_triangles}, new String[]{"\n                    create table ", " as select id, \n                    st_union(st_accum(the_geom)) the_geom, type from ", " a group by id, type;\n                    "})));
                }
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{coastLinesIntersects, islands_mark, mergingDataTable, coastLinesIntersectsPoints, coastLinesPoints, sea_land_mask, water_filtered_exploded, water_to_be_filtered, sea_land_triangles, sea_id_triangles, water_id_triangles}, new String[]{"DROP TABLE IF EXISTS ", ",\n                        ", ", ", ",  ", ", ", ",", ",\n                        ", ",", ", ", ", ", ", ", "\n                        "})));
                IndyInterface.bootstrap("invoke", "debug", 2, this, "The sea/land mask has been computed");
                return outputTableName;
            }
            if (IndyInterface.bootstrap("cast", "()", 0, water) != false) {
                CallSite waterTypes = IndyInterface.bootstrap("invoke", "firstRow", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{water}, new String[]{"SELECT COUNT(*) as count, type from ", " group by type"})));
                if (DefaultTypeTransformation.booleanUnbox((Object)waterTypes) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsValue", 0, waterTypes, "water")) == false) {
                    IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{water, water, zone}, new String[]{"\n                            DROP TABLE IF EXISTS ", ";\n                            CREATE TABLE ", " as select CAST(1 AS INTEGER) AS ID_WATER, NULL AS ID_SOURCE , CAST(0 AS INTEGER) AS ZINDEX, the_geom, 'sea' as type from ", "  ;                        \n                            "})));
                    return outputTableName;
                }
            }
        }
        return outputTableName;
    }

    public static int getSpeedInKmh(Object speedPattern, String maxspeedValue) {
        if (IndyInterface.bootstrap("cast", "()", 0, maxspeedValue) == false) {
            return -1;
        }
        CallSite matcher = IndyInterface.bootstrap("invoke", "matcher", 0, speedPattern, maxspeedValue);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, matcher)) == false) {
            return -1;
        }
        CallSite speed = IndyInterface.bootstrap("invoke", "parseInt", 0, Integer.class, IndyInterface.bootstrap("invoke", "group", 0, matcher, true));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "group", 0, matcher, 3)) == false) {
            return DefaultTypeTransformation.intUnbox((Object)speed);
        }
        CallSite type = IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "group", 0, matcher, 3));
        CallSite callSite = type;
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"kmh")) {
            return DefaultTypeTransformation.intUnbox((Object)speed);
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"mph")) {
            return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "round", 0, Math.class, IndyInterface.bootstrap("invoke", "multiply", 0, speed, $const$2)));
        }
        return -1;
    }

    @Generated
    public Map formatBuildingLayer(JdbcDataSource datasource, String building, String zone, String urban_areas, int h_lev_min) {
        Reference datasource2 = new Reference((Object)datasource);
        Reference h_lev_min2 = new Reference((Object)h_lev_min);
        return this.formatBuildingLayer((JdbcDataSource)datasource2.get(), building, zone, urban_areas, DefaultTypeTransformation.intUnbox((Object)h_lev_min2.get()), "");
    }

    @Generated
    public Map formatBuildingLayer(JdbcDataSource datasource, String building, String zone, String urban_areas) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatBuildingLayer((JdbcDataSource)datasource2.get(), building, zone, urban_areas, 3, "");
    }

    @Generated
    public Map formatBuildingLayer(JdbcDataSource datasource, String building, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatBuildingLayer((JdbcDataSource)datasource2.get(), building, zone, "", 3, "");
    }

    @Generated
    public Map formatBuildingLayer(JdbcDataSource datasource, String building) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatBuildingLayer((JdbcDataSource)datasource2.get(), building, "", "", 3, "");
    }

    @Generated
    public String formatRoadLayer(JdbcDataSource datasource, String road, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatRoadLayer((JdbcDataSource)datasource2.get(), road, zone, "");
    }

    @Generated
    public String formatRoadLayer(JdbcDataSource datasource, String road) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatRoadLayer((JdbcDataSource)datasource2.get(), road, "", "");
    }

    @Generated
    public String formatRailsLayer(JdbcDataSource datasource, String rail, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatRailsLayer((JdbcDataSource)datasource2.get(), rail, zone, "");
    }

    @Generated
    public String formatRailsLayer(JdbcDataSource datasource, String rail) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatRailsLayer((JdbcDataSource)datasource2.get(), rail, "", "");
    }

    @Generated
    public String formatVegetationLayer(JdbcDataSource datasource, String vegetation, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatVegetationLayer((JdbcDataSource)datasource2.get(), vegetation, zone, "");
    }

    @Generated
    public String formatVegetationLayer(JdbcDataSource datasource, String vegetation) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatVegetationLayer((JdbcDataSource)datasource2.get(), vegetation, "", "");
    }

    @Generated
    public String formatWaterLayer(JdbcDataSource datasource, String water) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatWaterLayer((JdbcDataSource)datasource2.get(), water, "");
    }

    @Generated
    public String formatImperviousLayer(JdbcDataSource datasource, String impervious, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatImperviousLayer((JdbcDataSource)datasource2.get(), impervious, zone, "");
    }

    @Generated
    public String formatImperviousLayer(JdbcDataSource datasource, String impervious) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatImperviousLayer((JdbcDataSource)datasource2.get(), impervious, "", "");
    }

    @Generated
    public String formatUrbanAreas(JdbcDataSource datasource, String urban_areas, String zone) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatUrbanAreas((JdbcDataSource)datasource2.get(), urban_areas, zone, "");
    }

    @Generated
    public String formatUrbanAreas(JdbcDataSource datasource, String urban_areas) {
        Reference datasource2 = new Reference((Object)datasource);
        return this.formatUrbanAreas((JdbcDataSource)datasource2.get(), urban_areas, "", "");
    }

    @Generated
    public String formatSeaLandMask(JdbcDataSource datasource, String coastline, String zone) {
        return this.formatSeaLandMask(datasource, coastline, zone, "");
    }

    @Generated
    public String formatSeaLandMask(JdbcDataSource datasource, String coastline) {
        return this.formatSeaLandMask(datasource, coastline, "", "");
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != InputDataFormatting.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        $const$0 = bigDecimal3 = new BigDecimal("0.0254");
        $const$1 = bigDecimal2 = new BigDecimal("0.3048");
        $const$2 = bigDecimal = new BigDecimal("1.609");
    }

    static {
        org.orbisgis.geoclimate.osm.InputDataFormatting.__$swapInit();
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

