/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.geoclimate.osm;

import groovy.json.JsonSlurper;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.GeographyUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.orbisgis.data.jdbc.JdbcDataSource;
import org.orbisgis.geoclimate.osm.OSM;
import org.orbisgis.geoclimate.osmtools.OSMTools;
import org.orbisgis.geoclimate.osmtools.utils.OSMElement;
import org.orbisgis.geoclimate.osmtools.utils.Utilities;

public class InputDataLoading
extends OSM {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public static void main(String ... args) {
        IndyInterface.bootstrap("invoke", "runScript", 0, InvokerHelper.class, InputDataLoading.class, args);
    }

    public Object run() {
        InputDataLoading OSM2 = this;
        return OSM2;
    }

    public Map extractAndCreateGISLayers(JdbcDataSource datasource, Object zoneToExtract, float distance, boolean downloadAllOSMData) {
        if (ScriptBytecodeAdapter.compareEqual((Object)datasource, null)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The datasource cannot be null");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, zoneToExtract) != false) {
            GStringImpl outputZoneTable = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"ZONE_", ""});
            GStringImpl outputZoneEnvelopeTable = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"ZONE_ENVELOPE_", ""});
            String GEOMETRY_TYPE = "GEOMETRY";
            CallSite geom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getArea", 0, Utilities.class, zoneToExtract));
            if (IndyInterface.bootstrap("cast", "()", 0, geom) == false) {
                IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{zoneToExtract}, new String[]{"Cannot find an area from the place name ", ""}));
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            if (geom instanceof Polygon) {
                GEOMETRY_TYPE = "POLYGON";
            } else if (geom instanceof MultiPolygon) {
                GEOMETRY_TYPE = "MULTIPOLYGON";
            } else {
                IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getGeometryType", 0, geom)}, new String[]{"Invalid geometry to extract the OSM data ", ""}));
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            CallSite envelope = IndyInterface.bootstrap("invoke", "expandEnvelopeByMeters", 0, GeographyUtilities.class, IndyInterface.bootstrap("invoke", "getEnvelopeInternal", 0, geom), distance);
            CallSite con = IndyInterface.bootstrap("invoke", "getConnection", 0, datasource);
            CallSite interiorPoint = IndyInterface.bootstrap("invoke", "centre", 0, envelope);
            CallSite epsg = IndyInterface.bootstrap("invoke", "getSRID", 0, GeographyUtilities.class, con, ScriptBytecodeAdapter.createPojoWrapper((Object)Float.valueOf(((Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "y", 0, interiorPoint), Float.class))).floatValue()), Float.TYPE), ScriptBytecodeAdapter.createPojoWrapper((Object)Float.valueOf(((Float)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "x", 0, interiorPoint), Float.class))).floatValue()), Float.TYPE));
            CallSite geomUTM = IndyInterface.bootstrap("invoke", "ST_Transform", 0, ST_Transform.class, con, geom, epsg);
            CallSite tmpGeomEnv = IndyInterface.bootstrap("invoke", "toGeometry", 0, IndyInterface.bootstrap("invoke", "getFactory", 0, geom), envelope);
            IndyInterface.bootstrap("invoke", "setSRID", 0, tmpGeomEnv, 4326);
            IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputZoneTable, outputZoneTable, GEOMETRY_TYPE, epsg, outputZoneTable, IndyInterface.bootstrap("invoke", "toString", 0, geomUTM), epsg, IndyInterface.bootstrap("invoke", "toString", 0, zoneToExtract)}, new String[]{"drop table if exists ", "; \n        create table ", " (the_geom GEOMETRY(", ", ", "), ID_ZONE VARCHAR);\n        INSERT INTO ", " VALUES (ST_GEOMFROMTEXT('", "', ", "), '", "');"})));
            IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputZoneEnvelopeTable, outputZoneEnvelopeTable, epsg, outputZoneEnvelopeTable, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "ST_Transform", 0, ST_Transform.class, con, tmpGeomEnv, epsg)), epsg, IndyInterface.bootstrap("invoke", "toString", 0, zoneToExtract)}, new String[]{"drop table if exists ", "; \n         create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_ZONE VARCHAR);\n        INSERT INTO ", " VALUES (ST_GEOMFROMTEXT('", "',", "), '", "');\n        "})));
            CallSite query = IndyInterface.bootstrap("invoke", "plus", 0, "[maxsize:1073741824]", IndyInterface.bootstrap("invoke", "buildOSMQuery", 0, IndyInterface.bootstrap("getProperty", "Utilities", 0, OSMTools.class), envelope, null, IndyInterface.bootstrap("getProperty", "NODE", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "WAY", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "RELATION", 0, OSMElement.class)));
            if (downloadAllOSMData) {
                List keysValues = ScriptBytecodeAdapter.createList((Object[])new Object[]{"building", "railway", "amenity", "leisure", "highway", "natural", "landuse", "landcover", "vegetation", "waterway", "area", "aeroway", "area:aeroway", "tourism", "sport"});
                query = IndyInterface.bootstrap("invoke", "plus", 0, "[maxsize:1073741824]", IndyInterface.bootstrap("invoke", "buildOSMQueryWithAllData", 0, IndyInterface.bootstrap("getProperty", "Utilities", 0, OSMTools.class), envelope, keysValues, IndyInterface.bootstrap("getProperty", "NODE", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "WAY", 0, OSMElement.class), IndyInterface.bootstrap("getProperty", "RELATION", 0, OSMElement.class)));
            }
            CallSite extract = IndyInterface.bootstrap("invoke", "extract", 0, IndyInterface.bootstrap("getProperty", "Loader", 0, OSMTools.class), query);
            if (IndyInterface.bootstrap("cast", "()", 0, extract) != false) {
                CallSite results = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createGISLayers", 2, this, datasource, extract, epsg));
                if (IndyInterface.bootstrap("cast", "()", 0, results) != false) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"building", IndyInterface.bootstrap("getProperty", "building", 0, results), "road", IndyInterface.bootstrap("getProperty", "road", 0, results), "rail", IndyInterface.bootstrap("getProperty", "rail", 0, results), "vegetation", IndyInterface.bootstrap("getProperty", "vegetation", 0, results), "water", IndyInterface.bootstrap("getProperty", "water", 0, results), "impervious", IndyInterface.bootstrap("getProperty", "impervious", 0, results), "urban_areas", IndyInterface.bootstrap("getProperty", "urban_areas", 0, results), "zone", outputZoneTable, "zone_envelope", outputZoneEnvelopeTable, "coastline", IndyInterface.bootstrap("getProperty", "coastline", 0, results)});
                }
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{extract}, new String[]{"Cannot load the OSM file ", ""})));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{query}, new String[]{"Cannot execute the overpass query ", ""})));
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, "The zone to extract cannot be null or empty");
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public Map createGISLayers(JdbcDataSource datasource, String osmFilePath, int epsg) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createGISLayers", 2, this, datasource, osmFilePath, null, epsg));
    }

    public Map createGISLayers(JdbcDataSource datasource, String osmFilePath, Geometry geometry, int epsg) {
        if (epsg <= -1) {
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{epsg}, new String[]{"Invalid epsg code ", ""}));
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        GStringImpl prefix = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)), "-", "_")}, new String[]{"OSM_DATA_", ""});
        IndyInterface.bootstrap("invoke", "debug", 2, this, "Loading");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "load", 0, IndyInterface.bootstrap("getProperty", "Loader", 0, OSMTools.class), datasource, prefix, osmFilePath)) != false) {
            CallSite outputBuildingTableName = null;
            CallSite outputRoadTableName = null;
            CallSite outputRailTableName = null;
            CallSite outputVegetationTableName = null;
            CallSite outputHydroTableName = null;
            CallSite outputImperviousTableName = null;
            CallSite outputUrbanAreasTableName = null;
            CallSite outputCoastlineTableName = null;
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the building layer");
            CallSite paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "buildingParams.json");
            CallSite parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            CallSite tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            CallSite columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite building = IndyInterface.bootstrap("invoke", "toPolygons", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry, true);
            if (IndyInterface.bootstrap("cast", "()", 0, building) != false) {
                outputBuildingTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_BUILDING");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{building, outputBuildingTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Building layer created");
            }
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the road layer");
            paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "roadParams.json");
            parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite road = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractWaysAsLines", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry));
            if (IndyInterface.bootstrap("cast", "()", 0, road) != false) {
                outputRoadTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_ROAD");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{road, outputRoadTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Road layer created");
            }
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the rail layer");
            paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "railParams.json");
            parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite rail = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractWaysAsLines", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry));
            if (IndyInterface.bootstrap("cast", "()", 0, rail) != false) {
                outputRailTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_RAIL");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{rail, outputRailTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Rail layer created");
            }
            paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "vegetParams.json");
            parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite vegetation = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toPolygons", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry, true));
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the vegetation layer");
            if (IndyInterface.bootstrap("cast", "()", 0, vegetation) != false) {
                outputVegetationTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_VEGETATION");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{vegetation, outputVegetationTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Vegetation layer created");
            }
            paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "waterParams.json");
            parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite water = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toPolygons", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry, true));
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the water layer");
            if (IndyInterface.bootstrap("cast", "()", 0, water) != false) {
                outputHydroTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_WATER");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{water, outputHydroTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Water layer created");
            }
            paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "imperviousParams.json");
            parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite impervious = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toPolygons", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry, true));
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the impervious layer");
            if (IndyInterface.bootstrap("cast", "()", 0, impervious) != false) {
                outputImperviousTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_IMPERVIOUS");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{impervious, outputImperviousTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Impervious layer created");
            }
            paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "urbanAreasParams.json");
            parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite urban_areas = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toPolygons", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry, true));
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the urban areas layer");
            if (IndyInterface.bootstrap("cast", "()", 0, urban_areas) != false) {
                outputUrbanAreasTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_URBAN_AREAS");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{urban_areas, outputUrbanAreasTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Urban areas layer created");
            }
            IndyInterface.bootstrap("invoke", "debug", 2, this, "Create the coastline layer");
            paramsDefaultFile = IndyInterface.bootstrap("invoke", "getResourceAsStream", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), "coastlineParams.json");
            parametersMap = IndyInterface.bootstrap("invoke", "readJSONParameters", 0, InputDataLoading.class, paramsDefaultFile);
            tags = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "tags");
            columnsToKeep = IndyInterface.bootstrap("invoke", "get", 0, parametersMap, "columns");
            CallSite coastlines = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toLines", 0, IndyInterface.bootstrap("getProperty", "Transform", 0, OSMTools.class), datasource, prefix, epsg, tags, columnsToKeep, geometry));
            if (IndyInterface.bootstrap("cast", "()", 0, coastlines) != false) {
                outputCoastlineTableName = IndyInterface.bootstrap("invoke", "postfix", 2, this, "OSM_COASTLINE");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{coastlines, outputCoastlineTableName}, new String[]{"ALTER TABLE ", " RENAME TO ", ""})));
                IndyInterface.bootstrap("invoke", "info", 2, this, "Coastline layer created");
            }
            IndyInterface.bootstrap("invoke", "dropOSMTables", 0, IndyInterface.bootstrap("getProperty", "Utilities", 0, OSMTools.class), prefix, datasource);
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"building", outputBuildingTableName, "road", outputRoadTableName, "rail", outputRailTableName, "vegetation", outputVegetationTableName, "water", outputHydroTableName, "impervious", outputImperviousTableName, "urban_areas", outputUrbanAreasTableName, "coastline", outputCoastlineTableName});
        }
        return null;
    }

    public static Object readJSONParameters(Object jsonFile) {
        if (IndyInterface.bootstrap("cast", "()", 0, jsonFile) != false) {
            return IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), jsonFile);
        }
        return null;
    }

    @Generated
    public Map extractAndCreateGISLayers(JdbcDataSource datasource, Object zoneToExtract, float distance) {
        return this.extractAndCreateGISLayers(datasource, zoneToExtract, distance, true);
    }

    @Generated
    public Map extractAndCreateGISLayers(JdbcDataSource datasource, Object zoneToExtract) {
        return this.extractAndCreateGISLayers(datasource, zoneToExtract, 0.0f, true);
    }

    @Generated
    public Map createGISLayers(JdbcDataSource datasource, String osmFilePath) {
        return this.createGISLayers(datasource, osmFilePath, -1);
    }

    @Generated
    public Map createGISLayers(JdbcDataSource datasource, String osmFilePath, Geometry geometry) {
        return this.createGISLayers(datasource, osmFilePath, geometry, -1);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != InputDataLoading.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

