/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.geoclimate.worldpoptools;

import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.xml.XmlSlurper;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.cts.util.UTMUtils;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.functions.io.asc.AscReaderDriver;
import org.h2gis.utilities.FileUtilities;
import org.orbisgis.data.jdbc.JdbcDataSource;
import org.orbisgis.geoclimate.worldpoptools.WorldPopTools;

public class WorldPopExtract
extends WorldPopTools {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public static void main(String ... args) {
        IndyInterface.bootstrap("invoke", "runScript", 0, InvokerHelper.class, WorldPopExtract.class, args);
    }

    public Object run() {
        WorldPopExtract pf = this;
        return pf;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String extractWorldPopLayer(String coverageId, List bbox) {
        IndyInterface.bootstrap("invoke", "info", 2, this, "Extract the world population grid");
        CallSite gridRequest = IndyInterface.bootstrap("invoke", "createGridRequest", 2, this, coverageId, bbox);
        CallSite queryHash = IndyInterface.bootstrap("invoke", "digest", 0, gridRequest, "SHA-256");
        CallSite outputGridFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "java.io.tmpdir"), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), new GStringImpl(new Object[]{queryHash}, new String[]{"", ".asc"})));
        CallSite popGridFilePath = IndyInterface.bootstrap("getProperty", "absolutePath", 0, outputGridFile);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, outputGridFile)) != false) {
            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "length", 0, outputGridFile), (Object)0)) {
                IndyInterface.bootstrap("invoke", "debug", 2, this, new GStringImpl(new Object[]{popGridFilePath, gridRequest}, new String[]{"\nThe cached grid file ", " will be re-used for the query :  \n", "."}));
                return IndyInterface.bootstrap("cast", "()", 0, popGridFilePath);
            }
            IndyInterface.bootstrap("invoke", "delete", 0, outputGridFile);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createNewFile", 0, outputGridFile)) == false) return IndyInterface.bootstrap("cast", "()", 0, popGridFilePath);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "grid", 2, this, gridRequest, outputGridFile)) != false) {
                IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{popGridFilePath}, new String[]{"The grid file has been downloaded at ", "."}));
                return IndyInterface.bootstrap("cast", "()", 0, popGridFilePath);
            }
            IndyInterface.bootstrap("invoke", "delete", 0, outputGridFile);
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{gridRequest}, new String[]{"Cannot extract the grid data for the query ", ""}));
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createNewFile", 0, outputGridFile)) == false) return IndyInterface.bootstrap("cast", "()", 0, popGridFilePath);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "grid", 2, this, gridRequest, outputGridFile)) != false) {
            IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{popGridFilePath}, new String[]{"The WorldPop file has been downloaded at ", "."}));
            return IndyInterface.bootstrap("cast", "()", 0, popGridFilePath);
        }
        IndyInterface.bootstrap("invoke", "delete", 0, outputGridFile);
        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{gridRequest}, new String[]{"Cannot extract the WorldPop file for the query ", ""}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public String importAscGrid(JdbcDataSource datasource, String worldPopFilePath, int epsg, String tableName) {
        IndyInterface.bootstrap("invoke", "info", 2, this, "Import the the world pop asc file");
        CallSite outputTableWorldPopName = IndyInterface.bootstrap("invoke", "postfix", 2, this, tableName);
        if (IndyInterface.bootstrap("cast", "()", 0, worldPopFilePath) == false) {
            IndyInterface.bootstrap("invoke", "info", 2, this, "Create a default empty worldpop table");
            IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, epsg}, new String[]{"drop table if exists ", ";\n                    create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_POP INTEGER, POP FLOAT);"})));
        }
        CallSite ascReaderDriver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AscReaderDriver.class));
        IndyInterface.bootstrap("invoke", "setAs3DPoint", 0, ascReaderDriver, false);
        IndyInterface.bootstrap("invoke", "setEncoding", 0, ascReaderDriver, "UTF-8");
        if (epsg != 4326) {
            CallSite importTable = IndyInterface.bootstrap("invoke", "postfix", 2, this, "imported_grid");
            try {
                IndyInterface.bootstrap("invoke", "read", 0, ascReaderDriver, IndyInterface.bootstrap("invoke", "getConnection", 0, datasource), IndyInterface.bootstrap("init", "<init>", 0, File.class, worldPopFilePath), IndyInterface.bootstrap("init", "<init>", 0, EmptyProgressVisitor.class), importTable, 4326);
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, epsg, importTable, importTable}, new String[]{"drop table if exists ", ";\n                    create table ", " as select ST_TRANSFORM(THE_GEOM, ", ") as the_geom,\n                PK AS ID_POP, Z as POP from ", ";\n                drop table if exists ", ""})));
            }
            catch (Exception ex) {
                IndyInterface.bootstrap("invoke", "info", 2, this, "Cannot find any worldpop data on the requested area");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, epsg}, new String[]{"drop table if exists ", ";\n                    create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_POP INTEGER, POP FLOAT);"})));
            }
        } else {
            try {
                IndyInterface.bootstrap("invoke", "read", 0, ascReaderDriver, IndyInterface.bootstrap("invoke", "getConnection", 0, datasource), IndyInterface.bootstrap("init", "<init>", 0, File.class, worldPopFilePath), IndyInterface.bootstrap("init", "<init>", 0, EmptyProgressVisitor.class), outputTableWorldPopName, 4326);
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName}, new String[]{"ALTER TABLE ", " RENAME COLUMN PK TO ID_POP;\n                                ALTER TABLE ", " RENAME COLUMN Z TO POP;"})));
            }
            catch (Exception ex) {
                IndyInterface.bootstrap("invoke", "info", 2, this, "Cannot find any worldpop data on the requested area");
                IndyInterface.bootstrap("invoke", "execute", 0, datasource, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{outputTableWorldPopName, outputTableWorldPopName, epsg}, new String[]{"drop table if exists ", ";\n                    create table ", " (the_geom GEOMETRY(POLYGON, ", "), ID_POP INTEGER, POP FLOAT);"})));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, outputTableWorldPopName);
    }

    public String createGridRequest(String coverageId, Object bbox) {
        if (IndyInterface.bootstrap("cast", "()", 0, coverageId) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The coverageId cannot be null or empty");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite subset = IndyInterface.bootstrap("invoke", "buildSubset", 0, WorldPopExtract.class, bbox);
        if (IndyInterface.bootstrap("cast", "()", 0, subset) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot create the subset WCS filter");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        String crsOutPut = "outputCRS=http://www.opengis.net/def/crs/EPSG/0/4326";
        CallSite WCS_SERVER = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{coverageId, subset, crsOutPut}, new String[]{"https://ogc.worldpop.org/geoserver/ows?service=WCS&version=2.0.1&request=GetCoverage&coverageId=", "&format=ArcGrid&", "&", ""}));
        return IndyInterface.bootstrap("cast", "()", 0, WCS_SERVER);
    }

    public boolean grid(String coverageId, Object bbox, File outputGridFile) {
        CallSite queryUrl = IndyInterface.bootstrap("invoke", "createGridRequest", 2, this, coverageId, bbox);
        if (IndyInterface.bootstrap("cast", "()", 0, queryUrl) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The request to the server cannot be null or empty");
            return false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, outputGridFile) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The output Grid File cannot be null or empty");
            return false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isExtensionWellFormated", 0, FileUtilities.class, outputGridFile, "asc")) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Only support asc (ArcGrid format) as output Grid File");
            return false;
        }
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "grid", 2, this, queryUrl, outputGridFile));
    }

    public boolean grid(String wcsRequest, File outputGridFile) {
        CallSite queryUrl = IndyInterface.bootstrap("init", "<init>", 0, URL.class, wcsRequest);
        if (IndyInterface.bootstrap("cast", "()", 0, wcsRequest) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "The request cannot be null or empty");
            return false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isExtensionWellFormated", 0, FileUtilities.class, outputGridFile, "asc")) == false) {
            IndyInterface.bootstrap("invoke", "error", 2, this, "Only support asc (ArcGrid format) as output Grid File");
            return false;
        }
        CallSite proxyHost = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "http.proxyHost"));
        int proxyPort = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "parseInt", 0, Integer.class, IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "http.proxyPort", "80")));
        HttpURLConnection connection = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)proxyHost, null)) {
            CallSite proxy = IndyInterface.bootstrap("init", "<init>", 0, Proxy.class, IndyInterface.bootstrap("getProperty", "HTTP", 0, Proxy.Type.class), IndyInterface.bootstrap("init", "<init>", 0, InetSocketAddress.class, proxyHost, proxyPort));
            connection = (HttpURLConnection)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "openConnection", 0, queryUrl, proxy), HttpURLConnection.class));
        } else {
            connection = (HttpURLConnection)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "openConnection", 0, queryUrl), HttpURLConnection.class));
        }
        IndyInterface.bootstrap("invoke", "info", 2, this, IndyInterface.bootstrap("invoke", "toString", 0, queryUrl));
        IndyInterface.bootstrap("invoke", "connect", 0, connection);
        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{queryUrl}, new String[]{"Executing query... ", ""}));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "responseCode", 0, connection), (Object)200)) {
            IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{outputGridFile}, new String[]{"Downloading the GridCoverage data from WorldPop server in ", ""}));
            IndyInterface.bootstrap("invoke", "leftShift", 0, outputGridFile, IndyInterface.bootstrap("getProperty", "inputStream", 0, connection));
            return true;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "responseCode", 0, connection), (Object)404)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{queryUrl}, new String[]{"The service is not available to execute the WCS query.", ""}));
            return false;
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{queryUrl}, new String[]{"Cannot execute the WCS query.", ""}));
        return false;
    }

    public boolean isCoverageAvailable(String coverageId) {
        CallSite describeRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{coverageId}, new String[]{"https://ogc.worldpop.org/geoserver/ows?service=WCS&version=2.0.1&request=DescribeCoverage&coverageId=", ""})));
        CallSite queryUrl = IndyInterface.bootstrap("init", "<init>", 0, URL.class, describeRequest);
        CallSite proxyHost = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "http.proxyHost"));
        int proxyPort = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "parseInt", 0, Integer.class, IndyInterface.bootstrap("invoke", "getProperty", 0, System.class, "http.proxyPort", "80")));
        HttpURLConnection connection = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)proxyHost, null)) {
            CallSite proxy = IndyInterface.bootstrap("init", "<init>", 0, Proxy.class, IndyInterface.bootstrap("getProperty", "HTTP", 0, Proxy.Type.class), IndyInterface.bootstrap("init", "<init>", 0, InetSocketAddress.class, proxyHost, proxyPort));
            connection = (HttpURLConnection)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "openConnection", 0, queryUrl, proxy), HttpURLConnection.class));
        } else {
            connection = (HttpURLConnection)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "openConnection", 0, queryUrl), HttpURLConnection.class));
        }
        IndyInterface.bootstrap("invoke", "info", 2, this, IndyInterface.bootstrap("invoke", "toString", 0, queryUrl));
        IndyInterface.bootstrap("invoke", "connect", 0, connection);
        IndyInterface.bootstrap("invoke", "info", 2, this, new GStringImpl(new Object[]{queryUrl}, new String[]{"Executing query... ", ""}));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "responseCode", 0, connection), (Object)200)) {
            CallSite xmlParser = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlSlurper.class));
            CallSite nodes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, xmlParser, IndyInterface.bootstrap("getProperty", "inputStream", 0, connection)));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "Exception", 4, nodes)) != false) {
                return true;
            }
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{coverageId}, new String[]{"The service is not available for the coverageId : ", ""}));
            return false;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "responseCode", 0, connection), (Object)404)) {
            IndyInterface.bootstrap("invoke", "error", 2, this, new GStringImpl(new Object[]{coverageId}, new String[]{"The service is not available for the coverageId : ", ""}));
            return false;
        }
        IndyInterface.bootstrap("invoke", "error", 2, this, "Cannot request the WorldPop service");
        return false;
    }

    public static String buildSubset(Object bbox) {
        if (IndyInterface.bootstrap("cast", "()", 0, bbox) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, WorldPopExtract.class, "The latitude and longitude values cannot be null or empty");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (!(bbox instanceof Collection)) {
            IndyInterface.bootstrap("invoke", "error", 0, WorldPopExtract.class, "The latitude and longitude values must be set as an array");
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, bbox), (Object)4) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isValidLatitude", 0, UTMUtils.class, IndyInterface.bootstrap("invoke", "getAt", 0, bbox, false))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isValidLatitude", 0, UTMUtils.class, IndyInterface.bootstrap("invoke", "getAt", 0, bbox, 2))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isValidLongitude", 0, UTMUtils.class, IndyInterface.bootstrap("invoke", "getAt", 0, bbox, true))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isValidLongitude", 0, UTMUtils.class, IndyInterface.bootstrap("invoke", "getAt", 0, bbox, 3)))) {
            return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, bbox, false), IndyInterface.bootstrap("invoke", "getAt", 0, bbox, 2), IndyInterface.bootstrap("invoke", "getAt", 0, bbox, true), IndyInterface.bootstrap("invoke", "getAt", 0, bbox, 3)}, new String[]{"subset=Lat(", ",", ")&subset=Long(", ",", ")"}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "error", 0, WorldPopExtract.class, "The bbox must be defined with 4 values"));
    }

    @Generated
    public String importAscGrid(JdbcDataSource datasource, String worldPopFilePath, int epsg) {
        return this.importAscGrid(datasource, worldPopFilePath, epsg, "world_pop");
    }

    @Generated
    public String importAscGrid(JdbcDataSource datasource, String worldPopFilePath) {
        return this.importAscGrid(datasource, worldPopFilePath, 4326, "world_pop");
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != WorldPopExtract.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

