/*
 * Decompiled with CFR 0.152.
 */
package org.jdelaunay.delaunay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jdelaunay.delaunay.error.DelaunayError;
import org.jdelaunay.delaunay.geometries.DEdge;
import org.jdelaunay.delaunay.geometries.DPoint;
import org.jdelaunay.delaunay.geometries.DTriangle;

final class BoundaryPart {
    private LinkedList<DEdge> boundaryEdges;
    private DEdge constraint;
    private List<DEdge> badEdges;
    private List<DEdge> addedEdges;
    private DEdge splitMem;

    private void init() {
        this.badEdges = new LinkedList<DEdge>();
        this.addedEdges = new ArrayList<DEdge>();
    }

    private BoundaryPart() {
    }

    BoundaryPart(List<DEdge> bound, DEdge cstr) {
        this.init();
        this.boundaryEdges = bound instanceof LinkedList ? (LinkedList<Object>)bound : new LinkedList<DEdge>(bound);
        this.constraint = cstr;
    }

    BoundaryPart(List<DEdge> bound) {
        this.init();
        this.boundaryEdges = bound instanceof LinkedList ? (LinkedList<Object>)bound : new LinkedList<DEdge>(bound);
        this.constraint = null;
    }

    BoundaryPart(DEdge cstr) {
        this.init();
        this.setConstraint(cstr);
        this.boundaryEdges = new LinkedList();
    }

    List<DEdge> getBoundaryEdges() {
        return this.boundaryEdges;
    }

    void setBoundaryEdges(List<DEdge> bound) {
        this.boundaryEdges = bound == null ? new LinkedList() : (bound instanceof LinkedList ? (LinkedList<Object>)bound : new LinkedList<DEdge>(bound));
    }

    DEdge getConstraint() {
        return this.constraint;
    }

    void setConstraint(DEdge constraint) {
        if (constraint != null && constraint.getPointLeft().equals(constraint.getEndPoint())) {
            constraint.swap();
        }
        this.constraint = constraint;
    }

    List<DEdge> getAddedEdges() {
        return this.addedEdges;
    }

    List<DEdge> getBadEdges() {
        return this.badEdges;
    }

    boolean pointIsLower(DPoint point) {
        return this.constraint.isRight(point);
    }

    boolean pointIsUpper(DPoint point) {
        return this.constraint.isLeft(point);
    }

    boolean isConstraintRightPoint(DPoint point) {
        return this.constraint.getPointRight().equals(point);
    }

    boolean canBeNext(BoundaryPart bpo) {
        DEdge last = this.boundaryEdges.get(this.boundaryEdges.size() - 1);
        DPoint left = bpo.getConstraint().getPointLeft();
        DPoint right = bpo.getConstraint().getPointRight();
        return (left.equals(last.getStartPoint()) || left.equals(last.getEndPoint())) && last.isRight(right) && !this.constraint.getPointLeft().equals(left);
    }

    BoundaryPart split(DEdge cstr) throws DelaunayError {
        if (this.boundaryEdges.isEmpty() || cstr == null) {
            throw new DelaunayError(107);
        }
        DPoint split = cstr.getPointLeft();
        BoundaryPart ret = new BoundaryPart(cstr);
        if (split.equals(this.boundaryEdges.get(0).getStartPoint())) {
            ret.setBoundaryEdges(this.boundaryEdges);
            this.setBoundaryEdges(new LinkedList<DEdge>());
            return ret;
        }
        LinkedList<DEdge> futureBoundary = new LinkedList<DEdge>();
        LinkedList<DEdge> otherBoundary = this.boundaryEdges;
        LinkedList<DEdge> degen = new LinkedList<DEdge>();
        ListIterator iter = otherBoundary.listIterator();
        boolean success = false;
        while (iter.hasNext()) {
            DEdge course = (DEdge)iter.next();
            if (course.isDegenerated()) {
                degen.add(course);
            }
            futureBoundary.add(course);
            iter.remove();
            if (!course.getEndPoint().equals(split)) continue;
            if (course.isDegenerated()) {
                Collections.reverse(degen);
                for (DEdge edge : degen) {
                    edge.setDegenerated(false);
                    edge.setShared(true);
                }
                degen.addAll(otherBoundary);
                otherBoundary = degen;
                this.splitMem = cstr;
            }
            success = true;
            break;
        }
        if (!success) {
            throw new DelaunayError(107);
        }
        this.setBoundaryEdges(futureBoundary);
        return new BoundaryPart(otherBoundary, cstr);
    }

    List<DTriangle> connectPoint(DPoint point, DEdge nextCstr) throws DelaunayError {
        if (this.boundaryEdges == null || this.boundaryEdges.isEmpty() && this.constraint == null) {
            throw new DelaunayError(106);
        }
        this.badEdges = new ArrayList<DEdge>();
        this.addedEdges = new ArrayList<DEdge>();
        boolean revertDir = !this.boundaryEdges.isEmpty() && this.constraint != null ? this.boundaryEdges.get(0).getEndPoint().equals(this.constraint.getStartPoint()) : false;
        boolean removeDegen = !this.boundaryEdges.isEmpty() && this.splitMem != null ? this.boundaryEdges.get(this.boundaryEdges.size() - 1).getEndPoint().equals(this.splitMem.getStartPoint()) : false;
        revertDir = removeDegen || revertDir;
        ListIterator<DEdge> iter = this.boundaryEdges.listIterator();
        DEdge mem = null;
        DEdge memBis = null;
        boolean endShared = false;
        boolean rightDeg = false;
        if (this.boundaryEdges.isEmpty()) {
            return this.buildFirstDegen(point, nextCstr);
        }
        ArrayList<DTriangle> triList = new ArrayList<DTriangle>();
        DTriangle temp = null;
        while (iter.hasNext()) {
            DEdge current = (DEdge)iter.next();
            if (current.isDegenerated()) {
                iter.previous();
                mem = this.connectToDegenerated(iter, point, triList, mem, revertDir, nextCstr);
                boolean bl = rightDeg = mem == null;
                if (mem == null || !mem.isDegenerated()) continue;
                return new ArrayList<DTriangle>();
            }
            if (current.isShared()) {
                boolean bl = endShared = (mem = this.connectToShared(iter, current, point, triList, mem, nextCstr)) == null ? false : mem.equals(memBis);
                if (endShared) break;
                memBis = mem;
                continue;
            }
            if (current.isRight(point)) {
                this.badEdges.add(current);
                if (mem == null) {
                    mem = new DEdge(current.getStartPoint(), point);
                    if ((mem = this.replaceByCstr(mem, nextCstr)).isShared()) {
                        mem.setShared(false);
                    }
                    if (mem.isDegenerated()) {
                        mem.setDegenerated(false);
                    }
                    this.addedEdges.add(mem);
                    iter.previous();
                    iter.add(mem);
                    iter.next();
                }
                memBis = new DEdge(point, current.getEndPoint());
                memBis = this.replaceByCstr(memBis, nextCstr);
                this.addedEdges.add(memBis);
                temp = new DTriangle(current, mem, memBis);
                triList.add(temp);
                mem = memBis;
                iter.remove();
                continue;
            }
            if (mem == null) continue;
            iter.previous();
            iter.add(mem);
            return triList;
        }
        if (mem == null && triList.isEmpty()) {
            this.connectDegenOrphan(point, iter, nextCstr);
        } else if (!rightDeg && !endShared) {
            iter.add(mem);
        }
        return triList;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectDegenOrphan(DPoint point, ListIterator<DEdge> iter, DEdge nextCstr) {
        void var5_8;
        DEdge mem = null;
        ListIterator<DEdge> listIterator = iter;
        if (this.constraint == null) {
            if (this.boundaryEdges.get(this.boundaryEdges.size() - 1).getPointRight().equals(point)) return;
            mem = new DEdge(this.boundaryEdges.get(this.boundaryEdges.size() - 1).getPointRight(), point);
        } else {
            if (this.constraint.getLeft() != null && this.constraint.getPointRight().equals(point)) {
                this.boundaryEdges.add(0, this.constraint);
                return;
            }
            if (!this.boundaryEdges.isEmpty()) {
                if (this.boundaryEdges.get(0).isShared()) {
                    if (this.boundaryEdges.get(0).getStartPoint().equals(this.constraint.getStartPoint())) {
                        mem = new DEdge(this.boundaryEdges.get(this.boundaryEdges.size() - 1).getPointRight(), point);
                    } else {
                        mem = new DEdge(this.constraint.getStartPoint(), point);
                        ListIterator listIterator2 = this.boundaryEdges.listIterator();
                    }
                } else if (this.boundaryEdges.get(0).getStartPoint().equals(this.boundaryEdges.get(0).getPointLeft())) {
                    mem = new DEdge(this.boundaryEdges.get(this.boundaryEdges.size() - 1).getPointRight(), point);
                } else {
                    mem = new DEdge(this.constraint.getStartPoint(), point);
                    ListIterator listIterator3 = this.boundaryEdges.listIterator();
                }
            } else {
                mem = new DEdge(this.constraint.getStartPoint(), point);
            }
        }
        mem = this.replaceByCstr(mem, nextCstr);
        mem.setDegenerated(true);
        this.addedEdges.add(mem);
        var5_8.add(mem);
    }

    private DEdge connectToShared(ListIterator<DEdge> iter, DEdge share, DPoint point, List<DTriangle> tri, DEdge prev, DEdge nextCstr) throws DelaunayError {
        DEdge e;
        DEdge ret = null;
        DEdge prevAdd = prev;
        boolean reverse = false;
        boolean prevUsed = false;
        boolean connectedToPrev = false;
        connectedToPrev = prevAdd != null && (share.isExtremity(prevAdd.getStartPoint()) || share.isExtremity(prevAdd.getEndPoint()));
        boolean connectedToConstraint = false;
        if (this.constraint != null) {
            reverse = share.isLeft(this.constraint.getPointLeft());
            boolean bl = connectedToConstraint = share.isExtremity(this.constraint.getStartPoint()) || share.isExtremity(this.constraint.getEndPoint());
            if (!connectedToConstraint) {
                iter.previous();
                if (iter.hasPrevious()) {
                    DEdge temp = iter.previous();
                    if (temp.getEndPoint().equals(share.getStartPoint())) {
                        prevAdd = temp;
                        connectedToConstraint = true;
                        prevUsed = true;
                    }
                    iter.next();
                }
                iter.next();
            }
            if (!connectedToConstraint && !connectedToPrev) {
                return prevAdd;
            }
            reverse = connectedToPrev ? share.getEndPoint().equals(prevAdd.getStartPoint()) || share.getEndPoint().equals(prevAdd.getEndPoint()) : share.getEndPoint().equals(this.constraint.getStartPoint()) || share.getEndPoint().equals(this.constraint.getEndPoint());
        } else {
            if (prevAdd != null && !connectedToPrev) {
                return prevAdd;
            }
            if (prevAdd != null) {
                boolean bl = reverse = share.getEndPoint().equals(prevAdd.getStartPoint()) || share.getEndPoint().equals(prevAdd.getEndPoint());
            }
        }
        if (reverse && share.isLeft(point)) {
            ret = new DEdge(point, share.getStartPoint());
            ret = this.replaceByCstr(ret, nextCstr);
            if (connectedToPrev) {
                tri.add(new DTriangle(share, prevAdd, ret));
                iter.remove();
            } else {
                e = new DEdge(share.getEndPoint(), point);
                e = this.replaceByCstr(e, nextCstr);
                e.setDegenerated(false);
                tri.add(new DTriangle(share, e, ret));
                iter.remove();
                iter.add(e);
                this.addedEdges.add(e);
            }
            this.addedEdges.add(ret);
            share.setShared(false);
        } else if (!reverse && share.isRight(point)) {
            ret = new DEdge(point, share.getEndPoint());
            ret = this.replaceByCstr(ret, nextCstr);
            if (connectedToPrev) {
                tri.add(new DTriangle(share, prevAdd, ret));
                iter.remove();
            } else {
                e = new DEdge(share.getStartPoint(), point);
                e = this.replaceByCstr(e, nextCstr);
                tri.add(new DTriangle(share, e, ret));
                iter.remove();
                iter.add(e);
                this.addedEdges.add(e);
            }
            this.addedEdges.add(ret);
            share.setShared(false);
            share.swap();
        } else if (prevAdd != null && !prevUsed) {
            iter.previous();
            iter.add(prevAdd);
            iter.next();
        }
        return ret == null && !prevUsed ? prevAdd : ret;
    }

    private DEdge connectToDegenerated(ListIterator<DEdge> iter, DPoint point, List<DTriangle> tri, DEdge prevAdded, boolean revertDir, DEdge nextCstr) throws DelaunayError {
        DEdge current = iter.next();
        DEdge ret = null;
        DEdge mem = null;
        DEdge memBis = null;
        LinkedList<DEdge> llMem = new LinkedList<DEdge>();
        if (current.isColinear(point)) {
            while (current.isColinear(point) && iter.hasNext() && current.isDegenerated() && !current.isShared()) {
                current = iter.next();
            }
            if (!current.isColinear(point) || !current.isDegenerated()) {
                current = iter.previous();
                current = iter.previous();
                ret = new DEdge(current.getEndPoint(), point);
                ret = this.replaceByCstr(ret, nextCstr);
                ret.setDegenerated(true);
                this.addedEdges.add(ret);
                iter.next();
                iter.add(ret);
                return ret;
            }
            if (!current.getEndPoint().equals(point)) {
                ret = new DEdge(current.getEndPoint(), point);
                ret = this.replaceByCstr(ret, nextCstr);
                ret.setDegenerated(true);
                this.addedEdges.add(ret);
                iter.add(ret);
            }
            return ret;
        }
        boolean nextReached = false;
        boolean isUpper = current.isLeft(point);
        iter.previous();
        while (iter.hasNext()) {
            current = iter.next();
            if (!current.isDegenerated()) {
                nextReached = true;
                break;
            }
            if (isUpper) {
                if (revertDir) {
                    if (mem == null) {
                        mem = new DEdge(current.getEndPoint(), point);
                        ret = mem = this.replaceByCstr(mem, nextCstr);
                        this.addedEdges.add(mem);
                    }
                    memBis = new DEdge(point, current.getStartPoint());
                    memBis = this.replaceByCstr(memBis, nextCstr);
                    this.addedEdges.add(memBis);
                    tri.add(new DTriangle(current, memBis, mem));
                    mem = memBis;
                    current.setDegenerated(false);
                    iter.remove();
                    continue;
                }
                if (mem == null) {
                    ret = new DEdge(point, current.getStartPoint());
                    mem = ret = this.replaceByCstr(ret, nextCstr);
                    this.addedEdges.add(mem);
                }
                memBis = new DEdge(current.getEndPoint(), point);
                memBis = this.replaceByCstr(memBis, nextCstr);
                this.addedEdges.add(memBis);
                tri.add(new DTriangle(current, memBis, mem));
                mem = memBis;
                current.setDegenerated(false);
                continue;
            }
            if (!revertDir) {
                llMem.addFirst(current);
            }
            current.swap();
            iter.remove();
            if (mem == null) {
                mem = new DEdge(current.getEndPoint(), point);
                if (mem.equals(prevAdded)) {
                    mem = prevAdded;
                } else {
                    mem = this.replaceByCstr(mem, nextCstr);
                    this.addedEdges.add(mem);
                    iter.add(mem);
                }
            }
            memBis = new DEdge(point, current.getStartPoint());
            memBis = this.replaceByCstr(memBis, nextCstr);
            this.addedEdges.add(memBis);
            tri.add(new DTriangle(mem, memBis, current));
            mem = memBis;
            current.setDegenerated(false);
        }
        if (isUpper) {
            if (nextReached) {
                iter.previous();
            }
            if (revertDir) {
                iter.add(ret);
                ret = mem;
            } else {
                iter.add(mem);
            }
        } else {
            if (nextReached) {
                iter.previous();
            }
            iter.add(mem);
            for (DEdge ed : llMem) {
                iter.add(ed);
            }
        }
        return ret;
    }

    private DEdge replaceByCstr(DEdge mem, DEdge cstr) {
        DEdge memRet;
        DEdge dEdge = memRet = mem.equals(cstr) ? cstr : mem;
        if (mem.equals(this.constraint)) {
            memRet = this.constraint;
            this.constraint = null;
        }
        if (memRet.getStartPoint().equals(mem.getEndPoint())) {
            memRet.swap();
        }
        return memRet;
    }

    private List<DTriangle> buildFirstDegen(DPoint point, DEdge nextCstr) {
        DEdge mem = new DEdge(this.constraint.getPointLeft(), point);
        mem.setDegenerated(true);
        if (mem.equals(this.constraint)) {
            mem = this.constraint;
            if (mem.getLeft() == null && mem.getRight() == null) {
                mem.setDegenerated(true);
            }
        } else {
            mem = mem.equals(nextCstr) ? nextCstr : mem;
        }
        this.addedEdges.add(mem);
        this.boundaryEdges.add(mem);
        return new ArrayList<DTriangle>();
    }

    List<DTriangle> connectPoint(DPoint point) throws DelaunayError {
        return this.connectPoint(point, null);
    }
}

